/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.j2ee;

import com.sun.enterprise.config.serverbeans.Server;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.impl.config.ConfigBeanRegistry;
import org.glassfish.admin.amx.impl.j2ee.DASJ2EEServerImpl;
import org.glassfish.admin.amx.impl.j2ee.J2EEManagedObjectImplBase;
import org.glassfish.admin.amx.impl.j2ee.Metadata;
import org.glassfish.admin.amx.impl.j2ee.MetadataImpl;
import org.glassfish.admin.amx.impl.util.Issues;
import org.glassfish.admin.amx.impl.util.ObjectNameBuilder;
import org.glassfish.admin.amx.j2ee.J2EEDomain;
import org.glassfish.admin.amx.j2ee.J2EEManagedObject;

public class J2EEDomainImpl
extends J2EEManagedObjectImplBase {
    public static final Class<? extends J2EEManagedObject> INTF = J2EEDomain.class;
    private String serverName = "server";

    public J2EEDomainImpl(ObjectName parentObjectName, Metadata meta) {
        super(parentObjectName, meta, INTF);
        Issues.getAMXIssues().notDone("J2EEDomainImpl needs to account for DAS/non-DAS");
    }

    public String[] getservers() {
        return this.getChildrenAsStrings("J2EEServer");
    }

    @Override
    protected String getExtraObjectNameProps(MBeanServer server, ObjectName nameIn) {
        String props = super.getExtraObjectNameProps(server, nameIn);
        String nameProp = Util.makeNameProp(nameIn.getDomain());
        props = Util.concatenateProps(props, nameProp);
        return props;
    }

    @Override
    protected void registerChildren() {
        ObjectNameBuilder builder = this.getObjectNames();
        MetadataImpl meta = this.defaultChildMetadata();
        List<Server> servers = this.getDomain().getServers().getServer();
        for (Server server : servers) {
            meta.setCorrespondingConfig(ConfigBeanRegistry.getInstance().getObjectNameForProxy(server));
            DASJ2EEServerImpl impl = new DASJ2EEServerImpl(this.getObjectName(), meta);
            ObjectName serverObjectName = this.getObjectNames().buildChildObjectName("J2EEServer", server.getName());
            this.registerChild(impl, serverObjectName);
        }
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }
}

