/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.glassfish.admin.amx.impl.config.ConfigBeanJMXSupport;
import org.glassfish.external.arc.Stability;
import org.glassfish.external.arc.Taxonomy;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;

@Taxonomy(stability=Stability.NOT_AN_INTERFACE)
final class ConfigBeanJMXSupportRegistry {
    private static final ConcurrentMap<Class<? extends ConfigBeanProxy>, ConfigBeanJMXSupport> INSTANCES = new ConcurrentHashMap<Class<? extends ConfigBeanProxy>, ConfigBeanJMXSupport>();

    private ConfigBeanJMXSupportRegistry() {
    }

    public static ConfigBeanJMXSupport getInstance(Class<? extends ConfigBeanProxy> intf) {
        if (intf == null) {
            throw new IllegalArgumentException("null ConfigBeanProxy interface passed in");
        }
        ConfigBeanJMXSupport helper = (ConfigBeanJMXSupport)INSTANCES.get(intf);
        if (helper == null) {
            helper = new ConfigBeanJMXSupport(intf, null);
        }
        return helper;
    }

    public static synchronized List<Class<? extends ConfigBeanProxy>> getConfiguredClasses() {
        return new ArrayList<Class<? extends ConfigBeanProxy>>(INSTANCES.keySet());
    }

    public static ConfigBeanJMXSupport getInstance(ConfigBean configBean) {
        ConfigBeanJMXSupport helper = (ConfigBeanJMXSupport)INSTANCES.get(configBean.getProxyType());
        if (helper == null) {
            helper = ConfigBeanJMXSupportRegistry.addInstance(configBean);
        }
        return helper;
    }

    private static synchronized ConfigBeanJMXSupport addInstance(ConfigBean configBean) {
        Class intf = configBean.getProxyType();
        ConfigBeanJMXSupport helper = (ConfigBeanJMXSupport)INSTANCES.get(intf);
        if (helper == null) {
            helper = new ConfigBeanJMXSupport(configBean);
            INSTANCES.put(intf, helper);
        }
        return helper;
    }

    public static Set<Class<? extends ConfigBeanProxy>> getAllConfigBeanProxyInterfaces(ConfigBeanJMXSupport top) {
        HashSet<Class<? extends ConfigBeanProxy>> all = new HashSet<Class<? extends ConfigBeanProxy>>();
        all.add(top.getIntf());
        for (Class<? extends ConfigBeanProxy> intf : top.childTypes().values()) {
            all.addAll(ConfigBeanJMXSupportRegistry.getAllConfigBeanProxyInterfaces(ConfigBeanJMXSupportRegistry.getInstance(intf)));
        }
        return all;
    }

    public static Class<? extends ConfigBeanProxy> getConfigBeanProxyClassFor(ConfigBeanJMXSupport start, String type2) {
        Class<? extends ConfigBeanProxy> result = start.childTypes().get(type2);
        if (result == null) {
            for (String sub : start.childTypes().keySet()) {
                Class<? extends ConfigBeanProxy> intf = start.childTypes().get(sub);
                ConfigBeanJMXSupport spt = ConfigBeanJMXSupportRegistry.getInstance(intf);
                result = ConfigBeanJMXSupportRegistry.getConfigBeanProxyClassFor(spt, type2);
                if (result == null) continue;
                break;
            }
        }
        return result;
    }
}

