/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.config;

import com.sun.enterprise.config.serverbeans.Domain;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.proxy.ProxyFactory;
import org.glassfish.admin.amx.impl.config.AMXConfigLoader;
import org.glassfish.admin.amx.impl.config.ConfigBeanRegistry;
import org.glassfish.admin.amx.impl.util.ImplUtil;
import org.glassfish.admin.amx.impl.util.InjectedValues;
import org.glassfish.admin.amx.util.AMXLoggerInfo;
import org.glassfish.admin.amx.util.TimingDelta;
import org.glassfish.admin.mbeanserver.PendingConfigBeans;
import org.glassfish.api.amx.AMXLoader;
import org.glassfish.external.arc.Stability;
import org.glassfish.external.arc.Taxonomy;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Transactions;

@Taxonomy(stability=Stability.NOT_AN_INTERFACE)
@Service
public final class AMXConfigStartupService
implements PostConstruct,
PreDestroy,
AMXLoader {
    @Inject
    InjectedValues mInjectedValues;
    @Inject
    private MBeanServer mMBeanServer;
    @Inject
    private volatile PendingConfigBeans mPendingConfigBeans;
    @Inject
    private Transactions mTransactions;
    private volatile AMXConfigLoader mLoader;
    private volatile PendingConfigBeans mPendingConfigBeansBackup;

    private static void debug(String s) {
        System.out.println(s);
    }

    @Override
    public void postConstruct() {
        TimingDelta delta = new TimingDelta();
        if (this.mMBeanServer == null) {
            throw new Error("AMXStartup: null MBeanServer");
        }
        if (this.mPendingConfigBeans == null) {
            throw new Error("AMXStartup: null mPendingConfigBeans");
        }
        this.mPendingConfigBeansBackup = this.mPendingConfigBeans;
        AMXLoggerInfo.getLogger().log(Level.FINE, "Initialized AMXConfig Startup service in {0} ms", delta.elapsedMillis());
    }

    @Override
    public void preDestroy() {
        AMXLoggerInfo.getLogger().info("NCLS-COM-036");
        this.unloadAMXMBeans();
    }

    public DomainRoot getDomainRoot() {
        return ProxyFactory.getInstance(this.mMBeanServer).getDomainRootProxy(false);
    }

    public ObjectName getDomainConfig() {
        return ConfigBeanRegistry.getInstance().getObjectNameForProxy(this.getDomain());
    }

    public Domain getDomain() {
        return InjectedValues.getInstance().getHabitat().getService(Domain.class, new Annotation[0]);
    }

    public AMXProxy getDomainConfigProxy() {
        return ProxyFactory.getInstance(this.mMBeanServer).getProxy(this.getDomainConfig(), AMXProxy.class);
    }

    @Override
    public synchronized ObjectName loadAMXMBeans() {
        if (this.mLoader == null) {
            if (this.mPendingConfigBeans.size() == 0) {
                this.mPendingConfigBeans = this.mPendingConfigBeansBackup;
            }
            this.mLoader = new AMXConfigLoader(this.mMBeanServer, this.mPendingConfigBeans, this.mTransactions);
            this.mLoader.start();
        }
        return this.getDomainConfig();
    }

    @Override
    public synchronized void unloadAMXMBeans() {
        AMXProxy domainConfigProxy = this.getDomainConfigProxy();
        if (domainConfigProxy != null) {
            ImplUtil.unregisterAMXMBeans(domainConfigProxy);
        }
        if (this.mLoader != null) {
            this.mLoader.stop();
        }
        this.mLoader = null;
    }
}

