/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.serializers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.serializers.Serializer;

public class XMLSerializer
implements Serializer {
    JAXBContext context;

    public XMLSerializer() {
    }

    public XMLSerializer(String packageName) {
        try {
            this.context = JAXBContext.newInstance(packageName);
        }
        catch (JAXBException exception) {
            throw new RuntimeException(exception);
        }
    }

    public XMLSerializer(JAXBContext context) {
        this.context = context;
    }

    @Override
    public byte[] serialize(Object object, Session session) {
        try {
            if (this.context == null) {
                String packageName = object.getClass().getPackage().getName();
                this.context = JAXBContext.newInstance(packageName);
            }
            Marshaller marshaller = this.context.createMarshaller();
            marshaller.setProperty("jaxb.fragment", true);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            marshaller.marshal(object, stream);
            return stream.toByteArray();
        }
        catch (JAXBException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public Object deserialize(byte[] bytes, Session session) {
        try {
            if (this.context == null) {
                String packageName = session.getDescriptors().keySet().iterator().next().getPackage().getName();
                this.context = JAXBContext.newInstance(packageName);
            }
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            return unmarshaller.unmarshal(stream);
        }
        catch (JAXBException exception) {
            throw new RuntimeException(exception);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

