/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.platform.database.AccessPlatform;
import org.eclipse.persistence.platform.database.CloudscapePlatform;
import org.eclipse.persistence.platform.database.DB2Platform;
import org.eclipse.persistence.platform.database.DBasePlatform;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.database.DerbyPlatform;
import org.eclipse.persistence.platform.database.HSQLPlatform;
import org.eclipse.persistence.platform.database.InformixPlatform;
import org.eclipse.persistence.platform.database.MySQLPlatform;
import org.eclipse.persistence.platform.database.OraclePlatform;
import org.eclipse.persistence.platform.database.PointBasePlatform;
import org.eclipse.persistence.platform.database.SQLServerPlatform;
import org.eclipse.persistence.platform.database.SybasePlatform;
import org.eclipse.persistence.platform.database.SymfowarePlatform;
import org.eclipse.persistence.platform.database.converters.StructConverter;
import org.eclipse.persistence.platform.database.partitioning.DataPartitioningCallback;
import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.sessions.DefaultConnector;
import org.eclipse.persistence.sessions.DirectConnector;
import org.eclipse.persistence.sessions.JNDIConnector;

public class DatabaseLogin
extends DatasourceLogin {
    public static final int TRANSACTION_NONE = 0;
    public static final int TRANSACTION_READ_UNCOMMITTED = 1;
    public static final int TRANSACTION_READ_COMMITTED = 2;
    public static final int TRANSACTION_REPEATABLE_READ = 4;
    public static final int TRANSACTION_SERIALIZABLE = 8;
    protected int queryRetryAttemptCount;
    protected int delayBetweenConnectionAttempts;
    protected Boolean connectionHealthValidatedOnError;

    public DatabaseLogin() {
        this(new DatabasePlatform());
    }

    public DatabaseLogin(DatabasePlatform databasePlatform) {
        super(databasePlatform);
        this.useDefaultDriverConnect();
        this.delayBetweenConnectionAttempts = 5000;
        this.queryRetryAttemptCount = 3;
    }

    public void usePlatform(DatabasePlatform platform) {
        super.usePlatform(platform);
    }

    public void addStructConverter(StructConverter converter) {
        this.getPlatform().addStructConverter(converter);
    }

    public void bindAllParameters() {
        this.setShouldBindAllParameters(true);
    }

    @Override
    public Accessor buildAccessor() {
        return new DatabaseAccessor();
    }

    public void cacheAllStatements() {
        this.setShouldCacheAllStatements(true);
    }

    public void dontBindAllParameters() {
        this.setShouldBindAllParameters(false);
    }

    public void dontCacheAllStatements() {
        this.setShouldCacheAllStatements(false);
    }

    public void dontOptimizeDataConversion() {
        this.setShouldOptimizeDataConversion(false);
    }

    public void dontUseBatchWriting() {
        this.setUsesBatchWriting(false);
    }

    public void dontUseByteArrayBinding() {
        this.setUsesByteArrayBinding(false);
    }

    public void dontUseJDBCBatchWriting() {
        this.setUsesJDBCBatchWriting(false);
    }

    public void dontUseNativeSQL() {
        this.setUsesNativeSQL(false);
    }

    public void dontUseStreamsForBinding() {
        this.setUsesStreamsForBinding(false);
    }

    public void dontUseStringBinding() {
        this.getPlatform().setStringBindingSize(0);
        this.getPlatform().setUsesStringBinding(false);
    }

    protected boolean driverIs(String driverName) {
        try {
            return this.getDriverClassName().equals(driverName);
        }
        catch (ValidationException validationException) {
            return false;
        }
    }

    public String getConnectionString() throws ValidationException {
        return this.getDefaultConnector().getConnectionString();
    }

    public int getCursorCode() {
        return this.getPlatform().getCursorCode();
    }

    public String getDatabaseName() {
        return this.properties.getProperty("database");
    }

    public String getDatabaseURL() {
        if (!(this.getConnector() instanceof DefaultConnector)) {
            return "";
        }
        return this.getDefaultConnector().getDatabaseURL();
    }

    public String getDataSourceName() throws ValidationException {
        return this.getDatabaseURL();
    }

    @Override
    public Platform getDatasourcePlatform() {
        if (this.platform == null) {
            this.platform = new DatabasePlatform();
        }
        return this.platform;
    }

    protected DefaultConnector getDefaultConnector() throws ValidationException {
        try {
            return (DefaultConnector)this.getConnector();
        }
        catch (ClassCastException classCastException) {
            throw ValidationException.invalidConnector(this.connector);
        }
    }

    public String getDriverClassName() {
        if (!(this.getConnector() instanceof DefaultConnector)) {
            return "";
        }
        return this.getDefaultConnector().getDriverClassName();
    }

    public String getDriverURLHeader() {
        if (!(this.getConnector() instanceof DefaultConnector)) {
            return "";
        }
        return this.getDefaultConnector().getDriverURLHeader();
    }

    public int getMaxBatchWritingSize() {
        return this.getPlatform().getMaxBatchWritingSize();
    }

    public String getPingSQL() {
        return this.getPlatform().getPingSQL();
    }

    public int getQueryRetryAttemptCount() {
        return this.queryRetryAttemptCount;
    }

    public String getServerName() {
        return this.properties.getProperty("server");
    }

    public boolean getShouldBindAllParameters() {
        return this.shouldBindAllParameters();
    }

    public boolean getShouldCacheAllStatements() {
        return this.shouldCacheAllStatements();
    }

    public boolean getShouldOptimizeDataConversion() {
        return this.shouldOptimizeDataConversion();
    }

    public boolean getShouldTrimStrings() {
        return this.shouldTrimStrings();
    }

    public int getStatementCacheSize() {
        return this.getPlatform().getStatementCacheSize();
    }

    public int getStringBindingSize() {
        return this.getPlatform().getStringBindingSize();
    }

    public String getTableCreationSuffix() {
        return this.getPlatform().getTableCreationSuffix();
    }

    public int getTransactionIsolation() {
        return this.getPlatform().getTransactionIsolation();
    }

    public boolean getUsesBinding() {
        return this.shouldUseByteArrayBinding();
    }

    public boolean getUsesNativeSequencing() {
        return this.shouldUseNativeSequencing();
    }

    public boolean getUsesNativeSQL() {
        return this.shouldUseNativeSQL();
    }

    public boolean getUsesStreamsForBinding() {
        return this.shouldUseStreamsForBinding();
    }

    public boolean getUsesStringBinding() {
        return this.getPlatform().usesStringBinding();
    }

    public void handleTransactionsManuallyForSybaseJConnect() {
        this.getPlatform().setSupportsAutoCommit(false);
    }

    public boolean isAnyOracleJDBCDriver() {
        return this.oracleDriverIs("jdbc:oracle:");
    }

    public boolean isCloudscapeJDBCDriver() {
        return this.driverIs("COM.cloudscape.core.JDBCDriver");
    }

    public boolean isDB2JDBCDriver() {
        return this.driverIs("COM.ibm.db2.jdbc.app.DB2Driver");
    }

    public boolean isIntersolvSequeLinkDriver() {
        return this.driverIs("intersolv.jdbc.sequelink.SequeLinkDriver");
    }

    public boolean isJConnectDriver() {
        return this.driverIs("com.sybase.jdbc.SybDriver");
    }

    public boolean isJDBCConnectDriver() {
        return this.driverIs("borland.jdbc.Bridge.LocalDriver");
    }

    public boolean isJDBCConnectRemoteDriver() {
        return this.driverIs("borland.jdbc.Broker.RemoteDriver");
    }

    public boolean isJDBCODBCBridge() {
        return this.driverIs("sun.jdbc.odbc.JdbcOdbcDriver");
    }

    public boolean isOracle7JDBCDriver() {
        return this.oracleDriverIs("jdbc:oracle:oci7:@");
    }

    public boolean isOracleJDBCDriver() {
        return this.oracleDriverIs("jdbc:oracle:oci8:@");
    }

    public boolean isOracleServerJDBCDriver() {
        return this.oracleDriverIs("jdbc:oracle:kprb:");
    }

    public boolean isOracleThinJDBCDriver() {
        return this.oracleDriverIs("jdbc:oracle:thin:@");
    }

    public boolean isWebLogicOracleOCIDriver() {
        return this.driverIs("weblogic.jdbc.oci.Driver");
    }

    public boolean isWebLogicSQLServerDBLibDriver() {
        return this.driverIs("weblogic.jdbc.dblib.Driver");
    }

    public boolean isWebLogicSQLServerDriver() {
        return this.driverIs("weblogic.jdbc.mssqlserver4.Driver");
    }

    public boolean isWebLogicSybaseDBLibDriver() {
        return this.driverIs("weblogic.jdbc.dblib.Driver");
    }

    public boolean isWebLogicThinClientDriver() {
        return this.driverIs("weblogic.jdbc.t3Client.Driver");
    }

    public boolean isWebLogicThinDriver() {
        return this.driverIs("weblogic.jdbc.t3.Driver");
    }

    public void optimizeDataConversion() {
        this.setShouldOptimizeDataConversion(true);
    }

    protected boolean oracleDriverIs(String urlPrefix) {
        try {
            if (this.getDriverURLHeader().length() != 0) {
                return this.getDriverURLHeader().indexOf(urlPrefix) != -1;
            }
            return this.getDatabaseURL().indexOf(urlPrefix) != -1;
        }
        catch (ValidationException validationException) {
            return false;
        }
    }

    public void setConnectionString(String url) throws ValidationException {
        this.setDriverURLHeader("");
        this.setDatabaseURL(url);
    }

    public void setURL(String url) {
        this.setDriverURLHeader("");
        this.setDatabaseURL(url);
    }

    public String getURL() {
        return this.getConnectionString();
    }

    public void setCursorCode(int cursorCode) {
        this.getPlatform().setCursorCode(cursorCode);
    }

    public void setDatabaseName(String databaseName) {
        this.setProperty("database", databaseName);
    }

    public void setDatabaseURL(String databaseURL) throws ValidationException {
        this.getDefaultConnector().setDatabaseURL(databaseURL);
    }

    public void setODBCDataSourceName(String dataSourceName) {
        this.setDatabaseURL(dataSourceName);
    }

    public void setPingSQL(String pingSQL) {
        this.getPlatform().setPingSQL(pingSQL);
    }

    public void setQueryRetryAttemptCount(int queryRetryAttemptCount) {
        this.queryRetryAttemptCount = queryRetryAttemptCount;
    }

    @Override
    public void setDefaultNullValue(Class type2, Object value) {
        this.getPlatform().getConversionManager().setDefaultNullValue(type2, value);
    }

    public void setDriverClass(Class driverClass) {
        this.setDriverClassName(driverClass.getName());
    }

    public void setDriverClassName(String driverClassName) throws ValidationException {
        this.getDefaultConnector().setDriverClassName(driverClassName);
    }

    public void setDriverURLHeader(String driverURLHeader) throws ValidationException {
        this.getDefaultConnector().setDriverURLHeader(driverURLHeader);
    }

    public void setMaxBatchWritingSize(int maxBatchWritingSize) {
        this.getPlatform().setMaxBatchWritingSize(maxBatchWritingSize);
    }

    public void setServerName(String name) {
        this.setProperty("server", name);
    }

    public void setShouldBindAllParameters(boolean shouldBindAllParameters) {
        this.getPlatform().setShouldBindAllParameters(shouldBindAllParameters);
    }

    public void setShouldCacheAllStatements(boolean shouldCacheAllStatements) {
        this.getPlatform().setShouldCacheAllStatements(shouldCacheAllStatements);
    }

    public void setShouldForceFieldNamesToUpperCase(boolean shouldForceFieldNamesToUpperCase) {
        this.getPlatform().setShouldForceFieldNamesToUpperCase(shouldForceFieldNamesToUpperCase);
    }

    public static void setShouldIgnoreCaseOnFieldComparisons(boolean shouldIgnoreCaseOnFieldComparisons) {
        DatabasePlatform.setShouldIgnoreCaseOnFieldComparisons(shouldIgnoreCaseOnFieldComparisons);
    }

    public void setShouldOptimizeDataConversion(boolean value) {
        this.getPlatform().setShouldOptimizeDataConversion(value);
    }

    public void setShouldTrimStrings(boolean shouldTrimStrings) {
        this.getPlatform().setShouldTrimStrings(shouldTrimStrings);
    }

    public void setStatementCacheSize(int size) {
        this.getPlatform().setStatementCacheSize(size);
    }

    public void setStringBindingSize(int stringBindingSize) {
        this.getPlatform().setStringBindingSize(stringBindingSize);
    }

    public void setTableCreationSuffix(String tableCreationSuffix) {
        this.getPlatform().setTableCreationSuffix(tableCreationSuffix);
    }

    @Override
    public void setTableQualifier(String qualifier) {
        this.getPlatform().setTableQualifier(qualifier);
    }

    public void setTransactionIsolation(int isolationLevel) {
        this.getPlatform().setTransactionIsolation(isolationLevel);
    }

    public void setUsesBatchWriting(boolean value) {
        this.getPlatform().setUsesBatchWriting(value);
    }

    public void setUsesByteArrayBinding(boolean value) {
        this.getPlatform().setUsesByteArrayBinding(value);
    }

    public void setUsesJDBCBatchWriting(boolean usesJDBCBatchWriting) {
        this.getPlatform().setUsesJDBCBatchWriting(usesJDBCBatchWriting);
    }

    public void setUsesNativeSQL(boolean value) {
        this.getPlatform().setUsesNativeSQL(value);
    }

    public void setUsesStreamsForBinding(boolean value) {
        this.getPlatform().setUsesStreamsForBinding(value);
    }

    public void setUsesStringBinding(boolean usesStringBindingSize) {
        this.getPlatform().setUsesStringBinding(usesStringBindingSize);
    }

    public DataPartitioningCallback getPartitioningCallback() {
        return this.getPlatform().getPartitioningCallback();
    }

    public void setPartitioningCallback(DataPartitioningCallback partitioningCallback) {
        this.getPlatform().setPartitioningCallback(partitioningCallback);
    }

    public boolean shouldBindAllParameters() {
        return this.getPlatform().shouldBindAllParameters();
    }

    public boolean shouldCacheAllStatements() {
        return this.getPlatform().shouldCacheAllStatements();
    }

    public boolean shouldForceFieldNamesToUpperCase() {
        return this.getPlatform().shouldForceFieldNamesToUpperCase();
    }

    public static boolean shouldIgnoreCaseOnFieldComparisons() {
        return DatabasePlatform.shouldIgnoreCaseOnFieldComparisons();
    }

    public boolean shouldOptimizeDataConversion() {
        return this.getPlatform().shouldOptimizeDataConversion();
    }

    public boolean shouldTrimStrings() {
        return this.getPlatform().shouldTrimStrings();
    }

    public boolean shouldUseBatchWriting() {
        return this.getPlatform().usesBatchWriting();
    }

    public boolean shouldUseByteArrayBinding() {
        return this.getPlatform().usesByteArrayBinding();
    }

    public boolean shouldUseJDBCBatchWriting() {
        return this.getPlatform().usesJDBCBatchWriting();
    }

    public boolean shouldUseNativeSequencing() {
        return this.getPlatform().getDefaultSequence() instanceof NativeSequence;
    }

    public boolean shouldUseNativeSQL() {
        return this.getPlatform().usesNativeSQL();
    }

    public boolean shouldUseStreamsForBinding() {
        return this.getPlatform().usesStreamsForBinding();
    }

    public boolean shouldUseStringBinding() {
        return this.getPlatform().usesStringBinding();
    }

    @Override
    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        writer.println("DatabaseLogin(");
        writer.println("\t" + ToStringLocalization.buildMessage("platform", null) + "=>" + this.getDatasourcePlatform());
        writer.println("\t" + ToStringLocalization.buildMessage("user_name", null) + "=> \"" + this.getUserName() + "\"");
        writer.print("\t");
        this.getConnector().toString(writer);
        if (this.getServerName() != null) {
            writer.println("\t" + ToStringLocalization.buildMessage("server_name", null) + "=> \"" + this.getServerName() + "\"");
        }
        if (this.getDatabaseName() != null) {
            writer.println("\t" + ToStringLocalization.buildMessage("database_name", null) + "=> \"" + this.getDatabaseName() + "\"");
        }
        writer.write(")");
        return stringWriter.toString();
    }

    public void useAccess() {
        if (this.getPlatform().isAccess()) {
            return;
        }
        AccessPlatform newPlatform = new AccessPlatform();
        this.getPlatform().copyInto(newPlatform);
        this.setPlatform(newPlatform);
    }

    public void useBatchWriting() {
        this.setUsesBatchWriting(true);
    }

    public void useByteArrayBinding() {
        this.setUsesByteArrayBinding(true);
    }

    public void useCloudscape() {
        if (this.getPlatform().isCloudscape()) {
            return;
        }
        CloudscapePlatform newPlatform = new CloudscapePlatform();
        this.getPlatform().copyInto(newPlatform);
        this.setPlatform(newPlatform);
    }

    public void useDerby() {
        if (this.getPlatform().isDerby()) {
            return;
        }
        DerbyPlatform newPlatform = new DerbyPlatform();
        this.getPlatform().copyInto(newPlatform);
        this.setPlatform(newPlatform);
    }

    public void useCloudscapeDriver() {
        this.useCloudscape();
        this.setDriverClassName("COM.cloudscape.core.JDBCDriver");
        this.setDriverURLHeader("jdbc:cloudscape:");
    }

    public void useDB2() {
        if (this.getPlatform().isDB2()) {
            return;
        }
        DB2Platform newPlatform = new DB2Platform();
        this.getPlatform().copyInto(newPlatform);
        this.setPlatform(newPlatform);
    }

    public void useDB2JDBCDriver() {
        this.useDB2();
        this.setDriverClassName("COM.ibm.db2.jdbc.app.DB2Driver");
        this.setDriverURLHeader("jdbc:db2:");
        this.useStreamsForBinding();
    }

    public void useDB2NetJDBCDriver() {
        this.useDB2();
        this.setDriverClassName("COM.ibm.db2.jdbc.net.DB2Driver");
        this.setDriverURLHeader("jdbc:db2:");
        this.useStreamsForBinding();
    }

    public void useDBase() {
        if (this.getPlatform().isDBase()) {
            return;
        }
        DBasePlatform newPlatform = new DBasePlatform();
        this.getPlatform().copyInto(newPlatform);
        this.setPlatform(newPlatform);
    }

    public void useDefaultDriverConnect() {
        this.setConnector(new DefaultConnector());
    }

    public void useDefaultDriverConnect(String driverClassName, String driverURLHeader, String databaseURL) {
        this.setConnector(new DefaultConnector(driverClassName, driverURLHeader, databaseURL));
    }

    public void useDirectDriverConnect() {
        this.setConnector(new DirectConnector());
    }

    public void useDataSource(String dataSource) {
        this.setConnector(new JNDIConnector(dataSource));
        this.useExternalConnectionPooling();
    }

    public void useJTADataSource(String dataSource) {
        this.useDataSource(dataSource);
        this.useExternalTransactionController();
    }

    public void useDirectDriverConnect(String driverClassName, String driverURLHeader, String databaseURL) {
        this.setConnector(new DirectConnector(driverClassName, driverURLHeader, databaseURL));
    }

    @Override
    public void useExternalConnectionPooling() {
        this.setUsesExternalConnectionPooling(true);
    }

    @Override
    public void useExternalTransactionController() {
        this.setUsesExternalTransactionController(true);
    }

    public void useHSQL() {
        if (this.getPlatform().isHSQL()) {
            return;
        }
        HSQLPlatform newPlatform = new HSQLPlatform();
        this.getPlatform().copyInto(newPlatform);
        this.setPlatform(newPlatform);
    }

    public void useHSQLDriver() {
        this.useHSQL();
        this.setDriverClassName("org.hsqldb.jdbcDriver");
        this.setDriverURLHeader("jdbc:hsqldb:");
    }

    public void useINetSQLServerDriver() {
        this.setDriverClassName("com.inet.tds.TdsDriver");
        this.setDriverURLHeader("jdbc:inetdae:");
    }

    public void useInformix() {
        if (this.getPlatform().isInformix()) {
            return;
        }
        InformixPlatform newPlatform = new InformixPlatform();
        this.getPlatform().copyInto(newPlatform);
        this.setPlatform(newPlatform);
    }

    public void useIntersolvSequeLinkDriver() {
        this.setDriverClassName("intersolv.jdbc.sequelink.SequeLinkDriver");
        this.setDriverURLHeader("jdbc:sequelink:");
    }

    public void useJConnect50Driver() {
        this.useSybase();
        this.setDriverClassName("com.sybase.jdbc2.jdbc.SybDriver");
        this.setDriverURLHeader("jdbc:sybase:Tds:");
        this.useNativeSQL();
    }

    public void useJConnectDriver() {
        this.useSybase();
        this.setDriverClassName("com.sybase.jdbc.SybDriver");
        this.setDriverURLHeader("jdbc:sybase:Tds:");
        this.useNativeSQL();
    }

    public void useJDBC() {
        DatabasePlatform newPlatform = new DatabasePlatform();
        this.getPlatform().copyInto(newPlatform);
        this.setPlatform(newPlatform);
    }

    public void useJDBCBatchWriting() {
        this.setUsesJDBCBatchWriting(true);
    }

    public void useJDBCConnectDriver() {
        this.setDriverClassName("borland.jdbc.Bridge.LocalDriver");
        this.setDriverURLHeader("jdbc:BorlandBridge:");
    }

    public void useJDBCConnectRemoteDriver() {
        this.setDriverClassName("borland.jdbc.Broker.RemoteDriver");
        this.setDriverURLHeader("jdbc:BorlandBridge:");
    }

    public void useJDBCODBCBridge() {
        this.setDriverClassName("sun.jdbc.odbc.JdbcOdbcDriver");
        this.setDriverURLHeader("jdbc:odbc:");
    }

    public void useMySQL() {
        if (this.getPlatform().isMySQL()) {
            return;
        }
        MySQLPlatform newPlatform = new MySQLPlatform();
        this.getPlatform().copyInto(newPlatform);
        this.setPlatform(newPlatform);
    }

    public void useNativeSequencing() {
        if (!this.shouldUseNativeSequencing()) {
            this.getPlatform().setDefaultSequence(new NativeSequence(this.getPlatform().getDefaultSequence().getName(), this.getPlatform().getDefaultSequence().getPreallocationSize(), this.getPlatform().getDefaultSequence().getInitialValue()));
        }
    }

    public void useNativeSQL() {
        this.setUsesNativeSQL(true);
    }

    public void useOracle() {
        if (this.getPlatform().isOracle()) {
            return;
        }
        OraclePlatform newPlatform = new OraclePlatform();
        this.getPlatform().copyInto(newPlatform);
        this.setPlatform(newPlatform);
    }

    public void useOracle7JDBCDriver() {
        this.useOracle();
        this.setDriverClassName("oracle.jdbc.OracleDriver");
        this.setDriverURLHeader("jdbc:oracle:oci7:@");
        this.useByteArrayBinding();
        this.useStreamsForBinding();
    }

    public void useOracleJDBCDriver() {
        this.useOracle();
        this.setDriverClassName("oracle.jdbc.OracleDriver");
        this.setDriverURLHeader("jdbc:oracle:oci8:@");
        this.useByteArrayBinding();
        this.useStreamsForBinding();
    }

    public void useOracleServerJDBCDriver() {
        this.useOracle();
        this.setDriverClassName("oracle.jdbc.OracleDriver");
        this.setDriverURLHeader("jdbc:oracle:kprb:");
        this.useByteArrayBinding();
    }

    public void useOracleThinJDBCDriver() {
        this.useOracle();
        this.setDriverClassName("oracle.jdbc.OracleDriver");
        this.setDriverURLHeader("jdbc:oracle:thin:@");
        this.useByteArrayBinding();
        this.useStreamsForBinding();
    }

    public void usePointBase() {
        if (this.getPlatform().isPointBase()) {
            return;
        }
        PointBasePlatform newPlatform = new PointBasePlatform();
        this.getPlatform().copyInto(newPlatform);
        this.setPlatform(newPlatform);
    }

    public void usePointBaseDriver() {
        this.usePointBase();
        this.setDriverClassName("com.pointbase.jdbc.jdbcUniversalDriver");
        this.setDriverURLHeader("jdbc:pointbase:");
    }

    public void useSQLServer() {
        if (this.getPlatform().isSQLServer()) {
            return;
        }
        SQLServerPlatform newPlatform = new SQLServerPlatform();
        this.getPlatform().copyInto(newPlatform);
        this.setPlatform(newPlatform);
    }

    public void useSymfoware() {
        if (this.getPlatform().isSymfoware()) {
            return;
        }
        SymfowarePlatform newPlatform = new SymfowarePlatform();
        this.getPlatform().copyInto(newPlatform);
        this.setPlatform(newPlatform);
    }

    public void useStreamsForBinding() {
        this.setUsesStreamsForBinding(true);
    }

    public void useStringBinding() {
        this.useStringBinding(255);
    }

    public void useStringBinding(int size) {
        this.getPlatform().setStringBindingSize(size);
        this.getPlatform().setUsesStringBinding(true);
    }

    public void useSybase() {
        if (this.getPlatform().isSybase()) {
            return;
        }
        SybasePlatform newPlatform = new SybasePlatform();
        this.getPlatform().copyInto(newPlatform);
        this.setPlatform(newPlatform);
    }

    public void useWebLogicDriverCursoredOutputCode() {
        this.setCursorCode(1111);
    }

    public void useWebLogicJDBCConnectionPool(String poolName) {
        this.setDriverClassName("weblogic.jdbc.jts.Driver");
        this.setConnectionString("jdbc:weblogic:jts:" + poolName);
    }

    public void useWebLogicOracleOCIDriver() {
        this.useOracle();
        this.setDriverClassName("weblogic.jdbc.oci.Driver");
        this.setDriverURLHeader("jdbc:weblogic:oracle:");
        this.dontOptimizeDataConversion();
        this.useWebLogicDriverCursoredOutputCode();
    }

    public void useWebLogicSQLServerDBLibDriver() {
        this.useSQLServer();
        this.setDriverClassName("weblogic.jdbc.dblib.Driver");
        this.setDriverURLHeader("jdbc:weblogic:mssqlserver:");
        this.dontOptimizeDataConversion();
    }

    public void useWebLogicSQLServerDriver() {
        this.useSQLServer();
        this.setDriverClassName("weblogic.jdbc.mssqlserver4.Driver");
        this.setDriverURLHeader("jdbc:weblogic:mssqlserver4:");
        this.dontOptimizeDataConversion();
    }

    public void useWebLogicSybaseDBLibDriver() {
        this.useSybase();
        this.setDriverClassName("weblogic.jdbc.dblib.Driver");
        this.setDriverURLHeader("jdbc:weblogic:sybase:");
        this.dontOptimizeDataConversion();
    }

    public void useWebLogicThinClientDriver() {
        this.setDriverClassName("weblogic.jdbc.t3Client.Driver");
        this.setDriverURLHeader("jdbc:weblogic:t3Client:");
    }

    public void useWebLogicThinDriver() {
        this.setDriverClassName("weblogic.jdbc.t3.Driver");
        this.setDriverURLHeader("jdbc:weblogic:t3:");
    }

    public int getDelayBetweenConnectionAttempts() {
        return this.delayBetweenConnectionAttempts;
    }

    public void setDelayBetweenConnectionAttempts(int delayBetweenConnectionAttempts) {
        this.delayBetweenConnectionAttempts = delayBetweenConnectionAttempts;
    }

    public boolean isConnectionHealthValidatedOnError(DatabaseCall call) {
        if (this.connectionHealthValidatedOnError == null) {
            return this.getPingSQL() == null || call == null || call.getQueryTimeout() == 0;
        }
        return this.connectionHealthValidatedOnError;
    }

    @Override
    public boolean isConnectionHealthValidatedOnError() {
        if (this.connectionHealthValidatedOnError == null) {
            return this.getPingSQL() == null;
        }
        return this.connectionHealthValidatedOnError;
    }

    public void setConnectionHealthValidatedOnError(boolean isConnectionHealthValidatedOnError) {
        this.connectionHealthValidatedOnError = isConnectionHealthValidatedOnError;
    }
}

