/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.core.descriptors.CoreInheritancePolicy;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.Namespace;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathQName;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.record.XMLRecord;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.MediaType;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class XMLRecord
extends AbstractRecord
implements org.eclipse.persistence.internal.oxm.record.XMLRecord<AbstractSession, DatabaseField, XMLMarshaller, NamespaceResolver, XMLUnmarshaller> {
    protected XMLMarshaller marshaller;
    protected XMLUnmarshaller unmarshaller;
    private DocumentPreservationPolicy docPresPolicy;
    private Object owningObject;
    protected Object currentObject;
    private XPathQName leafElementType;
    protected NamespaceResolver namespaceResolver;
    protected AbstractSession session;
    private boolean isXOPPackage;
    protected boolean namespaceAware = true;
    protected boolean hasCustomNamespaceMapper;
    protected boolean equalNamespaceResolvers = false;
    public static final XMLRecord.Nil NIL = org.eclipse.persistence.internal.oxm.record.XMLRecord.NIL;

    public XMLRecord() {
        super(null, null, 0);
    }

    @Override
    public Object get(String key) {
        return this.get(new XMLField(key));
    }

    @Override
    public Object put(String key, Object value) {
        return this.put(new XMLField(key), value);
    }

    @Override
    public void attributeWithoutQName(String namespaceURI, String localName, String prefix, String value) {
        String qualifiedName = localName;
        if (prefix != null && prefix.length() > 0) {
            qualifiedName = String.valueOf(prefix) + this.getNamespaceSeparator() + qualifiedName;
        }
        this.attribute(namespaceURI, localName, qualifiedName, value);
    }

    public void attribute(String namespaceURI, String localName, String qName, String value) {
        XMLField xmlField = new XMLField(XMLConstants.ATTRIBUTE + qName);
        xmlField.setNamespaceResolver(this.getNamespaceResolver());
        xmlField.getLastXPathFragment().setNamespaceURI(namespaceURI);
        this.add(xmlField, value);
    }

    @Override
    public void namespaceDeclaration(String prefix, String namespaceURI) {
        String existingPrefix = this.getNamespaceResolver().resolveNamespaceURI(namespaceURI);
        if (existingPrefix == null || existingPrefix != null && !existingPrefix.equals("") && !existingPrefix.equals(prefix)) {
            XMLField xmlField = new XMLField("@xmlns:" + prefix);
            xmlField.setNamespaceResolver(this.getNamespaceResolver());
            xmlField.getXPathFragment().setNamespaceURI("http://www.w3.org/2000/xmlns/");
            this.add(xmlField, namespaceURI);
        }
    }

    public abstract String getLocalName();

    public abstract String getNamespaceURI();

    @Override
    public abstract void clear();

    public abstract Document getDocument();

    @Override
    public boolean contains(Object value) {
        return this.values().contains(value);
    }

    @Override
    public abstract Node getDOM();

    public abstract String transformToXML();

    protected XMLField convertToXMLField(DatabaseField databaseField) {
        try {
            return (XMLField)databaseField;
        }
        catch (ClassCastException classCastException) {
            return new XMLField(databaseField.getName());
        }
    }

    protected List<XMLField> convertToXMLField(List<DatabaseField> databaseFields) {
        ArrayList<XMLField> xmlFields = new ArrayList<XMLField>(databaseFields.size());
        for (DatabaseField next : databaseFields) {
            try {
                xmlFields.add((XMLField)next);
            }
            catch (ClassCastException classCastException) {
                xmlFields.add(new XMLField(next.getName()));
            }
        }
        return xmlFields;
    }

    @Override
    public Object get(DatabaseField key) {
        return this.getIndicatingNoEntry(key);
    }

    @Override
    public Object getIndicatingNoEntry(String fieldName) {
        return this.getIndicatingNoEntry(new XMLField(fieldName));
    }

    @Override
    public String resolveNamespacePrefix(String prefix) {
        return null;
    }

    @Override
    public XMLMarshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(XMLMarshaller marshaller) {
        this.marshaller = marshaller;
        if (marshaller != null) {
            MediaType mediaType = marshaller.getMediaType();
            this.namespaceAware = marshaller.getNamespacePrefixMapper() != null ? true : mediaType.isApplicationXML();
        }
    }

    @Override
    public XMLUnmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    public void setUnmarshaller(XMLUnmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public void setDocPresPolicy(DocumentPreservationPolicy policy) {
        this.docPresPolicy = policy;
    }

    public DocumentPreservationPolicy getDocPresPolicy() {
        return this.docPresPolicy;
    }

    public Object getOwningObject() {
        return this.owningObject;
    }

    public void setOwningObject(Object obj) {
        this.owningObject = obj;
    }

    public Object getCurrentObject() {
        return this.currentObject;
    }

    public void setCurrentObject(Object obj) {
        this.currentObject = obj;
    }

    public XPathQName getLeafElementType() {
        return this.leafElementType;
    }

    public void setLeafElementType(XPathQName type2) {
        this.leafElementType = type2;
    }

    public void setLeafElementType(QName type2) {
        if (type2 != null) {
            this.setLeafElementType(new XPathQName(type2, this.isNamespaceAware()));
        }
    }

    public void setNamespaceResolver(NamespaceResolver nr) {
        this.namespaceResolver = nr;
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    @Override
    public AbstractSession getSession() {
        return this.session;
    }

    public void setSession(AbstractSession session) {
        this.session = session;
    }

    public void setEqualNamespaceResolvers(boolean equalNRs) {
        this.equalNamespaceResolvers = equalNRs;
    }

    @Override
    public boolean hasEqualNamespaceResolvers() {
        return this.equalNamespaceResolvers;
    }

    public boolean isXOPPackage() {
        return this.isXOPPackage;
    }

    public void setXOPPackage(boolean isXOPPackage) {
        this.isXOPPackage = isXOPPackage;
    }

    @Override
    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    @Override
    public char getNamespaceSeparator() {
        return ':';
    }

    @Override
    public boolean hasCustomNamespaceMapper() {
        return this.hasCustomNamespaceMapper;
    }

    public void setCustomNamespaceMapper(boolean customNamespaceMapper) {
        this.hasCustomNamespaceMapper = customNamespaceMapper;
    }

    @Override
    public List<Namespace> addExtraNamespacesToNamespaceResolver(Descriptor desc, CoreAbstractSession session, boolean allowOverride, boolean ignoreEqualResolvers) {
        if (this.equalNamespaceResolvers && !ignoreEqualResolvers) {
            return null;
        }
        Object descriptorNamespaceResolver = desc.getNamespaceResolver();
        if (descriptorNamespaceResolver == null || !((org.eclipse.persistence.internal.oxm.NamespaceResolver)descriptorNamespaceResolver).hasPrefixesToNamespaces()) {
            return null;
        }
        Map<String, String> prefixesToNamespaces = ((org.eclipse.persistence.internal.oxm.NamespaceResolver)descriptorNamespaceResolver).getPrefixesToNamespaces();
        if (prefixesToNamespaces.size() == 0) {
            return null;
        }
        ArrayList<Namespace> returnList = new ArrayList<Namespace>(prefixesToNamespaces.size());
        NamespaceResolver marshalRecordNamespaceResolver = this.namespaceResolver;
        for (Map.Entry<String, String> entry : prefixesToNamespaces.entrySet()) {
            String prefix = marshalRecordNamespaceResolver.resolveNamespaceURI(entry.getValue());
            if (prefix == null || prefix.length() == 0) {
                String newPrefix;
                prefix = entry.getKey();
                if (this.hasCustomNamespaceMapper && (newPrefix = this.getMarshaller().getNamespacePrefixMapper().getPreferredPrefix(entry.getValue(), prefix, true)) != null && newPrefix.length() != 0) {
                    prefix = newPrefix;
                }
                String uri = marshalRecordNamespaceResolver.resolveNamespacePrefix(prefix);
                if (!this.hasCustomNamespaceMapper && !allowOverride && uri != null && uri.length() != 0) continue;
                marshalRecordNamespaceResolver.put(entry.getKey(), entry.getValue());
                returnList.add(new Namespace(prefix, entry.getValue()));
                continue;
            }
            if (!allowOverride || prefix.equals(entry.getKey()) || this.hasCustomNamespaceMapper) continue;
            marshalRecordNamespaceResolver.put(entry.getKey(), entry.getValue());
            returnList.add(new Namespace(entry.getKey(), entry.getValue()));
        }
        return returnList;
    }

    public boolean addXsiTypeAndClassIndicatorIfRequired(Descriptor descriptor, Descriptor referenceDescriptor, Field xmlField, boolean isRootElement) {
        Object inheritancePolicy;
        Field indicatorField;
        XMLObjectBuilder objectBuilder = (XMLObjectBuilder)descriptor.getObjectBuilder();
        boolean xsiTypeIndicatorField = objectBuilder.isXsiTypeIndicatorField();
        if (descriptor.hasInheritance() && !xsiTypeIndicatorField) {
            ((CoreInheritancePolicy)descriptor.getInheritancePolicy()).addClassIndicatorFieldToRow((XMLRecord)this);
            return true;
        }
        QName leafType = null;
        if (xmlField != null) {
            leafType = xmlField.getLeafElementType();
            XMLSchemaReference xmlRef = descriptor.getSchemaReference();
            if (xmlRef != null) {
                QName ctxQName;
                if (leafType == null) {
                    if (xmlRef.getType() == 3) {
                        return false;
                    }
                    if (referenceDescriptor == null) {
                        this.writeXsiTypeAttribute(descriptor, xmlRef, isRootElement);
                        return true;
                    }
                } else if ((xmlRef.getType() == 1 || xmlRef.getType() == 2) && xmlRef.getSchemaContext() != null && xmlRef.isGlobalDefinition() && !(ctxQName = xmlRef.getSchemaContextAsQName((org.eclipse.persistence.internal.oxm.NamespaceResolver)descriptor.getNamespaceResolver())).equals(leafType)) {
                    this.writeXsiTypeAttribute(descriptor, xmlRef, isRootElement);
                    return true;
                }
            }
        }
        if (referenceDescriptor != null && referenceDescriptor == descriptor) {
            return false;
        }
        if (descriptor.hasInheritance() && !((CoreInheritancePolicy)descriptor.getInheritancePolicy()).isRootParentDescriptor() && (indicatorField = (Field)((CoreInheritancePolicy)(inheritancePolicy = descriptor.getInheritancePolicy())).getClassIndicatorField()) != null && xsiTypeIndicatorField) {
            Object classIndicatorValueObject = ((CoreInheritancePolicy)inheritancePolicy).getClassIndicatorMapping().get(descriptor.getJavaClass());
            String classIndicatorUri = null;
            String classIndicatorLocal = null;
            String classIndicatorPrefix = null;
            if (classIndicatorValueObject instanceof QName) {
                QName classIndicatorQName = (QName)classIndicatorValueObject;
                classIndicatorUri = classIndicatorQName.getNamespaceURI();
                classIndicatorLocal = classIndicatorQName.getLocalPart();
                classIndicatorPrefix = classIndicatorQName.getPrefix();
            } else {
                String classIndicatorValue = (String)((CoreInheritancePolicy)inheritancePolicy).getClassIndicatorMapping().get(descriptor.getJavaClass());
                int nsindex = classIndicatorValue.indexOf(58);
                String prefix = null;
                if (nsindex != -1) {
                    classIndicatorLocal = classIndicatorValue.substring(nsindex + 1);
                    prefix = classIndicatorValue.substring(0, nsindex);
                } else {
                    classIndicatorLocal = classIndicatorValue;
                }
                classIndicatorUri = ((org.eclipse.persistence.internal.oxm.NamespaceResolver)descriptor.getNonNullNamespaceResolver()).resolveNamespacePrefix(prefix);
            }
            if (leafType == null || isRootElement && this.marshaller.getMediaType().isApplicationJSON() && !this.marshaller.isIncludeRoot() || !leafType.getLocalPart().equals(classIndicatorLocal) || classIndicatorUri == null && leafType.getNamespaceURI() != null && leafType.getNamespaceURI().length() > 0 || classIndicatorUri != null && !classIndicatorUri.equals(leafType.getNamespaceURI())) {
                if (((CoreInheritancePolicy)inheritancePolicy).hasClassExtractor()) {
                    ((CoreInheritancePolicy)inheritancePolicy).addClassIndicatorFieldToRow((XMLRecord)this);
                } else {
                    this.writeXsiTypeAttribute(descriptor, classIndicatorUri, classIndicatorLocal, classIndicatorPrefix, isRootElement);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean addXsiTypeAndClassIndicatorIfRequired(Descriptor descriptor, Descriptor referenceDescriptor, Field xmlField, Object originalObject, Object obj, boolean wasXMLRoot, boolean isRootElement) {
        if (wasXMLRoot) {
            XMLSchemaReference xmlRef = descriptor.getSchemaReference();
            if (descriptor != null) {
                Root xr = (Root)originalObject;
                if (xmlRef == null) {
                    return false;
                }
                String xmlRootLocalName = xr.getLocalName();
                String xmlRootUri = xr.getNamespaceURI();
                XPathQName qName = new XPathQName(xmlRootUri, xmlRootLocalName, this.namespaceAware);
                XMLDescriptor xdesc = this.marshaller.getXMLContext().getDescriptor(qName);
                if (xdesc != null) {
                    boolean writeTypeAttribute;
                    boolean bl = writeTypeAttribute = xdesc.getJavaClass() != descriptor.getJavaClass();
                    if (writeTypeAttribute) {
                        this.writeXsiTypeAttribute(descriptor, xmlRef, isRootElement);
                        return true;
                    }
                    return false;
                }
                if (xr.getDeclaredType() != null && xr.getDeclaredType() == xr.getObject().getClass()) {
                    return false;
                }
                boolean writeTypeAttribute = true;
                int tableSize = descriptor.getTableNames().size();
                int i = 0;
                while (i < tableSize) {
                    if (!writeTypeAttribute) {
                        return false;
                    }
                    String defaultRootQualifiedName = (String)descriptor.getTableNames().get(i);
                    if (defaultRootQualifiedName != null) {
                        String defaultRootLocalName = null;
                        String defaultRootUri = null;
                        int colonIndex = defaultRootQualifiedName.indexOf(58);
                        if (colonIndex > 0) {
                            String defaultRootPrefix = defaultRootQualifiedName.substring(0, colonIndex);
                            defaultRootLocalName = defaultRootQualifiedName.substring(colonIndex + 1);
                            if (descriptor.getNamespaceResolver() != null) {
                                defaultRootUri = ((org.eclipse.persistence.internal.oxm.NamespaceResolver)descriptor.getNamespaceResolver()).resolveNamespacePrefix(defaultRootPrefix);
                            }
                        } else {
                            defaultRootLocalName = defaultRootQualifiedName;
                        }
                        if (xmlRootLocalName != null && (defaultRootLocalName == null && xmlRootLocalName == null || defaultRootLocalName.equals(xmlRootLocalName)) && (defaultRootUri == null && xmlRootUri == null || xmlRootUri != null && defaultRootUri != null && defaultRootUri.equals(xmlRootUri))) {
                            return false;
                        }
                    } else if (xmlRootLocalName == null) {
                        return false;
                    }
                    ++i;
                }
                if (writeTypeAttribute && xmlRef != null) {
                    this.writeXsiTypeAttribute(descriptor, xmlRef, isRootElement);
                    return true;
                }
            }
            return false;
        }
        return this.addXsiTypeAndClassIndicatorIfRequired(descriptor, referenceDescriptor, xmlField, isRootElement);
    }

    public void removeExtraNamespacesFromNamespaceResolver(List<Namespace> extraNamespaces, CoreAbstractSession session) {
        if (extraNamespaces == null) {
            return;
        }
        int i = 0;
        while (i < extraNamespaces.size()) {
            Namespace nextExtraNamespace = extraNamespaces.get(i);
            String uri = this.namespaceResolver.resolveNamespacePrefix(nextExtraNamespace.getPrefix());
            if (uri != null && uri.equals(nextExtraNamespace.getNamespaceURI())) {
                this.namespaceResolver.removeNamespace(nextExtraNamespace.getPrefix());
            }
            ++i;
        }
    }

    public void writeXsiTypeAttribute(Descriptor xmlDescriptor, String typeUri, String typeLocal, String typePrefix, boolean addToNamespaceResolver) {
        if (typeLocal == null) {
            return;
        }
        String typeValue = typeLocal;
        if (this.isNamespaceAware() && typeUri != null && !typeUri.equals("") && !typeUri.equals(this.namespaceResolver.getDefaultNamespaceURI())) {
            String prefix = this.namespaceResolver.resolveNamespaceURI(typeUri);
            if (prefix != null && !prefix.equals("")) {
                typeValue = String.valueOf(prefix) + this.getNamespaceSeparator() + typeValue;
            } else if (typeUri.equals("http://www.w3.org/2001/XMLSchema")) {
                prefix = this.namespaceResolver.generatePrefix("xsd");
                typeValue = String.valueOf(prefix) + this.getNamespaceSeparator() + typeValue;
                this.namespaceDeclaration(prefix, typeUri);
            } else if (typePrefix != null && !typePrefix.equals("")) {
                String existingUri = this.namespaceResolver.resolveNamespacePrefix(typePrefix);
                prefix = existingUri != null ? this.namespaceResolver.generatePrefix() : typePrefix;
                typeValue = String.valueOf(prefix) + this.getNamespaceSeparator() + typeValue;
                this.namespaceDeclaration(prefix, typeUri);
            } else {
                prefix = this.namespaceResolver.generatePrefix();
                typeValue = String.valueOf(prefix) + this.getNamespaceSeparator() + typeValue;
                this.namespaceDeclaration(prefix, typeUri);
            }
        }
        String xsiPrefix = null;
        if (this.isNamespaceAware() && (xsiPrefix = this.namespaceResolver.resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance")) == null) {
            xsiPrefix = this.namespaceResolver.generatePrefix("xsi");
            this.namespaceDeclaration(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
            if (addToNamespaceResolver) {
                this.namespaceResolver.put(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
            }
        }
        this.attributeWithoutQName("http://www.w3.org/2001/XMLSchema-instance", "type", xsiPrefix, typeValue);
    }

    protected void writeXsiTypeAttribute(Descriptor xmlDescriptor, XMLSchemaReference xmlRef, boolean addToNamespaceResolver) {
        QName contextAsQName = xmlRef.getSchemaContextAsQName();
        if (contextAsQName == null) {
            contextAsQName = xmlRef.getSchemaContextAsQName(this.namespaceResolver);
        }
        if (contextAsQName != null) {
            this.writeXsiTypeAttribute(xmlDescriptor, contextAsQName.getNamespaceURI(), contextAsQName.getLocalPart(), null, addToNamespaceResolver);
        }
    }
}

