/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.jpa.rs.AbstractResource;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.response.QueryResultList;
import org.eclipse.persistence.jpa.rs.response.QueryResultListItem;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;
import org.eclipse.persistence.jpa.rs.util.StreamingOutputMarshaller;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;

@Produces(value={"application/json", "application/xml"})
@Consumes(value={"application/json", "application/xml"})
@Path(value="/{context}/query/")
public class QueryResource
extends AbstractResource {
    @POST
    @Path(value="{name}")
    public Response namedQueryUpdate(@PathParam(value="context") String persistenceUnit, @PathParam(value="name") String name, @Context HttpHeaders hh, @Context UriInfo ui) {
        return this.namedQueryUpdateInternal(persistenceUnit, name, hh, ui);
    }

    protected Response namedQueryUpdateInternal(String persistenceUnit, String name, HttpHeaders hh, UriInfo ui) {
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, ui.getBaseUri(), null);
        if (app == null) {
            JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        int result = app.queryExecuteUpdate(QueryResource.getMatrixParameters(ui, persistenceUnit), name, QueryResource.getMatrixParameters(ui, name), QueryResource.getQueryParameters(ui));
        JAXBElement<Integer> jaxbElement = new JAXBElement<Integer>(new QName("result"), new Integer(result).getClass(), result);
        return Response.ok(new StreamingOutputMarshaller(app, jaxbElement, hh.getAcceptableMediaTypes())).build();
    }

    @GET
    @Path(value="{name}")
    public Response namedQuery(@PathParam(value="context") String persistenceUnit, @PathParam(value="name") String name, @Context HttpHeaders hh, @Context UriInfo ui) {
        return this.namedQueryInternal(persistenceUnit, name, hh, ui);
    }

    protected Response namedQueryInternal(String persistenceUnit, String name, HttpHeaders hh, UriInfo ui) {
        PersistenceContext app = this.getPersistenceFactory().get(persistenceUnit, ui.getBaseUri(), null);
        if (app == null) {
            JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        Query query = app.buildQuery(QueryResource.getMatrixParameters(ui, persistenceUnit), name, QueryResource.getMatrixParameters(ui, name), QueryResource.getQueryParameters(ui));
        DatabaseQuery dbQuery = ((EJBQueryImpl)query).getDatabaseQuery();
        if (dbQuery instanceof ReportQuery) {
            List<ReportItem> reportItems = ((ReportQuery)dbQuery).getItems();
            List results = app.queryMultipleResults(query);
            QueryResultList resultList = this.populateReportQueryResponse(results, reportItems);
            if (resultList != null) {
                return Response.ok(new StreamingOutputMarshaller(app, (Object)resultList, hh.getAcceptableMediaTypes())).build();
            }
        } else if (dbQuery instanceof ReadAllQuery || dbQuery instanceof ReadObjectQuery) {
            List results = app.queryMultipleResults(query);
            return Response.ok(new StreamingOutputMarshaller(app, (Object)results, hh.getAcceptableMediaTypes())).build();
        }
        return null;
    }

    private QueryResultList populateReportQueryResponse(List<Object[]> results, List<ReportItem> reportItems) {
        QueryResultList response = new QueryResultList();
        for (Object[] result : results) {
            QueryResultListItem queryResultListItem = new QueryResultListItem();
            List<JAXBElement> jaxbFields = this.createShellJAXBElementList(reportItems);
            if (jaxbFields == null) {
                return null;
            }
            if (result instanceof Object[]) {
                int i = 0;
                while (i < result.length) {
                    jaxbFields.get(i).setValue(result[i]);
                    ++i;
                }
            } else if (result instanceof Object) {
                jaxbFields.get(0).setValue(result);
            }
            queryResultListItem.setFields(jaxbFields);
            response.addItem(queryResultListItem);
        }
        return response;
    }

    private List<JAXBElement> createShellJAXBElementList(List<ReportItem> reportItems) {
        ArrayList<JAXBElement> jaxbElements = new ArrayList<JAXBElement>(reportItems.size());
        if (reportItems != null && reportItems.size() > 0) {
            for (ReportItem reportItem : reportItems) {
                String reportItemName = reportItem.getName();
                Class resultType = reportItem.getResultType();
                if (resultType == null) {
                    DatabaseMapping dbMapping = reportItem.getMapping();
                    if (dbMapping != null) {
                        resultType = dbMapping.getAttributeClassification();
                    } else {
                        ClassDescriptor desc = reportItem.getDescriptor();
                        if (desc != null) {
                            resultType = desc.getJavaClass();
                        } else {
                            return null;
                        }
                    }
                }
                JAXBElement<Object> element = new JAXBElement<Object>(new QName(reportItemName), resultType, null);
                jaxbElements.add(reportItem.getResultIndex(), element);
            }
        }
        return jaxbElements;
    }
}

