/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.jpa.weaving.RestAdapterClassWriter;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredFields;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.internal.weaving.RelationshipInfo;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBMarshaller;
import org.eclipse.persistence.jaxb.JAXBUnmarshaller;
import org.eclipse.persistence.jaxb.dynamic.DynamicJAXBContextFactory;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.jpa.PersistenceProvider;
import org.eclipse.persistence.jpa.dynamic.JPADynamicHelper;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSException;
import org.eclipse.persistence.jpa.rs.logging.LoggingLocalization;
import org.eclipse.persistence.jpa.rs.response.QueryResultList;
import org.eclipse.persistence.jpa.rs.response.QueryResultListItem;
import org.eclipse.persistence.jpa.rs.util.DynamicXMLMetadataSource;
import org.eclipse.persistence.jpa.rs.util.IdHelper;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;
import org.eclipse.persistence.jpa.rs.util.JTATransactionWrapper;
import org.eclipse.persistence.jpa.rs.util.LinkAdapter;
import org.eclipse.persistence.jpa.rs.util.LinkMetadataSource;
import org.eclipse.persistence.jpa.rs.util.PreLoginMappingAdapter;
import org.eclipse.persistence.jpa.rs.util.QueryResultListItemMetadataSource;
import org.eclipse.persistence.jpa.rs.util.QueryResultListMetadataSource;
import org.eclipse.persistence.jpa.rs.util.RelationshipLinkAdapter;
import org.eclipse.persistence.jpa.rs.util.ResourceLocalTransactionWrapper;
import org.eclipse.persistence.jpa.rs.util.TransactionWrapper;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLInverseReferenceMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;

public class PersistenceContext {
    public static final String JPARS_CONTEXT = "eclipselink.jpars.context";
    protected List<XmlAdapter> adapters = null;
    protected String name = null;
    protected EntityManagerFactory emf;
    protected JAXBContext context = null;
    protected URI baseURI = null;
    protected TransactionWrapper transaction = null;

    protected PersistenceContext() {
    }

    public PersistenceContext(String emfName, EntityManagerFactoryImpl emf, URI defaultURI) {
        this.emf = emf;
        this.name = emfName;
        this.transaction = this.getJpaSession().hasExternalTransactionController() ? new JTATransactionWrapper() : new ResourceLocalTransactionWrapper();
        try {
            this.context = this.createDynamicJAXBContext(emf.getDatabaseSession());
        }
        catch (JAXBException jaxbe) {
            JPARSLogger.exception("exception_creating_jaxb_context", new Object[]{emfName, jaxbe.toString()}, jaxbe);
            emf.close();
        }
        catch (IOException e) {
            JPARSLogger.exception("exception_creating_jaxb_context", new Object[]{emfName, e.toString()}, e);
            emf.close();
        }
        this.setBaseURI(defaultURI);
    }

    protected void addDynamicXMLMetadataSources(List<Object> metadataSources, DatabaseSession session) {
        HashSet<String> packages = new HashSet<String>();
        for (Class descriptorClass : session.getDescriptors().keySet()) {
            String packageName = "";
            if (descriptorClass.getName().lastIndexOf(46) > 0) {
                packageName = descriptorClass.getName().substring(0, descriptorClass.getName().lastIndexOf(46));
            }
            if (packages.contains(packageName)) continue;
            packages.add(packageName);
        }
        for (String packageName : packages) {
            metadataSources.add(new DynamicXMLMetadataSource(session, packageName));
        }
    }

    public void create(Map<String, String> tenantId, Object entity) {
        EntityManager em = this.getEmf().createEntityManager(tenantId);
        try {
            this.transaction.beginTransaction(em);
            em.persist(entity);
            this.transaction.commitTransaction(em);
        }
        finally {
            em.close();
        }
    }

    protected JAXBContext createDynamicJAXBContext(DatabaseSession session) throws JAXBException, IOException {
        JAXBContext jaxbContext = (JAXBContext)session.getProperty(JAXBContext.class.getName());
        if (jaxbContext != null) {
            return jaxbContext;
        }
        Map<String, Object> properties = this.createJAXBProperties(session);
        ClassLoader cl = session.getPlatform().getConversionManager().getLoader();
        jaxbContext = DynamicJAXBContextFactory.createContextFromOXM(cl, properties);
        session.setProperty(JAXBContext.class.getName(), jaxbContext);
        return jaxbContext;
    }

    protected EntityManagerFactoryImpl createEntityManagerFactory(PersistenceUnitInfo info, Map<String, ?> properties) {
        PersistenceProvider provider = new PersistenceProvider();
        EntityManagerFactory emf = provider.createContainerEntityManagerFactory(info, properties);
        return (EntityManagerFactoryImpl)emf;
    }

    protected EntityManager createEntityManager(String tenantId) {
        return this.getEmf().createEntityManager();
    }

    protected Map<String, Object> createJAXBProperties(DatabaseSession session) throws IOException {
        Object passedOXMLocations;
        HashMap<String, Object> properties = new HashMap<String, Object>(1);
        ArrayList<Object> metadataLocations = new ArrayList<Object>();
        this.addDynamicXMLMetadataSources(metadataLocations, session);
        String oxmLocation = (String)this.emf.getProperties().get("eclipselink.jpa-rs.oxm");
        if (oxmLocation != null) {
            metadataLocations.add(oxmLocation);
        }
        if ((passedOXMLocations = this.emf.getProperties().get("eclipselink.oxm.metadata-source")) != null) {
            if (passedOXMLocations instanceof Collection) {
                metadataLocations.addAll((Collection)passedOXMLocations);
            } else {
                metadataLocations.add(passedOXMLocations);
            }
        }
        metadataLocations.add(new LinkMetadataSource());
        metadataLocations.add(new QueryResultListMetadataSource());
        metadataLocations.add(new QueryResultListItemMetadataSource());
        properties.put("eclipselink.oxm.metadata-source", metadataLocations);
        properties.put("eclipselink.session-event-listener", new PreLoginMappingAdapter((AbstractSession)((Object)session)));
        return properties;
    }

    public void delete(Map<String, String> tenantId, String type2, Object id) {
        EntityManager em = this.getEmf().createEntityManager(tenantId);
        try {
            this.transaction.beginTransaction(em);
            Object entity = em.find(this.getClass(type2), id);
            if (entity != null) {
                em.remove(entity);
            }
            this.transaction.commitTransaction(em);
        }
        finally {
            em.close();
        }
    }

    public boolean doesExist(Map<String, String> tenantId, Object entity) {
        DatabaseSession session = JpaHelper.getDatabaseSession(this.getEmf());
        return session.doesObjectExist(entity);
    }

    public void finalize() {
        this.emf.close();
        this.emf = null;
        this.context = null;
    }

    public Object find(String entityName, Object id) {
        return this.find(null, entityName, id);
    }

    public Object find(Map<String, String> tenantId, String entityName, Object id) {
        return this.find(tenantId, entityName, id, null);
    }

    public Object find(Map<String, String> tenantId, String entityName, Object id, Map<String, Object> properties) {
        EntityManager em = this.getEmf().createEntityManager(tenantId);
        try {
            Object obj = em.find(this.getClass(entityName), id, properties);
            return obj;
        }
        finally {
            em.close();
        }
    }

    public Object findAttribute(Map<String, String> tenantId, String entityName, Object id, Map<String, Object> properties, String attribute) {
        EntityManager em = this.getEmf().createEntityManager(tenantId);
        try {
            Object object = em.find(this.getClass(entityName), id, properties);
            ClassDescriptor descriptor = this.getJpaSession().getClassDescriptor(this.getClass(entityName));
            DatabaseMapping mapping = descriptor.getMappingForAttributeName(attribute);
            if (mapping == null) {
                return null;
            }
            Object object2 = mapping.getRealAttributeValueFromAttribute(mapping.getAttributeValueFromObject(object), object, (AbstractSession)((Object)this.getJpaSession()));
            return object2;
        }
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object updateOrAddAttribute(Map<String, String> tenantId, String entityName, Object id, Map<String, Object> properties, String attribute, Object attributeValue, String partner) {
        EntityManager em = this.getEmf().createEntityManager(tenantId);
        try {
            ClassDescriptor referenceDescriptor;
            ClassDescriptor descriptor = this.getJpaSession().getClassDescriptor(this.getClass(entityName));
            DatabaseMapping mapping = descriptor.getMappingForAttributeName(attribute);
            Object object = null;
            if (mapping == null) {
                return null;
            }
            if (!mapping.isObjectReferenceMapping()) {
                if (!mapping.isCollectionMapping()) return null;
            }
            DatabaseMapping partnerMapping = null;
            if (partner != null && (partnerMapping = (referenceDescriptor = ((ForeignReferenceMapping)mapping).getReferenceDescriptor()).getMappingForAttributeName(partner)) == null) {
                return null;
            }
            this.transaction.beginTransaction(em);
            try {
                object = em.find(this.getClass(entityName), id, properties);
                if (object == null) {
                    return null;
                }
            }
            catch (Exception e) {
                JPARSLogger.fine("exception_while_updating_attribute", new Object[]{entityName, this.getName(), e.toString()});
                this.transaction.rollbackTransaction(em);
                em.close();
                return null;
            }
            {
                attributeValue = em.merge(attributeValue);
                this.setMappingValueInObject(object, attributeValue, mapping, partnerMapping);
                this.transaction.commitTransaction(em);
            }
            Object var15_15 = object;
            return var15_15;
        }
        finally {
            em.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object removeAttribute(Map<String, String> tenantId, String entityName, Object id, String attribute, String listItemId, Object entity, String partner) {
        EntityManager em = this.getEmf().createEntityManager(tenantId);
        String fieldName = null;
        try {
            Class<?> clazz = this.getClass(entityName);
            ClassDescriptor descriptor = this.getJpaSession().getClassDescriptor(clazz);
            DatabaseMapping mapping = descriptor.getMappingForAttributeName(attribute);
            if (mapping == null) {
                return null;
            }
            if (!mapping.isObjectReferenceMapping()) {
                if (!mapping.isCollectionMapping()) return null;
            }
            DatabaseMapping partnerMapping = null;
            Object originalAttributeValue = null;
            ClassDescriptor referenceDescriptor = ((ForeignReferenceMapping)mapping).getReferenceDescriptor();
            if (partner != null && (partnerMapping = referenceDescriptor.getMappingForAttributeName(partner)) == null) {
                return null;
            }
            Field[] fields = null;
            fields = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Field[])AccessController.doPrivileged(new PrivilegedGetDeclaredFields(clazz)) : PrivilegedAccessHelper.getDeclaredFields(clazz);
            int i = 0;
            while (i < fields.length) {
                Field field = fields[i];
                fieldName = field.getName();
                if (fieldName.equals(attribute)) {
                    try {
                        Object attributeValue;
                        originalAttributeValue = attributeValue = this.getAttribute(entity, attribute);
                        if (attributeValue instanceof Collection) {
                            if (listItemId == null) {
                                ((Collection)attributeValue).clear();
                                break;
                            }
                            Object realListItemId = IdHelper.buildId(this, referenceDescriptor.getAlias(), listItemId);
                            Object member = this.find(referenceDescriptor.getAlias(), realListItemId);
                            ((Collection)attributeValue).remove(member);
                            break;
                        }
                        if (attributeValue instanceof Object) {
                            attributeValue = null;
                            break;
                        }
                        attributeValue = 0;
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        em.close();
                        return null;
                    }
                }
                ++i;
            }
            this.transaction.beginTransaction(em);
            entity = em.merge(entity);
            this.removeMappingValueFromObject(entity, originalAttributeValue, mapping, partnerMapping);
            this.transaction.commitTransaction(em);
            Object object = entity;
            return object;
        }
        catch (Exception e) {
            JPARSLogger.fine("exception_while_removing_attribute", new Object[]{fieldName, entityName, this.getName(), e.toString()});
            this.transaction.rollbackTransaction(em);
            return null;
        }
        finally {
            em.close();
        }
    }

    private Object getAttribute(Object entity, String propertyName) {
        try {
            PropertyDescriptor[] props;
            BeanInfo info = Introspector.getBeanInfo(entity.getClass(), Object.class);
            PropertyDescriptor[] propertyDescriptorArray = props = info.getPropertyDescriptors();
            int n = props.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                String name = pd.getName();
                if (propertyName.equals(name)) {
                    Method getter = pd.getReadMethod();
                    Object value = null;
                    value = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedMethodInvoker(getter, entity)) : PrivilegedAccessHelper.invokeMethod(getter, entity);
                    return value;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    protected void removeMappingValueFromObject(Object object, Object attributeValue, DatabaseMapping mapping, DatabaseMapping partner) {
        boolean removed;
        if (mapping.isObjectReferenceMapping()) {
            Object currentValue = mapping.getRealAttributeValueFromObject(object, (AbstractSession)((Object)this.getJpaSession()));
            if (currentValue.equals(attributeValue)) {
                ((ObjectReferenceMapping)mapping).getIndirectionPolicy().setRealAttributeValueInObject(object, null, true);
                if (partner != null) {
                    this.removeMappingValueFromObject(attributeValue, object, partner, null);
                }
            }
        } else if (mapping.isCollectionMapping() && (removed = ((Collection)mapping.getRealAttributeValueFromObject(object, (AbstractSession)((Object)this.getJpaSession()))).remove(attributeValue)) && partner != null) {
            this.removeMappingValueFromObject(attributeValue, object, partner, null);
        }
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public Class<?> getClass(String entityName) {
        ClassDescriptor descriptor = this.getDescriptor(entityName);
        if (descriptor == null) {
            return null;
        }
        return descriptor.getJavaClass();
    }

    public DatabaseSession getJpaSession() {
        DatabaseSession dbSession = JpaHelper.getDatabaseSession(this.emf);
        return dbSession;
    }

    public ClassDescriptor getDescriptor(String entityName) {
        DatabaseSession session = this.getJpaSession();
        ClassDescriptor descriptor = session.getDescriptorForAlias(entityName);
        if (descriptor == null) {
            for (Object ajaxBSession : this.getJAXBContext().getXMLContext().getSessions()) {
                descriptor = ((Session)ajaxBSession).getClassDescriptorForAlias(entityName);
                if (descriptor != null) break;
            }
        }
        return descriptor;
    }

    public ClassDescriptor getDescriptorForClass(Class clazz) {
        DatabaseSession session = this.getJpaSession();
        ClassDescriptor descriptor = session.getDescriptor(clazz);
        if (descriptor == null) {
            return this.getJAXBDescriptorForClass(clazz);
        }
        return descriptor;
    }

    public ClassDescriptor getJAXBDescriptorForClass(Class clazz) {
        ClassDescriptor descriptor = null;
        for (Object ajaxBSession : this.getJAXBContext().getXMLContext().getSessions()) {
            descriptor = ((Session)ajaxBSession).getClassDescriptor(clazz);
            if (descriptor != null) break;
        }
        return descriptor;
    }

    public EntityManagerFactory getEmf() {
        return this.emf;
    }

    public JAXBContext getJAXBContext() {
        return this.context;
    }

    public String getName() {
        return this.name;
    }

    public Object merge(Map<String, String> tenantId, Object entity) {
        EntityManager em = this.getEmf().createEntityManager(tenantId);
        ArrayList mergedEntity = null;
        try {
            this.transaction.beginTransaction(em);
            if (entity instanceof List) {
                ArrayList mergeList = new ArrayList();
                for (Object o : (List)entity) {
                    mergeList.add(em.merge(o));
                }
                mergedEntity = mergeList;
            } else {
                mergedEntity = em.merge(entity);
            }
            this.transaction.commitTransaction(em);
            ArrayList arrayList = mergedEntity;
            return arrayList;
        }
        finally {
            em.close();
        }
    }

    public DynamicEntity newEntity(String type2) {
        return this.newEntity(null, type2);
    }

    public DynamicEntity newEntity(Map<String, String> tenantId, String type2) {
        JPADynamicHelper helper = new JPADynamicHelper(this.getEmf());
        DynamicEntity entity = null;
        try {
            entity = helper.newDynamicEntity(type2);
        }
        catch (IllegalArgumentException e) {
            DynamicType jaxbType;
            ClassDescriptor descriptor = this.getDescriptor(type2);
            if (descriptor != null && (jaxbType = (DynamicType)descriptor.getProperty("ENTITY_TYPE")) != null) {
                return jaxbType.newDynamicEntity();
            }
            JPARSLogger.fine("exception_thrown_while_creating_dynamic_entity", new Object[]{type2, e.toString()});
            throw e;
        }
        return entity;
    }

    public int queryExecuteUpdate(Map<String, String> tenantId, String name, Map<?, ?> parameters, Map<String, ?> hints) {
        EntityManager em = this.getEmf().createEntityManager(tenantId);
        try {
            Query query = this.constructQuery(em, name, parameters, hints);
            this.transaction.beginTransaction(em);
            int result = query.executeUpdate();
            this.transaction.commitTransaction(em);
            int n = result;
            return n;
        }
        finally {
            em.close();
        }
    }

    public Object querySingleResult(Map<String, String> tenantId, String name, Map<?, ?> parameters, Map<String, ?> hints) {
        EntityManager em = this.getEmf().createEntityManager(tenantId);
        try {
            Query query = this.constructQuery(em, name, parameters, hints);
            Object object = query.getSingleResult();
            return object;
        }
        finally {
            em.close();
        }
    }

    public List queryMultipleResults(Map<String, String> tenantId, String name, Map<?, ?> parameters, Map<String, ?> hints) {
        EntityManager em = this.getEmf().createEntityManager(tenantId);
        try {
            Query query = this.constructQuery(em, name, parameters, hints);
            List list = query.getResultList();
            return list;
        }
        finally {
            em.close();
        }
    }

    public List queryMultipleResults(Query query) {
        return query.getResultList();
    }

    protected Query constructQuery(EntityManager em, String name, Map<?, ?> parameters, Map<String, ?> hints) {
        Query query = em.createNamedQuery(name);
        DatabaseQuery dbQuery = ((EJBQueryImpl)query).getDatabaseQuery();
        if (parameters != null) {
            for (String key : parameters.keySet()) {
                Class parameterClass = null;
                int index = dbQuery.getArguments().indexOf(key);
                if (index >= 0) {
                    parameterClass = dbQuery.getArgumentTypes().get(index);
                }
                Object parameter = parameters.get(key);
                if (parameterClass != null) {
                    parameter = ConversionManager.getDefaultManager().convertObject(parameter, parameterClass);
                }
                query.setParameter(key, parameter);
            }
        }
        if (hints != null) {
            for (String key : hints.keySet()) {
                query.setHint(key, hints.get(key));
            }
        }
        return query;
    }

    protected Query buildQuery(Map<String, String> tenantId, String name, Map<?, ?> parameters, Map<String, ?> hints) {
        EntityManager em = this.getEmf().createEntityManager(tenantId);
        Query query = em.createNamedQuery(name);
        DatabaseQuery dbQuery = ((EJBQueryImpl)query).getDatabaseQuery();
        if (parameters != null) {
            for (String key : parameters.keySet()) {
                Class parameterClass = null;
                int index = dbQuery.getArguments().indexOf(key);
                if (index >= 0) {
                    parameterClass = dbQuery.getArgumentTypes().get(index);
                }
                Object parameter = parameters.get(key);
                if (parameterClass != null) {
                    parameter = ConversionManager.getDefaultManager().convertObject(parameter, parameterClass);
                }
                query.setParameter(key, parameter);
            }
        }
        if (hints != null) {
            for (String key : hints.keySet()) {
                query.setHint(key, hints.get(key));
            }
        }
        return query;
    }

    public void setBaseURI(URI baseURI) {
        this.baseURI = baseURI;
    }

    protected void setMappingValueInObject(Object object, Object attributeValue, DatabaseMapping mapping, DatabaseMapping partner) {
        if (mapping.isObjectReferenceMapping()) {
            ((ObjectReferenceMapping)mapping).getIndirectionPolicy().setRealAttributeValueInObject(object, attributeValue, true);
            if (partner != null) {
                this.setMappingValueInObject(attributeValue, object, partner, null);
            }
        } else if (mapping.isCollectionMapping()) {
            ((Collection)mapping.getAttributeValueFromObject(object)).add(attributeValue);
            if (partner != null) {
                this.setMappingValueInObject(attributeValue, object, partner, null);
            }
        }
    }

    public void stop() {
        if (this.emf != null && this.emf.isOpen()) {
            this.emf.close();
        }
        this.emf = null;
        this.context = null;
    }

    public String toString() {
        return "Application(" + this.getName() + ")::" + System.identityHashCode(this);
    }

    public Object unmarshalEntity(String type2, MediaType acceptedMedia, InputStream in) throws JAXBException {
        return this.unmarshalEntity(this.getClass(type2), acceptedMedia, in);
    }

    public Object unmarshalEntity(Class type2, MediaType acceptedMedia, InputStream in) throws JAXBException {
        JAXBUnmarshaller unmarshaller = this.getJAXBContext().createUnmarshaller();
        unmarshaller.setProperty("eclipselink.json.include-root", Boolean.FALSE);
        unmarshaller.setProperty("eclipselink.media-type", acceptedMedia.toString());
        unmarshaller.setAdapter(new LinkAdapter(this.getBaseURI().toString(), this));
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            @Override
            public boolean handleEvent(ValidationEvent event) {
                return event.getSeverity() == 0;
            }
        });
        for (XmlAdapter adapter : this.getAdapters()) {
            unmarshaller.setAdapter(adapter);
        }
        if (acceptedMedia == MediaType.APPLICATION_JSON_TYPE) {
            JAXBElement element = unmarshaller.unmarshal((Source)new StreamSource(in), type2);
            if (element.getValue() instanceof List) {
                for (Object object : (List)element.getValue()) {
                    this.wrap(object);
                }
                return element.getValue();
            }
            this.wrap(element.getValue());
            return element.getValue();
        }
        Object domainObject = unmarshaller.unmarshal(new StreamSource(in));
        if (domainObject instanceof List) {
            for (Object object : (List)domainObject) {
                this.wrap(object);
            }
            return domainObject;
        }
        this.wrap(domainObject);
        return domainObject;
    }

    protected Object wrap(Object entity) {
        if (!this.doesExist(null, entity)) {
            return entity;
        }
        ClassDescriptor descriptor = this.getJAXBDescriptorForClass(entity.getClass());
        if (entity instanceof FetchGroupTracker) {
            FetchGroup fetchGroup = new FetchGroup();
            for (DatabaseMapping mapping : descriptor.getMappings()) {
                if (mapping instanceof XMLInverseReferenceMapping) continue;
                fetchGroup.addAttribute(mapping.getAttributeName());
            }
            new FetchGroupManager().setObjectFetchGroup(entity, fetchGroup, null);
            ((FetchGroupTracker)entity)._persistence_setSession(JpaHelper.getDatabaseSession(this.getEmf()));
        } else if (descriptor.hasRelationships()) {
            for (DatabaseMapping mapping : descriptor.getMappings()) {
                if (!(mapping instanceof XMLInverseReferenceMapping)) continue;
                throw new JPARSException(LoggingLocalization.buildMessage("weaving_required_for_relationships", new Object[0]));
            }
        }
        return entity;
    }

    public void marshallEntity(Object object, MediaType mediaType, OutputStream output) throws JAXBException {
        this.marshallEntity(object, mediaType, output, true);
    }

    public void marshallEntity(Object object, MediaType mediaType, OutputStream output, boolean sendRelationships) throws JAXBException {
        if (sendRelationships) {
            this.preMarshallEntity(object);
        }
        JAXBMarshaller marshaller = this.getJAXBContext().createMarshaller();
        marshaller.setProperty("eclipselink.media-type", mediaType.toString());
        marshaller.setProperty("eclipselink.json.include-root", false);
        marshaller.setProperty("eclipselink.json.reduce-any-arrays", true);
        marshaller.setAdapter(new LinkAdapter(this.getBaseURI().toString(), this));
        marshaller.setAdapter(new RelationshipLinkAdapter(this.getBaseURI().toString(), this));
        for (XmlAdapter adapter : this.getAdapters()) {
            marshaller.setAdapter(adapter);
        }
        if (mediaType == MediaType.APPLICATION_XML_TYPE && object instanceof List) {
            marshaller.setProperty("jaxb.fragment", true);
            XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
            XMLStreamWriter writer = null;
            try {
                writer = outputFactory.createXMLStreamWriter(output);
                writer.writeStartDocument();
                writer.writeStartElement("List");
                for (Object o : (List)object) {
                    marshaller.marshal(o, writer);
                }
                writer.writeEndDocument();
                this.postMarshallEntity(object);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new JPARSException(e.toString());
            }
        } else {
            marshaller.marshal(object, output);
            this.postMarshallEntity(object);
        }
    }

    protected void preMarshallEntity(Object object) {
        if (object instanceof List) {
            Iterator i = ((List)object).iterator();
            while (i.hasNext()) {
                this.preMarshallIndividualEntity(i.next());
            }
        } else {
            this.preMarshallIndividualEntity(object);
        }
    }

    protected void preMarshallIndividualEntity(Object entity) {
        if (entity instanceof QueryResultListItem) {
            QueryResultListItem item = (QueryResultListItem)entity;
            List<JAXBElement> fields = item.getFields();
            int i = 0;
            while (i < fields.size()) {
                this.setRelationshipInfo(fields.get(i).getValue());
                ++i;
            }
        } else if (entity instanceof QueryResultList) {
            QueryResultList list = (QueryResultList)entity;
            List<QueryResultListItem> items = list.getItems();
            int i = 0;
            while (i < items.size()) {
                QueryResultListItem item = items.get(i);
                List<JAXBElement> fields = item.getFields();
                int index = 0;
                while (index < fields.size()) {
                    this.setRelationshipInfo(fields.get(index).getValue());
                    ++index;
                }
                ++i;
            }
        } else {
            this.setRelationshipInfo(entity);
        }
    }

    private void setRelationshipInfo(Object entity) {
        ClassDescriptor descriptor;
        if (entity != null && entity instanceof PersistenceWeavedRest && (descriptor = this.getJpaSession().getClassDescriptor(entity.getClass())) != null) {
            ((PersistenceWeavedRest)entity)._persistence_setRelationships(new ArrayList<RelationshipInfo>());
            for (DatabaseMapping mapping : descriptor.getMappings()) {
                if (!mapping.isForeignReferenceMapping()) continue;
                ForeignReferenceMapping frMapping = (ForeignReferenceMapping)mapping;
                RelationshipInfo info = new RelationshipInfo();
                info.setAttributeName(frMapping.getAttributeName());
                info.setOwningEntity(entity);
                info.setOwningEntityAlias(descriptor.getAlias());
                info.setPersistencePrimaryKey(descriptor.getObjectBuilder().extractPrimaryKeyFromObject(entity, (AbstractSession)((Object)this.getJpaSession())));
                ((PersistenceWeavedRest)entity)._persistence_getRelationships().add(info);
            }
        }
    }

    protected void postMarshallEntity(Object object) {
        if (object instanceof List) {
            for (Object entity : (List)object) {
                if (!(entity instanceof PersistenceWeavedRest)) continue;
                ((PersistenceWeavedRest)entity)._persistence_setRelationships(new ArrayList<RelationshipInfo>());
            }
        } else if (object instanceof PersistenceWeavedRest) {
            ((PersistenceWeavedRest)object)._persistence_setRelationships(new ArrayList<RelationshipInfo>());
        }
    }

    protected List<XmlAdapter> getAdapters() throws JPARSException {
        if (this.adapters != null) {
            return this.adapters;
        }
        this.adapters = new ArrayList<XmlAdapter>();
        try {
            for (ClassDescriptor desc : this.getJpaSession().getDescriptors().values()) {
                if (desc.isAggregateCollectionDescriptor() || desc.isAggregateDescriptor()) continue;
                Class clz = desc.getJavaClass();
                String referenceAdapterName = RestAdapterClassWriter.constructClassNameForReferenceAdapter(clz.getName());
                ClassLoader cl = this.getJpaSession().getDatasourcePlatform().getConversionManager().getLoader();
                Class<?> referenceAdaptorClass = Class.forName(referenceAdapterName, true, cl);
                Class[] argTypes = new Class[]{String.class, PersistenceContext.class};
                Constructor<?> referenceAdaptorConstructor = referenceAdaptorClass.getDeclaredConstructor(argTypes);
                Object[] args = new Object[]{this.getBaseURI().toString(), this};
                this.adapters.add((XmlAdapter)referenceAdaptorConstructor.newInstance(args));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new JPARSException(ex.getMessage());
        }
        return this.adapters;
    }
}

