/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriInfo;
import org.eclipse.persistence.jpa.rs.PersistenceContextFactory;
import org.eclipse.persistence.jpa.rs.PersistenceContextFactoryProvider;

public abstract class AbstractResource {
    protected PersistenceContextFactory factory;

    public void setPersistenceFactory(PersistenceContextFactory factory) {
        this.factory = factory;
    }

    public PersistenceContextFactory getPersistenceFactory() {
        if (this.factory == null) {
            this.factory = this.buildPersistenceContextFactory();
        }
        return this.factory;
    }

    protected PersistenceContextFactory buildPersistenceContextFactory() {
        ServiceLoader<PersistenceContextFactoryProvider> contextFactoryLoader = ServiceLoader.load(PersistenceContextFactoryProvider.class);
        for (PersistenceContextFactoryProvider provider : contextFactoryLoader) {
            PersistenceContextFactory factory = provider.getPersistenceContextFactory(null);
            if (factory == null) continue;
            return factory;
        }
        return null;
    }

    protected static Map<String, String> getMatrixParameters(UriInfo info, String segment) {
        HashMap<String, String> matrixParameters = new HashMap<String, String>();
        for (PathSegment pathSegment : info.getPathSegments()) {
            if (pathSegment.getPath() == null || !pathSegment.getPath().equals(segment)) continue;
            for (Map.Entry entry : pathSegment.getMatrixParameters().entrySet()) {
                matrixParameters.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
            }
            return matrixParameters;
        }
        return matrixParameters;
    }

    protected static Map<String, Object> getQueryParameters(UriInfo info) {
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        for (String key : info.getQueryParameters().keySet()) {
            queryParameters.put(key, info.getQueryParameters().getFirst(key));
        }
        return queryParameters;
    }
}

