/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.spi.java;

import java.lang.reflect.Member;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.spi.IEmbeddable;
import org.eclipse.persistence.jpa.jpql.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IMappedSuperclass;
import org.eclipse.persistence.jpa.jpql.spi.IMappingBuilder;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.java.JavaEmbeddable;
import org.eclipse.persistence.jpa.jpql.spi.java.JavaEntity;
import org.eclipse.persistence.jpa.jpql.spi.java.JavaMappedSuperclass;
import org.eclipse.persistence.jpa.jpql.spi.java.JavaType;
import org.eclipse.persistence.jpa.jpql.spi.java.JavaTypeRepository;
import org.eclipse.persistence.jpa.jpql.util.iterable.SnapshotCloneIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaManagedTypeProvider
implements IManagedTypeProvider {
    private Map<String, IEmbeddable> embeddables;
    private Map<String, IEntity> entities;
    private Map<String, IManagedType> managedTypes;
    private Map<String, IMappedSuperclass> mappedSuperclasses;
    private IMappingBuilder<Member> mappingBuilder;
    private JavaTypeRepository typeRepository;

    public JavaManagedTypeProvider(IMappingBuilder<Member> mappingBuilder) {
        this.initialize(mappingBuilder);
    }

    public IEmbeddable addEmbeddable(Class<?> type2) {
        IEmbeddable embeddable = this.buildEmbeddable(type2);
        this.embeddables.put(type2.getName(), embeddable);
        this.managedTypes.put(type2.getName(), embeddable);
        return embeddable;
    }

    public IEntity addEntity(Class<?> type2) {
        IEntity entity = this.buildEntity(type2);
        this.entities.put(type2.getName(), entity);
        this.managedTypes.put(type2.getName(), entity);
        return entity;
    }

    public IMappedSuperclass addMappedSuperclass(Class<?> type2) {
        IMappedSuperclass mappedSuperclass = this.buildMappedSuperclass(type2);
        this.mappedSuperclasses.put(type2.getName(), mappedSuperclass);
        this.managedTypes.put(type2.getName(), mappedSuperclass);
        return mappedSuperclass;
    }

    protected IEmbeddable buildEmbeddable(Class<?> type2) {
        return new JavaEmbeddable(this, (JavaType)this.getTypeRepository().getType((Class)type2), this.mappingBuilder);
    }

    protected IEntity buildEntity(Class<?> type2) {
        return new JavaEntity(this, (JavaType)this.getTypeRepository().getType((Class)type2), this.mappingBuilder);
    }

    protected IMappedSuperclass buildMappedSuperclass(Class<?> type2) {
        return new JavaMappedSuperclass(this, (JavaType)this.getTypeRepository().getType((Class)type2), this.mappingBuilder);
    }

    @Override
    public Iterable<IEntity> entities() {
        return new SnapshotCloneIterable<IEntity>(this.entities.values());
    }

    @Override
    public IEmbeddable getEmbeddable(IType type2) {
        return this.getEmbeddable(type2.getName());
    }

    @Override
    public IEmbeddable getEmbeddable(String typeName) {
        return this.embeddables.get(typeName);
    }

    @Override
    public IEntity getEntity(IType type2) {
        return this.getEntity(type2.getName());
    }

    @Override
    public IEntity getEntity(String typeName) {
        return this.entities.get(typeName);
    }

    @Override
    public IEntity getEntityNamed(String entityName) {
        for (IEntity entity : this.entities.values()) {
            if (!entity.getName().equals(entityName)) continue;
            return entity;
        }
        return null;
    }

    @Override
    public IManagedType getManagedType(IType type2) {
        return this.getManagedType(type2.getName());
    }

    @Override
    public IManagedType getManagedType(String typeName) {
        return this.managedTypes.get(typeName);
    }

    @Override
    public IMappedSuperclass getMappedSuperclass(IType type2) {
        return this.getMappedSuperclass(type2.getName());
    }

    @Override
    public IMappedSuperclass getMappedSuperclass(String typeName) {
        return this.mappedSuperclasses.get(typeName);
    }

    protected IMappingBuilder<Member> getMappingBuilder() {
        return this.mappingBuilder;
    }

    @Override
    public JavaTypeRepository getTypeRepository() {
        if (this.typeRepository == null) {
            this.typeRepository = new JavaTypeRepository(this.getClass().getClassLoader());
        }
        return this.typeRepository;
    }

    protected void initialize() {
    }

    private void initialize(IMappingBuilder<Member> mappingBuilder) {
        Assert.isNotNull(mappingBuilder, "The IMappingBuilder cannot be null");
        this.mappingBuilder = mappingBuilder;
        this.entities = new HashMap<String, IEntity>();
        this.embeddables = new HashMap<String, IEmbeddable>();
        this.managedTypes = new HashMap<String, IManagedType>();
        this.mappedSuperclasses = new HashMap<String, IMappedSuperclass>();
        this.initialize();
    }

    @Override
    public Iterable<IManagedType> managedTypes() {
        return new SnapshotCloneIterable<IManagedType>(this.managedTypes.values());
    }
}

