/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.spi.java;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Access;
import javax.persistence.AccessType;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IMappingBuilder;
import org.eclipse.persistence.jpa.jpql.spi.java.JavaType;
import org.eclipse.persistence.jpa.jpql.util.iterable.SnapshotCloneIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaManagedType
implements IManagedType {
    private IMappingBuilder<Member> mappingBuilder;
    private Map<String, IMapping> mappings;
    private final IManagedTypeProvider provider;
    private final JavaType type;

    public JavaManagedType(IManagedTypeProvider provider, JavaType type2, IMappingBuilder<Member> mappingBuilder) {
        this.type = type2;
        this.provider = provider;
        this.mappingBuilder = mappingBuilder;
    }

    protected IMapping buildMapping(Member member) {
        return this.mappingBuilder.buildMapping(this, member);
    }

    @Override
    public int compareTo(IManagedType managedType) {
        return this.getType().getName().compareTo(managedType.getType().getName());
    }

    protected AccessType getAccessType() {
        Access accessType = this.type.getType().getAnnotation(Access.class);
        if (accessType == null) {
            return AccessType.FIELD;
        }
        return accessType.value();
    }

    @Override
    public IMapping getMappingNamed(String name) {
        this.initializeMappings();
        return this.mappings.get(name);
    }

    @Override
    public IManagedTypeProvider getProvider() {
        return this.provider;
    }

    @Override
    public JavaType getType() {
        return this.type;
    }

    protected void initializeMappings() {
        if (this.mappings == null) {
            this.mappings = new HashMap<String, IMapping>();
            this.initializeMappings(this.type.getType(), this.getAccessType());
        }
    }

    protected void initializeMappings(Class<?> type2, AccessType accessType) {
        if (type2 == Object.class) {
            return;
        }
        if (accessType == AccessType.FIELD) {
            Field[] fieldArray = type2.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (this.isPersistentAttribute(field)) {
                    this.mappings.put(field.getName(), this.buildMapping(field));
                }
                ++n2;
            }
        } else {
            Method[] methodArray = type2.getDeclaredMethods();
            int n = methodArray.length;
            int n3 = 0;
            while (n3 < n) {
                Method method = methodArray[n3];
                if (this.isProperty(method)) {
                    this.mappings.put(method.getName(), this.buildMapping(method));
                }
                ++n3;
            }
        }
        this.initializeMappings(type2.getSuperclass(), accessType);
    }

    protected boolean isPersistentAttribute(Field field) {
        int modifiers = field.getModifiers();
        return !Modifier.isStatic(modifiers) && !Modifier.isPublic(modifiers);
    }

    protected boolean isProperty(Method method) {
        int modifiers = method.getModifiers();
        String name = method.getName();
        return !(!name.startsWith("get") && !name.startsWith("is") || method.getReturnType() == Void.class || method.getParameterTypes().length != 0 || Modifier.isStatic(modifiers) || Modifier.isNative(modifiers) || !Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers));
    }

    @Override
    public final Iterable<IMapping> mappings() {
        this.initializeMappings();
        return new SnapshotCloneIterable<IMapping>(this.mappings.values());
    }
}

