/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.spi.java;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import org.eclipse.persistence.jpa.jpql.spi.IConstructor;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.spi.ITypeRepository;
import org.eclipse.persistence.jpa.jpql.spi.java.JavaType;
import org.eclipse.persistence.jpa.jpql.spi.java.JavaTypeDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaConstructor
implements IConstructor {
    private Constructor<?> constructor;
    private ITypeDeclaration[] parameterTypes;
    private JavaType type;

    public JavaConstructor(JavaType type2, Constructor<?> constructor) {
        this.type = type2;
        this.constructor = constructor;
    }

    protected ITypeDeclaration[] buildParameterTypes() {
        Class<?>[] types = this.constructor.getParameterTypes();
        Type[] genericTypes = this.constructor.getGenericParameterTypes();
        ITypeDeclaration[] typeDeclarations = new ITypeDeclaration[types.length];
        int index = 0;
        int count = types.length;
        while (index < count) {
            typeDeclarations[index] = this.buildTypeDeclaration(types[index], genericTypes[index]);
            ++index;
        }
        return typeDeclarations;
    }

    protected ITypeDeclaration buildTypeDeclaration(Class<?> javaType, Type genericType) {
        ITypeRepository typeRepository = this.getTypeRepository();
        IType type2 = typeRepository.getType(javaType);
        return new JavaTypeDeclaration(typeRepository, type2, genericType, javaType.isArray());
    }

    @Override
    public ITypeDeclaration[] getParameterTypes() {
        if (this.parameterTypes == null) {
            this.parameterTypes = this.buildParameterTypes();
        }
        return this.parameterTypes;
    }

    protected ITypeRepository getTypeRepository() {
        return this.type.getTypeRepository();
    }

    public String toString() {
        return this.constructor.toGenericString();
    }
}

