/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.spi.java;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.eclipse.persistence.jpa.jpql.TypeHelper;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.spi.ITypeRepository;
import org.eclipse.persistence.jpa.jpql.spi.java.JavaTypeDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMapping
implements IMapping {
    private int mappingType;
    private Member member;
    private IManagedType parent;
    private IType type;
    private ITypeDeclaration typeDeclaration;

    protected AbstractMapping(IManagedType parent, Member member) {
        this.parent = parent;
        this.member = member;
        this.mappingType = -1;
    }

    protected ITypeDeclaration buildTypeDeclaration() {
        return new JavaTypeDeclaration(this.parent.getProvider().getTypeRepository(), this.getType(), this.getMemberGenericType(), this.getMemberType().isArray());
    }

    protected int calculateMappingType() {
        return this.calculateMappingType(this.getMemberAnnotations());
    }

    protected int calculateMappingType(Annotation[] annotations) {
        if (this.hasAnnotation(annotations, ElementCollection.class)) {
            return 2;
        }
        if (this.hasAnnotation(annotations, Embedded.class)) {
            return 3;
        }
        if (this.hasAnnotation(annotations, EmbeddedId.class)) {
            return 4;
        }
        if (this.hasAnnotation(annotations, Id.class)) {
            return 5;
        }
        if (this.hasAnnotation(annotations, ManyToMany.class)) {
            return 6;
        }
        if (this.hasAnnotation(annotations, ManyToOne.class)) {
            return 7;
        }
        if (this.hasAnnotation(annotations, OneToMany.class)) {
            return 8;
        }
        if (this.hasAnnotation(annotations, OneToOne.class)) {
            return 9;
        }
        if (this.hasAnnotation(annotations, Transient.class)) {
            return 10;
        }
        if (this.hasAnnotation(annotations, Version.class)) {
            return 11;
        }
        IType type2 = this.getType();
        TypeHelper typeHelper = this.getTypeRepository().getTypeHelper();
        if (typeHelper.isCollectionType(type2) || typeHelper.isMapType(type2)) {
            return 8;
        }
        if (this.parent.getProvider().getEntity(type2) != null) {
            return 9;
        }
        if (this.parent.getProvider().getEmbeddable(type2) != null) {
            return 3;
        }
        return 1;
    }

    @Override
    public int compareTo(IMapping mapping) {
        return this.getName().compareTo(mapping.getName());
    }

    @Override
    public int getMappingType() {
        if (this.mappingType == -1) {
            this.mappingType = this.calculateMappingType();
        }
        return this.mappingType;
    }

    public Member getMember() {
        return this.member;
    }

    protected abstract Annotation[] getMemberAnnotations();

    protected abstract Type getMemberGenericType();

    protected abstract Class<?> getMemberType();

    @Override
    public String getName() {
        return this.member.getName();
    }

    @Override
    public IManagedType getParent() {
        return this.parent;
    }

    @Override
    public IType getType() {
        if (this.type == null) {
            this.type = this.getTypeRepository().getType(this.getMemberType());
        }
        return this.type;
    }

    @Override
    public ITypeDeclaration getTypeDeclaration() {
        if (this.typeDeclaration == null) {
            this.typeDeclaration = this.buildTypeDeclaration();
        }
        return this.typeDeclaration;
    }

    protected ITypeRepository getTypeRepository() {
        return this.parent.getProvider().getTypeRepository();
    }

    protected boolean hasAnnotation(Annotation[] annotations, Class<? extends Annotation> annotationType) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType() == annotationType) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean hasAnnotation(Annotation[] annotations, String annotationType) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().getName().equals(annotationType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isCollection() {
        switch (this.getMappingType()) {
            case 2: 
            case 6: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isProperty() {
        switch (this.getMappingType()) {
            case 1: 
            case 5: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isRelationship() {
        switch (this.getMappingType()) {
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isTransient() {
        return this.getMappingType() == 10;
    }

    public String toString() {
        return this.getName();
    }
}

