/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.util.iterable.ListIterable;
import org.eclipse.persistence.jpa.jpql.util.iterable.SnapshotCloneListIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPathExpression
extends AbstractExpression {
    private Boolean endsWithDot;
    private AbstractExpression identificationVariable;
    private List<String> paths;
    private int pathSize = -1;
    private boolean startsWithDot;
    private boolean virtualIdentificationVariable;

    protected AbstractPathExpression(AbstractExpression parent, AbstractExpression expression) {
        super(parent);
        this.identificationVariable = expression;
        this.identificationVariable.setParent(this);
    }

    public AbstractPathExpression(AbstractExpression parent, AbstractExpression expression, String paths) {
        super(parent, paths);
        this.identificationVariable = expression;
        this.identificationVariable.setParent(this);
    }

    protected AbstractPathExpression(AbstractExpression parent, String paths) {
        super(parent, paths);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getIdentificationVariable().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        this.checkPaths();
        children.add(this.identificationVariable);
    }

    @Override
    protected final void addOrderedChildrenTo(List<Expression> children) {
        this.checkPaths();
        children.add(this.identificationVariable);
        children.add(this.buildStringExpression(this.getText()));
    }

    private void checkPaths() {
        if (this.paths == null) {
            boolean hasDot;
            this.paths = new ArrayList<String>();
            String text = this.getText();
            StringBuilder word = new StringBuilder();
            boolean bl = hasDot = text.indexOf(46) > -1;
            if (this.identificationVariable != null && !this.virtualIdentificationVariable) {
                this.paths.add(this.identificationVariable.toParsedText());
            }
            int index = 0;
            int count = text.length();
            while (index < count) {
                char character = text.charAt(index);
                if (index != 0 || character != '.' || this.identificationVariable == null) {
                    if (character != '.') {
                        word.append(character);
                    } else {
                        if (hasDot && this.identificationVariable == null) {
                            this.identificationVariable = word.length() == 0 ? this.buildNullExpression() : new IdentificationVariable(this, word.toString());
                        }
                        this.paths.add(word.toString());
                        word.delete(0, word.length());
                    }
                }
                ++index;
            }
            if (this.identificationVariable == null) {
                this.identificationVariable = hasDot ? new IdentificationVariable(this, word.toString()) : this.buildNullExpression();
            }
            if (word.length() > 0) {
                this.paths.add(word.toString());
            }
        }
    }

    public final boolean endsWithDot() {
        if (this.endsWithDot == null) {
            String text = this.getText();
            this.endsWithDot = text.charAt(text.length() - 1) == '.';
        }
        return this.endsWithDot;
    }

    public final Expression getIdentificationVariable() {
        this.checkPaths();
        return this.identificationVariable;
    }

    public final String getPath(int index) {
        this.checkPaths();
        return this.paths.get(index);
    }

    public final boolean hasIdentificationVariable() {
        this.checkPaths();
        return !this.identificationVariable.isNull() && !this.identificationVariable.isVirtual();
    }

    public final boolean hasVirtualIdentificationVariable() {
        return this.virtualIdentificationVariable;
    }

    @Override
    protected final void parse(WordParser wordParser, boolean tolerant) {
        String word = this.getText();
        if (!this.hasIdentificationVariable()) {
            this.startsWithDot = word.startsWith(".");
        }
        wordParser.moveForward(word);
    }

    public final ListIterable<String> paths() {
        this.checkPaths();
        return new SnapshotCloneListIterable<String>(this.paths);
    }

    public final int pathSize() {
        if (this.pathSize == -1) {
            this.checkPaths();
            this.pathSize = this.paths.size();
        }
        return this.pathSize;
    }

    protected final void setVirtualIdentificationVariable(String variableName) {
        this.paths = null;
        this.virtualIdentificationVariable = true;
        this.identificationVariable = new IdentificationVariable(this, variableName, true);
        this.rebuildActualText();
        this.rebuildParsedText();
    }

    public final boolean startsWithDot() {
        return this.startsWithDot;
    }

    public String toParsedText(int startIndex, int stopIndex) {
        this.checkPaths();
        StringBuilder writer = new StringBuilder();
        int index = startIndex;
        while (index < stopIndex) {
            writer.append(this.paths.get(index));
            if (index < stopIndex - 1) {
                writer.append('.');
            }
            ++index;
        }
        return writer.toString();
    }

    @Override
    protected final void toParsedText(StringBuilder writer, boolean actual) {
        int pathSize = this.pathSize();
        if (this.startsWithDot) {
            writer.append('.');
        } else if (!this.virtualIdentificationVariable) {
            this.identificationVariable.toParsedText(writer, actual);
            if (pathSize > 1) {
                writer.append('.');
            }
        }
        int index = this.virtualIdentificationVariable ? 0 : 1;
        while (index < pathSize) {
            writer.append(this.paths.get(index));
            if (index < pathSize - 1) {
                writer.append('.');
            }
            ++index;
        }
        if (this.endsWithDot()) {
            writer.append('.');
        }
    }
}

