/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.model.IListChangeEvent;
import org.eclipse.persistence.jpa.jpql.model.IListChangeListener;
import org.eclipse.persistence.jpa.jpql.model.ListChangeEvent;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.ListHolderStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.parser.AbstractPathExpression;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.util.CollectionTools;
import org.eclipse.persistence.jpa.jpql.util.iterable.ListIterable;
import org.eclipse.persistence.jpa.jpql.util.iterable.SnapshotCloneListIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPathExpressionStateObject
extends AbstractStateObject
implements ListHolderStateObject<String> {
    private StateObject identificationVariable;
    private IManagedType managedType;
    private ArrayList<IMapping> mappings;
    private List<String> paths;
    private boolean resolved;
    private IType type;
    private ITypeDeclaration typeDeclaration;
    public static final String IDENTIFICATION_VARIABLE_PROPERTY = "identificationVariable";
    public static final String PATHS_LIST = "paths";

    protected AbstractPathExpressionStateObject(StateObject parent) {
        super(parent);
    }

    protected AbstractPathExpressionStateObject(StateObject parent, String path) {
        super(parent);
        this.setPath(path);
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        super.addChildren(children);
        StateObject stateObject = this.getIdentificationVariable();
        if (stateObject != null) {
            children.add(stateObject);
        }
    }

    @Override
    public String addItem(String item) {
        this.getChangeSupport().addItem(this, this.paths, PATHS_LIST, item);
        return item;
    }

    @Override
    public void addItems(List<? extends String> items) {
        this.getChangeSupport().addItems(this, this.paths, PATHS_LIST, items);
    }

    @Override
    public void addListChangeListener(String listName, IListChangeListener<String> listener) {
        this.getChangeSupport().addListChangeListener(listName, listener);
    }

    public void append(String text) {
        StringBuilder word = new StringBuilder();
        int pathCount = this.paths.size();
        boolean appendToLastSegment = true;
        int startIndex = pathCount;
        int index = 0;
        int count = text.length();
        while (index < count) {
            char character = text.charAt(index);
            if (character == '.') {
                if (word.length() > 0) {
                    if (appendToLastSegment) {
                        String currentPath = this.paths.get(pathCount - 1);
                        this.paths.set(pathCount - 1, String.valueOf(currentPath) + word);
                        startIndex = pathCount - 1;
                    } else {
                        this.paths.add(word.toString());
                        ++pathCount;
                    }
                    word.delete(0, word.length());
                }
                appendToLastSegment = false;
            } else {
                word.append(character);
            }
            ++index;
        }
        if (word.length() > 0) {
            if (appendToLastSegment) {
                String currentPath = this.paths.get(pathCount - 1);
                this.paths.set(pathCount - 1, String.valueOf(currentPath) + word);
                startIndex = pathCount - 1;
            } else {
                this.paths.add(word.toString());
            }
        }
        ListChangeEvent<String> event = new ListChangeEvent<String>(this, this.paths, IListChangeEvent.EventType.CHANGED, PATHS_LIST, this.paths, startIndex, this.itemsSize());
        this.getChangeSupport().fireListChangeEvent(event);
    }

    @Override
    public boolean canMoveDown(String item) {
        return false;
    }

    @Override
    public boolean canMoveUp(String item) {
        return false;
    }

    protected void clearResolvedObjects() {
        this.mappings.clear();
        this.resolved = false;
        this.type = null;
        this.typeDeclaration = null;
    }

    @Override
    public AbstractPathExpression getExpression() {
        return (AbstractPathExpression)super.getExpression();
    }

    public StateObject getIdentificationVariable() {
        if (this.identificationVariable == null && this.hasItems()) {
            this.identificationVariable = this.buildStateObject(this.getItem(0), "identification_variable");
        }
        return this.identificationVariable;
    }

    @Override
    public String getItem(int index) {
        return this.paths.get(index);
    }

    public IManagedType getManagedType() {
        if (this.managedType == null) {
            this.managedType = this.resolveManagedType();
        }
        return this.managedType;
    }

    public IMapping getMapping() {
        this.resolveMappings();
        return this.mappings.get(this.itemsSize() - 1);
    }

    public IMapping getMapping(int index) {
        this.resolveMappings();
        return this.mappings.get(index);
    }

    public String getPath() {
        return this.toString();
    }

    public IType getType() {
        if (this.type == null) {
            this.type = this.resolveType();
        }
        return this.type;
    }

    public ITypeDeclaration getTypeDeclaration() {
        if (this.typeDeclaration == null) {
            this.typeDeclaration = this.resolveTypeDeclaration();
        }
        return this.typeDeclaration;
    }

    public boolean hasIdentificationVariable() {
        return this.getIdentificationVariable() != null;
    }

    @Override
    public boolean hasItems() {
        return !this.paths.isEmpty();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.paths = new ArrayList<String>();
        this.mappings = new ArrayList();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean isEquivalent(StateObject stateObject) {
        if (!super.isEquivalent(stateObject)) {
            return false;
        }
        path = (AbstractPathExpressionStateObject)stateObject;
        if (!this.areEquivalent(this.getIdentificationVariable(), path.getIdentificationVariable())) {
            return false;
        }
        index = this.itemsSize();
        if (index == path.itemsSize()) ** GOTO lbl12
        return false;
lbl-1000:
        // 1 sources

        {
            path1 = this.getItem(index);
            if (!ExpressionTools.valuesAreDifferent(path1, path2 = path.getItem(index))) continue;
            return false;
lbl12:
            // 2 sources

            ** while (--index > 0)
        }
lbl13:
        // 1 sources

        return true;
    }

    @Override
    public ListIterable<String> items() {
        return new SnapshotCloneListIterable<String>(this.paths);
    }

    @Override
    public int itemsSize() {
        return this.paths.size();
    }

    @Override
    public String moveDown(String item) {
        throw new RuntimeException(String.valueOf(this.getClass().getName()) + " does not support moveDown(String).");
    }

    @Override
    public String moveUp(String item) {
        throw new RuntimeException(String.valueOf(this.getClass().getName()) + " does not support moveUp(String).");
    }

    @Override
    public void removeItem(int index) {
        if (index == 0) {
            this.setIdentificationVariableInternally(null);
        }
        this.removeItem(this.getItem(index));
    }

    @Override
    public void removeItem(String item) {
        this.getChangeSupport().removeItem(this, this.paths, PATHS_LIST, item);
    }

    @Override
    public void removeItems(Collection<String> items) {
        this.getChangeSupport().removeItems(this, this.paths, PATHS_LIST, items);
    }

    @Override
    public void removeListChangeListener(String listName, IListChangeListener<String> listener) {
        this.getChangeSupport().removeListChangeListener(listName, listener);
    }

    protected abstract IManagedType resolveManagedType();

    protected void resolveMappings() {
        if (!this.resolved) {
            this.resolved = true;
            IManagedTypeProvider provider = this.getManagedTypeProvider();
            IManagedType managedType = null;
            int index = 0;
            int count = this.itemsSize();
            while (index < count) {
                if (index == 0) {
                    StateObject stateObject = this.getIdentificationVariable();
                    if (stateObject != null) {
                        managedType = this.getDeclaration().findManagedType(stateObject);
                    }
                    this.mappings.add(null);
                } else if (managedType != null) {
                    String path = this.getItem(index);
                    IMapping mapping = managedType.getMappingNamed(path);
                    this.mappings.add(mapping);
                    managedType = mapping != null ? provider.getManagedType(mapping.getType()) : null;
                } else {
                    this.mappings.add(null);
                }
                ++index;
            }
        }
    }

    protected abstract IType resolveType();

    protected ITypeDeclaration resolveTypeDeclaration() {
        this.resolveMappings();
        return this.getMapping().getTypeDeclaration();
    }

    public void setIdentificationVariable(StateObject identificationVariable) {
        this.setIdentificationVariableInternally(identificationVariable);
        this.getChangeSupport().replaceItem(this, this.paths, PATHS_LIST, 0, identificationVariable.toString());
    }

    protected void setIdentificationVariableInternally(StateObject identificationVariable) {
        this.clearResolvedObjects();
        StateObject oldIdentificationVariable = this.identificationVariable;
        this.identificationVariable = this.parent(identificationVariable);
        this.firePropertyChanged(IDENTIFICATION_VARIABLE_PROPERTY, oldIdentificationVariable, identificationVariable);
    }

    public void setPath(CharSequence path) {
        ArrayList<String> paths = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(path.toString(), ".", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!token.equals(".")) {
                paths.add(token);
                continue;
            }
            if (tokenizer.hasMoreTokens()) continue;
            paths.add("");
        }
        this.setPaths(paths.listIterator());
    }

    public void setPath(int index, String path) {
        if (index == 0) {
            this.setIdentificationVariableInternally(null);
        } else {
            this.clearResolvedObjects();
        }
        this.getChangeSupport().replaceItem(this, this.paths, PATHS_LIST, index, path);
    }

    public void setPaths(List<String> paths) {
        this.setIdentificationVariableInternally(null);
        this.getChangeSupport().replaceItems(this, this.paths, PATHS_LIST, paths);
    }

    public void setPaths(ListIterator<String> paths) {
        this.setPaths(CollectionTools.list(paths));
    }

    public void setPaths(String ... paths) {
        this.setPaths(Arrays.asList(paths));
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        String variable;
        StateObject stateObject = this.getIdentificationVariable();
        if (stateObject != null && (variable = stateObject.toString()).length() > 0) {
            writer.append(variable);
            if (this.hasItems()) {
                writer.append('.');
            }
        }
        int index = 1;
        int count = this.paths.size();
        while (index < count) {
            writer.append(this.paths.get(index));
            if (index < count - 1) {
                writer.append('.');
            }
            ++index;
        }
    }
}

