/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.persistence.jpa.jpql.NumericTypeComparator;
import org.eclipse.persistence.jpa.jpql.Resolver;
import org.eclipse.persistence.jpa.jpql.TypeHelper;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericResolver
extends Resolver {
    private final Collection<Resolver> resolvers;

    public NumericResolver(Resolver parent, Collection<Resolver> typeResolvers) {
        super(parent);
        this.resolvers = typeResolvers;
    }

    public NumericResolver(Resolver parent, Resolver resolver) {
        this(parent, Collections.singleton(resolver));
    }

    @Override
    protected IType buildType() {
        ArrayList<IType> types = new ArrayList<IType>(this.resolvers.size());
        TypeHelper helper = this.getTypeHelper();
        IType unresolvableType = helper.unknownType();
        for (Resolver typeResolver : this.resolvers) {
            IType type2 = typeResolver.getType();
            if (type2 == unresolvableType) continue;
            if (!helper.isNumericType(type2)) {
                type2 = helper.objectType();
            }
            types.add(type2);
        }
        if (types.isEmpty()) {
            return helper.unknownType();
        }
        Collections.sort(types, new NumericTypeComparator(helper));
        return (IType)types.get(0);
    }

    @Override
    protected ITypeDeclaration buildTypeDeclaration() {
        return this.getType().getTypeDeclaration();
    }
}

