/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.parser.AbstractPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.jpql.parser.AnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.EntityTypeLiteral;
import org.eclipse.persistence.jpa.jpql.parser.FunctionExpression;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.jpql.parser.Join;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.StringLiteral;
import org.eclipse.persistence.jpa.jpql.parser.TreatExpression;

public abstract class LiteralVisitor
extends AnonymousExpressionVisitor {
    public String literal;
    protected LiteralType type;

    protected LiteralVisitor() {
    }

    public LiteralType getType() {
        return this.type;
    }

    public void setType(LiteralType type2) {
        this.type = type2;
        this.literal = "";
    }

    public void visit(AbstractSchemaName expression) {
        if (this.type == LiteralType.ABSTRACT_SCHEMA_NAME) {
            this.literal = expression.getText();
        }
    }

    public void visit(CollectionMemberDeclaration expression) {
        if (this.type == LiteralType.PATH_EXPRESSION_ALL_PATH || this.type == LiteralType.PATH_EXPRESSION_IDENTIFICATION_VARIABLE || this.type == LiteralType.PATH_EXPRESSION_LAST_PATH) {
            expression.getCollectionValuedPathExpression().accept(this);
        } else if (this.type == LiteralType.IDENTIFICATION_VARIABLE) {
            expression.getIdentificationVariable().accept(this);
        }
    }

    public void visit(CollectionValuedPathExpression expression) {
        this.visitAbstractPathExpression(expression);
    }

    public void visit(EntityTypeLiteral expression) {
        if (this.type == LiteralType.ENTITY_TYPE) {
            this.literal = expression.getEntityTypeName();
        }
    }

    public void visit(FunctionExpression expression) {
        if (this.type == LiteralType.STRING_LITERAL) {
            this.literal = expression.getFunctionName();
        }
    }

    public void visit(IdentificationVariable expression) {
        if (this.type == LiteralType.RESULT_VARIABLE || this.type == LiteralType.IDENTIFICATION_VARIABLE || this.type == LiteralType.PATH_EXPRESSION_IDENTIFICATION_VARIABLE) {
            this.literal = expression.getText();
        }
    }

    public void visit(InputParameter expression) {
        if (this.type == LiteralType.INPUT_PARAMETER) {
            this.literal = expression.getParameter();
        }
    }

    public void visit(Join expression) {
        if (this.type == LiteralType.IDENTIFICATION_VARIABLE) {
            expression.getIdentificationVariable().accept(this);
        } else {
            expression.getJoinAssociationPath().accept(this);
        }
    }

    public void visit(RangeVariableDeclaration expression) {
        if (this.type == LiteralType.ABSTRACT_SCHEMA_NAME) {
            expression.getRootObject().accept(this);
        } else if (this.type == LiteralType.IDENTIFICATION_VARIABLE) {
            expression.getIdentificationVariable().accept(this);
        }
    }

    public void visit(ResultVariable expression) {
        if (this.type == LiteralType.RESULT_VARIABLE) {
            expression.getResultVariable().accept(this);
        }
    }

    public void visit(StateFieldPathExpression expression) {
        this.visitAbstractPathExpression(expression);
    }

    public void visit(StringLiteral expression) {
        if (this.type == LiteralType.STRING_LITERAL) {
            this.literal = expression.getText();
        }
    }

    public void visit(TreatExpression expression) {
        expression.getCollectionValuedPathExpression().accept(this);
        expression.getEntityType().accept(this);
    }

    protected void visitAbstractPathExpression(AbstractPathExpression expression) {
        if (this.type == LiteralType.PATH_EXPRESSION_IDENTIFICATION_VARIABLE) {
            expression.getIdentificationVariable().accept(this);
        } else if (this.type == LiteralType.PATH_EXPRESSION_ALL_PATH) {
            this.literal = expression.toParsedText();
        } else if (this.type == LiteralType.PATH_EXPRESSION_LAST_PATH) {
            this.literal = expression.getPath(expression.pathSize() - 1);
        }
    }
}

