/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import org.eclipse.persistence.jpa.jpql.AbstractContentAssistVisitor;
import org.eclipse.persistence.jpa.jpql.ContentAssistProposals;
import org.eclipse.persistence.jpa.jpql.Declaration;
import org.eclipse.persistence.jpa.jpql.EclipseLinkVersion;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.parser.AbstractEclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractFromClause;
import org.eclipse.persistence.jpa.jpql.parser.AbstractPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.AsOfClause;
import org.eclipse.persistence.jpa.jpql.parser.CastExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConnectByClause;
import org.eclipse.persistence.jpa.jpql.parser.DatabaseType;
import org.eclipse.persistence.jpa.jpql.parser.EclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExtractExpression;
import org.eclipse.persistence.jpa.jpql.parser.GroupByClause;
import org.eclipse.persistence.jpa.jpql.parser.HavingClause;
import org.eclipse.persistence.jpa.jpql.parser.HierarchicalQueryClause;
import org.eclipse.persistence.jpa.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.jpql.parser.OrderSiblingsByClause;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.RegexpExpression;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.StartWithClause;
import org.eclipse.persistence.jpa.jpql.parser.TableExpression;
import org.eclipse.persistence.jpa.jpql.parser.TableVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.UnionClause;
import org.eclipse.persistence.jpa.jpql.parser.WhereClause;

public class EclipseLinkContentAssistVisitor
extends AbstractContentAssistVisitor
implements EclipseLinkExpressionVisitor {
    public EclipseLinkContentAssistVisitor(JPQLQueryContext queryContext) {
        super(queryContext);
    }

    protected AcceptableTypeVisitor buildAcceptableTypeVisitor() {
        return new AcceptableTypeVisitor();
    }

    protected AppendableExpressionVisitor buildAppendableExpressionVisitor() {
        return new AppendableExpressionVisitor();
    }

    protected ConditionalExpressionCompletenessVisitor buildConditionalExpressionCompletenessVisitor() {
        return new ConditionalExpressionCompletenessVisitor();
    }

    protected FromClauseCollectionHelper buildFromClauseCollectionHelper() {
        return new FromClauseCollectionHelper();
    }

    protected FromClauseSelectStatementHelper buildFromClauseSelectStatementHelper() {
        return new FromClauseSelectStatementHelper();
    }

    protected GroupByClauseCollectionHelper buildGroupByClauseCollectionHelper() {
        return new GroupByClauseCollectionHelper();
    }

    protected GroupByClauseSelectStatementHelper buildGroupByClauseSelectStatementHelper() {
        return new GroupByClauseSelectStatementHelper();
    }

    protected HavingClauseSelectStatementHelper buildHavingClauseSelectStatementHelper() {
        return new HavingClauseSelectStatementHelper();
    }

    protected OrderByClauseSelectStatementHelper buildOrderByClauseSelectStatementHelper() {
        return new OrderByClauseSelectStatementHelper();
    }

    protected TableExpressionVisitor buildTableExpressionVisitor() {
        return new TableExpressionVisitor();
    }

    protected TrailingCompletenessVisitor buildTrailingCompleteness() {
        return new TrailingCompletenessVisitor();
    }

    protected UnionClauseSelectStatementHelper buildUnionClauseSelectStatementHelper() {
        return new UnionClauseSelectStatementHelper();
    }

    protected WhereClauseSelectStatementHelper buildWhereClauseSelectStatementHelper() {
        return new WhereClauseSelectStatementHelper();
    }

    protected TableExpressionVisitor getTableExpressionVisitor() {
        TableExpressionVisitor visitor = this.getHelper(TableExpressionVisitor.class);
        if (visitor == null) {
            visitor = this.buildTableExpressionVisitor();
            this.registerHelper(TableExpressionVisitor.class, visitor);
        }
        return visitor;
    }

    protected String getTableName(String variableName) {
        Declaration declaration = this.queryContext.getDeclaration(variableName);
        if (declaration != null && declaration.baseExpression != null && this.isTableExpression(declaration.baseExpression)) {
            return this.queryContext.literal(declaration.baseExpression, LiteralType.STRING_LITERAL);
        }
        return null;
    }

    protected UnionClauseSelectStatementHelper getUnionClauseSelectStatementHelper() {
        UnionClauseSelectStatementHelper helper = this.getHelper(UnionClauseSelectStatementHelper.class);
        if (helper == null) {
            helper = this.buildUnionClauseSelectStatementHelper();
            this.registerHelper(UnionClauseSelectStatementHelper.class, helper);
        }
        return helper;
    }

    protected boolean isJoinFetchIdentifiable() {
        EclipseLinkVersion version = EclipseLinkVersion.value(this.getGrammar().getProviderVersion());
        return version.isNewerThanOrEqual(EclipseLinkVersion.VERSION_2_4);
    }

    protected boolean isTableExpression(Expression expression) {
        TableExpressionVisitor visitor = this.getTableExpressionVisitor();
        try {
            visitor.expression = expression;
            expression.accept(visitor);
            boolean bl = visitor.valid;
            return bl;
        }
        finally {
            visitor.valid = false;
            visitor.expression = null;
        }
    }

    public void visit(AsOfClause expression) {
        super.visit(expression);
    }

    public void visit(CastExpression expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - (Integer)this.corrections.peek();
        String identifier = expression.getIdentifier();
        if (this.isPositionWithin(position, identifier)) {
            this.proposals.addIdentifier(identifier);
        } else if (expression.hasLeftParenthesis()) {
            Expression scalarExpression;
            int length = identifier.length() + 1;
            if (position == length) {
                this.addAllIdentificationVariables();
                this.addAllFunctions(expression.encapsulatedExpressionBNF());
            } else if (expression.hasExpression() && this.isComplete(scalarExpression = expression.getExpression())) {
                length += this.length(scalarExpression);
                if (expression.hasSpaceAfterExpression()) {
                    if (position == ++length) {
                        this.addAllAggregates(expression.encapsulatedExpressionBNF());
                        this.proposals.addIdentifier("AS");
                    } else if (this.isPositionWithin(position, length, "AS")) {
                        this.proposals.addIdentifier("AS");
                    }
                }
            }
        }
    }

    public void visit(ConnectByClause expression) {
        super.visit(expression);
    }

    public void visit(DatabaseType expression) {
        super.visit(expression);
    }

    public void visit(ExtractExpression expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - (Integer)this.corrections.peek();
        String identifier = expression.getIdentifier();
        if (this.isPositionWithin(position, identifier)) {
            this.proposals.addIdentifier(identifier);
        } else if (expression.hasLeftParenthesis()) {
            int length = identifier.length() + 1;
            if (expression.hasDatePart()) {
                String datePart = expression.getDatePart();
                this.isPositionWithin(position, length, datePart);
                length += datePart.length();
                if (expression.hasSpaceAfterDatePart() && position == ++length) {
                    this.addIdentifier("FROM");
                    if (!expression.hasExpression() || !expression.hasFrom()) {
                        this.addAllIdentificationVariables();
                        this.addAllFunctions(expression.encapsulatedExpressionBNF());
                    }
                }
            }
            if (expression.hasFrom()) {
                if (this.isPositionWithin(position, length, "FROM")) {
                    this.proposals.addIdentifier("FROM");
                    if (!expression.hasExpression()) {
                        this.addAllIdentificationVariables();
                        this.addAllFunctions(expression.encapsulatedExpressionBNF());
                    }
                }
                length += 4;
                if (expression.hasSpaceAfterFrom()) {
                    ++length;
                }
                if (position == length) {
                    this.addAllIdentificationVariables();
                    this.addAllFunctions(expression.encapsulatedExpressionBNF());
                }
            }
        }
    }

    public void visit(HierarchicalQueryClause expression) {
        super.visit(expression);
    }

    public void visit(OrderByItem expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - (Integer)this.corrections.peek();
        if (expression.hasExpression()) {
            int length = this.length(expression.getExpression());
            if (expression.hasSpaceAfterExpression()) {
                if (position == ++length) {
                    if (expression.getOrdering() == OrderByItem.Ordering.DEFAULT) {
                        this.proposals.addIdentifier("NULLS FIRST");
                        this.proposals.addIdentifier("NULLS LAST");
                    }
                } else if (position > (length += expression.getActualOrdering().length()) && expression.hasSpaceAfterOrdering()) {
                    if (position == ++length) {
                        this.proposals.addIdentifier("NULLS FIRST");
                        this.proposals.addIdentifier("NULLS LAST");
                    } else {
                        String nullOrdering = expression.getActualNullOrdering();
                        if (this.isPositionWithin(position, length, nullOrdering)) {
                            this.proposals.addIdentifier("NULLS FIRST");
                            this.proposals.addIdentifier("NULLS LAST");
                        }
                    }
                }
            }
        }
    }

    public void visit(OrderSiblingsByClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitCollectionExpression(expression, "ORDER SIBLINGS BY", this.getOrderByClauseCollectionHelper());
        }
    }

    public void visit(RangeVariableDeclaration expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - (Integer)this.corrections.peek();
        if (expression.hasRootObject()) {
            Expression rootObject = expression.getRootObject();
            int length = this.length(rootObject);
            if (position >= 0 && position <= length) {
                String root = rootObject.toActualText();
                this.proposals.setClassNamePrefix(root.substring(0, position), ContentAssistProposals.ClassType.INSTANTIABLE);
            }
        }
    }

    public void visit(RegexpExpression expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - (Integer)this.corrections.peek();
        int length = 0;
        if (expression.hasStringExpression()) {
            length += this.length(expression.getStringExpression());
            if (expression.hasSpaceAfterStringExpression()) {
                ++length;
            }
        }
        if (this.isPositionWithin(position, length, "REGEXP")) {
            this.proposals.addIdentifier("REGEXP");
        } else {
            length += 6;
            if (expression.hasSpaceAfterIdentifier()) {
                ++length;
                this.addAllIdentificationVariables();
                this.addAllFunctions("pattern_value");
            }
        }
    }

    public void visit(StartWithClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitClause(expression, "START WITH", expression.hasSpaceAfterIdentifier(), this.abstractConditionalClauseHelper());
            this.visitCompoundableExpression(expression);
        }
    }

    public void visit(TableExpression expression) {
        super.visit(expression);
        int position = this.getPosition(expression);
        if (this.isPositionWithin(position, "TABLE")) {
            this.proposals.addIdentifier("TABLE");
        } else if (expression.hasLeftParenthesis()) {
            int length = "TABLE".length() + 1;
            if (position == length) {
                this.proposals.setTableNamePrefix("");
            } else {
                Expression nameExpression = expression.getExpression();
                String tableName = this.queryContext.literal(nameExpression, LiteralType.STRING_LITERAL);
                if (tableName.length() == 0) {
                    tableName = this.queryContext.literal(nameExpression, LiteralType.IDENTIFICATION_VARIABLE);
                }
                int tableNameLength = tableName.length();
                if (position > length && position <= length + tableNameLength) {
                    String prefix = tableName.substring(0, position - length);
                    prefix = ExpressionTools.unquote(prefix);
                    this.proposals.setTableNamePrefix(prefix);
                }
            }
        }
    }

    public void visit(TableVariableDeclaration expression) {
        super.visit(expression);
        TableExpression tableExpression = expression.getTableExpression();
        int position = this.getPosition(expression) - (Integer)this.corrections.peek();
        int length = this.length(tableExpression);
        if (expression.hasSpaceAfterTableExpression() && this.isPositionWithin(position, ++length, "AS")) {
            this.addIdentifier("AS");
        }
    }

    public void visit(UnionClause expression) {
        String identifier;
        int position = this.getPosition(expression) - (Integer)this.corrections.peek();
        if (this.isPositionWithin(position, identifier = expression.getIdentifier())) {
            this.proposals.addIdentifier("EXCEPT");
            this.proposals.addIdentifier("INTERSECT");
            this.proposals.addIdentifier("UNION");
        } else if (expression.hasSpaceAfterIdentifier()) {
            int length = identifier.length() + 1;
            if (position == length) {
                this.proposals.addIdentifier("ALL");
                if (!expression.hasAll()) {
                    this.addIdentifier("SELECT");
                }
            } else if (this.isPositionWithin(position, length, "ALL")) {
                this.addIdentifier("ALL");
            } else if (position == length && !expression.hasAll()) {
                this.proposals.addIdentifier("SELECT");
            } else {
                if (expression.hasAll()) {
                    length += 3;
                }
                if (expression.hasSpaceAfterAll() && position == ++length) {
                    this.proposals.addIdentifier("SELECT");
                }
            }
        }
    }

    protected void visitThirdPartyPathExpression(AbstractPathExpression expression, String variableName) {
        String tableName;
        int secondDotIndex;
        int position = this.getPosition(expression);
        String text = expression.toActualText();
        int dotIndex = text.indexOf(46);
        int n = secondDotIndex = dotIndex > -1 ? text.indexOf(46, dotIndex + 1) : -1;
        if ((secondDotIndex == -1 || position < secondDotIndex) && (tableName = this.getTableName(variableName)) != "") {
            tableName = ExpressionTools.unquote(tableName);
            this.proposals.setTableName(tableName, text.substring(dotIndex + 1, position));
        }
    }

    protected class AcceptableTypeVisitor
    extends AbstractContentAssistVisitor.AcceptableTypeVisitor {
        protected AcceptableTypeVisitor() {
        }
    }

    protected class AppendableExpressionVisitor
    extends AbstractContentAssistVisitor.AppendableExpressionVisitor
    implements EclipseLinkExpressionVisitor {
        protected AppendableExpressionVisitor() {
        }

        public void visit(AsOfClause expression) {
        }

        public void visit(CastExpression expression) {
        }

        public void visit(ConnectByClause expression) {
        }

        public void visit(DatabaseType expression) {
        }

        public void visit(ExtractExpression expression) {
        }

        public void visit(HierarchicalQueryClause expression) {
        }

        public void visit(OrderSiblingsByClause expression) {
            this.clauseOfItems = true;
            super.visit(expression);
            this.clauseOfItems = false;
        }

        public void visit(RegexpExpression expression) {
        }

        public void visit(StartWithClause expression) {
        }

        public void visit(TableExpression expression) {
        }

        public void visit(TableVariableDeclaration expression) {
        }

        public void visit(UnionClause expression) {
        }
    }

    protected class ConditionalExpressionCompletenessVisitor
    extends AbstractContentAssistVisitor.ConditionalExpressionCompletenessVisitor
    implements EclipseLinkExpressionVisitor {
        protected ConditionalExpressionCompletenessVisitor() {
        }

        public void visit(AsOfClause expression) {
        }

        public void visit(CastExpression expression) {
        }

        public void visit(ConnectByClause expression) {
        }

        public void visit(DatabaseType expression) {
        }

        public void visit(ExtractExpression expression) {
        }

        public void visit(HierarchicalQueryClause expression) {
        }

        public void visit(OrderSiblingsByClause expression) {
        }

        public void visit(RegexpExpression expression) {
            this.complete = expression.hasPatternValue();
            if (this.complete) {
                this.complete = EclipseLinkContentAssistVisitor.this.isComplete(expression.getPatternValue());
            }
        }

        public void visit(StartWithClause expression) {
        }

        public void visit(TableExpression expression) {
        }

        public void visit(TableVariableDeclaration expression) {
        }

        public void visit(UnionClause expression) {
        }
    }

    protected class FromClauseCollectionHelper
    extends AbstractContentAssistVisitor.FromClauseCollectionHelper {
        protected FromClauseCollectionHelper() {
        }

        public void addProposals(AbstractFromClause expression, int index) {
            super.addProposals(expression, index);
            EclipseLinkContentAssistVisitor.this.proposals.setClassNamePrefix("", ContentAssistProposals.ClassType.INSTANTIABLE);
        }
    }

    protected class FromClauseSelectStatementHelper
    extends AbstractContentAssistVisitor.FromClauseSelectStatementHelper {
        protected FromClauseSelectStatementHelper() {
        }

        protected void addClauseIdentifierProposals(SelectStatement expression) {
            super.addClauseIdentifierProposals(expression);
            if (!(expression.hasWhereClause() || expression.hasGroupByClause() || expression.hasHavingClause() || expression.hasOrderByClause())) {
                EclipseLinkContentAssistVisitor.this.addIdentifier("UNION");
                EclipseLinkContentAssistVisitor.this.addIdentifier("EXCEPT");
                EclipseLinkContentAssistVisitor.this.addIdentifier("INTERSECT");
            }
        }
    }

    protected class GroupByClauseCollectionHelper
    extends AbstractContentAssistVisitor.GroupByClauseCollectionHelper {
        protected GroupByClauseCollectionHelper() {
        }

        public void addAtTheEndOfChild(GroupByClause expression, Expression child, int index) {
        }
    }

    protected class GroupByClauseSelectStatementHelper
    extends AbstractContentAssistVisitor.GroupByClauseSelectStatementHelper {
        protected GroupByClauseSelectStatementHelper() {
        }

        public void appendNextClauseProposals(SelectStatement expression, GroupByClause clause, int position, boolean complete) {
            super.appendNextClauseProposals(expression, clause, position, complete);
            if ((complete || EclipseLinkContentAssistVisitor.this.isGroupByComplete(clause)) && !expression.hasHavingClause() && !expression.hasOrderByClause()) {
                EclipseLinkContentAssistVisitor.this.addIdentifier("EXCEPT");
                EclipseLinkContentAssistVisitor.this.addIdentifier("INTERSECT");
                EclipseLinkContentAssistVisitor.this.addIdentifier("UNION");
            }
        }
    }

    protected class HavingClauseSelectStatementHelper
    extends AbstractContentAssistVisitor.HavingClauseSelectStatementHelper {
        protected HavingClauseSelectStatementHelper() {
        }

        public void appendNextClauseProposals(SelectStatement expression, HavingClause clause, int position, boolean complete) {
            super.appendNextClauseProposals(expression, clause, position, complete);
            if ((complete || EclipseLinkContentAssistVisitor.this.isAppendable(clause)) && !expression.hasOrderByClause()) {
                EclipseLinkContentAssistVisitor.this.addIdentifier("EXCEPT");
                EclipseLinkContentAssistVisitor.this.addIdentifier("INTERSECT");
                EclipseLinkContentAssistVisitor.this.addIdentifier("UNION");
            }
        }
    }

    protected class OrderByClauseSelectStatementHelper
    extends AbstractContentAssistVisitor.OrderByClauseSelectStatementHelper {
        protected OrderByClauseSelectStatementHelper() {
        }

        public void appendNextClauseProposals(SelectStatement expression, OrderByClause clause, int position, boolean complete) {
            super.appendNextClauseProposals(expression, clause, position, complete);
            if (complete || EclipseLinkContentAssistVisitor.this.isAppendable(clause)) {
                EclipseLinkContentAssistVisitor.this.addIdentifier("EXCEPT");
                EclipseLinkContentAssistVisitor.this.addIdentifier("INTERSECT");
                EclipseLinkContentAssistVisitor.this.addIdentifier("UNION");
            }
        }

        public UnionClauseSelectStatementHelper getNextHelper() {
            return EclipseLinkContentAssistVisitor.this.getUnionClauseSelectStatementHelper();
        }

        public boolean hasSpaceAfterClause(SelectStatement expression) {
            return expression.hasSpaceBeforeUnion();
        }
    }

    protected class TableExpressionVisitor
    extends AbstractEclipseLinkExpressionVisitor {
        protected Expression expression;
        protected boolean valid;

        protected TableExpressionVisitor() {
        }

        public void visit(TableExpression expression) {
            this.valid = this.expression == expression;
        }
    }

    protected class TrailingCompletenessVisitor
    extends AbstractContentAssistVisitor.TrailingCompletenessVisitor
    implements EclipseLinkExpressionVisitor {
        protected TrailingCompletenessVisitor() {
        }

        public void visit(AsOfClause expression) {
            this.complete = expression.hasExpression();
            if (this.complete) {
                expression.getExpression().accept(this);
            }
        }

        public void visit(CastExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(ConnectByClause expression) {
            this.complete = expression.hasExpression();
        }

        public void visit(DatabaseType expression) {
        }

        public void visit(ExtractExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(HierarchicalQueryClause expression) {
            if (expression.hasOrderSiblingsByClause()) {
                expression.getOrderSiblingsByClause().accept(this);
            } else {
                this.complete = expression.hasConnectByClause();
                if (this.complete) {
                    expression.getConnectByClause().accept(this);
                }
            }
        }

        public void visit(OrderSiblingsByClause expression) {
            this.complete = expression.hasOrderByItems();
            if (this.complete) {
                expression.getOrderByItems().accept(this);
            }
        }

        public void visit(RegexpExpression expression) {
            this.complete = expression.hasPatternValue();
        }

        public void visit(StartWithClause expression) {
            this.complete = expression.hasConditionalExpression();
            if (this.complete) {
                expression.getConditionalExpression().accept(this);
            }
        }

        public void visit(TableExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(TableVariableDeclaration expression) {
            this.complete = expression.hasIdentificationVariable();
        }

        public void visit(UnionClause expression) {
            this.complete = expression.hasQuery();
            if (this.complete) {
                expression.getQuery().accept(this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UnionClauseSelectStatementHelper
    implements AbstractContentAssistVisitor.SelectStatementHelper<SelectStatement, UnionClause> {
        protected UnionClauseSelectStatementHelper() {
        }

        @Override
        public void addClauseProposal() {
            EclipseLinkContentAssistVisitor.this.addIdentifier("EXCEPT");
            EclipseLinkContentAssistVisitor.this.addIdentifier("INTERSECT");
            EclipseLinkContentAssistVisitor.this.addIdentifier("UNION");
        }

        @Override
        public void appendNextClauseProposals(SelectStatement expression, UnionClause clause, int position, boolean complete) {
            EclipseLinkContentAssistVisitor.this.addIdentifier("EXCEPT");
            EclipseLinkContentAssistVisitor.this.addIdentifier("INTERSECT");
            EclipseLinkContentAssistVisitor.this.addIdentifier("UNION");
        }

        @Override
        public UnionClause getClause(SelectStatement expression) {
            return (UnionClause)expression.getUnionClauses();
        }

        @Override
        public Expression getClauseExpression(UnionClause clause) {
            return clause.getQuery();
        }

        @Override
        public AbstractContentAssistVisitor.SelectStatementHelper<? extends AbstractSelectStatement, ? extends Expression> getNextHelper() {
            return null;
        }

        public AbstractContentAssistVisitor.OrderByClauseSelectStatementHelper getPreviousHelper() {
            return EclipseLinkContentAssistVisitor.this.getOrderByClauseSelectStatementHelper();
        }

        @Override
        public boolean hasClause(SelectStatement expression) {
            return expression.hasUnionClauses();
        }

        @Override
        public boolean hasClauseExpression(UnionClause clause) {
            return clause.hasQuery();
        }

        @Override
        public boolean hasSpaceAfterClause(SelectStatement expression) {
            return false;
        }

        @Override
        public boolean hasSpaceBeforeClause(SelectStatement expression) {
            return expression.hasSpaceBeforeUnion();
        }

        @Override
        public boolean isClauseExpressionComplete(Expression expression) {
            return false;
        }
    }

    protected class WhereClauseSelectStatementHelper
    extends AbstractContentAssistVisitor.WhereClauseSelectStatementHelper {
        protected WhereClauseSelectStatementHelper() {
        }

        public void appendNextClauseProposals(SelectStatement expression, WhereClause clause, int position, boolean complete) {
            super.appendNextClauseProposals(expression, clause, position, complete);
            if (!(!complete && !EclipseLinkContentAssistVisitor.this.isAppendable(clause) || expression.hasGroupByClause() || expression.hasHavingClause() || expression.hasOrderByClause())) {
                EclipseLinkContentAssistVisitor.this.addIdentifier("EXCEPT");
                EclipseLinkContentAssistVisitor.this.addIdentifier("INTERSECT");
                EclipseLinkContentAssistVisitor.this.addIdentifier("UNION");
            }
        }
    }
}

