/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.AbstractRefactoringTool;
import org.eclipse.persistence.jpa.jpql.DefaultRefactoringDelta;
import org.eclipse.persistence.jpa.jpql.DefaultTextEdit;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.RefactoringDelta;
import org.eclipse.persistence.jpa.jpql.Resolver;
import org.eclipse.persistence.jpa.jpql.StateFieldResolver;
import org.eclipse.persistence.jpa.jpql.TextEdit;
import org.eclipse.persistence.jpa.jpql.parser.AbstractPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.jpql.parser.AbstractTraverseChildrenVisitor;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.jpql.parser.EntityTypeLiteral;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.java.JavaQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicRefactoringTool
extends AbstractRefactoringTool {
    private DefaultRefactoringDelta delta;
    private JPQLExpression jpqlExpression;
    private JPQLGrammar jpqlGrammar;
    private JPQLQueryContext queryContext;

    protected BasicRefactoringTool(CharSequence jpqlQuery, JPQLGrammar jpqlGrammar, IManagedTypeProvider managedTypeProvider) {
        this(jpqlQuery, jpqlGrammar, managedTypeProvider, "ql_statement");
    }

    protected BasicRefactoringTool(CharSequence jpqlFragment, JPQLGrammar jpqlGrammar, IManagedTypeProvider managedTypeProvider, String jpqlQueryBNFId) {
        super(jpqlFragment, managedTypeProvider, jpqlQueryBNFId);
        this.jpqlGrammar = jpqlGrammar;
        this.delta = new DefaultRefactoringDelta(jpqlFragment);
    }

    protected AttributeNameRenamer buildAttributeNameRenamer(String typeName, String oldAttributeName, String newAttributeName) {
        return new AttributeNameRenamer(this.getQueryContext(), typeName, oldAttributeName, newAttributeName);
    }

    protected ClassNameRenamer buildClassNameRenamer(String oldClassName, String newClassName) {
        return new ClassNameRenamer(oldClassName, newClassName);
    }

    protected EntityNameRenamer buildEntityNameRenamer(String oldEntityName, String newEntityName) {
        return new EntityNameRenamer(oldEntityName, newEntityName);
    }

    protected EnumConstantRenamer buildEnumConstantRenamer(String oldClassName, String newClassName) {
        return new EnumConstantRenamer(this.getManagedTypeProvider(), oldClassName, newClassName);
    }

    protected abstract JPQLQueryContext buildJPQLQueryContext();

    protected ResultVariableNameRenamer buildResultVariableNameRenamer(String oldVariableName, String newVariableName) {
        return new ResultVariableNameRenamer(oldVariableName, newVariableName);
    }

    protected VariableNameRenamer buildVariableNameRenamer(String oldVariableName, String newVariableName) {
        return new VariableNameRenamer(oldVariableName, newVariableName);
    }

    public RefactoringDelta getDelta() {
        return this.delta;
    }

    public JPQLExpression getExpression() {
        if (this.jpqlExpression == null) {
            this.jpqlExpression = new JPQLExpression(this.getJPQLFragment(), this.jpqlGrammar, this.isTolerant());
        }
        return this.jpqlExpression;
    }

    public JPQLGrammar getGrammar() {
        return this.jpqlGrammar;
    }

    public JPQLQueryContext getQueryContext() {
        if (this.queryContext == null) {
            this.queryContext = this.buildJPQLQueryContext();
            this.queryContext.setJPQLExpression(this.getExpression());
            this.queryContext.setQuery(new JavaQuery(this.getManagedTypeProvider(), this.getJPQLFragment()));
        }
        return this.queryContext;
    }

    public boolean hasChanges() {
        return this.delta.hasTextEdits();
    }

    public void renameAttribute(Class<?> type2, String oldAttributeName, String newAttributeName) {
        this.renameAttribute(type2.getName(), oldAttributeName, newAttributeName);
    }

    public void renameAttribute(IType type2, String oldAttributeName, String newAttributeName) {
        this.renameAttribute(type2.getName(), oldAttributeName, newAttributeName);
    }

    public void renameAttribute(String typeName, String oldAttributeName, String newAttributeName) {
        AttributeNameRenamer renamer = this.buildAttributeNameRenamer(typeName, oldAttributeName, newAttributeName);
        this.getExpression().accept(renamer);
        this.delta.addTextEdits(renamer.textEdits);
    }

    public void renameClassName(String oldClassName, String newClassName) {
        ClassNameRenamer renamer = this.buildClassNameRenamer(oldClassName, newClassName);
        this.getExpression().accept(renamer);
        this.delta.addTextEdits(renamer.textEdits);
    }

    public void renameEntityName(String oldEntityName, String newEntityName) {
        EntityNameRenamer renamer = this.buildEntityNameRenamer(oldEntityName, newEntityName);
        this.getExpression().accept(renamer);
        this.delta.addTextEdits(renamer.textEdits);
    }

    public void renameEnumConstant(String oldEnumConstant, String newEnumConstant) {
        EnumConstantRenamer renamer = this.buildEnumConstantRenamer(oldEnumConstant, newEnumConstant);
        this.getExpression().accept(renamer);
        this.delta.addTextEdits(renamer.textEdits);
    }

    public void renameResultVariable(String oldVariableName, String newVariableName) {
        ResultVariableNameRenamer renamer = this.buildResultVariableNameRenamer(oldVariableName, newVariableName);
        this.getExpression().accept(renamer);
        this.delta.addTextEdits(renamer.textEdits);
    }

    public void renameVariable(String oldVariableName, String newVariableName) {
        VariableNameRenamer renamer = this.buildVariableNameRenamer(oldVariableName, newVariableName);
        this.getExpression().accept(renamer);
        this.delta.addTextEdits(renamer.textEdits);
    }

    @Override
    public String toActualText() {
        return this.getDelta().applyChanges();
    }

    protected abstract class AbstractRenamer
    extends AbstractTraverseChildrenVisitor {
        protected List<TextEdit> textEdits = new ArrayList<TextEdit>();

        protected AbstractRenamer() {
        }

        protected void addTextEdit(Expression expression, int extraOffset, String oldValue, String newValue) {
            TextEdit textEdit = this.buildTextEdit(this.reposition(expression.getOffset() + extraOffset), oldValue, newValue);
            this.textEdits.add(textEdit);
        }

        protected void addTextEdit(Expression expression, String oldValue, String newValue) {
            this.addTextEdit(expression, 0, oldValue, newValue);
        }

        protected TextEdit buildTextEdit(int offset, String oldValue, String newValue) {
            return new DefaultTextEdit(offset, oldValue, newValue);
        }

        protected int reposition(int offset) {
            return ExpressionTools.repositionCursor(BasicRefactoringTool.this.getExpression().toActualText(), offset, BasicRefactoringTool.this.getJPQLFragment());
        }
    }

    protected class AttributeNameRenamer
    extends AbstractRenamer {
        protected final String newAttributeName;
        protected final String oldAttributeName;
        private final JPQLQueryContext queryContext;
        protected final String typeName;

        public AttributeNameRenamer(JPQLQueryContext queryContext, String typeName, String oldAttributeName, String newAttributeName) {
            this.typeName = typeName;
            this.queryContext = queryContext;
            this.oldAttributeName = oldAttributeName;
            this.newAttributeName = newAttributeName;
        }

        protected void rename(AbstractPathExpression expression) {
            if (!expression.hasIdentificationVariable() || expression.startsWithDot()) {
                return;
            }
            Resolver resolver = this.queryContext.getResolver(expression.getIdentificationVariable());
            if (resolver == null) {
                return;
            }
            int index = expression.hasVirtualIdentificationVariable() ? 0 : 1;
            int count = expression.pathSize();
            while (index < count) {
                String parentTypeName;
                IMapping mapping;
                String path = expression.getPath(index);
                Resolver childResolver = resolver.getChild(path);
                if (childResolver == null) {
                    childResolver = new StateFieldResolver(resolver, path);
                    resolver.addChild(path, childResolver);
                }
                if ((mapping = childResolver.getMapping()) == null) break;
                if (mapping.getName().equals(this.oldAttributeName) && (parentTypeName = mapping.getParent().getType().getName()).equals(this.typeName)) {
                    int extraOffset = expression.toParsedText(0, index).length() + 1;
                    this.addTextEdit(expression, extraOffset, this.oldAttributeName, this.newAttributeName);
                    break;
                }
                resolver = childResolver;
                ++index;
            }
        }

        public void visit(CollectionValuedPathExpression expression) {
            this.rename(expression);
        }

        public void visit(StateFieldPathExpression expression) {
            this.rename(expression);
        }
    }

    protected class ClassNameRenamer
    extends AbstractRenamer {
        protected final String newClassName;
        protected final String oldClassName;

        public ClassNameRenamer(String oldClassName, String newClassName) {
            this.oldClassName = oldClassName;
            this.newClassName = newClassName;
        }

        public void visit(CollectionValuedPathExpression expression) {
            if (!expression.startsWithDot()) {
                this.visit(expression, expression.toActualText(), 0);
            }
        }

        public void visit(ConstructorExpression expression) {
            this.visit(expression, expression.getClassName(), 4);
        }

        protected void visit(Expression expression, String value, int extraOffset) {
            if (this.oldClassName.equals(value)) {
                this.addTextEdit(expression, extraOffset, this.oldClassName, this.newClassName);
            } else {
                int index = value.lastIndexOf(46);
                while (index > -1) {
                    String fragment = value.substring(0, index);
                    if (this.oldClassName.equals(fragment)) {
                        this.addTextEdit(expression, extraOffset, this.oldClassName, this.newClassName);
                        break;
                    }
                    if (fragment.length() < this.oldClassName.length()) break;
                    index = value.lastIndexOf(46, index - 1);
                }
            }
        }

        public void visit(StateFieldPathExpression expression) {
            if (!expression.startsWithDot()) {
                this.visit(expression, expression.toActualText(), 0);
            }
        }
    }

    protected class EntityNameRenamer
    extends AbstractRenamer {
        protected final String newEntityName;
        protected final String oldEntityName;

        public EntityNameRenamer(String oldEntityName, String newEntityName) {
            this.oldEntityName = oldEntityName;
            this.newEntityName = newEntityName;
        }

        public void visit(AbstractSchemaName expression) {
            if (this.oldEntityName.equals(expression.getText())) {
                this.addTextEdit(expression, this.oldEntityName, this.newEntityName);
            }
        }

        public void visit(EntityTypeLiteral expression) {
            if (this.oldEntityName.equals(expression.getEntityTypeName())) {
                this.addTextEdit(expression, this.oldEntityName, this.newEntityName);
            }
        }

        public void visit(IdentificationVariable expression) {
            if (this.oldEntityName.equals(expression.getText())) {
                this.addTextEdit(expression, this.oldEntityName, this.newEntityName);
            }
        }
    }

    protected class EnumConstantRenamer
    extends AbstractRenamer {
        protected final IManagedTypeProvider managedTypeProvider;
        protected final String newEnumConstant;
        protected final String oldEnumConstant;

        public EnumConstantRenamer(IManagedTypeProvider managedTypeProvider, String oldEnumConstant, String newEnumConstant) {
            this.oldEnumConstant = oldEnumConstant;
            this.newEnumConstant = newEnumConstant;
            this.managedTypeProvider = managedTypeProvider;
        }

        protected void renameEnumConstant(AbstractPathExpression expression) {
            IType type2;
            String path = expression.toString();
            if (path.equals(this.oldEnumConstant) && (type2 = this.managedTypeProvider.getTypeRepository().getEnumType(path)) != null) {
                this.addTextEdit(expression, this.oldEnumConstant, this.newEnumConstant);
            }
        }

        public void visit(CollectionValuedPathExpression expression) {
            this.renameEnumConstant(expression);
        }

        public void visit(StateFieldPathExpression expression) {
            this.renameEnumConstant(expression);
        }
    }

    protected class ResultVariableNameRenamer
    extends AbstractRenamer {
        protected final String newVariableName;
        protected final String oldVariableName;
        protected boolean renameIdentificationVariable;

        public ResultVariableNameRenamer(String oldVariableName, String newVariableName) {
            this.oldVariableName = oldVariableName;
            this.newVariableName = newVariableName;
        }

        public void visit(IdentificationVariable expression) {
            if (this.renameIdentificationVariable && this.oldVariableName.equalsIgnoreCase(expression.getText())) {
                this.addTextEdit(expression, this.oldVariableName, this.newVariableName);
            }
        }

        public void visit(ResultVariable expression) {
            if (expression.hasResultVariable()) {
                this.renameIdentificationVariable = true;
                try {
                    expression.getResultVariable().accept(this);
                }
                finally {
                    this.renameIdentificationVariable = false;
                }
            }
        }

        public void visit(SelectStatement expression) {
            expression.getSelectClause().accept(this);
            if (expression.hasOrderByClause()) {
                this.renameIdentificationVariable = true;
                try {
                    expression.getOrderByClause().accept(this);
                }
                finally {
                    this.renameIdentificationVariable = false;
                }
            }
        }
    }

    protected class VariableNameRenamer
    extends AbstractRenamer {
        protected final String newVariableName;
        protected final String oldVariableName;

        public VariableNameRenamer(String oldVariableName, String newVariableName) {
            this.oldVariableName = oldVariableName;
            this.newVariableName = newVariableName;
        }

        public void visit(IdentificationVariable expression) {
            if (this.oldVariableName.equalsIgnoreCase(expression.getText())) {
                this.addTextEdit(expression, this.oldVariableName, this.newVariableName);
            }
        }
    }
}

