/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.LoadState;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.ProviderUtil;
import org.eclipse.persistence.exceptions.PersistenceUnitLoadingException;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.deployment.JPAInitializer;
import org.eclipse.persistence.internal.jpa.deployment.JavaSECMPInitializer;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;

public class PersistenceProvider
implements javax.persistence.spi.PersistenceProvider,
ProviderUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EntityManagerFactoryImpl createEntityManagerFactoryImpl(PersistenceUnitInfo puInfo, Map properties) {
        if (puInfo != null) {
            String puName;
            EntityManagerSetupImpl emSetupImpl;
            String sessionName;
            String uniqueName;
            boolean isNew;
            block22: {
                isNew = false;
                uniqueName = null;
                sessionName = null;
                emSetupImpl = null;
                puName = puInfo.getPersistenceUnitName();
                JPAInitializer initializer = this.getInitializer(puInfo.getPersistenceUnitName(), properties);
                try {
                    if (EntityManagerSetupImpl.mustBeCompositeMember(puInfo)) {
                        emSetupImpl = new EntityManagerSetupImpl(puName, puName);
                        emSetupImpl.predeploy(puInfo, properties);
                        isNew = true;
                        break block22;
                    }
                    uniqueName = initializer.isPersistenceUnitUniquelyDefinedByName() ? puName : initializer.createUniquePersistenceUnitName(puInfo);
                    sessionName = EntityManagerSetupImpl.getOrBuildSessionName(properties, puInfo, uniqueName);
                    HashMap<String, EntityManagerSetupImpl> hashMap = EntityManagerFactoryProvider.emSetupImpls;
                    synchronized (hashMap) {
                        emSetupImpl = EntityManagerFactoryProvider.getEntityManagerSetupImpl(sessionName);
                        if (emSetupImpl == null) {
                            emSetupImpl = initializer.extractInitialEmSetupImpl(puName);
                            if (emSetupImpl != null) {
                                emSetupImpl.changeSessionName(sessionName);
                            } else {
                                emSetupImpl = initializer.callPredeploy((SEPersistenceUnitInfo)puInfo, properties, uniqueName, sessionName);
                            }
                            emSetupImpl.predeploy(emSetupImpl.getPersistenceUnitInfo(), properties);
                            EntityManagerFactoryProvider.addEntityManagerSetupImpl(sessionName, emSetupImpl);
                            isNew = true;
                        }
                    }
                }
                catch (Exception e) {
                    throw PersistenceUnitLoadingException.exceptionSearchingForPersistenceResources(initializer.getInitializationClassLoader(), e);
                }
            }
            if (!isNew) {
                if (!uniqueName.equals(emSetupImpl.getPersistenceUnitUniqueName())) {
                    throw PersistenceUnitLoadingException.sessionNameAlreadyInUse(sessionName, uniqueName, emSetupImpl.getPersistenceUnitUniqueName());
                }
                boolean undeployed = false;
                EntityManagerSetupImpl entityManagerSetupImpl = emSetupImpl;
                synchronized (entityManagerSetupImpl) {
                    if (emSetupImpl.isUndeployed()) {
                        undeployed = true;
                    }
                    emSetupImpl.predeploy(emSetupImpl.getPersistenceUnitInfo(), properties);
                }
                if (undeployed) {
                    return (EntityManagerFactoryImpl)this.createEntityManagerFactory(puName, properties);
                }
            }
            EntityManagerFactoryImpl factory = null;
            try {
                factory = new EntityManagerFactoryImpl(emSetupImpl, properties);
                if (emSetupImpl.shouldGetSessionOnCreateFactory(properties)) {
                    factory.getDatabaseSession();
                }
                return factory;
            }
            catch (RuntimeException ex) {
                if (factory != null) {
                    factory.close();
                } else {
                    emSetupImpl.undeploy();
                }
                throw ex;
            }
        }
        return null;
    }

    @Override
    public EntityManagerFactory createEntityManagerFactory(String emName, Map properties) {
        Map nonNullProperties;
        Map map = nonNullProperties = properties == null ? new HashMap() : properties;
        if (this.checkForProviderProperty(nonNullProperties)) {
            String name = emName == null ? "" : emName;
            JPAInitializer initializer = this.getInitializer(name, nonNullProperties);
            return this.createEntityManagerFactoryImpl(initializer.findPersistenceUnitInfo(name, nonNullProperties), nonNullProperties);
        }
        return null;
    }

    @Override
    public void generateSchema(PersistenceUnitInfo info, Map properties) {
        if (this.checkForProviderProperty(properties)) {
            properties.put("internal-provider-generate-schema", true);
            EntityManagerFactoryImpl emfImpl = this.createEntityManagerFactoryImpl(info, properties);
            EntityManager em = emfImpl.createEntityManager(properties);
            em.close();
            properties.put("internal-provider-generate-schema", false);
        }
    }

    @Override
    public boolean generateSchema(String persistenceUnitName, Map properties) {
        JPAInitializer initializer;
        SEPersistenceUnitInfo puInfo;
        Map nonNullProperties;
        String puName = persistenceUnitName == null ? "" : persistenceUnitName;
        Map map = nonNullProperties = properties == null ? new HashMap() : properties;
        if (this.checkForProviderProperty(nonNullProperties) && (puInfo = (initializer = this.getInitializer(puName, nonNullProperties)).findPersistenceUnitInfo(puName, nonNullProperties)) != null) {
            this.generateSchema(puInfo, nonNullProperties);
            return true;
        }
        return false;
    }

    public JPAInitializer getInitializer(String emName, Map m) {
        ClassLoader classLoader = this.getClassLoader(emName, m);
        return JavaSECMPInitializer.getJavaSECMPInitializer(classLoader);
    }

    public boolean checkForProviderProperty(Map properties) {
        Object provider = properties.get("javax.persistence.provider");
        if (provider != null) {
            if (provider instanceof Class) {
                provider = ((Class)provider).getName();
            }
            try {
                if (!((String)provider).equals(EntityManagerFactoryProvider.class.getName()) && !((String)provider).equals(PersistenceProvider.class.getName())) {
                    return false;
                }
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map properties) {
        JavaSECMPInitializer.setIsInContainer(true);
        Map nonNullProperties = properties == null ? new HashMap() : properties;
        EntityManagerSetupImpl emSetupImpl = null;
        if (EntityManagerSetupImpl.mustBeCompositeMember(info)) {
            emSetupImpl = new EntityManagerSetupImpl(info.getPersistenceUnitName(), info.getPersistenceUnitName());
            emSetupImpl.predeploy(info, nonNullProperties);
        } else {
            boolean isNew = false;
            ClassTransformer transformer = null;
            String uniqueName = PersistenceUnitProcessor.buildPersistenceUnitName(info.getPersistenceUnitRootUrl(), info.getPersistenceUnitName());
            String sessionName = EntityManagerSetupImpl.getOrBuildSessionName(nonNullProperties, info, uniqueName);
            HashMap<String, EntityManagerSetupImpl> hashMap = EntityManagerFactoryProvider.emSetupImpls;
            synchronized (hashMap) {
                emSetupImpl = EntityManagerFactoryProvider.getEntityManagerSetupImpl(sessionName);
                if (emSetupImpl == null) {
                    emSetupImpl = new EntityManagerSetupImpl(uniqueName, sessionName);
                    isNew = true;
                    emSetupImpl.setIsInContainerMode(true);
                    transformer = emSetupImpl.predeploy(info, nonNullProperties);
                    EntityManagerFactoryProvider.addEntityManagerSetupImpl(sessionName, emSetupImpl);
                }
            }
            if (!isNew) {
                if (!uniqueName.equals(emSetupImpl.getPersistenceUnitUniqueName())) {
                    throw PersistenceUnitLoadingException.sessionNameAlreadyInUse(sessionName, uniqueName, emSetupImpl.getPersistenceUnitUniqueName());
                }
                boolean undeployed = false;
                EntityManagerSetupImpl entityManagerSetupImpl = emSetupImpl;
                synchronized (entityManagerSetupImpl) {
                    if (emSetupImpl.isUndeployed()) {
                        undeployed = true;
                    }
                    transformer = emSetupImpl.predeploy(emSetupImpl.getPersistenceUnitInfo(), nonNullProperties);
                }
                if (undeployed) {
                    return this.createContainerEntityManagerFactory(info, properties);
                }
            }
            if (transformer != null) {
                info.addTransformer(transformer);
            }
        }
        EntityManagerFactoryImpl factory = null;
        try {
            factory = new EntityManagerFactoryImpl(emSetupImpl, nonNullProperties);
            if (emSetupImpl.shouldGetSessionOnCreateFactory(nonNullProperties)) {
                factory.getDatabaseSession();
            }
            return factory;
        }
        catch (RuntimeException ex) {
            if (factory != null) {
                factory.close();
            } else {
                emSetupImpl.undeploy();
            }
            throw ex;
        }
    }

    @Override
    public ProviderUtil getProviderUtil() {
        return this;
    }

    @Override
    public LoadState isLoadedWithoutReference(Object entity, String attributeName) {
        if (entity instanceof PersistenceWeaved) {
            return this.isLoadedWithReference(entity, attributeName);
        }
        return LoadState.UNKNOWN;
    }

    @Override
    public LoadState isLoadedWithReference(Object entity, String attributeName) {
        for (EntityManagerSetupImpl setup : EntityManagerFactoryProvider.getEmSetupImpls().values()) {
            Boolean isLoaded;
            if (!setup.isDeployed() || (isLoaded = EntityManagerFactoryImpl.isLoaded(entity, setup.getSession())) == null) continue;
            if (isLoaded.booleanValue() && attributeName != null) {
                isLoaded = EntityManagerFactoryImpl.isLoaded(entity, attributeName, setup.getSession());
            }
            if (isLoaded == null) continue;
            return isLoaded != false ? LoadState.LOADED : LoadState.NOT_LOADED;
        }
        return LoadState.UNKNOWN;
    }

    @Override
    public LoadState isLoaded(Object entity) {
        if (entity instanceof PersistenceWeaved) {
            return this.isLoadedWithReference(entity, null);
        }
        return LoadState.UNKNOWN;
    }

    public ClassLoader getClassLoader(String emName, Map properties) {
        ClassLoader classloader = null;
        if (properties != null) {
            classloader = (ClassLoader)properties.get("eclipselink.classloader");
        }
        if (classloader == null) {
            classloader = Thread.currentThread().getContextClassLoader();
        }
        return classloader;
    }
}

