/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.namespace.QName;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;

public class ElementDeclaration {
    private QName elementName;
    private QName substitutionHead;
    private String javaTypeName;
    private JavaClass javaType;
    private JavaClass adaptedJavaType;
    private String adaptedJavaTypeName;
    private List<ElementDeclaration> substitutableElements;
    private boolean isXmlRootElement = false;
    private boolean isList = false;
    private Class javaTypeAdapterClass;
    private Class scopeClass;
    private String defaultValue;
    private TypeMappingInfo typeMappingInfo;
    private boolean xmlAttachmentRef;
    private String xmlMimeType;
    private boolean nillable;

    public ElementDeclaration(QName name, JavaClass javaType, String javaTypeName, boolean isList) {
        this.elementName = name;
        this.javaTypeName = javaTypeName;
        this.javaType = javaType;
        this.substitutableElements = new ArrayList<ElementDeclaration>();
        this.isList = isList;
        this.scopeClass = XmlElementDecl.GLOBAL.class;
    }

    public ElementDeclaration(QName name, JavaClass javaType, String javaTypeName, boolean isList, Class scopeClass) {
        this(name, javaType, javaTypeName, isList);
        this.scopeClass = scopeClass;
    }

    public QName getElementName() {
        return this.elementName;
    }

    public String getJavaTypeName() {
        return this.javaTypeName;
    }

    public List<ElementDeclaration> getSubstitutableElements() {
        return this.substitutableElements;
    }

    public void addSubstitutableElement(ElementDeclaration element) {
        this.substitutableElements.add(element);
    }

    public void setSubstitutionHead(QName rootElement) {
        this.substitutionHead = rootElement;
    }

    public QName getSubstitutionHead() {
        return this.substitutionHead;
    }

    public boolean isXmlRootElement() {
        return this.isXmlRootElement;
    }

    public void setIsXmlRootElement(boolean isXmlRoot) {
        this.isXmlRootElement = isXmlRoot;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public void setNillable(boolean nillable) {
        this.nillable = nillable;
    }

    public JavaClass getJavaType() {
        return this.javaType;
    }

    public void setJavaType(JavaClass type2) {
        this.javaType = type2;
        this.javaTypeName = type2.getQualifiedName();
    }

    public boolean isList() {
        return this.isList;
    }

    public void setList(boolean isList) {
        this.isList = isList;
    }

    public Class getJavaTypeAdapterClass() {
        return this.javaTypeAdapterClass;
    }

    public void setJavaTypeAdapterClass(Class javaTypeAdapterClass) {
        this.javaTypeAdapterClass = javaTypeAdapterClass;
    }

    public JavaClass getAdaptedJavaType() {
        return this.adaptedJavaType;
    }

    public void setAdaptedJavaType(JavaClass adaptedJavaType) {
        this.adaptedJavaType = adaptedJavaType;
        this.adaptedJavaTypeName = adaptedJavaType.getQualifiedName();
    }

    public String getAdaptedJavaTypeName() {
        return this.adaptedJavaTypeName;
    }

    public Class getScopeClass() {
        return this.scopeClass;
    }

    public void setScopeClass(Class scopeClass) {
        this.scopeClass = scopeClass;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    public TypeMappingInfo getTypeMappingInfo() {
        return this.typeMappingInfo;
    }

    public void setTypeMappingInfo(TypeMappingInfo info) {
        this.typeMappingInfo = info;
    }

    public String getXmlMimeType() {
        return this.xmlMimeType;
    }

    public void setXmlMimeType(String xmlMimeType) {
        this.xmlMimeType = xmlMimeType;
    }

    public boolean isXmlAttachmentRef() {
        return this.xmlAttachmentRef;
    }

    public void setXmlAttachmentRef(boolean xmlAttachmentRef) {
        this.xmlAttachmentRef = xmlAttachmentRef;
    }
}

