/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.descriptors.CoreObjectBuilder;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.jaxb.IDResolverWrapper;
import org.eclipse.persistence.internal.jaxb.WrappedValue;
import org.eclipse.persistence.internal.jaxb.many.ManyValue;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.oxm.StrBuffer;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.mappings.DirectCollectionMapping;
import org.eclipse.persistence.internal.oxm.record.XMLEventReaderInputSource;
import org.eclipse.persistence.internal.oxm.record.XMLEventReaderReader;
import org.eclipse.persistence.internal.oxm.record.XMLStreamReaderInputSource;
import org.eclipse.persistence.internal.oxm.record.XMLStreamReaderReader;
import org.eclipse.persistence.internal.oxm.record.namespaces.PrefixMapperNamespaceResolver;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBErrorHandler;
import org.eclipse.persistence.jaxb.JAXBUnmarshalListener;
import org.eclipse.persistence.jaxb.JAXBUnmarshallerHandler;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.attachment.AttachmentUnmarshallerAdapter;
import org.eclipse.persistence.oxm.IDResolver;
import org.eclipse.persistence.oxm.MediaType;
import org.eclipse.persistence.oxm.NamespacePrefixMapper;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JAXBUnmarshaller
implements Unmarshaller {
    private ValidationEventHandler validationEventHandler = JAXBContext.DEFAULT_VALIDATION_EVENT_HANDER;
    private XMLUnmarshaller xmlUnmarshaller;
    private JAXBContext jaxbContext;
    public static final String XML_JAVATYPE_ADAPTERS = "xml-javatype-adapters";
    public static final String STAX_SOURCE_CLASS_NAME = "javax.xml.transform.stax.StAXSource";
    private static final String SUN_ID_RESOLVER = "com.sun.xml.bind.IDResolver";
    private static final String SUN_JSE_ID_RESOLVER = "com.sun.xml.internal.bind.IDResolver";

    public JAXBUnmarshaller(XMLUnmarshaller newXMLUnmarshaller) {
        this.xmlUnmarshaller = newXMLUnmarshaller;
        this.xmlUnmarshaller.setValidationMode(0);
        this.xmlUnmarshaller.setUnmarshalListener(new JAXBUnmarshalListener(this));
        this.xmlUnmarshaller.setErrorHandler(new JAXBErrorHandler(this.validationEventHandler));
    }

    public XMLUnmarshaller getXMLUnmarshaller() {
        return this.xmlUnmarshaller;
    }

    @Override
    public Object unmarshal(File file) throws JAXBException {
        try {
            Object value = this.xmlUnmarshaller.unmarshal(file);
            return this.createJAXBElementOrUnwrapIfRequired(value);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    @Override
    public Object unmarshal(InputStream inputStream) throws JAXBException {
        try {
            if (this.xmlUnmarshaller.isAutoDetectMediaType() || this.xmlUnmarshaller.getMediaType() == MediaType.APPLICATION_JSON || this.jaxbContext.getXMLInputFactory() == null || this.xmlUnmarshaller.getValidationMode() != 0) {
                return this.createJAXBElementOrUnwrapIfRequired(this.xmlUnmarshaller.unmarshal(inputStream));
            }
            if (inputStream == null) {
                throw XMLMarshalException.nullArgumentException();
            }
            XMLStreamReader xmlStreamReader = this.jaxbContext.getXMLInputFactory().createXMLStreamReader(inputStream);
            Object value = this.unmarshal(xmlStreamReader);
            xmlStreamReader.close();
            return value;
        }
        catch (JAXBException jaxbException) {
            throw jaxbException;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
        catch (Exception exception) {
            throw new UnmarshalException(exception);
        }
    }

    @Override
    public Object unmarshal(URL url) throws JAXBException {
        try {
            Object value = this.xmlUnmarshaller.unmarshal(url);
            return this.createJAXBElementOrUnwrapIfRequired(value);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    @Override
    public Object unmarshal(InputSource inputSource) throws JAXBException {
        try {
            Object value = this.xmlUnmarshaller.unmarshal(inputSource);
            return this.createJAXBElementOrUnwrapIfRequired(value);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    @Override
    public Object unmarshal(Reader reader) throws JAXBException {
        try {
            if (this.xmlUnmarshaller.isAutoDetectMediaType() || this.xmlUnmarshaller.getMediaType() == MediaType.APPLICATION_JSON || this.jaxbContext.getXMLInputFactory() == null || this.xmlUnmarshaller.getValidationMode() != 0) {
                return this.createJAXBElementOrUnwrapIfRequired(this.xmlUnmarshaller.unmarshal(reader));
            }
            if (reader == null) {
                throw XMLMarshalException.nullArgumentException();
            }
            XMLStreamReader xmlStreamReader = this.jaxbContext.getXMLInputFactory().createXMLStreamReader(reader);
            Object value = this.unmarshal(xmlStreamReader);
            xmlStreamReader.close();
            return value;
        }
        catch (JAXBException jaxbException) {
            throw jaxbException;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
        catch (Exception exception) {
            throw new UnmarshalException(exception);
        }
    }

    @Override
    public Object unmarshal(Node node) throws JAXBException {
        try {
            Object value = this.xmlUnmarshaller.unmarshal(node);
            return this.createJAXBElementOrUnwrapIfRequired(value);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    private JAXBElement buildJAXBElementFromObject(Object obj, Class declaredClass) {
        if (obj instanceof Root) {
            JAXBElement jaxbElement = this.jaxbContext.createJAXBElementFromXMLRoot((Root)obj, declaredClass);
            if (((Root)obj).isNil()) {
                jaxbElement.setNil(((Root)obj).isNil());
                jaxbElement.setValue(null);
            }
            return jaxbElement;
        }
        if (obj instanceof JAXBElement) {
            return (JAXBElement)obj;
        }
        AbstractSession sess = this.xmlUnmarshaller.getXMLContext().getSession(obj);
        Descriptor desc = (Descriptor)((Object)sess.getClassDescriptor(obj));
        String rootName = desc.getDefaultRootElement();
        if (rootName == null) {
            return this.jaxbContext.createJAXBElement(new QName(""), obj.getClass(), obj);
        }
        String rootNamespaceUri = null;
        int idx = rootName.indexOf(":");
        if (idx != -1) {
            rootNamespaceUri = ((NamespaceResolver)desc.getNamespaceResolver()).resolveNamespacePrefix(rootName.substring(0, idx));
            rootName = rootName.substring(idx + 1);
        }
        QName qname = rootNamespaceUri == null ? new QName(rootName) : new QName(rootNamespaceUri, rootName);
        if (declaredClass != null) {
            return this.jaxbContext.createJAXBElement(qname, declaredClass, obj);
        }
        return this.jaxbContext.createJAXBElement(qname, obj.getClass(), obj);
    }

    public JAXBElement unmarshal(Node node, Class javaClass) throws JAXBException {
        if (javaClass == null) {
            throw new IllegalArgumentException();
        }
        try {
            Class generatedClass;
            Class classToUnmarshalTo = this.getClassToUnmarshalTo(javaClass);
            if (this.jaxbContext.getArrayClassesToGeneratedClasses() != null && (generatedClass = this.jaxbContext.getArrayClassesToGeneratedClasses().get(javaClass.getCanonicalName())) != null) {
                classToUnmarshalTo = generatedClass;
            }
            return this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal(node, classToUnmarshalTo), javaClass);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    @Override
    public Object unmarshal(Source source) throws JAXBException {
        try {
            Object value = this.xmlUnmarshaller.unmarshal(source);
            return this.createJAXBElementOrUnwrapIfRequired(value);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(Source source, Class javaClass) throws JAXBException {
        if (javaClass == null) {
            throw new IllegalArgumentException();
        }
        Class classToUnmarshalTo = this.getClassToUnmarshalTo(javaClass);
        try {
            return this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal(source, classToUnmarshalTo), javaClass);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    private JAXBElement unmarshal(Source source, Class javaClass, Class declaredType) {
        Class generatedClass;
        Class classToUnmarshalTo = javaClass;
        if (this.jaxbContext.getArrayClassesToGeneratedClasses() != null && (generatedClass = this.jaxbContext.getArrayClassesToGeneratedClasses().get(javaClass.getCanonicalName())) != null) {
            classToUnmarshalTo = generatedClass;
        }
        return this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal(source, classToUnmarshalTo), declaredType);
    }

    public JAXBElement unmarshal(Source source, Type type2) throws JAXBException {
        if (type2 == null) {
            throw new IllegalArgumentException();
        }
        try {
            TypeMappingInfo tmi;
            if (this.jaxbContext.getTypeToTypeMappingInfo() != null && (tmi = this.jaxbContext.getTypeToTypeMappingInfo().get(type2)) != null) {
                return this.unmarshal(source, tmi);
            }
            Class unmarshalClass = this.jaxbContext.getCollectionClassesToGeneratedClasses().get(type2);
            if (unmarshalClass != null) {
                JAXBElement unmarshalled = this.unmarshal(source, unmarshalClass, Object.class);
                Class declaredClass = null;
                declaredClass = type2 instanceof Class ? (Class)type2 : Object.class;
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), declaredClass, unmarshalled.getScope(), unmarshalled.getValue());
                return returnVal;
            }
            if (type2 instanceof Class) {
                return this.unmarshal(source, (Class)type2, Object.class);
            }
            return null;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(Source source, TypeMappingInfo type2) throws JAXBException {
        try {
            Class unmarshalClass = this.jaxbContext.getTypeMappingInfoToGeneratedType().get(type2);
            JAXBContext.RootLevelXmlAdapter adapter = this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().get(type2);
            if (unmarshalClass != null) {
                JAXBElement unmarshalled = this.unmarshal(source, unmarshalClass);
                Class declaredClass = null;
                declaredClass = type2.getType() instanceof Class ? (Class)type2.getType() : Object.class;
                Object value = unmarshalled.getValue();
                if (adapter != null) {
                    try {
                        value = adapter.getXmlAdapter().unmarshal(value);
                    }
                    catch (Exception ex) {
                        throw new JAXBException(XMLMarshalException.marshalException(ex));
                    }
                }
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), declaredClass, unmarshalled.getScope(), value);
                return returnVal;
            }
            if (type2.getType() instanceof Class) {
                if (adapter != null) {
                    JAXBElement element = this.unmarshal(source, adapter.getBoundType());
                    try {
                        Object value = adapter.getXmlAdapter().unmarshal(element.getValue());
                        element.setValue(value);
                        return element;
                    }
                    catch (Exception ex) {
                        throw new JAXBException(XMLMarshalException.marshalException(ex));
                    }
                }
                return this.unmarshal(source, (Class)type2.getType());
            }
            if (type2.getType() instanceof ParameterizedType) {
                return this.unmarshal(source, ((ParameterizedType)type2.getType()).getRawType());
            }
            return null;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(XMLStreamReader streamReader, Class javaClass) throws JAXBException {
        if (streamReader == null || javaClass == null) {
            throw new IllegalArgumentException();
        }
        try {
            XMLStreamReaderReader staxReader = new XMLStreamReaderReader(this.xmlUnmarshaller);
            XMLStreamReaderInputSource inputSource = new XMLStreamReaderInputSource(streamReader);
            if (XMLConversionManager.getDefaultJavaTypes().get(javaClass) != null || CoreClassConstants.XML_GREGORIAN_CALENDAR.isAssignableFrom(javaClass) || CoreClassConstants.DURATION.isAssignableFrom(javaClass)) {
                PrimitiveContentHandler primitiveContentHandler = new PrimitiveContentHandler(javaClass);
                staxReader.setContentHandler(primitiveContentHandler);
                staxReader.parse(inputSource);
                return primitiveContentHandler.getJaxbElement();
            }
            Class classToUnmarshalTo = this.getClassToUnmarshalTo(javaClass);
            JAXBElement unmarshalled = this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal(staxReader, inputSource, classToUnmarshalTo), javaClass);
            if (classToUnmarshalTo != javaClass) {
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), javaClass, unmarshalled.getScope(), unmarshalled.getValue());
                return returnVal;
            }
            return unmarshalled;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
        catch (Exception e) {
            throw new JAXBException(e);
        }
    }

    public JAXBElement unmarshal(XMLStreamReader streamReader, Type type2) throws JAXBException {
        if (streamReader == null || type2 == null) {
            throw new IllegalArgumentException();
        }
        try {
            TypeMappingInfo tmi;
            if (this.jaxbContext.getTypeToTypeMappingInfo() != null && (tmi = this.jaxbContext.getTypeToTypeMappingInfo().get(type2)) != null) {
                return this.unmarshal(streamReader, tmi);
            }
            Class unmarshalClass = this.jaxbContext.getCollectionClassesToGeneratedClasses().get(type2);
            if (unmarshalClass != null) {
                JAXBElement unmarshalled = this.unmarshal(streamReader, unmarshalClass);
                Class declaredClass = null;
                declaredClass = type2 instanceof Class ? (Class)type2 : Object.class;
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), declaredClass, unmarshalled.getScope(), unmarshalled.getValue());
                return returnVal;
            }
            if (type2 instanceof Class) {
                return this.unmarshal(streamReader, (Class)type2);
            }
            return null;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(XMLStreamReader streamReader, TypeMappingInfo type2) throws JAXBException {
        try {
            JAXBContext.RootLevelXmlAdapter adapter;
            Descriptor xmlDescriptor = type2.getXmlDescriptor();
            if (type2.getType() instanceof Class) {
                Class javaClass = (Class)type2.getType();
                Class<?> componentClass = javaClass.getComponentType();
                if (javaClass.isArray() && javaClass != CoreClassConstants.APBYTE && javaClass != CoreClassConstants.ABYTE && XMLConversionManager.getDefaultJavaTypes().get(componentClass) != null) {
                    DirectCollectionMapping mapping = (DirectCollectionMapping)xmlDescriptor.getMappings().get(0);
                    XMLStreamReaderReader staxReader = new XMLStreamReaderReader(this.xmlUnmarshaller);
                    staxReader.setErrorHandler(this.xmlUnmarshaller.getErrorHandler());
                    PrimitiveArrayContentHandler primitiveArrayContentHandler = new PrimitiveArrayContentHandler(javaClass, componentClass, mapping.usesSingleNode());
                    staxReader.setContentHandler(primitiveArrayContentHandler);
                    XMLStreamReaderInputSource inputSource = new XMLStreamReaderInputSource(streamReader);
                    staxReader.parse(inputSource);
                    return primitiveArrayContentHandler.getJaxbElement();
                }
            }
            if (xmlDescriptor != null && this.getSchema() == null) {
                adapter = null;
                if (this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().size() > 0) {
                    adapter = this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().get(type2);
                }
                UnmarshalRecord unmarshalRecord = (UnmarshalRecord)((CoreObjectBuilder)xmlDescriptor.getObjectBuilder()).createRecord((AbstractSession)((AbstractSession)((Object)this.xmlUnmarshaller.getXMLContext().getSession(0))));
                XMLStreamReaderReader staxReader = new XMLStreamReaderReader(this.xmlUnmarshaller);
                unmarshalRecord.setUnmarshaller(this.xmlUnmarshaller);
                unmarshalRecord.setXMLReader(staxReader);
                staxReader.setContentHandler(unmarshalRecord);
                staxReader.parse(streamReader);
                Object value = null;
                value = unmarshalRecord.isNil() ? null : unmarshalRecord.getCurrentObject();
                if (value instanceof WrappedValue) {
                    value = ((WrappedValue)value).getValue();
                }
                if (value instanceof ManyValue) {
                    value = ((ManyValue)value).getItem();
                }
                if (adapter != null) {
                    try {
                        value = adapter.getXmlAdapter().unmarshal(value);
                    }
                    catch (Exception ex) {
                        throw new JAXBException(XMLMarshalException.marshalException(ex));
                    }
                }
                Class declaredClass = null;
                declaredClass = type2.getType() instanceof Class ? (Class)type2.getType() : Object.class;
                return new JAXBElement<Object>(new QName(unmarshalRecord.getRootElementNamespaceUri(), unmarshalRecord.getLocalName()), declaredClass, value);
            }
            if (this.jaxbContext.getTypeMappingInfoToGeneratedType() == null) {
                return this.unmarshal(streamReader, type2.getType());
            }
            adapter = null;
            if (this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().size() > 0) {
                adapter = this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().get(type2);
            }
            Class unmarshalClass = null;
            if (this.jaxbContext.getTypeMappingInfoToGeneratedType().size() > 0) {
                unmarshalClass = this.jaxbContext.getTypeMappingInfoToGeneratedType().get(type2);
            }
            if (unmarshalClass != null) {
                JAXBElement unmarshalled = this.unmarshal(streamReader, unmarshalClass);
                Class declaredClass = null;
                declaredClass = type2.getType() instanceof Class ? (Class)type2.getType() : Object.class;
                Object value = unmarshalled.getValue();
                if (adapter != null) {
                    try {
                        value = adapter.getXmlAdapter().unmarshal(value);
                    }
                    catch (Exception ex) {
                        throw new JAXBException(XMLMarshalException.marshalException(ex));
                    }
                }
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), declaredClass, unmarshalled.getScope(), value);
                return returnVal;
            }
            if (type2.getType() instanceof Class) {
                if (adapter != null) {
                    JAXBElement element = this.unmarshal(streamReader, adapter.getBoundType());
                    try {
                        Object value = adapter.getXmlAdapter().unmarshal(element.getValue());
                        element.setValue(value);
                        return element;
                    }
                    catch (Exception ex) {
                        throw new JAXBException(XMLMarshalException.marshalException(ex));
                    }
                }
                return this.unmarshal(streamReader, (Class)type2.getType());
            }
            if (type2.getType() instanceof ParameterizedType) {
                return this.unmarshal(streamReader, ((ParameterizedType)type2.getType()).getRawType());
            }
            return null;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
        catch (SAXException e) {
            throw new JAXBException(e);
        }
    }

    @Override
    public Object unmarshal(XMLStreamReader streamReader) throws JAXBException {
        if (streamReader == null) {
            throw new IllegalArgumentException();
        }
        try {
            XMLStreamReaderReader staxReader = new XMLStreamReaderReader(this.xmlUnmarshaller);
            XMLStreamReaderInputSource inputSource = new XMLStreamReaderInputSource(streamReader);
            Object value = this.xmlUnmarshaller.unmarshal(staxReader, inputSource);
            return this.createJAXBElementOrUnwrapIfRequired(value);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(XMLEventReader eventReader, Class javaClass) throws JAXBException {
        if (eventReader == null || javaClass == null) {
            throw new IllegalArgumentException();
        }
        try {
            Class classToUnmarshalTo = this.getClassToUnmarshalTo(javaClass);
            XMLEventReaderReader staxReader = new XMLEventReaderReader(this.xmlUnmarshaller);
            XMLEventReaderInputSource inputSource = new XMLEventReaderInputSource(eventReader);
            JAXBElement unmarshalled = this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal(staxReader, inputSource, classToUnmarshalTo), javaClass);
            if (classToUnmarshalTo != javaClass) {
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), javaClass, unmarshalled.getScope(), unmarshalled.getValue());
                return returnVal;
            }
            return unmarshalled;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(XMLEventReader eventReader, Type type2) throws JAXBException {
        if (eventReader == null || type2 == null) {
            throw new IllegalArgumentException();
        }
        try {
            TypeMappingInfo tmi;
            if (this.jaxbContext.getTypeToTypeMappingInfo() != null && (tmi = this.jaxbContext.getTypeToTypeMappingInfo().get(type2)) != null) {
                return this.unmarshal(eventReader, tmi);
            }
            Class unmarshalClass = this.jaxbContext.getCollectionClassesToGeneratedClasses().get(type2);
            if (unmarshalClass != null) {
                JAXBElement unmarshalled = this.unmarshal(eventReader, unmarshalClass);
                Class declaredClass = null;
                declaredClass = type2 instanceof Class ? (Class)type2 : Object.class;
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), declaredClass, unmarshalled.getScope(), unmarshalled.getValue());
                return returnVal;
            }
            if (type2 instanceof Class) {
                return this.unmarshal(eventReader, (Class)type2);
            }
            return null;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(XMLEventReader eventReader, TypeMappingInfo type2) throws JAXBException {
        try {
            if (this.jaxbContext.getTypeMappingInfoToGeneratedType() == null) {
                return this.unmarshal(eventReader, type2.getType());
            }
            Class unmarshalClass = this.jaxbContext.getTypeMappingInfoToGeneratedType().get(type2);
            JAXBContext.RootLevelXmlAdapter adapter = this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().get(type2);
            if (unmarshalClass != null) {
                JAXBElement unmarshalled = this.unmarshal(eventReader, unmarshalClass);
                Class declaredClass = null;
                declaredClass = type2.getType() instanceof Class ? (Class)type2.getType() : Object.class;
                Object value = unmarshalled.getValue();
                if (adapter != null) {
                    try {
                        value = adapter.getXmlAdapter().unmarshal(value);
                    }
                    catch (Exception ex) {
                        throw new JAXBException(XMLMarshalException.marshalException(ex));
                    }
                }
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), declaredClass, unmarshalled.getScope(), value);
                return returnVal;
            }
            if (type2.getType() instanceof Class) {
                if (adapter != null) {
                    JAXBElement element = this.unmarshal(eventReader, adapter.getBoundType());
                    try {
                        Object value = adapter.getXmlAdapter().unmarshal(element.getValue());
                        element.setValue(value);
                        return element;
                    }
                    catch (Exception ex) {
                        throw new JAXBException(XMLMarshalException.marshalException(ex));
                    }
                }
                return this.unmarshal(eventReader, (Class)type2.getType());
            }
            if (type2.getType() instanceof ParameterizedType) {
                return this.unmarshal(eventReader, ((ParameterizedType)type2.getType()).getRawType());
            }
            return null;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    @Override
    public Object unmarshal(XMLEventReader eventReader) throws JAXBException {
        if (eventReader == null) {
            throw new IllegalArgumentException();
        }
        try {
            XMLEventReaderReader staxReader = new XMLEventReaderReader(this.xmlUnmarshaller);
            XMLEventReaderInputSource inputSource = new XMLEventReaderInputSource(eventReader);
            Object value = this.xmlUnmarshaller.unmarshal(staxReader, inputSource);
            return this.createJAXBElementOrUnwrapIfRequired(value);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    @Override
    public UnmarshallerHandler getUnmarshallerHandler() {
        return new JAXBUnmarshallerHandler(this);
    }

    @Override
    public void setValidating(boolean validate) throws JAXBException {
        if (validate) {
            this.xmlUnmarshaller.setValidationMode(3);
        } else {
            this.xmlUnmarshaller.setValidationMode(0);
        }
    }

    @Override
    public boolean isValidating() throws JAXBException {
        return this.xmlUnmarshaller.getValidationMode() != 0;
    }

    @Override
    public void setEventHandler(ValidationEventHandler newValidationEventHandler) throws JAXBException {
        this.validationEventHandler = newValidationEventHandler == null ? JAXBContext.DEFAULT_VALIDATION_EVENT_HANDER : newValidationEventHandler;
        this.xmlUnmarshaller.setErrorHandler(new JAXBErrorHandler(this.validationEventHandler));
    }

    @Override
    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.validationEventHandler;
    }

    @Override
    public void setProperty(String key, Object value) throws PropertyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (key.equals("eclipselink.media-type")) {
            MediaType mType = null;
            if (value instanceof MediaType) {
                mType = (MediaType)value;
            } else if (value instanceof String) {
                mType = MediaType.getMediaType((String)value);
            }
            if (mType == null) {
                throw new PropertyException(key, "");
            }
            this.xmlUnmarshaller.setMediaType(mType);
        } else if (key.equals("eclipselink.auto-detect-media-type")) {
            if (value == null) {
                throw new PropertyException(key, "");
            }
            this.xmlUnmarshaller.setAutoDetectMediaType((Boolean)value);
        } else if (key.equals("eclipselink.json.attribute-prefix")) {
            this.xmlUnmarshaller.setAttributePrefix((String)value);
        } else if ("eclipselink.json.include-root".equals(key)) {
            if (value == null) {
                throw new PropertyException(key, "");
            }
            this.xmlUnmarshaller.setIncludeRoot((Boolean)value);
        } else if ("eclipselink.namespace-prefix-mapper".equals(key)) {
            if (value == null) {
                this.xmlUnmarshaller.setNamespaceResolver(null);
            } else if (value instanceof Map) {
                Map namespaces = (Map)value;
                org.eclipse.persistence.oxm.NamespaceResolver nr = new org.eclipse.persistence.oxm.NamespaceResolver();
                Iterator namesapcesIter = namespaces.entrySet().iterator();
                int i = 0;
                while (i < namespaces.size()) {
                    Map.Entry nextEntry = namesapcesIter.next();
                    nr.put((String)nextEntry.getValue(), (String)nextEntry.getKey());
                    ++i;
                }
                this.xmlUnmarshaller.setNamespaceResolver(nr);
            } else if (value instanceof NamespacePrefixMapper) {
                this.xmlUnmarshaller.setNamespaceResolver(new PrefixMapperNamespaceResolver((NamespacePrefixMapper)value, null));
            }
        } else if ("eclipselink.json.value-wrapper".equals(key)) {
            this.xmlUnmarshaller.setValueWrapper((String)value);
        } else if ("eclipselink.json.namespace-separator".equals(key)) {
            if (value == null) {
                throw new PropertyException(key, "");
            }
            this.xmlUnmarshaller.setNamespaceSeparator(((Character)value).charValue());
        } else if ("eclipselink.id-resolver".equals(key)) {
            this.setIDResolver((IDResolver)value);
        } else if (SUN_ID_RESOLVER.equals(key) || SUN_JSE_ID_RESOLVER.equals(key)) {
            if (value == null) {
                this.setIDResolver(null);
            } else {
                this.setIDResolver(new IDResolverWrapper(value));
            }
        } else {
            throw new PropertyException(key, value);
        }
    }

    @Override
    public Object getProperty(String key) throws PropertyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (key.equals("eclipselink.media-type")) {
            return this.xmlUnmarshaller.getMediaType();
        }
        if (key.equals("eclipselink.auto-detect-media-type")) {
            return this.xmlUnmarshaller.isAutoDetectMediaType();
        }
        if (key.equals("eclipselink.json.attribute-prefix")) {
            return this.xmlUnmarshaller.getAttributePrefix();
        }
        if (key.equals("eclipselink.json.include-root")) {
            return this.xmlUnmarshaller.isIncludeRoot();
        }
        if (key.equals("eclipselink.json.namespace-separator")) {
            return Character.valueOf(this.xmlUnmarshaller.getNamespaceSeparator());
        }
        if (key.equals("eclipselink.namespace-prefix-mapper")) {
            if (this.xmlUnmarshaller.getNamespaceResolver() == null) {
                return null;
            }
            if (this.xmlUnmarshaller.getNamespaceResolver() instanceof PrefixMapperNamespaceResolver) {
                PrefixMapperNamespaceResolver wrapper = (PrefixMapperNamespaceResolver)this.xmlUnmarshaller.getNamespaceResolver();
                return wrapper.getPrefixMapper();
            }
            HashMap<String, String> nsMap = new HashMap<String, String>();
            Map<String, String> prefixesToNS = this.xmlUnmarshaller.getNamespaceResolver().getPrefixesToNamespaces();
            Iterator<Map.Entry<String, String>> namesapcesIter = prefixesToNS.entrySet().iterator();
            int i = 0;
            while (i < prefixesToNS.size()) {
                Map.Entry<String, String> nextEntry = namesapcesIter.next();
                nsMap.put(nextEntry.getValue(), nextEntry.getKey());
                ++i;
            }
            return nsMap;
        }
        if (key.equals("eclipselink.json.value-wrapper")) {
            return this.xmlUnmarshaller.getValueWrapper();
        }
        if ("eclipselink.id-resolver".equals(key)) {
            return this.xmlUnmarshaller.getIDResolver();
        }
        if (SUN_ID_RESOLVER.equals(key) || SUN_JSE_ID_RESOLVER.equals(key)) {
            IDResolverWrapper wrapper = (IDResolverWrapper)this.xmlUnmarshaller.getIDResolver();
            if (wrapper == null) {
                return null;
            }
            return wrapper.getResolver();
        }
        throw new PropertyException(key);
    }

    @Override
    public Unmarshaller.Listener getListener() {
        return ((JAXBUnmarshalListener)this.xmlUnmarshaller.getUnmarshalListener()).getListener();
    }

    @Override
    public void setListener(Unmarshaller.Listener listener) {
        ((JAXBUnmarshalListener)this.xmlUnmarshaller.getUnmarshalListener()).setListener(listener);
    }

    public XmlAdapter getAdapter(Class javaClass) {
        HashMap result = (HashMap)this.xmlUnmarshaller.getProperty(XML_JAVATYPE_ADAPTERS);
        if (result == null) {
            return null;
        }
        return (XmlAdapter)result.get(javaClass);
    }

    public void setAdapter(Class javaClass, XmlAdapter adapter) {
        HashMap<Class, XmlAdapter> result = (HashMap<Class, XmlAdapter>)this.xmlUnmarshaller.getProperty(XML_JAVATYPE_ADAPTERS);
        if (result == null) {
            result = new HashMap<Class, XmlAdapter>();
            this.xmlUnmarshaller.getProperties().put(XML_JAVATYPE_ADAPTERS, result);
        }
        result.put(javaClass, adapter);
    }

    @Override
    public void setAdapter(XmlAdapter adapter) {
        this.setAdapter(adapter.getClass(), adapter);
    }

    @Override
    public void setSchema(Schema schema) {
        this.xmlUnmarshaller.setSchema(schema);
    }

    @Override
    public Schema getSchema() {
        return this.xmlUnmarshaller.getSchema();
    }

    @Override
    public AttachmentUnmarshaller getAttachmentUnmarshaller() {
        if (this.xmlUnmarshaller.getAttachmentUnmarshaller() == null) {
            return null;
        }
        return ((AttachmentUnmarshallerAdapter)this.xmlUnmarshaller.getAttachmentUnmarshaller()).getAttachmentUnmarshaller();
    }

    @Override
    public void setAttachmentUnmarshaller(AttachmentUnmarshaller unmarshaller) {
        if (unmarshaller == null) {
            this.xmlUnmarshaller.setAttachmentUnmarshaller(null);
        } else {
            this.xmlUnmarshaller.setAttachmentUnmarshaller(new AttachmentUnmarshallerAdapter(unmarshaller));
        }
    }

    public void setUnmarshalCallbacks(HashMap callbacks) {
        ((JAXBUnmarshalListener)this.xmlUnmarshaller.getUnmarshalListener()).setClassBasedUnmarshalEvents(callbacks);
    }

    private Object createJAXBElementOrUnwrapIfRequired(Object value) {
        if (value instanceof Root) {
            JAXBElement jaxbElement = this.jaxbContext.createJAXBElementFromXMLRoot((Root)value, Object.class);
            jaxbElement.setNil(((Root)value).isNil());
            return jaxbElement;
        }
        if (value instanceof WrappedValue) {
            return ((WrappedValue)value).getValue();
        }
        return value;
    }

    public JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }

    public void setJaxbContext(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    private Class getClassToUnmarshalTo(Class originalClass) {
        Class generatedClass;
        TypeMappingInfo tmi;
        Class generatedClass2;
        Class classToUnmarshalTo = originalClass;
        if (this.jaxbContext.getArrayClassesToGeneratedClasses() != null && this.jaxbContext.getArrayClassesToGeneratedClasses().size() > 0 && (generatedClass2 = this.jaxbContext.getArrayClassesToGeneratedClasses().get(originalClass.getCanonicalName())) != null) {
            classToUnmarshalTo = generatedClass2;
        }
        if (this.jaxbContext.getCollectionClassesToGeneratedClasses() != null && this.jaxbContext.getCollectionClassesToGeneratedClasses().size() > 0 && (generatedClass2 = this.jaxbContext.getCollectionClassesToGeneratedClasses().get(originalClass)) != null) {
            classToUnmarshalTo = generatedClass2;
        }
        if (this.jaxbContext.getTypeToTypeMappingInfo() != null && (tmi = this.jaxbContext.getTypeToTypeMappingInfo().get(originalClass)) != null && this.jaxbContext.getTypeMappingInfoToGeneratedType() != null && (generatedClass = this.jaxbContext.getTypeMappingInfoToGeneratedType().get(tmi)) != null) {
            classToUnmarshalTo = generatedClass;
        }
        return classToUnmarshalTo;
    }

    private JAXBException handleXMLMarshalException(XMLMarshalException xmlMarshalException) {
        if (xmlMarshalException.getErrorCode() == 25011) {
            throw new IllegalArgumentException(xmlMarshalException);
        }
        return new UnmarshalException(xmlMarshalException);
    }

    public IDResolver getIDResolver() {
        return this.getXMLUnmarshaller().getIDResolver();
    }

    public void setIDResolver(IDResolver idResolver) {
        this.getXMLUnmarshaller().setIDResolver(idResolver);
    }

    private static class PrimitiveArrayContentHandler<T, E>
    extends DefaultHandler {
        private Class<T> arrayClass;
        private Class<E> componentClass;
        private JAXBElement<T> jaxbElement;
        private QName qName;
        private StrBuffer stringBuffer = new StrBuffer();
        private boolean xsiNil;
        private boolean singleNode;
        private boolean acceptCharacters = false;
        private T unmarshalledArray;
        private int currentIndex = 0;
        private int currentSize = 10;
        private XMLConversionManager xcm = XMLConversionManager.getDefaultXMLManager();

        public PrimitiveArrayContentHandler(Class<T> arrayClass, Class<E> componentClass, boolean usesSingleNode) {
            this.arrayClass = arrayClass;
            this.componentClass = componentClass;
            this.singleNode = usesSingleNode;
            this.unmarshalledArray = Array.newInstance(componentClass, this.currentSize);
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
            String xsiNilValue;
            if (localName.equals("item") || this.singleNode) {
                this.acceptCharacters = true;
            }
            if ((xsiNilValue = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil")) != null) {
                this.xsiNil = xsiNilValue.equals("true") || xsiNilValue.equals("1");
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.acceptCharacters) {
                this.stringBuffer.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
            this.acceptCharacters = false;
            if (!qualifiedName.equals("item")) {
                this.qName = namespaceURI != null && namespaceURI.length() == 0 ? new QName(qualifiedName) : new QName(namespaceURI, localName);
                if (!this.singleNode) {
                    return;
                }
            }
            if (this.singleNode) {
                this.endElementSingleNode();
                return;
            }
            Object value = this.xsiNil ? null : this.xcm.convertObject(this.stringBuffer.toString(), this.componentClass);
            this.addValue(value);
            this.stringBuffer.reset();
        }

        private void endElementSingleNode() {
            this.acceptCharacters = false;
            if (this.xsiNil) {
                this.addValue(null);
                this.stringBuffer.reset();
                return;
            }
            StringTokenizer st = new StringTokenizer(this.stringBuffer.toString());
            while (st.hasMoreTokens()) {
                String nextToken = st.nextToken();
                Object value = this.xcm.convertObject(nextToken, this.componentClass);
                this.addValue(value);
            }
            this.stringBuffer.reset();
        }

        private void addValue(E value) {
            if (this.currentIndex == this.currentSize) {
                this.growArray();
            }
            Array.set(this.unmarshalledArray, this.currentIndex, value);
            ++this.currentIndex;
        }

        private void growArray() {
            int newSize = this.currentSize * 2;
            Object newArray = Array.newInstance(this.componentClass, newSize);
            System.arraycopy(this.unmarshalledArray, 0, newArray, 0, this.currentSize);
            this.unmarshalledArray = newArray;
            this.currentSize = newSize;
        }

        public JAXBElement<T> getJaxbElement() {
            if (this.jaxbElement == null) {
                Object newArray = Array.newInstance(this.componentClass, this.currentIndex);
                System.arraycopy(this.unmarshalledArray, 0, newArray, 0, this.currentIndex);
                this.jaxbElement = new JAXBElement<Object>(this.qName, this.arrayClass, newArray);
            }
            return this.jaxbElement;
        }
    }

    private static class PrimitiveContentHandler<T>
    extends DefaultHandler {
        private Class<T> clazz;
        private JAXBElement<T> jaxbElement;
        private Map<String, String> namespaces = new HashMap<String, String>(3);
        private StringBuilder stringBuilder = new StringBuilder();
        private String xsiType;
        private boolean xsiNil;

        public PrimitiveContentHandler(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.stringBuilder.append(ch, start, length);
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
            Object value;
            XMLConversionManager xcm = XMLConversionManager.getDefaultXMLManager();
            if (this.xsiNil) {
                value = null;
            } else if (this.xsiType == null) {
                value = this.clazz == CoreClassConstants.ABYTE || this.clazz == CoreClassConstants.APBYTE || this.clazz.getCanonicalName().equals("javax.activation.DataHandler") ? xcm.convertObject(this.stringBuilder.toString(), this.clazz, Constants.BASE_64_BINARY_QNAME) : xcm.convertObject(this.stringBuilder.toString(), this.clazz);
            } else {
                String typeName;
                String typePrefix;
                int colonIndex = this.xsiType.indexOf(58);
                if (colonIndex == -1) {
                    typePrefix = "";
                    typeName = this.xsiType;
                } else {
                    typePrefix = this.xsiType.substring(0, colonIndex);
                    typeName = this.xsiType.substring(colonIndex + 1);
                }
                String typeNamespace = this.namespaces.get(typePrefix);
                QName typeQName = new QName(typeNamespace, typeName);
                value = xcm.convertObject(this.stringBuilder.toString(), this.clazz, typeQName);
            }
            QName qName = namespaceURI != null && namespaceURI.length() == 0 ? new QName(qualifiedName) : new QName(namespaceURI, localName);
            this.jaxbElement = new JAXBElement<Object>(qName, this.clazz, value);
        }

        public JAXBElement<T> getJaxbElement() {
            return this.jaxbElement;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
            String xsiNilValue = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
            if (xsiNilValue != null) {
                boolean bl = this.xsiNil = xsiNilValue.equals("true") || xsiNilValue.equals("1");
            }
            if (!this.xsiNil) {
                this.xsiType = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.namespaces.put(prefix, uri);
        }
    }
}

