/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.exceptions.DBWSException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelProject;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.xr.Operation;
import org.eclipse.persistence.internal.xr.ProjectHelper;
import org.eclipse.persistence.internal.xr.Util;
import org.eclipse.persistence.internal.xr.XRDynamicClassLoader;
import org.eclipse.persistence.internal.xr.XRServiceAdapter;
import org.eclipse.persistence.internal.xr.XRServiceModel;
import org.eclipse.persistence.internal.xr.XRSessionConfigLoader;
import org.eclipse.persistence.internal.xr.XmlBindingsModel;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormatProject;
import org.eclipse.persistence.jaxb.dynamic.DynamicJAXBContext;
import org.eclipse.persistence.jaxb.dynamic.DynamicJAXBContextFactory;
import org.eclipse.persistence.jaxb.metadata.MetadataSource;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.factories.SessionManager;

public class XRServiceFactory {
    public XRServiceAdapter xrService;
    public ClassLoader parentClassLoader;
    public InputStream xrSchemaStream;
    static final String TYPE_STR = "Type";
    static final String XML_BINDINGS_STR = "xml-bindings";
    static final String DOM_PLATFORM_CLASSNAME = "org.eclipse.persistence.oxm.platform.DOMPlatform";
    static final String OXM_PROCESSING_EX = "An exception occurred processing OXM metadata";

    public XRServiceAdapter buildService() {
        this.initializeService(this.parentClassLoader, this.xrSchemaStream);
        return this.xrService;
    }

    public XRServiceAdapter buildService(XRServiceModel xrServiceModel) {
        this.xrService = new XRServiceAdapter();
        this.xrService.setName(xrServiceModel.getName());
        this.xrService.setSessionsFile(xrServiceModel.getSessionsFile());
        this.xrService.setOperations(xrServiceModel.getOperations());
        this.initializeService(this.parentClassLoader, this.xrSchemaStream);
        return this.xrService;
    }

    public void initializeService(ClassLoader parentClassLoader, InputStream xrSchemaStream) {
        this.parentClassLoader = parentClassLoader;
        this.xrSchemaStream = xrSchemaStream;
        this.loadXMLSchema(xrSchemaStream);
        this.logoutSessions();
        this.buildSessions();
        this.customizeSession(this.xrService.orSession, this.xrService.oxSession);
        this.buildDescriptorIndex();
        this.validateOperations();
        this.initializeOperations();
        this.loginSessions();
    }

    public void customizeSession(Session orSession, Session oxSession) {
    }

    public void loadXMLSchema(InputStream xrSchemaStream) {
        SchemaModelProject schemaProject = new SchemaModelProject();
        XMLContext xmlContext = new XMLContext(schemaProject);
        XMLUnmarshaller unmarshaller = xmlContext.createUnmarshaller();
        Schema schema = (Schema)unmarshaller.unmarshal(xrSchemaStream);
        NamespaceResolver nr = schema.getNamespaceResolver();
        String targetNamespace = schema.getTargetNamespace();
        nr.put("ns1", targetNamespace);
        this.xrService.schema = schema;
        this.xrService.schemaNamespace = targetNamespace;
    }

    protected Project loadOXMetadata(ClassLoader xrdecl) {
        Project oxProject = null;
        InputStream inStream = null;
        String searchPath = null;
        String[] stringArray = Util.META_INF_PATHS;
        int n = Util.META_INF_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            searchPath = String.valueOf(prefix) + "eclipselink-dbws-ox.xml";
            inStream = xrdecl.getResourceAsStream(searchPath);
            if (inStream != null) break;
            ++n2;
        }
        if (inStream != null) {
            HashMap<String, DBWSMetadataSource> metadataMap = null;
            StreamSource xml = new StreamSource(inStream);
            try {
                JAXBContext jc = JAXBContext.newInstance(XmlBindingsModel.class);
                Unmarshaller unmarshaller = jc.createUnmarshaller();
                JAXBElement<XmlBindingsModel> jaxbElt = unmarshaller.unmarshal(xml, XmlBindingsModel.class);
                XmlBindingsModel model = jaxbElt.getValue();
                if (model.getBindingsList() != null) {
                    metadataMap = new HashMap<String, DBWSMetadataSource>();
                    for (XmlBindings xmlBindings : model.getBindingsList()) {
                        metadataMap.put(xmlBindings.getPackageName(), new DBWSMetadataSource(xmlBindings));
                    }
                }
            }
            catch (JAXBException jaxbex) {
                throw new DBWSException(OXM_PROCESSING_EX, jaxbex);
            }
            if (metadataMap != null) {
                HashMap<String, HashMap<String, DBWSMetadataSource>> properties = new HashMap<String, HashMap<String, DBWSMetadataSource>>();
                properties.put("eclipselink.oxm.metadata-source", metadataMap);
                try {
                    DynamicJAXBContext jCtx = DynamicJAXBContextFactory.createContextFromOXM(xrdecl, properties);
                    oxProject = jCtx.getXMLContext().getSession(0).getProject();
                    if (oxProject.getAliasDescriptors() != null) {
                        HashMap<String, XMLDescriptor> aliasDescriptors = new HashMap<String, XMLDescriptor>();
                        for (Object key : oxProject.getAliasDescriptors().keySet()) {
                            XMLDescriptor xdesc = (XMLDescriptor)oxProject.getAliasDescriptors().get(key.toString());
                            String defaultRootElement = xdesc.getDefaultRootElement();
                            String proposedAlias = defaultRootElement;
                            if (proposedAlias.endsWith(TYPE_STR)) {
                                proposedAlias = proposedAlias.substring(0, proposedAlias.lastIndexOf(TYPE_STR));
                            }
                            xdesc.setAlias(proposedAlias);
                            aliasDescriptors.put(proposedAlias, xdesc);
                            for (DatabaseMapping mapping : xdesc.getMappings()) {
                                if (!(mapping instanceof XMLBinaryDataMapping)) continue;
                                ((XMLBinaryDataMapping)mapping).setAttributeClassification(ClassConstants.APBYTE);
                                ((XMLBinaryDataMapping)mapping).setAttributeClassificationName(ClassConstants.APBYTE.getName());
                            }
                        }
                        oxProject.setAliasDescriptors(aliasDescriptors);
                    }
                }
                catch (JAXBException e) {
                    throw new DBWSException(OXM_PROCESSING_EX, e);
                }
            }
        }
        return oxProject;
    }

    public void buildSessions() {
        String orSessionKey;
        XRDynamicClassLoader projectLoader = new XRDynamicClassLoader(this.parentClassLoader);
        SessionManager sessionManager = SessionManager.getManager();
        boolean found = false;
        String sessionsFile = this.xrService.sessionsFile == null ? "eclipselink-dbws-sessions.xml" : this.xrService.sessionsFile;
        String[] stringArray = Util.META_INF_PATHS;
        int n = Util.META_INF_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            String searchPath = String.valueOf(prefix) + sessionsFile;
            XRSessionConfigLoader loader = new XRSessionConfigLoader(searchPath);
            loader.setShouldLogin(false);
            try {
                found = loader.load(sessionManager, projectLoader);
            }
            catch (RuntimeException runtimeException) {}
            if (found) break;
            ++n2;
        }
        if (!found) {
            throw DBWSException.couldNotLocateFile("eclipselink-dbws-sessions.xml");
        }
        ConcurrentMap sessions = sessionManager.getSessions();
        if (!sessions.containsKey(orSessionKey = String.valueOf(this.xrService.name) + "-" + "dbws-or-session")) {
            throw DBWSException.couldNotLocateORSessionForService(this.xrService.name);
        }
        this.xrService.orSession = (Session)sessions.get(orSessionKey);
        Project oxProject = null;
        oxProject = this.loadOXMetadata(projectLoader);
        if (oxProject == null) {
            String oxSessionKey = String.valueOf(this.xrService.name) + "-" + "dbws-ox-session";
            if (sessions.containsKey(oxSessionKey)) {
                this.xrService.oxSession = (Session)sessions.get(oxSessionKey);
                ((XMLLogin)this.xrService.oxSession.getDatasourceLogin()).setEqualNamespaceResolvers(false);
                oxProject = this.xrService.oxSession.getProject();
            }
            if (oxProject == null) {
                oxProject = new SimpleXMLFormatProject();
            }
        }
        ProjectHelper.fixOROXAccessors(this.xrService.orSession.getProject(), oxProject);
        ((XMLLogin)oxProject.getDatasourceLogin()).setPlatformClassName(DOM_PLATFORM_CLASSNAME);
        ((XMLLogin)oxProject.getDatasourceLogin()).setEqualNamespaceResolvers(false);
        this.xrService.xmlContext = new XMLContext(oxProject);
        this.xrService.oxSession = this.xrService.xmlContext.getSession(0);
    }

    public void loginSessions() {
        ((DatabaseSession)this.xrService.orSession).login();
    }

    public void buildDescriptorIndex() {
        for (XMLDescriptor xMLDescriptor : this.xrService.oxSession.getProject().getOrderedDescriptors()) {
            String elementNameNS;
            QName elementName;
            String context;
            XMLSchemaReference schemaReference = xMLDescriptor.getSchemaReference();
            if (schemaReference == null || schemaReference.getType() != 1 || (context = schemaReference.getSchemaContext()) == null || context.lastIndexOf(47) != 0 || (elementName = this.resolveName(elementNameNS = context.substring(1), xMLDescriptor.getNamespaceResolver())) == null) continue;
            this.xrService.descriptorsByQName.put(elementName, xMLDescriptor);
        }
    }

    public void validateOperations() {
        for (Operation operation : this.xrService.getOperationsList()) {
            operation.validate(this.xrService);
        }
    }

    public void initializeOperations() {
        for (Operation operation : this.xrService.getOperationsList()) {
            operation.initialize(this.xrService);
        }
    }

    protected void logoutSessions() {
        String orSessionName;
        SessionManager manager = SessionManager.getManager();
        ConcurrentMap sessions = manager.getSessions();
        Session orSession = (Session)sessions.remove(orSessionName = String.valueOf(this.xrService.name) + "-" + "dbws-or-session");
        if (orSession != null && orSession.isConnected()) {
            ((DatabaseSession)orSession).logout();
        }
        String oxSessionName = String.valueOf(this.xrService.name) + "-" + "dbws-ox-session";
        sessions.remove(oxSessionName);
        this.xrService.orSession = null;
        this.xrService.oxSession = null;
    }

    protected QName resolveName(String name, NamespaceResolver ns) {
        if (ns == null) {
            return null;
        }
        if ("any".equals(name)) {
            return Constants.ANY_QNAME;
        }
        int index = name.indexOf(58);
        if (index != -1) {
            String uri = ns.resolveNamespacePrefix(name.substring(0, index));
            return new QName(uri, name.substring(index + 1));
        }
        if (ns.getDefaultNamespaceURI() != null) {
            return new QName(ns.getDefaultNamespaceURI(), name);
        }
        String uri = ns.resolveNamespacePrefix("xmlns");
        return new QName(uri, name);
    }

    public static DocumentBuilder getDocumentBuilder() {
        DocumentBuilder db = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {}
        return db;
    }

    public static Transformer getTransformer() {
        Transformer transformer = null;
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            transformer = tf.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {}
        return transformer;
    }

    public class DBWSMetadataSource
    implements MetadataSource {
        XmlBindings xmlbindings;

        public DBWSMetadataSource(XmlBindings bindings) {
            this.xmlbindings = bindings;
        }

        @Override
        public XmlBindings getXmlBindings(Map<String, ?> properties, ClassLoader classLoader) {
            return this.xmlbindings;
        }
    }
}

