/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import org.eclipse.persistence.internal.helper.ComplexDatabaseType;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.queries.PLSQLRecordMetadata;

public abstract class PLSQLComplexTypeMetadata
extends ORMetadata {
    private String name;
    private String compatibleType;
    private String javaType;

    public PLSQLComplexTypeMetadata(String element) {
        super(element);
    }

    public PLSQLComplexTypeMetadata(MetadataAnnotation record, MetadataAccessor accessor) {
        super(record, accessor);
        this.name = (String)record.getAttribute("name");
        this.compatibleType = (String)record.getAttribute("compatibleType");
        this.javaType = (String)record.getAttribute("javaType");
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof PLSQLRecordMetadata) {
            PLSQLRecordMetadata parameter = (PLSQLRecordMetadata)objectToCompare;
            if (!this.valuesMatch(this.name, parameter.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.compatibleType, parameter.getCompatibleType())) {
                return false;
            }
            return this.valuesMatch(this.javaType, parameter.getJavaType());
        }
        return false;
    }

    public String getCompatibleType() {
        return this.compatibleType;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public String getName() {
        return this.name;
    }

    public abstract ComplexDatabaseType process();

    protected void process(ComplexDatabaseType type2) {
        type2.setTypeName(this.name);
        type2.setCompatibleType(this.compatibleType);
        if (this.javaType != null) {
            type2.setJavaType(this.getJavaClass(this.getMetadataClass(this.javaType)));
        }
    }

    public void setCompatibleType(String compatibleType) {
        this.compatibleType = compatibleType;
    }

    public void setJavaType(String javaType) {
        this.javaType = javaType;
    }

    public void setName(String name) {
        this.name = name;
    }
}

