/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.persistence.AttributeConverter;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.AbstractColumnMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.sessions.Session;

public class ConverterClass
implements Converter {
    protected boolean isForMapKey;
    protected boolean disableConversion;
    protected Class fieldClassification;
    protected String fieldClassificationName;
    protected String attributeConverterClassName;
    protected AttributeConverter attributeConverter;

    public ConverterClass(String attributeConverterClassName, boolean isForMapKey, String fieldClassificationName, boolean disableConversion) {
        this.isForMapKey = isForMapKey;
        this.disableConversion = disableConversion;
        this.fieldClassificationName = fieldClassificationName;
        this.attributeConverterClassName = attributeConverterClassName;
    }

    @Override
    public Object convertDataValueToObjectValue(Object dataValue, Session session) {
        return this.attributeConverter.convertToEntityAttribute(dataValue);
    }

    @Override
    public Object convertObjectValueToDataValue(Object objectValue, Session session) {
        return this.attributeConverter.convertToDatabaseColumn(objectValue);
    }

    @Override
    public void initialize(DatabaseMapping mapping, Session session) {
        DatabaseMapping m;
        ConverterClass converter;
        block20: {
            ClassLoader loader;
            block19: {
                loader = session.getClass().getClassLoader();
                if (this.disableConversion) {
                    converter = null;
                } else {
                    converter = this;
                    Class attributeConverterClass = null;
                    try {
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                attributeConverterClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.attributeConverterClassName, true, loader));
                                this.attributeConverter = (AttributeConverter)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(attributeConverterClass));
                                break block19;
                            }
                            catch (PrivilegedActionException exception) {
                                throw ValidationException.classNotFoundWhileConvertingClassNames(this.attributeConverterClassName, exception.getException());
                            }
                        }
                        attributeConverterClass = PrivilegedAccessHelper.getClassForName(this.attributeConverterClassName, true, loader);
                        this.attributeConverter = (AttributeConverter)PrivilegedAccessHelper.newInstanceFromClass(attributeConverterClass);
                    }
                    catch (ClassNotFoundException exception) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.attributeConverterClassName, exception);
                    }
                    catch (IllegalAccessException exception) {
                        throw ValidationException.errorInstantiatingClass(attributeConverterClass, exception);
                    }
                    catch (InstantiationException exception) {
                        throw ValidationException.errorInstantiatingClass(attributeConverterClass, exception);
                    }
                }
            }
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        this.fieldClassification = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.fieldClassificationName, true, loader));
                        break block20;
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.fieldClassificationName, exception.getException());
                    }
                }
                this.fieldClassification = PrivilegedAccessHelper.getClassForName(this.fieldClassificationName, true, loader);
            }
            catch (ClassNotFoundException exception) {
                throw ValidationException.classNotFoundWhileConvertingClassNames(this.attributeConverterClassName, exception);
            }
        }
        if (mapping.isDirectToFieldMapping()) {
            m = (DirectToFieldMapping)mapping;
            ((AbstractColumnMapping)m).setConverter(converter);
            ((AbstractDirectMapping)m).setFieldClassification(this.fieldClassification);
            ((AbstractDirectMapping)m).setFieldClassificationClassName(this.fieldClassificationName);
        } else if (mapping.isDirectMapMapping() && this.isForMapKey) {
            m = (DirectMapMapping)mapping;
            ((DirectMapMapping)m).setKeyConverter(converter);
            ((DirectMapMapping)m).setDirectKeyFieldClassification(this.fieldClassification);
            ((DirectMapMapping)m).setDirectKeyFieldClassificationName(this.fieldClassificationName);
        } else if (mapping.isDirectCollectionMapping()) {
            m = (DirectCollectionMapping)mapping;
            ((DirectCollectionMapping)m).setValueConverter(converter);
            ((DirectCollectionMapping)m).setDirectFieldClassification(this.fieldClassification);
            ((DirectCollectionMapping)m).setDirectFieldClassificationName(this.fieldClassificationName);
        }
    }

    @Override
    public boolean isMutable() {
        return false;
    }
}

