/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.cache;

import org.eclipse.persistence.annotations.CacheCoordinationType;
import org.eclipse.persistence.annotations.CacheType;
import org.eclipse.persistence.annotations.DatabaseChangeNotificationType;
import org.eclipse.persistence.config.CacheIsolationType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.invalidation.DailyCacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.TimeToLiveCacheInvalidationPolicy;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.cache.TimeOfDayMetadata;

public class CacheMetadata
extends ORMetadata {
    protected Boolean m_alwaysRefresh;
    protected Boolean m_disableHits;
    protected Boolean m_shared;
    protected String m_isolation;
    protected Boolean m_refreshOnlyIfNewer;
    protected String m_coordinationType;
    protected String m_databaseChangeNotificationType;
    protected String m_type;
    protected Integer m_expiry;
    protected Integer m_size;
    protected TimeOfDayMetadata m_expiryTimeOfDay;

    public CacheMetadata() {
        super("<cache>");
    }

    public CacheMetadata(MetadataAnnotation cache, MetadataAccessor accessor) {
        super(cache, accessor);
        this.m_alwaysRefresh = (Boolean)cache.getAttribute("alwaysRefresh");
        this.m_disableHits = (Boolean)cache.getAttribute("disableHits");
        this.m_coordinationType = (String)cache.getAttribute("coordinationType");
        this.m_databaseChangeNotificationType = (String)cache.getAttribute("databaseChangeNotificationType");
        this.m_expiry = (Integer)cache.getAttribute("expiry");
        MetadataAnnotation expiryTimeOfDay = (MetadataAnnotation)cache.getAttribute("expiryTimeOfDay");
        if (expiryTimeOfDay != null) {
            this.m_expiryTimeOfDay = new TimeOfDayMetadata(expiryTimeOfDay, accessor);
        }
        this.m_shared = (Boolean)cache.getAttribute("shared");
        this.m_isolation = (String)cache.getAttribute("isolation");
        this.m_size = (Integer)cache.getAttribute("size");
        this.m_type = (String)cache.getAttribute("type");
        this.m_refreshOnlyIfNewer = (Boolean)cache.getAttribute("refreshOnlyIfNewer");
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof CacheMetadata) {
            CacheMetadata cache = (CacheMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_alwaysRefresh, cache.getAlwaysRefresh())) {
                return false;
            }
            if (!this.valuesMatch(this.m_disableHits, cache.getDisableHits())) {
                return false;
            }
            if (!this.valuesMatch(this.m_shared, cache.getShared())) {
                return false;
            }
            if (!this.valuesMatch(this.m_isolation, cache.getIsolation())) {
                return false;
            }
            if (!this.valuesMatch(this.m_refreshOnlyIfNewer, cache.getRefreshOnlyIfNewer())) {
                return false;
            }
            if (!this.valuesMatch(this.m_coordinationType, cache.getCoordinationType())) {
                return false;
            }
            if (!this.valuesMatch(this.m_databaseChangeNotificationType, cache.getDatabaseChangeNotificationType())) {
                return false;
            }
            if (!this.valuesMatch(this.m_type, cache.getType())) {
                return false;
            }
            if (!this.valuesMatch(this.m_expiry, cache.getExpiry())) {
                return false;
            }
            if (!this.valuesMatch(this.m_size, cache.getSize())) {
                return false;
            }
            return this.valuesMatch(this.m_expiryTimeOfDay, cache.getExpiryTimeOfDay());
        }
        return false;
    }

    public Boolean getAlwaysRefresh() {
        return this.m_alwaysRefresh;
    }

    public String getCoordinationType() {
        return this.m_coordinationType;
    }

    public Boolean getDisableHits() {
        return this.m_disableHits;
    }

    public Integer getExpiry() {
        return this.m_expiry;
    }

    public TimeOfDayMetadata getExpiryTimeOfDay() {
        return this.m_expiryTimeOfDay;
    }

    public Boolean getRefreshOnlyIfNewer() {
        return this.m_refreshOnlyIfNewer;
    }

    public Boolean getShared() {
        return this.m_shared;
    }

    public String getIsolation() {
        return this.m_isolation;
    }

    public Integer getSize() {
        return this.m_size;
    }

    public String getType() {
        return this.m_type;
    }

    public void process(MetadataDescriptor descriptor, MetadataClass javaClass) {
        descriptor.setHasCache();
        ClassDescriptor classDescriptor = descriptor.getClassDescriptor();
        if (this.m_type != null) {
            if (this.m_type.equals(CacheType.SOFT_WEAK.name())) {
                classDescriptor.useSoftCacheWeakIdentityMap();
            } else if (this.m_type.equals(CacheType.FULL.name())) {
                classDescriptor.getCachePolicy().useFullIdentityMap();
            } else if (this.m_type.equals(CacheType.WEAK.name())) {
                classDescriptor.getCachePolicy().useWeakIdentityMap();
            } else if (this.m_type.equals(CacheType.SOFT.name())) {
                classDescriptor.getCachePolicy().useSoftIdentityMap();
            } else if (this.m_type.equals(CacheType.HARD_WEAK.name())) {
                classDescriptor.getCachePolicy().useHardCacheWeakIdentityMap();
            } else if (this.m_type.equals(CacheType.CACHE.name())) {
                classDescriptor.useCacheIdentityMap();
            } else if (this.m_type.equals(CacheType.NONE.name())) {
                classDescriptor.getCachePolicy().useNoIdentityMap();
            }
        }
        if (this.m_size != null) {
            classDescriptor.getCachePolicy().setIdentityMapSize(this.m_size);
        }
        if (this.m_shared != null && !this.m_shared.booleanValue() || this.m_shared == null && descriptor.getProject().isSharedCacheModeEnableSelective()) {
            classDescriptor.getCachePolicy().setCacheIsolation(CacheIsolationType.ISOLATED);
        }
        if (this.m_isolation != null) {
            classDescriptor.getCachePolicy().setCacheIsolation(CacheIsolationType.valueOf(this.m_isolation));
        }
        if (this.m_expiryTimeOfDay == null) {
            if (this.m_expiry != null && this.m_expiry != -1) {
                classDescriptor.setCacheInvalidationPolicy(new TimeToLiveCacheInvalidationPolicy(this.m_expiry.intValue()));
            }
        } else if (this.m_expiry == null || this.m_expiry == -1) {
            classDescriptor.setCacheInvalidationPolicy(new DailyCacheInvalidationPolicy(this.m_expiryTimeOfDay.processHour(), this.m_expiryTimeOfDay.processMinute(), this.m_expiryTimeOfDay.processSecond(), this.m_expiryTimeOfDay.processMillisecond()));
        } else {
            throw ValidationException.cacheExpiryAndExpiryTimeOfDayBothSpecified(javaClass);
        }
        if (this.m_alwaysRefresh != null) {
            classDescriptor.getCachePolicy().setShouldAlwaysRefreshCache(this.m_alwaysRefresh);
        }
        if (this.m_refreshOnlyIfNewer != null) {
            classDescriptor.getCachePolicy().setShouldOnlyRefreshCacheIfNewerVersion(this.m_refreshOnlyIfNewer);
        }
        if (this.m_disableHits != null) {
            classDescriptor.getCachePolicy().setShouldDisableCacheHits(this.m_disableHits);
        }
        if (this.m_coordinationType != null) {
            if (this.m_coordinationType.equals(CacheCoordinationType.SEND_OBJECT_CHANGES.name())) {
                classDescriptor.getCachePolicy().setCacheSynchronizationType(1);
            } else if (this.m_coordinationType.equals(CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS.name())) {
                classDescriptor.getCachePolicy().setCacheSynchronizationType(2);
            } else if (this.m_coordinationType.equals(CacheCoordinationType.SEND_NEW_OBJECTS_WITH_CHANGES.name())) {
                classDescriptor.getCachePolicy().setCacheSynchronizationType(3);
            } else if (this.m_coordinationType.equals(CacheCoordinationType.NONE.name())) {
                classDescriptor.getCachePolicy().setCacheSynchronizationType(4);
            }
        }
        if (this.m_databaseChangeNotificationType != null) {
            if (this.m_databaseChangeNotificationType.equals(DatabaseChangeNotificationType.NONE.name())) {
                classDescriptor.getCachePolicy().setDatabaseChangeNotificationType(DatabaseChangeNotificationType.NONE);
            } else if (this.m_databaseChangeNotificationType.equals(DatabaseChangeNotificationType.INVALIDATE.name())) {
                classDescriptor.getCachePolicy().setDatabaseChangeNotificationType(DatabaseChangeNotificationType.INVALIDATE);
            }
        }
    }

    public void setAlwaysRefresh(Boolean alwaysRefresh) {
        this.m_alwaysRefresh = alwaysRefresh;
    }

    public void setCoordinationType(String coordinationType) {
        this.m_coordinationType = coordinationType;
    }

    public String getDatabaseChangeNotificationType() {
        return this.m_databaseChangeNotificationType;
    }

    public void setDatabaseChangeNotificationType(String databaseChangeNotificationType) {
        this.m_databaseChangeNotificationType = databaseChangeNotificationType;
    }

    public void setDisableHits(Boolean disableHits) {
        this.m_disableHits = disableHits;
    }

    public void setExpiry(Integer expiry) {
        this.m_expiry = expiry;
    }

    public void setExpiryTimeOfDay(TimeOfDayMetadata expiryTimeOfDay) {
        this.m_expiryTimeOfDay = expiryTimeOfDay;
    }

    public void setRefreshOnlyIfNewer(Boolean refreshOnlyIfNewer) {
        this.m_refreshOnlyIfNewer = refreshOnlyIfNewer;
    }

    public void setShared(Boolean shared) {
        this.m_shared = shared;
    }

    public void setIsolation(String isolation) {
        this.m_isolation = isolation;
    }

    public void setSize(Integer size) {
        this.m_size = size;
    }

    public void setType(String type2) {
        this.m_type = type2;
    }
}

