/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.objects;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataFactory;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.libraries.asm.AnnotationVisitor;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.FieldVisitor;
import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.commons.EmptyVisitor;

public class MetadataAsmFactory
extends MetadataFactory {
    public static final String PRIMITIVES = "VJIBZCSFD";
    public static final String TOKENS = "()<>;";

    public MetadataAsmFactory(MetadataLogger logger2, ClassLoader loader) {
        super(logger2, loader);
        this.addMetadataClass("I", new MetadataClass((MetadataFactory)this, Integer.TYPE));
        this.addMetadataClass("J", new MetadataClass((MetadataFactory)this, Long.TYPE));
        this.addMetadataClass("S", new MetadataClass((MetadataFactory)this, Short.TYPE));
        this.addMetadataClass("Z", new MetadataClass((MetadataFactory)this, Boolean.TYPE));
        this.addMetadataClass("F", new MetadataClass((MetadataFactory)this, Float.TYPE));
        this.addMetadataClass("D", new MetadataClass((MetadataFactory)this, Double.TYPE));
        this.addMetadataClass("C", new MetadataClass((MetadataFactory)this, Character.TYPE));
        this.addMetadataClass("B", new MetadataClass((MetadataFactory)this, Byte.TYPE));
    }

    protected void buildClassMetadata(MetadataClass metadataClass, String className, boolean isLazy) {
        block20: {
            InputStream stream;
            block17: {
                ClassMetadataVisitor visitor = new ClassMetadataVisitor(metadataClass, isLazy);
                stream = null;
                try {
                    block19: {
                        block18: {
                            try {
                                String resourceString = String.valueOf(className.replace('.', '/')) + ".class";
                                stream = this.m_loader.getResourceAsStream(resourceString);
                                ClassReader reader = new ClassReader(stream);
                                Attribute[] attributes = new Attribute[]{};
                                reader.accept(visitor, attributes, 7);
                                break block17;
                            }
                            catch (Exception exception) {
                                metadataClass = new MetadataClass(this, className, false);
                                if (className.length() <= 5 || !className.substring(0, 5).equals("java.")) break block18;
                                try {
                                    Class<?> reflectClass = Class.forName(className);
                                    if (reflectClass.getSuperclass() != null) {
                                        metadataClass.setSuperclassName(reflectClass.getSuperclass().getName());
                                    }
                                    Class<?>[] classArray = reflectClass.getInterfaces();
                                    int n = classArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        Class<?> reflectInterface = classArray[n2];
                                        metadataClass.addInterface(reflectInterface.getName());
                                        ++n2;
                                    }
                                    break block19;
                                }
                                catch (Exception exception2) {
                                    metadataClass.setIsAccessible(false);
                                }
                                break block19;
                            }
                        }
                        metadataClass.setIsAccessible(false);
                    }
                    this.addMetadataClass(metadataClass);
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    break block20;
                }
                catch (IOException iOException) {}
                break block20;
            }
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public MetadataClass getMetadataClass(String className) {
        return this.getMetadataClass(className, false);
    }

    @Override
    public MetadataClass getMetadataClass(String className, boolean isLazy) {
        if (className == null) {
            return null;
        }
        MetadataClass metaClass = (MetadataClass)this.m_metadataClasses.get(className);
        if (metaClass == null || !isLazy && metaClass.isLazy()) {
            if (metaClass != null) {
                metaClass.setIsLazy(false);
            }
            this.buildClassMetadata(metaClass, className, isLazy);
            metaClass = (MetadataClass)this.m_metadataClasses.get(className);
        }
        return metaClass;
    }

    @Override
    public void resolveGenericTypes(MetadataClass child, List<String> genericTypes, MetadataClass parent, MetadataDescriptor descriptor) {
        List<String> parentGenericTypes;
        if (genericTypes != null && (parentGenericTypes = parent.getGenericType()) != null) {
            ArrayList<String> genericParentTemp = new ArrayList<String>(genericTypes);
            genericParentTemp.removeAll(child.getInterfaces());
            int size = genericParentTemp.size();
            int parentIndex = 0;
            int index = genericTypes.indexOf(parent.getName()) + 1;
            while (index < size) {
                String actualTypeArgument = genericTypes.get(index);
                if (parentIndex >= parentGenericTypes.size()) break;
                String variable = parentGenericTypes.get(parentIndex);
                parentIndex += 3;
                if (actualTypeArgument.length() == 1) {
                    actualTypeArgument = genericTypes.get(++index);
                    descriptor.addGenericType(variable, descriptor.getGenericType(actualTypeArgument));
                } else {
                    descriptor.addGenericType(variable, actualTypeArgument);
                }
                ++index;
            }
        }
    }

    private static List<String> processDescription(String desc, boolean isGeneric) {
        if (desc == null) {
            return null;
        }
        ArrayList<String> arguments = new ArrayList<String>();
        int index = 0;
        int length = desc.length();
        boolean isGenericTyped = false;
        char[] chars = desc.toCharArray();
        while (index < length) {
            char next = chars[index];
            if ('(' != next && ')' != next && '<' != next && '>' != next && ';' != next) {
                int start;
                if (next == 'L') {
                    start = ++index;
                    next = chars[index];
                    while ('(' != next && ')' != next && '<' != next && '>' != next && ';' != next) {
                        next = chars[++index];
                    }
                    arguments.add(MetadataAsmFactory.toClassName(desc.substring(start, index)));
                    if (isGenericTyped) {
                        isGenericTyped = false;
                        if (next == '<') {
                            int cnt = 1;
                            while (cnt > 0 && ++index < desc.length()) {
                                switch (desc.charAt(index)) {
                                    case '<': {
                                        ++cnt;
                                        break;
                                    }
                                    case '>': {
                                        --cnt;
                                    }
                                }
                            }
                        }
                    }
                } else if (!isGeneric && PRIMITIVES.indexOf(next) != -1) {
                    arguments.add(MetadataAsmFactory.getPrimitiveName(next));
                } else if (next == '[') {
                    start = index++;
                    next = chars[index];
                    while (next == '[') {
                        next = chars[++index];
                    }
                    if (PRIMITIVES.indexOf(next) == -1) {
                        while (next != ';') {
                            next = chars[++index];
                        }
                        arguments.add(MetadataAsmFactory.toClassName(desc.substring(start, index + 1)));
                    } else {
                        arguments.add(desc.substring(start, index + 1));
                    }
                } else {
                    int end = start = index;
                    char myNext = next;
                    while (':' != myNext && '(' != myNext && ')' != myNext && '<' != myNext && '>' != myNext && ';' != myNext && end < length - 1) {
                        myNext = chars[++end];
                    }
                    if (myNext == ':') {
                        arguments.add(desc.substring(start, end));
                        isGenericTyped = true;
                        index = end;
                        arguments.add(":");
                        if (desc.charAt(index + 1) == ':') {
                            ++index;
                        }
                    } else if (myNext == ';' && next == 'T') {
                        arguments.add(new String(new char[]{next}));
                        arguments.add(desc.substring(start + 1, end));
                        index = end - 1;
                    } else {
                        arguments.add(new String(new char[]{next}));
                    }
                }
            }
            ++index;
        }
        return arguments;
    }

    private static String getPrimitiveName(char primitive) {
        if (primitive == 'V') {
            return "void";
        }
        if (primitive == 'I') {
            return "int";
        }
        if (primitive == 'Z') {
            return "boolean";
        }
        if (primitive == 'J') {
            return "long";
        }
        if (primitive == 'F') {
            return "float";
        }
        if (primitive == 'D') {
            return "double";
        }
        if (primitive == 'B') {
            return "byte";
        }
        if (primitive == 'C') {
            return "char";
        }
        if (primitive == 'S') {
            return "short";
        }
        return new String(new char[]{primitive});
    }

    private static String toClassName(String classDescription) {
        if (classDescription == null) {
            return "void";
        }
        return classDescription.replace('/', '.');
    }

    private static Object annotationValue(String description, Object value) {
        if (value instanceof Type) {
            return ((Type)value).getClassName();
        }
        return value;
    }

    public class ClassMetadataVisitor
    implements ClassVisitor {
        private boolean isLazy;
        private boolean processedMemeber;
        private MetadataClass classMetadata;

        ClassMetadataVisitor(MetadataClass metadataClass, boolean isLazy) {
            this.isLazy = isLazy;
            this.classMetadata = metadataClass;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            String className = MetadataAsmFactory.toClassName(name);
            if (this.classMetadata == null || !this.classMetadata.getName().equals(className)) {
                this.classMetadata = new MetadataClass(MetadataAsmFactory.this, className, this.isLazy);
                MetadataAsmFactory.this.addMetadataClass(this.classMetadata);
            }
            this.classMetadata.setName(className);
            this.classMetadata.setSuperclassName(MetadataAsmFactory.toClassName(superName));
            this.classMetadata.setModifiers(access);
            this.classMetadata.setGenericType(MetadataAsmFactory.processDescription(signature, true));
            String[] stringArray = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                String interfaceName = stringArray[n2];
                this.classMetadata.addInterface(MetadataAsmFactory.toClassName(interfaceName));
                ++n2;
            }
        }

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            this.processedMemeber = true;
            if (this.classMetadata.isLazy()) {
                return null;
            }
            return new MetadataFieldVisitor(this.classMetadata, access, name, desc, signature, value);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            this.processedMemeber = true;
            if (this.classMetadata.isLazy() || name.indexOf("init>") != -1) {
                return null;
            }
            return new MetadataMethodVisitor(this.classMetadata, access, name, signature, desc, exceptions);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (desc.startsWith("Ljavax/persistence") || desc.startsWith("Lorg/eclipse/persistence")) {
                if (!this.processedMemeber && this.classMetadata.isLazy()) {
                    this.classMetadata.setIsLazy(false);
                }
                return new MetadataAnnotationVisitor(this.classMetadata, desc);
            }
            return null;
        }

        @Override
        public void visitAttribute(Attribute attr) {
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void visitSource(String source, String debug) {
        }

        @Override
        public void visitOuterClass(String owner, String name, String desc) {
        }
    }

    class MetadataAnnotationArrayVisitor
    implements AnnotationVisitor {
        private MetadataAnnotation annotation;
        private String attributeName;
        private List<Object> values;

        public MetadataAnnotationArrayVisitor(MetadataAnnotation annotation, String name) {
            this.annotation = annotation;
            this.attributeName = name;
            this.values = new ArrayList<Object>();
        }

        @Override
        public void visit(String name, Object value) {
            this.values.add(MetadataAsmFactory.annotationValue(null, value));
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            this.values.add(MetadataAsmFactory.annotationValue(desc, value));
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            MetadataAnnotation mda = new MetadataAnnotation();
            mda.setName((String)MetadataAsmFactory.processDescription(desc, false).get(0));
            this.values.add(mda);
            return new MetadataAnnotationVisitor(mda);
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            return null;
        }

        @Override
        public void visitEnd() {
            this.annotation.addAttribute(this.attributeName, this.values.toArray());
        }
    }

    class MetadataAnnotationVisitor
    implements AnnotationVisitor {
        private MetadataAnnotatedElement element;
        private MetadataAnnotation annotation;

        MetadataAnnotationVisitor(MetadataAnnotatedElement element, String name) {
            this.element = element;
            this.annotation = new MetadataAnnotation();
            this.annotation.setName((String)MetadataAsmFactory.processDescription(name, false).get(0));
        }

        public MetadataAnnotationVisitor(MetadataAnnotation annotation) {
            this.annotation = annotation;
        }

        @Override
        public void visit(String name, Object value) {
            this.annotation.addAttribute(name, MetadataAsmFactory.annotationValue(null, value));
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            this.annotation.addAttribute(name, MetadataAsmFactory.annotationValue(desc, value));
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            MetadataAnnotation mda = new MetadataAnnotation();
            mda.setName((String)MetadataAsmFactory.processDescription(desc, false).get(0));
            this.annotation.addAttribute(name, mda);
            return new MetadataAnnotationVisitor(mda);
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            return new MetadataAnnotationArrayVisitor(this.annotation, name);
        }

        @Override
        public void visitEnd() {
            if (this.element != null) {
                this.element.addAnnotation(this.annotation);
            }
        }
    }

    class MetadataFieldVisitor
    implements FieldVisitor {
        private MetadataField field;

        public MetadataFieldVisitor(MetadataClass classMetadata, int access, String name, String desc, String signature, Object value) {
            this.field = new MetadataField(classMetadata);
            this.field.setModifiers(access);
            this.field.setName(name);
            this.field.setAttributeName(name);
            this.field.setGenericType(MetadataAsmFactory.processDescription(signature, true));
            this.field.setType((String)MetadataAsmFactory.processDescription(desc, false).get(0));
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (desc.startsWith("Ljavax/persistence") || desc.startsWith("Lorg/eclipse/persistence")) {
                return new MetadataAnnotationVisitor(this.field, desc);
            }
            return null;
        }

        @Override
        public void visitAttribute(Attribute attr) {
        }

        @Override
        public void visitEnd() {
            this.field.getDeclaringClass().addField(this.field);
        }
    }

    class MetadataMethodVisitor
    extends EmptyVisitor {
        private MetadataMethod method;

        public MetadataMethodVisitor(MetadataClass classMetadata, int access, String name, String desc, String signature, String[] exceptions) {
            this.method = new MetadataMethod(MetadataAsmFactory.this, classMetadata);
            this.method.setName(name);
            this.method.setAttributeName(Helper.getAttributeNameFromMethodName(name));
            this.method.setModifiers(access);
            this.method.setGenericType(MetadataAsmFactory.processDescription(desc, true));
            List argumentNames = MetadataAsmFactory.processDescription(signature, false);
            if (argumentNames != null && !argumentNames.isEmpty()) {
                this.method.setReturnType((String)argumentNames.get(argumentNames.size() - 1));
                argumentNames.remove(argumentNames.size() - 1);
                this.method.setParameters(argumentNames);
            }
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (desc.startsWith("Ljavax/persistence") || desc.startsWith("Lorg/eclipse/persistence")) {
                return new MetadataAnnotationVisitor(this.method, desc);
            }
            return null;
        }

        @Override
        public AnnotationVisitor visitAnnotationDefault() {
            return null;
        }

        @Override
        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            return null;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return null;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void visitEnd() {
            block1: {
                classMetadata = this.method.getMetadataClass();
                existing = classMetadata.getMethods().get(this.method.getName());
                if (existing != null) ** GOTO lbl8
                classMetadata.getMethods().put(this.method.getName(), this.method);
                break block1;
lbl-1000:
                // 1 sources

                {
                    existing = existing.getNext();
lbl8:
                    // 2 sources

                    ** while (existing.getNext() != null)
                }
lbl9:
                // 1 sources

                existing.setNext(this.method);
            }
        }
    }
}

