/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.namespace.QName;
import org.eclipse.persistence.core.mappings.converters.CoreConverter;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataHelper;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.mappings.BinaryDataMapping;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredMethods;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverterAdapter;
import org.eclipse.persistence.sessions.Session;

public class XMLJavaTypeConverter
extends XMLConverterAdapter {
    protected Class boundType = Object.class;
    protected Class valueType = Object.class;
    protected Class xmlAdapterClass;
    protected String xmlAdapterClassName;
    protected XmlAdapter xmlAdapter;
    protected QName schemaType;
    protected DatabaseMapping mapping;
    protected CoreConverter nestedConverter;

    public XMLJavaTypeConverter() {
    }

    public XMLJavaTypeConverter(Class xmlAdapterClass) {
        this.setXmlAdapterClass(xmlAdapterClass);
    }

    public XMLJavaTypeConverter(String xmlAdapterClassName) {
        this.xmlAdapterClassName = xmlAdapterClassName;
    }

    public XMLJavaTypeConverter(Class xmlAdapterClass, QName schemaType) {
        this.setSchemaType(schemaType);
        this.setXmlAdapterClass(xmlAdapterClass);
    }

    public XMLJavaTypeConverter(String xmlAdapterClassName, QName schemaType) {
        this.setSchemaType(schemaType);
        this.setXmlAdapterClassName(xmlAdapterClassName);
    }

    @Override
    public Object convertDataValueToObjectValue(Object dataValue, Session session, XMLUnmarshaller unmarshaller) {
        try {
            XmlAdapter runtimeAdapter;
            HashMap adapters;
            XmlAdapter adapter = this.xmlAdapter;
            if (unmarshaller != null && (adapters = (HashMap)unmarshaller.getProperty("xml-javatype-adapters")) != null && (runtimeAdapter = (XmlAdapter)adapters.get(this.xmlAdapterClass)) != null) {
                adapter = runtimeAdapter;
            }
            Object toConvert = dataValue;
            if (this.nestedConverter != null) {
                toConvert = this.nestedConverter.convertDataValueToObjectValue(toConvert, session);
            } else if (dataValue != null && dataValue.getClass() != this.valueType) {
                toConvert = this.mapping instanceof BinaryDataMapping ? XMLBinaryDataHelper.getXMLBinaryDataHelper().convertObject(dataValue, this.valueType, (AbstractSession)session) : (this.getSchemaType() != null ? ((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(dataValue, this.valueType, this.getSchemaType()) : session.getDatasourcePlatform().getConversionManager().convertObject(dataValue, this.valueType));
            }
            return adapter.unmarshal(toConvert);
        }
        catch (Exception ex) {
            throw ConversionException.couldNotBeConverted(dataValue, this.boundType, ex);
        }
    }

    @Override
    public Object convertObjectValueToDataValue(Object objectValue, Session session, XMLMarshaller marshaller) {
        try {
            XmlAdapter runtimeAdapter;
            HashMap adapters;
            XmlAdapter adapter = this.xmlAdapter;
            if (marshaller != null && (adapters = (HashMap)marshaller.getProperty("xml-javatype-adapters")) != null && (runtimeAdapter = (XmlAdapter)adapters.get(this.xmlAdapterClass)) != null) {
                adapter = runtimeAdapter;
            }
            Object dataValue = adapter.marshal(objectValue);
            if (this.nestedConverter != null) {
                dataValue = this.nestedConverter.convertObjectValueToDataValue(dataValue, session);
            }
            return dataValue;
        }
        catch (Exception ex) {
            throw ConversionException.couldNotBeConverted(objectValue, this.valueType, ex);
        }
    }

    public QName getSchemaType() {
        return this.schemaType;
    }

    public Class getXmlAdapterClass() {
        return this.xmlAdapterClass;
    }

    public String getXmlAdapterClassName() {
        if (this.xmlAdapterClassName == null) {
            this.xmlAdapterClassName = "";
        }
        return this.xmlAdapterClassName;
    }

    @Override
    public void initialize(DatabaseMapping mapping, Session session) {
        ClassLoader loader = session.getDatasourceLogin().getDatasourcePlatform().getConversionManager().getLoader();
        if (this.xmlAdapterClass == null) {
            try {
                this.xmlAdapterClass = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getXmlAdapterClassName(), true, loader)) : PrivilegedAccessHelper.getClassForName(this.getXmlAdapterClassName(), true, loader);
            }
            catch (Exception e) {
                throw JAXBException.adapterClassNotLoaded(this.getXmlAdapterClassName(), e);
            }
        }
        if (!XmlAdapter.class.isAssignableFrom(this.xmlAdapterClass)) {
            throw JAXBException.invalidAdapterClass(this.getXmlAdapterClassName());
        }
        this.mapping = mapping;
        Method[] methods = null;
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                methods = (Method[])AccessController.doPrivileged(new PrivilegedGetDeclaredMethods(this.xmlAdapterClass));
            }
            catch (PrivilegedActionException ex) {
                throw JAXBException.adapterClassMethodsCouldNotBeAccessed(this.getXmlAdapterClassName(), ex);
            }
        } else {
            methods = PrivilegedAccessHelper.getDeclaredMethods(this.xmlAdapterClass);
        }
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (method.getName().equals("marshal") && PrivilegedAccessHelper.getMethodReturnType(method) != Object.class && method.getParameterTypes()[0] != Object.class) {
                this.valueType = method.getReturnType();
                this.boundType = method.getParameterTypes()[0];
                break;
            }
            ++i;
        }
        try {
            this.xmlAdapter = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (XmlAdapter)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(this.getXmlAdapterClass())) : (XmlAdapter)PrivilegedAccessHelper.newInstanceFromClass(this.getXmlAdapterClass());
        }
        catch (Exception ex) {
            throw JAXBException.adapterClassCouldNotBeInstantiated(this.getXmlAdapterClassName(), ex);
        }
        if (this.nestedConverter != null) {
            if (this.nestedConverter instanceof ObjectTypeConverter) {
                ((ObjectTypeConverter)this.nestedConverter).convertClassNamesToClasses(loader);
            }
            this.nestedConverter.initialize(mapping, session);
        }
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    public void setSchemaType(QName qname) {
        this.schemaType = qname;
    }

    public void setXmlAdapterClass(Class xmlAdapterClass) {
        this.xmlAdapterClass = xmlAdapterClass;
    }

    public void setXmlAdapterClassName(String xmlAdapterClassName) {
        this.xmlAdapterClassName = xmlAdapterClassName;
    }

    public CoreConverter getNestedConverter() {
        return this.nestedConverter;
    }

    public void setNestedConverter(CoreConverter nestedConverter) {
        this.nestedConverter = nestedConverter;
    }
}

