/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.FunctorException;
import org.apache.commons.collections.functors.ConstantFactory;
import org.apache.commons.collections.functors.InstantiateFactory;

public class PrototypeFactory {
    public static Factory getInstance(Object prototype) {
        if (prototype == null) {
            return ConstantFactory.NULL_INSTANCE;
        }
        try {
            Method method = prototype.getClass().getMethod("clone", null);
            return new PrototypeCloneFactory(prototype, method);
        }
        catch (NoSuchMethodException ex) {
            try {
                prototype.getClass().getConstructor(prototype.getClass());
                return new InstantiateFactory(prototype.getClass(), new Class[]{prototype.getClass()}, new Object[]{prototype});
            }
            catch (NoSuchMethodException ex2) {
                if (prototype instanceof Serializable) {
                    return new PrototypeSerializationFactory((Serializable)prototype);
                }
                throw new IllegalArgumentException("The prototype must be cloneable via a public clone method");
            }
        }
    }

    private PrototypeFactory() {
    }

    static class PrototypeCloneFactory
    implements Factory,
    Serializable {
        static final long serialVersionUID = 5604271422565175555L;
        private final Object iPrototype;
        private transient Method iCloneMethod;

        private PrototypeCloneFactory(Object prototype, Method method) {
            this.iPrototype = prototype;
            this.iCloneMethod = method;
        }

        private void findCloneMethod() {
            try {
                this.iCloneMethod = this.iPrototype.getClass().getMethod("clone", null);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalArgumentException("PrototypeCloneFactory: The clone method must exist and be public ");
            }
        }

        public Object create() {
            if (this.iCloneMethod == null) {
                this.findCloneMethod();
            }
            try {
                return this.iCloneMethod.invoke(this.iPrototype, null);
            }
            catch (IllegalAccessException ex) {
                throw new FunctorException("PrototypeCloneFactory: Clone method must be public", ex);
            }
            catch (InvocationTargetException ex) {
                throw new FunctorException("PrototypeCloneFactory: Clone method threw an exception", ex);
            }
        }
    }

    static class PrototypeSerializationFactory
    implements Factory,
    Serializable {
        static final long serialVersionUID = -8704966966139178833L;
        private final Serializable iPrototype;

        private PrototypeSerializationFactory(Serializable prototype) {
            this.iPrototype = prototype;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object create() {
            block15: {
                baos = new ByteArrayOutputStream(512);
                bais = null;
                try {
                    try {
                        out = new ObjectOutputStream(baos);
                        out.writeObject(this.iPrototype);
                        bais = new ByteArrayInputStream(baos.toByteArray());
                        in = new ObjectInputStream(bais);
                        var5_7 = in.readObject();
                        var7_8 = null;
                    }
                    catch (ClassNotFoundException ex) {
                        throw new FunctorException(ex);
                    }
                    catch (IOException ex) {
                        throw new FunctorException(ex);
                    }
                }
                catch (Throwable var6_12) {
                    var7_9 = null;
                    try {
                        if (bais != null) {
                            bais.close();
                        }
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    try {
                        if (baos == null) throw var6_12;
                        baos.close();
                        throw var6_12;
                    }
                    catch (IOException ex) {
                        throw var6_12;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [3 : 97->108)] { 
lbl35:
                // 1 sources

                if (bais != null) {
                    bais.close();
                }
                break block15;
lbl38:
                // 1 sources

                catch (IOException ex) {
                    // empty catch block
                }
            }
            ** try [egrp 3[TRYBLOCK] [4 : 110->121)] { 
lbl42:
            // 1 sources

            if (baos == null) return var5_7;
            baos.close();
            return var5_7;
lbl45:
            // 1 sources

            catch (IOException ex) {
                // empty catch block
            }
            return var5_7;
        }
    }
}

