/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import org.apache.catalina.util.HexUtils;
import org.apache.naming.Util;
import org.glassfish.grizzly.http.util.ByteChunk;
import org.glassfish.grizzly.utils.Charsets;

public final class RequestUtil {
    private static final String SESSION_VERSION_SEPARATOR = ":";

    public static String encodeCookie(Cookie cookie) {
        StringBuilder buf = new StringBuilder(cookie.getName());
        buf.append("=");
        buf.append(cookie.getValue());
        if (cookie.getComment() != null) {
            buf.append("; Comment=\"");
            buf.append(cookie.getComment());
            buf.append("\"");
        }
        if (cookie.getDomain() != null) {
            buf.append("; Domain=\"");
            buf.append(cookie.getDomain());
            buf.append("\"");
        }
        if (cookie.getMaxAge() >= 0) {
            buf.append("; Max-Age=\"");
            buf.append(cookie.getMaxAge());
            buf.append("\"");
        }
        if (cookie.getPath() != null) {
            buf.append("; Path=\"");
            buf.append(cookie.getPath());
            buf.append("\"");
        }
        if (cookie.getSecure()) {
            buf.append("; Secure");
        }
        if (cookie.getVersion() > 0) {
            buf.append("; Version=\"");
            buf.append(cookie.getVersion());
            buf.append("\"");
        }
        return buf.toString();
    }

    public static String filter(String message) {
        if (message == null) {
            return null;
        }
        char[] content = new char[message.length()];
        message.getChars(0, message.length(), content, 0);
        StringBuilder result = new StringBuilder(content.length + 50);
        block6: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    result.append(content[i]);
                }
            }
        }
        return result.toString();
    }

    public static String normalize(String path) {
        return RequestUtil.normalize(path, true);
    }

    public static String normalize(String path, boolean replaceBackSlash) {
        return Util.normalize(path, replaceBackSlash);
    }

    public static String parseCharacterEncoding(String contentType) {
        if (contentType == null) {
            return null;
        }
        int start = contentType.indexOf("charset=");
        if (start < 0) {
            return null;
        }
        String encoding = contentType.substring(start + 8);
        int end = encoding.indexOf(59);
        if (end >= 0) {
            encoding = encoding.substring(0, end);
        }
        if ((encoding = encoding.trim()).length() > 2 && encoding.startsWith("\"") && encoding.endsWith("\"")) {
            encoding = encoding.substring(1, encoding.length() - 1);
        }
        return encoding.trim();
    }

    public static Cookie[] parseCookieHeader(String header) {
        if (header == null || header.length() < 1) {
            return new Cookie[0];
        }
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        while (header.length() > 0) {
            int semicolon = header.indexOf(59);
            if (semicolon < 0) {
                semicolon = header.length();
            }
            if (semicolon == 0) break;
            String token = header.substring(0, semicolon);
            header = semicolon < header.length() ? header.substring(semicolon + 1) : "";
            try {
                int equals = token.indexOf(61);
                if (equals <= 0) continue;
                String name = token.substring(0, equals).trim();
                String value = token.substring(equals + 1).trim();
                cookies.add(new Cookie(name, value));
            }
            catch (Throwable e) {}
        }
        return cookies.toArray(new Cookie[cookies.size()]);
    }

    public static void parseParameters(Map<String, String[]> map, String data, String encoding) throws UnsupportedEncodingException {
        if (data != null && data.length() > 0) {
            byte[] bytes = null;
            try {
                bytes = encoding == null ? data.getBytes(Charset.defaultCharset()) : data.getBytes(Charsets.lookupCharset(encoding));
            }
            catch (UnsupportedCharsetException uee) {
                // empty catch block
            }
            RequestUtil.parseParameters(map, bytes, encoding);
        }
    }

    public static String urlDecode(String str) {
        return Util.urlDecode(str);
    }

    public static String urlDecode(String str, String enc) {
        return Util.urlDecode(str, enc);
    }

    public static String urlDecode(byte[] bytes) {
        return Util.urlDecode(bytes);
    }

    public static String urlDecode(byte[] bytes, String enc) {
        return Util.urlDecode(bytes, enc);
    }

    public static String urlDecode(ByteChunk bc, boolean toString) {
        if (bc == null) {
            return null;
        }
        byte[] bytes = bc.getBytes();
        if (bytes == null) {
            return null;
        }
        int ix = bc.getStart();
        int end = bc.getEnd();
        int ox = ix;
        while (ix < end) {
            int b;
            if ((b = bytes[ix++]) == 43) {
                b = 32;
            } else if (b == 37) {
                b = (byte)((Util.convertHexDigit(bytes[ix++]) << 4) + Util.convertHexDigit(bytes[ix++]));
            }
            bytes[ox++] = b;
        }
        bc.setEnd(ox);
        if (toString) {
            return bc.toString();
        }
        return null;
    }

    private static void putMapEntry(Map<String, String[]> map, String name, String value) {
        String[] newValues = null;
        String[] oldValues = map.get(name);
        if (oldValues == null) {
            newValues = new String[]{value};
        } else {
            newValues = new String[oldValues.length + 1];
            System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
            newValues[oldValues.length] = value;
        }
        map.put(name, newValues);
    }

    public static void parseParameters(Map<String, String[]> map, byte[] data, String encoding) throws UnsupportedEncodingException {
        if (data != null && data.length > 0) {
            boolean pos = false;
            int ix = 0;
            int ox = 0;
            String key = null;
            String value = null;
            block6: while (ix < data.length) {
                byte c = data[ix++];
                switch ((char)c) {
                    case '&': {
                        value = new String(data, 0, ox, Charsets.lookupCharset(encoding));
                        if (key != null) {
                            RequestUtil.putMapEntry(map, key, value);
                            key = null;
                        }
                        ox = 0;
                        continue block6;
                    }
                    case '=': {
                        if (key == null) {
                            key = new String(data, 0, ox, Charsets.lookupCharset(encoding));
                            ox = 0;
                            continue block6;
                        }
                        data[ox++] = c;
                        continue block6;
                    }
                    case '+': {
                        data[ox++] = 32;
                        continue block6;
                    }
                    case '%': {
                        data[ox++] = (byte)((Util.convertHexDigit(data[ix++]) << 4) + Util.convertHexDigit(data[ix++]));
                        continue block6;
                    }
                }
                data[ox++] = c;
            }
            if (key != null) {
                value = new String(data, 0, ox, Charsets.lookupCharset(encoding));
                RequestUtil.putMapEntry(map, key, value);
            }
        }
    }

    public static final HashMap<String, String> parseSessionVersionString(String sessionVersion) {
        if (sessionVersion == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(sessionVersion, SESSION_VERSION_SEPARATOR);
        HashMap<String, String> result = new HashMap<String, String>(st.countTokens());
        while (st.hasMoreTokens()) {
            String hexPath = st.nextToken();
            if (!st.hasMoreTokens()) continue;
            try {
                String contextPath = new String(HexUtils.convert(hexPath), Charsets.UTF8_CHARSET);
                result.put(contextPath, st.nextToken());
            }
            catch (UnsupportedCharsetException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        return result;
    }

    public static String createSessionVersionString(Map<String, String> sessionVersions) {
        if (sessionVersions == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> e : sessionVersions.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(':');
            }
            String contextPath = e.getKey();
            try {
                sb.append(new String(HexUtils.convert(contextPath.getBytes(Charsets.UTF8_CHARSET))));
            }
            catch (UnsupportedCharsetException ex) {
                throw new IllegalArgumentException(ex);
            }
            sb.append(SESSION_VERSION_SEPARATOR);
            sb.append(e.getValue());
        }
        return sb.toString();
    }

    public static Charset lookupCharset(String enc) throws UnsupportedEncodingException {
        Charset charset = null;
        Throwable throwable = null;
        try {
            charset = Charsets.lookupCharset(enc);
        }
        catch (Throwable t) {
            throwable = t;
        }
        if (charset == null) {
            UnsupportedEncodingException uee = new UnsupportedEncodingException();
            if (throwable != null) {
                uee.initCause(throwable);
            }
            throw uee;
        }
        return charset;
    }
}

