/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.util.ResourceBundle;
import org.apache.catalina.core.StandardServer;

public final class HexUtils {
    private static final ResourceBundle rb = StandardServer.log.getResourceBundle();
    public static final String ODD_NUMBER_HEX_DIGITS_EXCEPTION = "AS-WEB-CORE-00828";
    public static final String BAD_HEX_DIGIT_EXCEPTION = "AS-WEB-CORE-00829";
    static final int[] DEC = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    public static byte[] convert(String digits) {
        int length = digits.length();
        if (length % 2 != 0) {
            throw new IllegalArgumentException(rb.getString(ODD_NUMBER_HEX_DIGITS_EXCEPTION));
        }
        int bLength = length / 2;
        byte[] bytes = new byte[bLength];
        for (int i = 0; i < bLength; ++i) {
            char c1 = digits.charAt(2 * i);
            char c2 = digits.charAt(2 * i + 1);
            int b = 0;
            if (c1 >= '0' && c1 <= '9') {
                b = (byte)(b + (c1 - 48) * 16);
            } else if (c1 >= 'a' && c1 <= 'f') {
                b = (byte)(b + (c1 - 97 + 10) * 16);
            } else if (c1 >= 'A' && c1 <= 'F') {
                b = (byte)(b + (c1 - 65 + 10) * 16);
            } else {
                throw new IllegalArgumentException(rb.getString(BAD_HEX_DIGIT_EXCEPTION));
            }
            if (c2 >= '0' && c2 <= '9') {
                b = (byte)(b + (c2 - 48));
            } else if (c2 >= 'a' && c2 <= 'f') {
                b = (byte)(b + (c2 - 97 + 10));
            } else if (c2 >= 'A' && c2 <= 'F') {
                b = (byte)(b + (c2 - 65 + 10));
            } else {
                throw new IllegalArgumentException(rb.getString(BAD_HEX_DIGIT_EXCEPTION));
            }
            bytes[i] = b;
        }
        return bytes;
    }

    public static char[] convert(byte[] bytes) {
        char[] arr = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            arr[2 * i] = HexUtils.convertDigit(bytes[i] >> 4);
            arr[2 * i + 1] = HexUtils.convertDigit(bytes[i] & 0xF);
        }
        return arr;
    }

    public static int convert2Int(byte[] hex) {
        if (hex.length < 4) {
            return 0;
        }
        if (DEC[hex[0]] < 0) {
            throw new IllegalArgumentException(rb.getString(BAD_HEX_DIGIT_EXCEPTION));
        }
        int len = DEC[hex[0]];
        len <<= 4;
        if (DEC[hex[1]] < 0) {
            throw new IllegalArgumentException(rb.getString(BAD_HEX_DIGIT_EXCEPTION));
        }
        len += DEC[hex[1]];
        len <<= 4;
        if (DEC[hex[2]] < 0) {
            throw new IllegalArgumentException(rb.getString(BAD_HEX_DIGIT_EXCEPTION));
        }
        len += DEC[hex[2]];
        len <<= 4;
        if (DEC[hex[3]] < 0) {
            throw new IllegalArgumentException(rb.getString(BAD_HEX_DIGIT_EXCEPTION));
        }
        return len += DEC[hex[3]];
    }

    private static char convertDigit(int value) {
        if ((value &= 0xF) >= 10) {
            return (char)(value - 10 + 97);
        }
        return (char)(value + 48);
    }
}

