/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Deployer;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.startup.ExpandWar;
import org.apache.naming.resources.ResourceAttributes;

public class HostConfig
implements LifecycleListener {
    private static final java.util.logging.Logger log = StandardServer.log;
    private static final ResourceBundle rb = log.getResourceBundle();
    public static final String LIFECYCLE_OBJECT_NOT_HOST_EXCEPTION = "AS-WEB-CORE-00770";
    public static final String DEPLOYING_CONFIG_DESCRIPTOR = "AS-WEB-CORE-00771";
    public static final String ERROR_DEPLOYING_CONFIG_DESCRIPTOR_EXCEPTION = "AS-WEB-CORE-00772";
    public static final String INVALID_WAR_NAME_EXCEPTION = "AS-WEB-CORE-00773";
    public static final String EXPANDING_WEB_APP = "AS-WEB-CORE-00774";
    public static final String EXPANDING_WEB_APP_EXCEPTION = "AS-WEB-CORE-00775";
    public static final String EXPANDING_WEB_APP_ARCHIVE_EXCEPTION = "AS-WEB-CORE-00776";
    public static final String DEPLOYING_WEB_APP_ARCHIVE = "AS-WEB-CORE-00777";
    public static final String ERROR_DEPLOYING_WEB_APP_ARCHIVE_EXCEPTION = "AS-WEB-CORE-00778";
    public static final String DEPLOYING_WEB_APP_DIR = "AS-WEB-CORE-00779";
    public static final String ERROR_DEPLOYING_WEB_APP_DIR = "AS-WEB-CORE-00780";
    public static final String ERROR_UNDEPLOYING_JAR_FILE_EXCEPTION = "AS-WEB-CORE-00781";
    public static final String RESTART_CONTEXT_INFO = "AS-WEB-CORE-00782";
    public static final String ERROR_DURING_CONTEXT_STOP_EXCEPTION = "AS-WEB-CORE-00783";
    public static final String ERROR_DURING_CONTEXT_RESTART_EXCEPTION = "AS-WEB-CORE-00784";
    public static final String PROCESSING_START = "AS-WEB-CORE-00785";
    public static final String PROCESSING_STOP = "AS-WEB-CORE-00786";
    public static final String UNDEPLOYING_WEB_APP = "AS-WEB-CORE-00787";
    public static final String UNDEPLOYING_CONTEXT = "AS-WEB-CORE-00788";
    public static final String ERROR_UNDEPLOYING_WEB_APP_EXCEPTION = "AS-WEB-CORE-00789";
    private File appBase = null;
    private File configBase = null;
    protected String configClass = "org.apache.catalina.startup.ContextConfig";
    protected String contextClass = "org.apache.catalina.core.StandardContext";
    protected int debug = 0;
    protected List<String> deployed = new ArrayList<String>();
    protected Host host = null;
    private boolean deployXML = false;
    private boolean unpackWARs = false;
    private Map<String, Long> webXmlLastModified = new HashMap<String, Long>();
    private Map<String, Long> contextXmlLastModified = new HashMap<String, Long>();
    private HashMap<String, Long> warLastModified = new HashMap();
    private boolean xmlValidation = false;
    private boolean xmlNamespaceAware = false;
    protected Set<String> invalidWars = new HashSet<String>();

    public String getConfigClass() {
        return this.configClass;
    }

    public void setConfigClass(String configClass) {
        this.configClass = configClass;
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public void setContextClass(String contextClass) {
        this.contextClass = contextClass;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public boolean isDeployXML() {
        return this.deployXML;
    }

    public void setDeployXML(boolean deployXML) {
        this.deployXML = deployXML;
    }

    public boolean isUnpackWARs() {
        return this.unpackWARs;
    }

    public void setUnpackWARs(boolean unpackWARs) {
        this.unpackWARs = unpackWARs;
    }

    public void setXmlValidation(boolean xmlValidation) {
        this.xmlValidation = xmlValidation;
    }

    public boolean getXmlValidation() {
        return this.xmlValidation;
    }

    public boolean getXmlNamespaceAware() {
        return this.xmlNamespaceAware;
    }

    public void setXmlNamespaceAware(boolean xmlNamespaceAware) {
        this.xmlNamespaceAware = xmlNamespaceAware;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getType().equals("check")) {
            this.check();
        }
        try {
            this.host = (Host)((Object)event.getLifecycle());
            if (this.host instanceof StandardHost) {
                int hostDebug = ((StandardHost)this.host).getDebug();
                if (hostDebug > this.debug) {
                    this.debug = hostDebug;
                }
                this.setDeployXML(((StandardHost)this.host).isDeployXML());
                this.setUnpackWARs(((StandardHost)this.host).isUnpackWARs());
                this.setXmlNamespaceAware(((StandardHost)this.host).getXmlNamespaceAware());
                this.setXmlValidation(((StandardHost)this.host).getXmlValidation());
            }
        }
        catch (ClassCastException e) {
            String msg = MessageFormat.format(rb.getString(LIFECYCLE_OBJECT_NOT_HOST_EXCEPTION), event.getLifecycle());
            log.log(Level.SEVERE, msg, e);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    protected File appBase() {
        if (this.appBase != null) {
            return this.appBase;
        }
        File file = new File(this.host.getAppBase());
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.host.getAppBase());
        }
        try {
            this.appBase = file.getCanonicalFile();
        }
        catch (IOException e) {
            this.appBase = file;
        }
        return this.appBase;
    }

    protected File configBase() {
        if (this.configBase != null) {
            return this.configBase;
        }
        File file = new File(System.getProperty("catalina.base"), "conf");
        Container parent = this.host.getParent();
        if (parent != null && parent instanceof Engine) {
            file = new File(file, parent.getName());
        }
        file = new File(file, this.host.getName());
        try {
            this.configBase = file.getCanonicalFile();
        }
        catch (IOException e) {
            this.configBase = file;
        }
        return this.configBase;
    }

    protected void deployApps() {
        if (!(this.host instanceof Deployer)) {
            return;
        }
        File appBase = this.appBase();
        if (!appBase.exists() || !appBase.isDirectory()) {
            return;
        }
        File configBase = this.configBase();
        if (configBase.exists() && configBase.isDirectory()) {
            String[] configFiles = configBase.list();
            this.deployDescriptors(configBase, configFiles);
        }
        String[] files = appBase.list();
        this.deployWARs(appBase, files);
        this.deployDirectories(appBase, files);
    }

    protected void deployDescriptors(File configBase, String[] files) {
        if (!this.deployXML) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].equalsIgnoreCase("META-INF") || files[i].equalsIgnoreCase("WEB-INF") || this.deployed.contains(files[i])) continue;
            File dir2 = new File(configBase, files[i]);
            if (!files[i].toLowerCase(Locale.ENGLISH).endsWith(".xml")) continue;
            this.deployed.add(files[i]);
            String file = files[i].substring(0, files[i].length() - 4);
            String contextPath = "/" + file.replace('_', '/');
            if (file.equals("ROOT")) {
                contextPath = "";
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, DEPLOYING_CONFIG_DESCRIPTOR, files[i]);
            }
            try {
                if (this.host.findChild(contextPath) != null) {
                    if (!this.deployed.contains(file) && !this.deployed.contains(file + ".war")) continue;
                    ((Deployer)((Object)this.host)).remove(contextPath);
                }
                URL config = new URL("file", null, dir2.getCanonicalPath());
                ((Deployer)((Object)this.host)).install(config, null);
                continue;
            }
            catch (Throwable t) {
                String msg = MessageFormat.format(rb.getString(ERROR_DEPLOYING_CONFIG_DESCRIPTOR_EXCEPTION), files[i]);
                log.log(Level.SEVERE, msg, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployWARs(File appBase, String[] files) {
        for (int i = 0; i < files.length; ++i) {
            URL url;
            if (files[i].equalsIgnoreCase("META-INF") || files[i].equalsIgnoreCase("WEB-INF") || this.deployed.contains(files[i])) continue;
            File dir2 = new File(appBase, files[i]);
            if (!files[i].toLowerCase(Locale.ENGLISH).endsWith(".war") || !dir2.isFile() || this.invalidWars.contains(files[i])) continue;
            this.deployed.add(files[i]);
            String contextPath = "/" + files[i];
            int period = contextPath.lastIndexOf(".");
            if (period >= 0) {
                contextPath = contextPath.substring(0, period);
            }
            if (!this.validateContextPath(appBase, contextPath)) {
                log.log(Level.SEVERE, INVALID_WAR_NAME_EXCEPTION, files[i]);
                this.invalidWars.add(files[i]);
                continue;
            }
            if (contextPath.equals("/ROOT")) {
                contextPath = "";
            }
            if (this.host.findChild(contextPath) != null) continue;
            JarFile jar = null;
            JarEntry entry = null;
            InputStream istream = null;
            FilterOutputStream ostream = null;
            File xml = new File(this.configBase, files[i].substring(0, files[i].lastIndexOf(".")) + ".xml");
            if (!xml.exists()) {
                try {
                    jar = new JarFile(dir2);
                    entry = jar.getJarEntry("META-INF/context.xml");
                    if (entry != null) {
                        int n;
                        istream = jar.getInputStream(entry);
                        ostream = new BufferedOutputStream(new FileOutputStream(xml), 1024);
                        byte[] buffer = new byte[1024];
                        while ((n = istream.read(buffer)) >= 0) {
                            ((BufferedOutputStream)ostream).write(buffer, 0, n);
                        }
                        ((BufferedOutputStream)ostream).flush();
                        ostream.close();
                        ostream = null;
                        istream.close();
                        istream = null;
                        entry = null;
                        jar.close();
                        jar = null;
                        this.deployDescriptors(this.configBase(), this.configBase.list());
                        return;
                    }
                }
                catch (IOException e) {
                }
                finally {
                    if (ostream != null) {
                        try {
                            ostream.close();
                        }
                        catch (Throwable t) {}
                        ostream = null;
                    }
                    if (istream != null) {
                        try {
                            istream.close();
                        }
                        catch (Throwable t) {}
                        istream = null;
                    }
                    entry = null;
                    if (jar != null) {
                        try {
                            jar.close();
                        }
                        catch (Throwable t) {}
                        jar = null;
                    }
                }
            }
            if (this.isUnpackWARs()) {
                String msg;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, EXPANDING_WEB_APP, files[i]);
                }
                url = null;
                String path = null;
                try {
                    url = new URL("jar:file:" + dir2.getCanonicalPath() + "!/");
                    path = ExpandWar.expand(this.host, url);
                }
                catch (IOException e) {
                    log.log(Level.WARNING, EXPANDING_WEB_APP_EXCEPTION, files[i]);
                    continue;
                }
                catch (Throwable t) {
                    msg = MessageFormat.format(rb.getString(EXPANDING_WEB_APP_ARCHIVE_EXCEPTION), files[i]);
                    log.log(Level.SEVERE, msg, t);
                    continue;
                }
                try {
                    if (path == null) continue;
                    url = new URL("file:" + path);
                    ((Deployer)((Object)this.host)).install(contextPath, url);
                }
                catch (Throwable t) {
                    msg = MessageFormat.format(rb.getString(EXPANDING_WEB_APP_ARCHIVE_EXCEPTION), files[i]);
                    log.log(Level.SEVERE, msg, t);
                }
                continue;
            }
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, DEPLOYING_WEB_APP_ARCHIVE, files[i]);
            }
            try {
                url = new URL("file", null, dir2.getCanonicalPath());
                url = new URL("jar:" + url.toString() + "!/");
                ((Deployer)((Object)this.host)).install(contextPath, url);
                continue;
            }
            catch (Throwable t) {
                String msg = MessageFormat.format(rb.getString(ERROR_DEPLOYING_WEB_APP_ARCHIVE_EXCEPTION), files[i]);
                log.log(Level.SEVERE, msg, t);
            }
        }
    }

    protected void deployDirectories(File appBase, String[] files) {
        for (int i = 0; i < files.length; ++i) {
            File dir2;
            if (files[i].equalsIgnoreCase("META-INF") || files[i].equalsIgnoreCase("WEB-INF") || this.deployed.contains(files[i]) || !(dir2 = new File(appBase, files[i])).isDirectory()) continue;
            this.deployed.add(files[i]);
            File webInf = new File(dir2, "/WEB-INF");
            if (!webInf.exists() || !webInf.isDirectory() || !webInf.canRead()) continue;
            String contextPath = "/" + files[i];
            if (files[i].equals("ROOT")) {
                contextPath = "";
            }
            if (this.host.findChild(contextPath) != null) continue;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, DEPLOYING_WEB_APP_DIR, files[i]);
            }
            long t1 = System.currentTimeMillis();
            try {
                URL url = new URL("file", null, dir2.getCanonicalPath());
                ((Deployer)((Object)this.host)).install(contextPath, url);
            }
            catch (Throwable t) {
                String msg = MessageFormat.format(rb.getString(ERROR_DEPLOYING_WEB_APP_DIR), files[i]);
                log.log(Level.SEVERE, msg, t);
            }
            long t2 = System.currentTimeMillis();
            if (t2 - t1 <= 200L || !log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "Deployed " + files[i] + " " + (t2 - t1));
        }
    }

    private boolean validateContextPath(File appBase, String contextPath) {
        StringBuilder docBase;
        String canonicalDocBase = null;
        try {
            String canonicalAppBase = appBase.getCanonicalPath();
            docBase = new StringBuilder(canonicalAppBase);
            if (canonicalAppBase.endsWith(File.separator)) {
                docBase.append(contextPath.substring(1).replace('/', File.separatorChar));
            } else {
                docBase.append(contextPath.replace('/', File.separatorChar));
            }
            canonicalDocBase = new File(docBase.toString()).getCanonicalPath();
            if (canonicalDocBase.endsWith(File.separator)) {
                docBase.append(File.separator);
            }
        }
        catch (IOException ioe) {
            return false;
        }
        return canonicalDocBase.equals(docBase.toString());
    }

    protected void checkContextLastModified() {
        if (!(this.host instanceof Deployer)) {
            return;
        }
        Deployer deployer = (Deployer)((Object)this.host);
        String[] contextNames = deployer.findDeployedApps();
        for (int i = 0; i < contextNames.length; ++i) {
            String contextName = contextNames[i];
            Context context = deployer.findDeployedApp(contextName);
            if (!(context instanceof Lifecycle)) continue;
            try {
                DirContext resources = context.getResources();
                if (resources == null) continue;
                ResourceAttributes webXmlAttributes = (ResourceAttributes)resources.getAttributes("/WEB-INF/web.xml");
                ResourceAttributes webInfAttributes = (ResourceAttributes)resources.getAttributes("/WEB-INF");
                long newLastModified = webXmlAttributes.getLastModified();
                long webInfLastModified = webInfAttributes.getLastModified();
                Long lastModified = this.webXmlLastModified.get(contextName);
                if (lastModified == null) {
                    this.webXmlLastModified.put(contextName, newLastModified);
                } else if (lastModified != newLastModified) {
                    if (newLastModified > webInfLastModified + 5000L) {
                        this.webXmlLastModified.remove(contextName);
                        this.restartContext(context);
                    } else {
                        this.webXmlLastModified.put(contextName, newLastModified);
                    }
                }
            }
            catch (NamingException e) {
                // empty catch block
            }
            Long lastModified = this.contextXmlLastModified.get(contextName);
            String configBase = this.configBase().getPath();
            String configFileName = context.getConfigFile();
            if (configFileName == null) continue;
            File configFile = new File(configFileName);
            if (!configFile.isAbsolute()) {
                configFile = new File(System.getProperty("catalina.base"), configFile.getPath());
            }
            long newLastModified = configFile.lastModified();
            if (lastModified == null) {
                this.contextXmlLastModified.put(contextName, newLastModified);
                continue;
            }
            if (lastModified == newLastModified) continue;
            this.contextXmlLastModified.remove(contextName);
            String fileName = configFileName;
            if (!fileName.startsWith(configBase)) continue;
            fileName = fileName.substring(configBase.length() + 1);
            try {
                this.deployed.remove(fileName);
                if (this.host.findChild(contextName) != null) {
                    ((Deployer)((Object)this.host)).remove(contextName);
                }
            }
            catch (Throwable t) {
                String msg = MessageFormat.format(rb.getString(ERROR_UNDEPLOYING_JAR_FILE_EXCEPTION), fileName);
                log.log(Level.SEVERE, msg, t);
            }
            this.deployApps();
        }
        if (this.isUnpackWARs()) {
            File appBase = this.appBase();
            if (!appBase.exists() || !appBase.isDirectory()) {
                return;
            }
            String[] files = appBase.list();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].endsWith(".war")) continue;
                File dir2 = new File(appBase, files[i]);
                Long lastModified = this.warLastModified.get(files[i]);
                long dirLastModified = dir2.lastModified();
                if (lastModified == null) {
                    this.warLastModified.put(files[i], dir2.lastModified());
                    continue;
                }
                if (dirLastModified <= lastModified) continue;
                String expandedDir = files[i];
                int period = expandedDir.lastIndexOf(".");
                if (period >= 0) {
                    expandedDir = expandedDir.substring(0, period);
                }
                File expanded = new File(appBase, expandedDir);
                String contextPath = "/" + expandedDir;
                if (contextPath.equals("/ROOT")) {
                    contextPath = "";
                }
                if (dirLastModified > expanded.lastModified()) {
                    try {
                        this.deployed.remove(files[i]);
                        this.deployed.remove(expandedDir + ".xml");
                        if (this.host.findChild(contextPath) != null) {
                            ((Deployer)((Object)this.host)).remove(contextPath, false);
                            ExpandWar.deleteDir(expanded);
                        }
                    }
                    catch (Throwable t) {
                        String msg = MessageFormat.format(rb.getString(ERROR_UNDEPLOYING_JAR_FILE_EXCEPTION), files[i]);
                        log.log(Level.SEVERE, msg, t);
                    }
                    this.deployApps();
                }
                if (this.host.findChild(contextPath) == null) continue;
                this.webXmlLastModified.remove(contextPath);
                this.warLastModified.put(files[i], dir2.lastModified());
            }
        }
    }

    protected boolean restartContext(Context context) {
        String msg;
        boolean result = true;
        if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, RESTART_CONTEXT_INFO, context.getName());
        }
        try {
            ((Lifecycle)((Object)context)).stop();
        }
        catch (Exception ex) {
            msg = MessageFormat.format(rb.getString(ERROR_DURING_CONTEXT_STOP_EXCEPTION), context.getName());
            log.log(Level.WARNING, msg, ex);
        }
        try {
            ((Lifecycle)((Object)context)).start();
        }
        catch (Exception e) {
            msg = MessageFormat.format(rb.getString(ERROR_DURING_CONTEXT_RESTART_EXCEPTION), context.getName());
            log.log(Level.WARNING, msg, e);
            result = false;
        }
        return result;
    }

    protected String expand(URL war) throws IOException {
        return ExpandWar.expand(this.host, war);
    }

    protected void expand(InputStream input, File docBase, String name) throws IOException {
        ExpandWar.expand(input, docBase, name);
    }

    protected void log(String message) {
        Logger logger2 = null;
        if (this.host != null) {
            logger2 = this.host.getLogger();
        }
        if (logger2 != null) {
            logger2.log("HostConfig[" + this.host.getName() + "]: " + message);
        } else {
            log.info(message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger2 = null;
        if (this.host != null) {
            logger2 = this.host.getLogger();
        }
        if (logger2 != null) {
            logger2.log("HostConfig[" + this.host.getName() + "] " + message, throwable);
        } else {
            log.log(Level.SEVERE, message, throwable);
        }
    }

    public void start() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, PROCESSING_START);
        }
        if (this.host.getDeployOnStartup()) {
            this.deployApps();
        } else {
            File configBase = this.configBase();
            if (configBase.exists() && configBase.isDirectory()) {
                String[] configFiles = configBase.list();
                this.deployDescriptors(configBase, configFiles);
            }
        }
    }

    public void stop() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, PROCESSING_STOP);
        }
        this.undeployApps();
        this.appBase = null;
        this.configBase = null;
    }

    protected void undeployApps() {
        if (!(this.host instanceof Deployer)) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, UNDEPLOYING_WEB_APP);
        }
        String[] contextPaths = ((Deployer)((Object)this.host)).findDeployedApps();
        for (int i = 0; i < contextPaths.length; ++i) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, UNDEPLOYING_CONTEXT, contextPaths[i]);
            }
            try {
                ((Deployer)((Object)this.host)).remove(contextPaths[i]);
                continue;
            }
            catch (Throwable t) {
                String msg = MessageFormat.format(rb.getString(ERROR_UNDEPLOYING_WEB_APP_EXCEPTION), contextPaths[i]);
                log.log(Level.SEVERE, msg, t);
            }
        }
        this.webXmlLastModified.clear();
        this.deployed.clear();
    }

    protected void check() {
        if (this.host.getAutoDeploy()) {
            this.deployApps();
            this.checkContextLastModified();
        }
    }
}

