/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Wrapper;
import org.apache.catalina.authenticator.BasicAuthenticator;
import org.apache.catalina.authenticator.DigestAuthenticator;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.authenticator.NonLoginAuthenticator;
import org.apache.catalina.authenticator.SSLAuthenticator;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.startup.ContextRuleSet;
import org.apache.catalina.startup.DigesterFactory;
import org.apache.catalina.startup.ExpandWar;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.catalina.startup.WebRuleSet;
import org.apache.tomcat.util.digester.Digester;
import org.glassfish.internal.api.Globals;
import org.glassfish.web.valve.GlassFishValve;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class ContextConfig
implements LifecycleListener {
    private static final Logger log = StandardServer.log;
    private static final ResourceBundle rb = log.getResourceBundle();
    public static final String EVENT_DATA_IS_NOT_CONTEXT_EXCEPTION = "AS-WEB-CORE-00710";
    public static final String ALT_DD_FILE_NOT_FOUND_EXCEPTION = "AS-WEB-CORE-00711";
    public static final String MISSING_APP_WEB_XML_FINE = "AS-WEB-CORE-00712";
    public static final String PARSE_ERROR_IN_APP_WEB_XML_EXCEPTION = "AS-WEB-CORE-00713";
    public static final String PARSE_ERROR_IN_APP_WEB_XML = "AS-WEB-CORE-00714";
    public static final String ERROR_CLOSING_APP_WEB_XML_EXCEPTION = "AS-WEB-CORE-00715";
    public static final String NO_REALM_BEEN_CONFIGURED_EXCEPTION = "AS-WEB-CORE-00716";
    public static final String CANNOT_CONFIG_AUTHENTICATOR_EXCEPTION = "AS-WEB-CORE-00717";
    public static final String CANNOT_INSTANTIATE_AUTHENTICATOR_EXCEPTION = "AS-WEB-CORE-00718";
    public static final String CONFIGURED_AUTHENTICATOR_FINE = "AS-WEB-CORE-00719";
    public static final String NO_DEFAULT_WEB_XML_INFO = "AS-WEB-CORE-00720";
    public static final String MISSING_DEFAULT_WEB_XML_EXCEPTION = "AS-WEB-CORE-00721";
    public static final String PARSE_ERROR_IN_DEFAULT_WEB_XML_EXCEPTION = "AS-WEB-CORE-00722";
    public static final String PARSE_ERROR_IN_DEFAULT_WEB_XML = "AS-WEB-CORE-00723";
    public static final String ERROR_CLOSING_DEFAULT_WEB_XML_EXCEPTION = "AS-WEB-CORE-00724";
    public static final String CONTEXT_CONFIG_INIT_FINE = "AS-WEB-CORE-00726";
    public static final String FIXING_DOC_BASE_EXCEPTION = "AS-WEB-CORE-00727";
    public static final String PROCESSING_START_FINEST = "AS-WEB-CORE-00728";
    public static final String PROCESSING_STOP_FINEST = "AS-WEB-CORE-00729";
    public static final String SECURITY_ROLE_NAME_USED_IN_AUTH_WITHOUT_DEFINITION = "AS-WEB-CORE-00730";
    public static final String SECURITY_ROLE_NAME_USED_IN_RUNAS_WITHOUT_DEFINITION = "AS-WEB-CORE-00731";
    public static final String SECURITY_ROLE_NAME_USED_IN_LINK_WITHOUT_DEFINITION = "AS-WEB-CORE-00732";
    public static final String NO_WEB_XML_INFO = "AS-WEB-CORE-00733";
    protected Map<String, Authenticator> customAuthenticators;
    protected static final Properties authenticators = new Properties();
    private ClassLoader classLoader;
    protected Context context = null;
    private int debug = 0;
    protected String defaultContextXml = null;
    protected String defaultWebXml = null;
    protected boolean ok = false;
    protected SAXParseException parseException = null;
    protected static final Digester contextDigester = ContextConfig.createContextDigester();
    protected static final Digester webDigester = ContextConfig.createWebDigester();
    protected static final WebRuleSet webRuleSet = new WebRuleSet();
    private static boolean xmlValidation = false;
    private static boolean xmlNamespaceAware = false;

    public void setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public String getDefaultWebXml() {
        if (this.defaultWebXml == null) {
            this.defaultWebXml = "conf/web.xml";
        }
        return this.defaultWebXml;
    }

    public void setDefaultWebXml(String path) {
        this.defaultWebXml = path;
    }

    public String getDefaultContextXml() {
        if (this.defaultContextXml == null) {
            this.defaultContextXml = "config/context.xml";
        }
        return this.defaultContextXml;
    }

    public void setDefaultContextXml(String path) {
        this.defaultContextXml = path;
    }

    public void setCustomAuthenticators(Map<String, Authenticator> customAuthenticators) {
        this.customAuthenticators = customAuthenticators;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) throws LifecycleException {
        try {
            this.context = (Context)((Object)event.getLifecycle());
        }
        catch (ClassCastException e) {
            String msg = MessageFormat.format(rb.getString(EVENT_DATA_IS_NOT_CONTEXT_EXCEPTION), event.getLifecycle());
            throw new LifecycleException(msg, e);
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        } else if (event.getType().equals("init")) {
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applicationConfig() throws LifecycleException {
        String altDDName = null;
        InputStream stream = null;
        ServletContext servletContext = this.context.getServletContext();
        if (servletContext != null) {
            altDDName = (String)servletContext.getAttribute("org.apache.catalina.deploy.alt_dd");
            if (altDDName != null) {
                try {
                    stream = new FileInputStream(altDDName);
                }
                catch (FileNotFoundException e) {
                    String msg = MessageFormat.format(rb.getString(ALT_DD_FILE_NOT_FOUND_EXCEPTION), altDDName);
                    throw new LifecycleException(msg);
                }
            } else {
                stream = servletContext.getResourceAsStream("/WEB-INF/web.xml");
            }
        }
        if (stream == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, MISSING_APP_WEB_XML_FINE, this.context);
            }
            return;
        }
        long t1 = System.currentTimeMillis();
        URL url = null;
        Digester digester = webDigester;
        synchronized (digester) {
            try {
                url = altDDName != null ? new File(altDDName).toURL() : servletContext.getResource("/WEB-INF/web.xml");
                if (url != null) {
                    InputSource is = new InputSource(url.toExternalForm());
                    is.setByteStream(stream);
                    webDigester.clear();
                    webDigester.setDebug(this.getDebug());
                    if (this.context instanceof StandardContext) {
                        ((StandardContext)this.context).setReplaceWelcomeFiles(true);
                    }
                    webDigester.setUseContextClassLoader(false);
                    webDigester.push(this.context);
                    webDigester.parse(is);
                } else if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, NO_WEB_XML_INFO);
                }
            }
            catch (SAXParseException e) {
                String msg = MessageFormat.format(rb.getString(PARSE_ERROR_IN_APP_WEB_XML_EXCEPTION), e.getLineNumber(), e.getColumnNumber());
                throw new LifecycleException(msg, e);
            }
            catch (Exception e) {
                throw new LifecycleException(rb.getString(PARSE_ERROR_IN_APP_WEB_XML), e);
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, ERROR_CLOSING_APP_WEB_XML_EXCEPTION, e);
                }
                webDigester.push(null);
            }
        }
        webRuleSet.recycle();
        long t2 = System.currentTimeMillis();
        if (this.context instanceof StandardContext) {
            ((StandardContext)this.context).setStartupTime(t2 - t1);
        }
    }

    protected synchronized void managerConfig() {
        if (this.context.getManager() == null) {
            this.context.setManager(new StandardManager());
        }
    }

    protected synchronized void authenticatorConfig() throws LifecycleException {
        Pipeline pipeline;
        String loginMethod;
        LoginConfig loginConfig = this.context.getLoginConfig();
        if (loginConfig == null) {
            loginConfig = new LoginConfig("NONE", null, null, null);
            this.context.setLoginConfig(loginConfig);
        }
        if (this.context instanceof Authenticator) {
            return;
        }
        if (this.context instanceof ContainerBase) {
            Pipeline pipeline2 = ((ContainerBase)((Object)this.context)).getPipeline();
            if (pipeline2 != null) {
                GlassFishValve basic = pipeline2.getBasic();
                if (basic != null && basic instanceof Authenticator) {
                    return;
                }
                GlassFishValve[] valves = pipeline2.getValves();
                for (int i = 0; i < valves.length; ++i) {
                    if (!(valves[i] instanceof Authenticator)) continue;
                    return;
                }
            }
        } else {
            return;
        }
        Realm rlm = this.context.getRealm();
        if (rlm == null) {
            throw new LifecycleException(rb.getString(NO_REALM_BEEN_CONFIGURED_EXCEPTION));
        }
        rlm.setRealmName(loginConfig.getRealmName(), loginConfig.getAuthMethod());
        if (!this.context.hasConstraints()) {
            return;
        }
        GlassFishValve authenticator = null;
        if (this.customAuthenticators != null && (loginMethod = loginConfig.getAuthMethod()) != null && this.customAuthenticators.containsKey(loginMethod) && (authenticator = this.getGlassFishValveAuthenticator(loginMethod)) == null) {
            String msg = MessageFormat.format(rb.getString(CANNOT_CONFIG_AUTHENTICATOR_EXCEPTION), loginMethod);
            throw new LifecycleException(msg);
        }
        if (authenticator == null) {
            String authenticatorName = null;
            String authMethod = loginConfig.getAuthMethod();
            if (authMethod == null) {
                authMethod = "NONE";
            }
            if ((authenticatorName = authenticators.getProperty(authMethod)) == null) {
                String msg = MessageFormat.format(rb.getString(CANNOT_CONFIG_AUTHENTICATOR_EXCEPTION), loginConfig.getAuthMethod());
                throw new LifecycleException(msg);
            }
            try {
                Class<?> authenticatorClass = Class.forName(authenticatorName);
                authenticator = (GlassFishValve)authenticatorClass.newInstance();
            }
            catch (Throwable t) {
                String msg = MessageFormat.format(rb.getString(CANNOT_INSTANTIATE_AUTHENTICATOR_EXCEPTION), authenticatorName);
                throw new LifecycleException(msg, t);
            }
        }
        if (authenticator != null && this.context instanceof ContainerBase && (pipeline = ((ContainerBase)((Object)this.context)).getPipeline()) != null) {
            ((ContainerBase)((Object)this.context)).addValve(authenticator);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, CONFIGURED_AUTHENTICATOR_FINE, loginConfig.getAuthMethod());
            }
        }
    }

    private GlassFishValve getGlassFishValveAuthenticator(String loginMethod) {
        return (GlassFishValve)((Object)this.customAuthenticators.get(loginMethod));
    }

    public static Digester createWebDigester() {
        return ContextConfig.createWebXmlDigester(xmlNamespaceAware, xmlValidation);
    }

    public static Digester createWebXmlDigester(boolean namespaceAware, boolean validation) {
        DigesterFactory df = Globals.get(DigesterFactory.class);
        Digester digester = df.newDigester(xmlValidation, xmlNamespaceAware, webRuleSet);
        digester.getParser();
        return digester;
    }

    protected static Digester createContextDigester() {
        Digester digester = new Digester();
        digester.setValidating(false);
        ContextRuleSet contextRuleSet = new ContextRuleSet("", false);
        digester.addRuleSet(contextRuleSet);
        NamingRuleSet namingRuleSet = new NamingRuleSet("Context/");
        digester.addRuleSet(namingRuleSet);
        digester.getParser();
        return digester;
    }

    protected String getBaseDir() {
        Container engineC = this.context.getParent().getParent();
        if (engineC instanceof StandardEngine) {
            return ((StandardEngine)engineC).getBaseDir();
        }
        return System.getProperty("catalina.base");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void defaultConfig() throws LifecycleException {
        File file;
        long t1 = System.currentTimeMillis();
        if (this.defaultWebXml == null && this.context instanceof StandardContext) {
            this.defaultWebXml = ((StandardContext)this.context).getDefaultWebXml();
        }
        if (this.defaultWebXml == null) {
            this.getDefaultWebXml();
        }
        if (!(file = new File(this.defaultWebXml)).isAbsolute()) {
            file = new File(this.getBaseDir(), this.defaultWebXml);
        }
        InputStream stream = null;
        InputSource source = null;
        try {
            if (!file.exists()) {
                stream = this.getClass().getClassLoader().getResourceAsStream(this.defaultWebXml);
                if (stream != null) {
                    source = new InputSource(this.getClass().getClassLoader().getResource(this.defaultWebXml).toString());
                }
                if (stream == null && (stream = this.getClass().getClassLoader().getResourceAsStream("web-embed.xml")) != null) {
                    source = new InputSource(this.getClass().getClassLoader().getResource("web-embed.xml").toString());
                }
                if (stream == null) {
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, NO_DEFAULT_WEB_XML_INFO);
                    }
                    return;
                }
            } else {
                source = new InputSource("file://" + file.getAbsolutePath());
                stream = new FileInputStream(file);
            }
        }
        catch (Exception e) {
            String msg = MessageFormat.format(rb.getString(MISSING_DEFAULT_WEB_XML_EXCEPTION), this.defaultWebXml, file);
            throw new LifecycleException(msg, e);
        }
        Digester e = webDigester;
        synchronized (e) {
            try {
                source.setByteStream(stream);
                webDigester.setDebug(this.getDebug());
                if (this.context instanceof StandardContext) {
                    ((StandardContext)this.context).setReplaceWelcomeFiles(true);
                }
                webDigester.clear();
                webDigester.setClassLoader(this.getClass().getClassLoader());
                webDigester.setUseContextClassLoader(false);
                webDigester.push(this.context);
                webDigester.parse(source);
            }
            catch (SAXParseException e2) {
                String msg = MessageFormat.format(rb.getString(PARSE_ERROR_IN_DEFAULT_WEB_XML_EXCEPTION), e2.getLineNumber(), e2.getColumnNumber());
                throw new LifecycleException(msg, e2);
            }
            catch (Exception e3) {
                throw new LifecycleException(rb.getString(PARSE_ERROR_IN_DEFAULT_WEB_XML), e3);
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e4) {
                    log.log(Level.SEVERE, ERROR_CLOSING_DEFAULT_WEB_XML_EXCEPTION, e4);
                }
            }
        }
        webRuleSet.recycle();
        long t2 = System.currentTimeMillis();
        if (t2 - t1 > 200L && log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Processed default web.xml " + file + " " + (t2 - t1));
        }
    }

    protected void contextConfig() {
        if (this.defaultContextXml == null) {
            this.getDefaultContextXml();
        }
        if (!this.context.getOverride()) {
            this.processContextConfig(new File(this.getBaseDir()), this.defaultContextXml);
        }
        if (this.context.getConfigFile() != null) {
            this.processContextConfig(new File(this.context.getConfigFile()), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processContextConfig(File baseDir, String resourceName) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Processing context [" + this.context.getName() + "] configuration file " + baseDir + " " + resourceName);
        }
        InputSource source = null;
        InputStream stream = null;
        File file = baseDir;
        if (resourceName != null) {
            file = new File(baseDir, resourceName);
        }
        try {
            if (!file.exists()) {
                if (resourceName != null && (stream = this.getClass().getClassLoader().getResourceAsStream(resourceName)) != null) {
                    source = new InputSource(this.getClass().getClassLoader().getResource(resourceName).toString());
                }
            } else {
                source = new InputSource("file://" + file.getAbsolutePath());
                stream = new FileInputStream(file);
                this.context.addWatchedResource(file.getAbsolutePath());
            }
        }
        catch (Exception e) {
            String msg = MessageFormat.format(rb.getString(MISSING_DEFAULT_WEB_XML_EXCEPTION), resourceName, file);
            log.log(Level.SEVERE, msg, e);
        }
        if (source == null) {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, ERROR_CLOSING_DEFAULT_WEB_XML_EXCEPTION, e);
                }
            }
            return;
        }
        Digester digester = contextDigester;
        synchronized (digester) {
            try {
                source.setByteStream(stream);
                contextDigester.setClassLoader(this.classLoader);
                contextDigester.setUseContextClassLoader(false);
                contextDigester.push(this.context.getParent());
                contextDigester.push(this.context);
                contextDigester.setErrorHandler(new ContextErrorHandler());
                contextDigester.parse(source);
                if (this.parseException != null) {
                    this.ok = false;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Successfully processed context [" + this.context.getName() + "] configuration file " + baseDir + " " + resourceName);
                }
            }
            catch (SAXParseException e) {
                String msg = MessageFormat.format(rb.getString(PARSE_ERROR_IN_DEFAULT_WEB_XML_EXCEPTION), e.getLineNumber(), e.getColumnNumber());
                log.log(Level.SEVERE, PARSE_ERROR_IN_DEFAULT_WEB_XML, e);
                log.log(Level.SEVERE, msg);
                this.ok = false;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, PARSE_ERROR_IN_DEFAULT_WEB_XML, e);
                this.ok = false;
            }
            finally {
                this.parseException = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, ERROR_CLOSING_DEFAULT_WEB_XML_EXCEPTION, e);
                }
            }
        }
    }

    protected void fixDocBase() throws IOException {
        File file;
        String docBase;
        Host host = (Host)this.context.getParent();
        String appBase = host.getAppBase();
        boolean unpackWARs = true;
        if (host instanceof StandardHost) {
            unpackWARs = ((StandardHost)host).isUnpackWARs() && ((StandardContext)this.context).getUnpackWAR();
        }
        File canonicalAppBase = null;
        if (appBase != null) {
            canonicalAppBase = new File(appBase);
            canonicalAppBase = canonicalAppBase.isAbsolute() ? canonicalAppBase.getCanonicalFile() : new File(System.getProperty("catalina.base"), appBase).getCanonicalFile();
        }
        if ((docBase = this.context.getDocBase()) == null) {
            String path = this.context.getPath();
            if (path == null) {
                return;
            }
            docBase = path.equals("") ? "ROOT" : (path.startsWith("/") ? path.substring(1).replace('/', '#') : path.replace('/', '#'));
        }
        docBase = !(file = new File(docBase)).isAbsolute() && canonicalAppBase != null ? new File(canonicalAppBase, docBase).getPath() : file.getCanonicalPath();
        file = new File(docBase);
        String origDocBase = docBase;
        String pathName = this.context.getPath();
        pathName = pathName.equals("") ? "ROOT" : pathName.substring(1).replace('/', '#');
        if (docBase.toLowerCase(Locale.ENGLISH).endsWith(".war") && !file.isDirectory() && unpackWARs) {
            URL war = new URL("jar:" + new File(docBase).toURI().toURL() + "!/");
            docBase = ExpandWar.expand(host, war, pathName);
            file = new File(docBase);
            docBase = file.getCanonicalPath();
            if (this.context instanceof StandardContext) {
                ((StandardContext)this.context).setOriginalDocBase(origDocBase);
            }
        } else if (docBase.toLowerCase(Locale.ENGLISH).endsWith(".war") && !file.isDirectory() && !unpackWARs) {
            URL war = new URL("jar:" + new File(docBase).toURI().toURL() + "!/");
            ExpandWar.validate(host, war, pathName);
        } else {
            File docDir = new File(docBase);
            if (!docDir.exists()) {
                File warFile = new File(docBase + ".war");
                if (warFile.exists()) {
                    URL war = new URL("jar:" + warFile.toURI().toURL() + "!/");
                    if (unpackWARs) {
                        docBase = ExpandWar.expand(host, war, pathName);
                        file = new File(docBase);
                        docBase = file.getCanonicalPath();
                    } else {
                        docBase = warFile.getCanonicalPath();
                        ExpandWar.validate(host, war, pathName);
                    }
                }
                if (this.context instanceof StandardContext) {
                    ((StandardContext)this.context).setOriginalDocBase(origDocBase);
                }
            }
        }
        if (canonicalAppBase != null && docBase.startsWith(canonicalAppBase.getPath())) {
            docBase = docBase.substring(canonicalAppBase.getPath().length());
            if ((docBase = docBase.replace(File.separatorChar, '/')).startsWith("/")) {
                docBase = docBase.substring(1);
            }
        } else {
            docBase = docBase.replace(File.separatorChar, '/');
        }
        this.context.setDocBase(docBase);
    }

    protected void init() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, CONTEXT_CONFIG_INIT_FINE);
        }
        this.context.setConfigured(false);
        this.ok = true;
        this.contextConfig();
        try {
            this.fixDocBase();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, FIXING_DOC_BASE_EXCEPTION, e);
        }
    }

    protected synchronized void start() throws LifecycleException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, PROCESSING_START_FINEST);
        }
        this.context.setConfigured(false);
        Container container = this.context.getParent();
        if (!this.context.getOverride() && container instanceof Host) {
            xmlValidation = this.context.getXmlValidation();
            if (!xmlValidation) {
                xmlValidation = ((Host)container).getXmlValidation();
            }
            if (!(xmlNamespaceAware = this.context.getXmlNamespaceAware())) {
                xmlNamespaceAware = ((Host)container).getXmlNamespaceAware();
            }
        }
        this.defaultConfig();
        this.applicationConfig();
        this.validateSecurityRoles();
        this.authenticatorConfig();
        this.managerConfig();
        if (log.isLoggable(Level.FINEST) && this.context instanceof ContainerBase) {
            log.log(Level.FINEST, "Pipline Configuration:");
            Pipeline pipeline = ((ContainerBase)((Object)this.context)).getPipeline();
            GlassFishValve[] valves = null;
            if (pipeline != null) {
                valves = pipeline.getValves();
            }
            if (valves != null) {
                for (int i = 0; i < valves.length; ++i) {
                    log.log(Level.FINEST, "  " + valves[i].getInfo());
                }
            }
            log.log(Level.FINEST, "======================");
        }
        this.context.setConfigured(true);
    }

    protected synchronized void stop() {
        int i;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, PROCESSING_STOP_FINEST);
        }
        Container[] children = this.context.findChildren();
        for (i = 0; i < children.length; ++i) {
            this.context.removeChild(children[i]);
        }
        this.context.removeConstraints();
        this.context.removeErrorPages();
        FilterDef[] filterDefs = this.context.findFilterDefs();
        for (i = 0; i < filterDefs.length; ++i) {
            this.context.removeFilterDef(filterDefs[i]);
        }
        this.context.removeFilterMaps();
        String[] mimeMappings = this.context.findMimeMappings();
        for (i = 0; i < mimeMappings.length; ++i) {
            this.context.removeMimeMapping(mimeMappings[i]);
        }
        String[] parameters = this.context.findParameters();
        for (i = 0; i < parameters.length; ++i) {
            this.context.removeParameter(parameters[i]);
        }
        this.context.removeSecurityRoles();
        String[] servletMappings = this.context.findServletMappings();
        for (i = 0; i < servletMappings.length; ++i) {
            this.context.removeServletMapping(servletMappings[i]);
        }
        this.context.removeWelcomeFiles();
        this.context.removeWrapperLifecycles();
        this.context.removeWrapperListeners();
        this.ok = true;
    }

    protected void validateSecurityRoles() {
        Iterator<SecurityConstraint> iter = this.context.getConstraints().iterator();
        while (iter.hasNext()) {
            for (String role : iter.next().findAuthRoles()) {
                if ("*".equals(role) || this.context.hasSecurityRole(role)) continue;
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, SECURITY_ROLE_NAME_USED_IN_AUTH_WITHOUT_DEFINITION, new Object[]{role, this.context.getName()});
                }
                this.context.addSecurityRole(role);
            }
        }
        Container[] wrappers = this.context.findChildren();
        for (int i = 0; i < wrappers.length; ++i) {
            Wrapper wrapper = (Wrapper)wrappers[i];
            String runAs = wrapper.getRunAs();
            if (runAs != null && !this.context.hasSecurityRole(runAs)) {
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, SECURITY_ROLE_NAME_USED_IN_RUNAS_WITHOUT_DEFINITION, new Object[]{runAs, this.context.getName()});
                }
                this.context.addSecurityRole(runAs);
            }
            String[] names = wrapper.findSecurityReferences();
            for (int j = 0; j < names.length; ++j) {
                String link = wrapper.findSecurityReference(names[j]);
                if (link == null || this.context.hasSecurityRole(link)) continue;
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, SECURITY_ROLE_NAME_USED_IN_LINK_WITHOUT_DEFINITION, new Object[]{link, this.context.getName()});
                }
                this.context.addSecurityRole(link);
            }
        }
    }

    static {
        authenticators.setProperty("BASIC", BasicAuthenticator.class.getName());
        authenticators.setProperty("CLIENT-CERT", SSLAuthenticator.class.getName());
        authenticators.setProperty("FORM", FormAuthenticator.class.getName());
        authenticators.setProperty("NONE", NonLoginAuthenticator.class.getName());
        authenticators.setProperty("DIGEST", DigestAuthenticator.class.getName());
    }

    protected class ContextErrorHandler
    implements ErrorHandler {
        protected ContextErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) {
            ContextConfig.this.parseException = exception;
        }

        @Override
        public void fatalError(SAXParseException exception) {
            ContextConfig.this.parseException = exception;
        }

        @Override
        public void warning(SAXParseException exception) {
            ContextConfig.this.parseException = exception;
        }
    }
}

