/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.logging.Level;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Server;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.startup.ContextRuleSet;
import org.apache.catalina.startup.Embedded;
import org.apache.catalina.startup.EngineRuleSet;
import org.apache.catalina.startup.HostRuleSet;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.catalina.startup.SetAllPropertiesRule;
import org.apache.catalina.startup.SetParentClassLoaderRule;
import org.apache.tomcat.util.digester.Digester;
import org.xml.sax.InputSource;

public class Catalina
extends Embedded {
    private static final ClassLoader standardServerClassLoader = StandardServer.class.getClassLoader();
    public static final String ERROR_PROCESSING_COMMAND_LINE_EXCEPTION = "AS-WEB-CORE-00695";
    public static final String CATALINA_STOP_EXCEPTION = "AS-WEB-CORE-00696";
    public static final String CANNOT_LOAD_SERVER_XML_EXCEPTION = "AS-WEB-CORE-00697";
    public static final String CATALINA_START_WARNING_EXCEPTION = "AS-WEB-CORE-00698";
    public static final String CATALINA_START_SEVERE_EXCEPTION = "AS-WEB-CORE-00699";
    public static final String INIT_PROCESSED_EXCEPTION = "AS-WEB-CORE-00700";
    public static final String ERROR_LOADING_CONFIGURATION_EXCEPTION = "AS-WEB-CORE-00701";
    public static final String SERVER_STARTUP_INFO = "AS-WEB-CORE-00702";
    protected String configFile = "conf/server.xml";
    protected ClassLoader parentClassLoader = Catalina.class.getClassLoader();
    protected Server server = null;
    protected boolean starting = false;
    protected boolean stopping = false;
    protected Thread shutdownHook = new CatalinaShutdownHook();

    public void setConfig(String file) {
        this.configFile = file;
    }

    public void setConfigFile(String file) {
        this.configFile = file;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setParentClassLoader(ClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
    }

    @Override
    public void setServer(Server server) {
        this.server = server;
    }

    public static void main(String[] args) {
        new Catalina().process(args);
    }

    public void process(String[] args) {
        this.setAwait(true);
        this.setCatalinaHome();
        this.setCatalinaBase();
        try {
            if (this.arguments(args)) {
                if (this.starting) {
                    this.load(args);
                    this.start();
                } else if (this.stopping) {
                    this.stopServer();
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, ERROR_PROCESSING_COMMAND_LINE_EXCEPTION, e);
        }
    }

    protected boolean arguments(String[] args) {
        boolean isConfig = false;
        if (args.length < 1) {
            this.usage();
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (isConfig) {
                this.configFile = args[i];
                isConfig = false;
                continue;
            }
            if (args[i].equals("-config")) {
                isConfig = true;
                continue;
            }
            if (args[i].equals("-debug")) {
                this.debug = 1;
                continue;
            }
            if (args[i].equals("-nonaming")) {
                this.setUseNaming(false);
                continue;
            }
            if (args[i].equals("-help")) {
                this.usage();
                return false;
            }
            if (args[i].equals("start")) {
                this.starting = true;
                this.stopping = false;
                continue;
            }
            if (args[i].equals("stop")) {
                this.starting = false;
                this.stopping = true;
                continue;
            }
            this.usage();
            return false;
        }
        return true;
    }

    protected File configFile() {
        File file = new File(this.configFile);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.configFile);
        }
        return file;
    }

    protected Digester createStartDigester() {
        long t1 = System.currentTimeMillis();
        Digester digester = new Digester();
        if (this.debug > 0) {
            digester.setDebug(this.debug);
        }
        digester.setValidating(false);
        digester.setClassLoader(standardServerClassLoader);
        digester.addObjectCreate("Server", "org.apache.catalina.core.StandardServer", "className");
        digester.addSetProperties("Server");
        digester.addSetNext("Server", "setServer", "org.apache.catalina.Server");
        digester.addObjectCreate("Server/GlobalNamingResources", "org.apache.catalina.deploy.NamingResources");
        digester.addSetProperties("Server/GlobalNamingResources");
        digester.addSetNext("Server/GlobalNamingResources", "setGlobalNamingResources", "org.apache.catalina.deploy.NamingResources");
        digester.addObjectCreate("Server/Listener", null, "className");
        digester.addSetProperties("Server/Listener");
        digester.addSetNext("Server/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addObjectCreate("Server/Service", "org.apache.catalina.core.StandardService", "className");
        digester.addSetProperties("Server/Service");
        digester.addSetNext("Server/Service", "addService", "org.apache.catalina.Service");
        digester.addObjectCreate("Server/Service/Listener", null, "className");
        digester.addSetProperties("Server/Service/Listener");
        digester.addSetNext("Server/Service/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addObjectCreate("Server/Service/Connector", "org.apache.catalina.connector.CoyoteConnector", "className");
        digester.addRule("Server/Service/Connector", new SetAllPropertiesRule());
        digester.addSetNext("Server/Service/Connector", "addConnector", "org.apache.catalina.Connector");
        digester.addObjectCreate("Server/Service/Connector/Factory", "org.apache.catalina.connector.CoyoteServerSocketFactory", "className");
        digester.addSetProperties("Server/Service/Connector/Factory");
        digester.addSetNext("Server/Service/Connector/Factory", "setFactory", "org.apache.catalina.net.ServerSocketFactory");
        digester.addObjectCreate("Server/Service/Connector/Listener", null, "className");
        digester.addSetProperties("Server/Service/Connector/Listener");
        digester.addSetNext("Server/Service/Connector/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addRuleSet(new NamingRuleSet("Server/GlobalNamingResources/"));
        digester.addRuleSet(new EngineRuleSet("Server/Service/"));
        digester.addRuleSet(new HostRuleSet("Server/Service/Engine/"));
        digester.addRuleSet(new ContextRuleSet("Server/Service/Engine/Default"));
        digester.addRuleSet(new NamingRuleSet("Server/Service/Engine/DefaultContext/"));
        digester.addRuleSet(new ContextRuleSet("Server/Service/Engine/Host/Default"));
        digester.addRuleSet(new NamingRuleSet("Server/Service/Engine/Host/DefaultContext/"));
        digester.addRuleSet(new ContextRuleSet("Server/Service/Engine/Host/"));
        digester.addRuleSet(new NamingRuleSet("Server/Service/Engine/Host/Context/"));
        digester.addRule("Server/Service/Engine", new SetParentClassLoaderRule(digester, this.parentClassLoader));
        long t2 = System.currentTimeMillis();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Digester for server.xml created " + (t2 - t1));
        }
        return digester;
    }

    protected Digester createStopDigester() {
        Digester digester = new Digester();
        if (this.debug > 0) {
            digester.setDebug(this.debug);
        }
        digester.addObjectCreate("Server", "org.apache.catalina.core.StandardServer", "className");
        digester.addSetProperties("Server");
        digester.addSetNext("Server", "setServer", "org.apache.catalina.Server");
        return digester;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() {
        if (this.server == null) {
            Digester digester = this.createStopDigester();
            digester.setClassLoader(Thread.currentThread().getContextClassLoader());
            File file = this.configFile();
            FileInputStream fis = null;
            try {
                InputSource is = new InputSource("file://" + file.getAbsolutePath());
                fis = new FileInputStream(file);
                is.setByteStream(fis);
                digester.push(this);
                digester.parse(is);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, CATALINA_STOP_EXCEPTION, e);
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                System.exit(1);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ioe) {}
            }
        }
        Socket socket = null;
        OutputStream stream = null;
        try {
            socket = new Socket("127.0.0.1", this.server.getPort());
            stream = socket.getOutputStream();
            String shutdown = this.server.getShutdown();
            for (int i = 0; i < shutdown.length(); ++i) {
                stream.write(shutdown.charAt(i));
            }
            stream.flush();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, CATALINA_STOP_EXCEPTION, e);
            System.exit(1);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setCatalinaBase() {
        this.initDirs();
    }

    public void setCatalinaHome() {
        this.initDirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        this.initDirs();
        this.initNaming();
        Digester digester = this.createStartDigester();
        long t1 = System.currentTimeMillis();
        Object ex = null;
        InputSource inputSource = null;
        InputStream inputStream = null;
        File file = null;
        try {
            file = this.configFile();
            inputStream = new FileInputStream(file);
            inputSource = new InputSource("file://" + file.getAbsolutePath());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (inputStream == null) {
            try {
                inputStream = this.getClass().getClassLoader().getResourceAsStream(this.getConfigFile());
                inputSource = new InputSource(this.getClass().getClassLoader().getResource(this.getConfigFile()).toString());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (inputStream == null) {
            try {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("server-embed.xml");
                inputSource = new InputSource(this.getClass().getClassLoader().getResource("server-embed.xml").toString());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (inputStream == null && file != null) {
            String msg = MessageFormat.format(rb.getString(CANNOT_LOAD_SERVER_XML_EXCEPTION), file.getAbsolutePath());
            log.log(Level.WARNING, msg);
            return;
        }
        if (inputStream != null) {
            try {
                inputSource.setByteStream(inputStream);
                digester.push(this);
                digester.parse(inputSource);
            }
            catch (Exception e) {
                log.log(Level.WARNING, CATALINA_START_WARNING_EXCEPTION, e);
                return;
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {}
            }
        }
        if (this.server instanceof Lifecycle) {
            try {
                this.server.initialize();
            }
            catch (LifecycleException e) {
                log.log(Level.SEVERE, CATALINA_START_SEVERE_EXCEPTION, e);
            }
        }
        if (log.isLoggable(Level.INFO)) {
            long t2 = System.currentTimeMillis();
            String msg = MessageFormat.format(rb.getString(INIT_PROCESSED_EXCEPTION), t2 - t1);
            log.log(Level.INFO, msg);
        }
    }

    public void load(String[] args) {
        this.setCatalinaHome();
        this.setCatalinaBase();
        try {
            if (this.arguments(args)) {
                this.load();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, ERROR_LOADING_CONFIGURATION_EXCEPTION, e);
        }
    }

    public void create() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void start() {
        if (this.server == null) {
            this.load();
        }
        long t1 = System.currentTimeMillis();
        if (this.server instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)this.server)).start();
            }
            catch (LifecycleException e) {
                log.log(Level.SEVERE, CATALINA_START_SEVERE_EXCEPTION, e);
            }
        }
        if (log.isLoggable(Level.INFO)) {
            long t2 = System.currentTimeMillis();
            String msg = MessageFormat.format(rb.getString(SERVER_STARTUP_INFO), t2 - t1);
            log.log(Level.INFO, msg);
        }
        try {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.await) {
            this.await();
            this.stop();
        }
    }

    @Override
    public void stop() {
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (this.server instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)this.server)).stop();
            }
            catch (LifecycleException e) {
                log.log(Level.SEVERE, CATALINA_STOP_EXCEPTION, e);
            }
        }
    }

    public void await() {
        this.server.await();
    }

    protected void usage() {
        System.out.println("usage: java org.apache.catalina.startup.Catalina [ -config {pathname} ] [ -debug ] [ -nonaming ] { start | stop }");
    }

    protected class CatalinaShutdownHook
    extends Thread {
        protected CatalinaShutdownHook() {
        }

        @Override
        public void run() {
            if (Catalina.this.server != null) {
                Catalina.this.stop();
            }
        }
    }
}

