/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.servlets.InvokerHttpRequest;

public final class InvokerServlet
extends HttpServlet
implements ContainerServlet {
    public static final ResourceBundle rb = StandardServer.log.getResourceBundle();
    public static final String SET_WRAPPER_NOT_CALLED_EXCEPTION = "AS-WEB-CORE-00570";
    public static final String CANNOT_CALL_INVOKER_SERVLET = "AS-WEB-CORE-00571";
    public static final String INVALID_PATH_EXCEPTION = "AS-WEB-CORE-00572";
    public static final String CANNOT_CREATE_SERVLET_WRAPPER_EXCEPTION = "AS-WEB-CORE-00573";
    public static final String CANNOT_ALLOCATE_SERVLET_INSTANCE_EXCEPTION = "AS-WEB-CORE-00574";
    public static final String CANNOT_DEALLOCATE_SERVLET_INSTANCE_EXCEPTION = "AS-WEB-CORE-00575";
    private Context context = null;
    private int debug = 0;
    private Wrapper wrapper = null;

    @Override
    public synchronized Wrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public synchronized void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
        this.context = wrapper == null ? null : (Context)wrapper.getParent();
    }

    @Override
    public void destroy() {
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.serveRequest(request, response);
    }

    @Override
    public void doHead(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.serveRequest(request, response);
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.serveRequest(request, response);
    }

    @Override
    public synchronized void init() throws ServletException {
        if (this.wrapper == null || this.context == null) {
            throw new UnavailableException(rb.getString(SET_WRAPPER_NOT_CALLED_EXCEPTION));
        }
        String value = null;
        try {
            value = this.getServletConfig().getInitParameter("debug");
            this.debug = Integer.parseInt(value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.debug >= 1) {
            this.log("init: Associated with Context '" + this.context.getPath() + "'");
        }
    }

    public synchronized void serveRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean included;
        if (request.getAttribute("org.apache.catalina.NAMED") != null) {
            throw new ServletException(rb.getString(CANNOT_CALL_INVOKER_SERVLET));
        }
        String inRequestURI = null;
        String inServletPath = null;
        String inPathInfo = null;
        boolean bl = included = request.getAttribute("javax.servlet.include.request_uri") != null;
        if (included) {
            inRequestURI = (String)request.getAttribute("javax.servlet.include.request_uri");
            inServletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            inPathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
        } else {
            inRequestURI = request.getRequestURI();
            inServletPath = request.getServletPath();
            inPathInfo = request.getPathInfo();
        }
        if (this.debug >= 1) {
            this.log("included='" + included + "', requestURI='" + inRequestURI + "'");
            this.log("  servletPath='" + inServletPath + "', pathInfo='" + inPathInfo + "'");
        }
        if (inPathInfo == null) {
            if (this.debug >= 1) {
                this.log("Invalid pathInfo 'null'");
            }
            String msg = MessageFormat.format(rb.getString(INVALID_PATH_EXCEPTION), inRequestURI);
            if (included) {
                throw new ServletException(msg);
            }
            this.log(msg);
            response.sendError(404);
            return;
        }
        String pathInfo = inPathInfo;
        String servletClass = pathInfo.substring(1);
        int slash = servletClass.indexOf(47);
        if (slash >= 0) {
            pathInfo = servletClass.substring(slash);
            servletClass = servletClass.substring(0, slash);
        } else {
            pathInfo = "";
        }
        if (servletClass.startsWith("org.apache.catalina")) {
            response.sendError(404);
            return;
        }
        if (this.debug >= 1) {
            this.log("Processing servlet '" + servletClass + "' with path info '" + pathInfo + "'");
        }
        String name = "org.apache.catalina.INVOKER." + servletClass;
        String pattern = inServletPath + "/" + servletClass + "/*";
        Wrapper wrapper = null;
        wrapper = (Wrapper)this.context.findChild(servletClass);
        if (wrapper == null) {
            wrapper = (Wrapper)this.context.findChild(name);
        }
        if (wrapper != null) {
            String actualServletClass = wrapper.getServletClassName();
            if (actualServletClass != null && actualServletClass.startsWith("org.apache.catalina")) {
                response.sendError(404);
                return;
            }
            if (this.debug >= 1) {
                this.log("Using wrapper for servlet '" + wrapper.getName() + "' with mapping '" + pattern + "'");
            }
            this.context.addServletMapping(pattern, wrapper.getName());
        } else {
            if (this.debug >= 1) {
                this.log("Creating wrapper for '" + servletClass + "' with mapping '" + pattern + "'");
            }
            try {
                wrapper = this.context.createWrapper();
                wrapper.setName(name);
                wrapper.setLoadOnStartup(1);
                wrapper.setServletClassName(servletClass);
                this.context.addChild(wrapper);
                this.context.addServletMapping(pattern, name);
            }
            catch (Throwable t) {
                String msg = MessageFormat.format(rb.getString(CANNOT_CREATE_SERVLET_WRAPPER_EXCEPTION), inRequestURI);
                this.log(msg, t);
                this.context.removeServletMapping(pattern);
                this.context.removeChild(wrapper);
                if (included) {
                    throw new ServletException(msg, t);
                }
                String invalidPathMsg = MessageFormat.format(rb.getString(INVALID_PATH_EXCEPTION), inRequestURI);
                this.log(invalidPathMsg);
                response.sendError(404);
                return;
            }
        }
        InvokerHttpRequest wrequest = new InvokerHttpRequest(request);
        wrequest.setRequestURI(inRequestURI);
        StringBuilder sb = new StringBuilder(inServletPath);
        sb.append("/");
        sb.append(servletClass);
        wrequest.setServletPath(sb.toString());
        if (pathInfo == null || pathInfo.length() < 1) {
            wrequest.setPathInfo(null);
            wrequest.setPathTranslated(null);
        } else {
            wrequest.setPathInfo(pathInfo);
            wrequest.setPathTranslated(this.getServletContext().getRealPath(pathInfo));
        }
        Servlet instance = null;
        String cannotAllocateMsg = MessageFormat.format(rb.getString(CANNOT_ALLOCATE_SERVLET_INSTANCE_EXCEPTION), inRequestURI);
        String invalidPathMsg = MessageFormat.format(rb.getString(INVALID_PATH_EXCEPTION), inRequestURI);
        try {
            instance = wrapper.allocate();
        }
        catch (ServletException e) {
            this.log(cannotAllocateMsg, e);
            this.context.removeServletMapping(pattern);
            this.context.removeChild(wrapper);
            Throwable rootCause = e.getRootCause();
            if (rootCause == null) {
                rootCause = e;
            }
            if (rootCause instanceof ClassNotFoundException) {
                this.log(invalidPathMsg);
                response.sendError(404);
                return;
            }
            if (rootCause instanceof IOException) {
                throw (IOException)rootCause;
            }
            if (rootCause instanceof RuntimeException) {
                throw (RuntimeException)rootCause;
            }
            if (rootCause instanceof ServletException) {
                throw (ServletException)rootCause;
            }
            throw new ServletException(cannotAllocateMsg, rootCause);
        }
        catch (Throwable e) {
            this.log(cannotAllocateMsg, e);
            this.context.removeServletMapping(pattern);
            this.context.removeChild(wrapper);
            throw new ServletException(cannotAllocateMsg, e);
        }
        if (included) {
            wrequest.setRequestURI(request.getRequestURI());
            wrequest.setPathInfo(request.getPathInfo());
            wrequest.setServletPath(request.getServletPath());
        }
        try {
            String jspFile = wrapper.getJspFile();
            if (jspFile != null) {
                request.setAttribute("org.apache.catalina.jsp_file", jspFile);
            } else {
                request.removeAttribute("org.apache.catalina.jsp_file");
            }
            request.setAttribute("org.apache.catalina.INVOKED", request.getServletPath());
            instance.service(wrequest, response);
            request.removeAttribute("org.apache.catalina.INVOKED");
            request.removeAttribute("org.apache.catalina.jsp_file");
        }
        catch (IOException e) {
            request.removeAttribute("org.apache.catalina.INVOKED");
            request.removeAttribute("org.apache.catalina.jsp_file");
            try {
                wrapper.deallocate(instance);
            }
            catch (Throwable f) {
                // empty catch block
            }
            throw e;
        }
        catch (UnavailableException e) {
            this.context.removeServletMapping(pattern);
            request.removeAttribute("org.apache.catalina.INVOKED");
            request.removeAttribute("org.apache.catalina.jsp_file");
            try {
                wrapper.deallocate(instance);
            }
            catch (Throwable f) {
                // empty catch block
            }
            throw e;
        }
        catch (ServletException e) {
            request.removeAttribute("org.apache.catalina.INVOKED");
            request.removeAttribute("org.apache.catalina.jsp_file");
            try {
                wrapper.deallocate(instance);
            }
            catch (Throwable f) {
                // empty catch block
            }
            throw e;
        }
        catch (RuntimeException e) {
            request.removeAttribute("org.apache.catalina.INVOKED");
            request.removeAttribute("org.apache.catalina.jsp_file");
            try {
                wrapper.deallocate(instance);
            }
            catch (Throwable f) {
                // empty catch block
            }
            throw e;
        }
        catch (Throwable e) {
            request.removeAttribute("org.apache.catalina.INVOKED");
            request.removeAttribute("org.apache.catalina.jsp_file");
            try {
                wrapper.deallocate(instance);
            }
            catch (Throwable f) {
                // empty catch block
            }
            throw new ServletException("Invoker service() exception", e);
        }
        String cannotDeallocateMsg = MessageFormat.format(rb.getString(CANNOT_DEALLOCATE_SERVLET_INSTANCE_EXCEPTION), inRequestURI);
        try {
            wrapper.deallocate(instance);
        }
        catch (ServletException e) {
            this.log(cannotDeallocateMsg, e);
            throw e;
        }
        catch (Throwable e) {
            this.log(cannotDeallocateMsg, e);
            throw new ServletException(cannotDeallocateMsg, e);
        }
    }
}

