/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.logger;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Timestamp;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.logger.LoggerBase;

public class FileLogger
extends LoggerBase {
    public static final String FILE_LOGGER_STARTED = "AS-WEB-CORE-00490";
    public static final String FILE_LOGGER_NOT_STARTED = "AS-WEB-CORE-00491";
    private String date = "";
    private String directory = "logs";
    protected static final String info = "org.apache.catalina.logger.FileLogger/1.0";
    private String prefix = "catalina.";
    private boolean started = false;
    private String suffix = ".log";
    private boolean timestamp = false;
    private PrintWriter writer = null;

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        String oldDirectory = this.directory;
        this.directory = directory;
        this.support.firePropertyChange("directory", oldDirectory, this.directory);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        String oldPrefix = this.prefix;
        this.prefix = prefix;
        this.support.firePropertyChange("prefix", oldPrefix, this.prefix);
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        String oldSuffix = this.suffix;
        this.suffix = suffix;
        this.support.firePropertyChange("suffix", oldSuffix, this.suffix);
    }

    public boolean getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(boolean timestamp) {
        boolean oldTimestamp = this.timestamp;
        this.timestamp = timestamp;
        this.support.firePropertyChange("timestamp", (Object)oldTimestamp, (Object)this.timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(String msg) {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        String tsString = ts.toString().substring(0, 19);
        String tsDate = tsString.substring(0, 10);
        if (!this.date.equals(tsDate)) {
            FileLogger fileLogger = this;
            synchronized (fileLogger) {
                if (!this.date.equals(tsDate)) {
                    this.close();
                    this.date = tsDate;
                    this.open();
                }
            }
        }
        if (this.writer != null) {
            if (this.timestamp) {
                this.writer.println(tsString + " " + msg);
            } else {
                this.writer.println(msg);
            }
        }
    }

    private void close() {
        if (this.writer == null) {
            return;
        }
        this.writer.flush();
        this.writer.close();
        this.writer = null;
        this.date = "";
    }

    private void open() {
        File dir2 = new File(this.directory);
        if (!dir2.isAbsolute()) {
            dir2 = new File(System.getProperty("catalina.base"), this.directory);
        }
        if (!dir2.mkdirs() && !dir2.exists()) {
            this.writer = null;
            return;
        }
        try {
            String pathname = dir2.getAbsolutePath() + File.separator + this.prefix + this.date + this.suffix;
            this.writer = new PrintWriter((Writer)new FileWriter(pathname, true), true);
        }
        catch (IOException e) {
            this.writer = null;
        }
    }

    @Override
    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(rb.getString(FILE_LOGGER_STARTED));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        super.start();
    }

    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(rb.getString(FILE_LOGGER_NOT_STARTED));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.close();
        super.stop();
    }
}

