/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.Service;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.util.LifecycleSupport;

public class StandardService
implements Lifecycle,
Service {
    private static final Logger log = StandardServer.log;
    private static final ResourceBundle rb = log.getResourceBundle();
    public static final String SERVICE_STARTED = "AS-WEB-CORE-00220";
    public static final String STARTING_SERVICE = "AS-WEB-CORE-00221";
    public static final String STOPPING_SERVICE = "AS-WEB-CORE-00222";
    public static final String SERVICE_HAS_BEEN_INIT = "AS-WEB-CORE-00223";
    public static final String ERROR_REGISTER_SERVICE_EXCEPTION = "AS-WEB-CORE-00224";
    public static final String FAILED_SERVICE_INIT_EXCEPTION = "AS-WEB-CORE-00225";
    private static final String info = "org.apache.catalina.core.StandardService/1.0";
    private String name = null;
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private Server server = null;
    private boolean started = false;
    protected int debug = 0;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected Connector[] connectors = new Connector[0];
    protected final Object connectorsMonitor = new Object();
    protected Container container = null;
    protected boolean initialized = false;
    private NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
    protected String domain;
    protected ObjectName oname;

    @Override
    public Container getContainer() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContainer(Container container) {
        Container oldContainer = this.container;
        if (oldContainer != null && oldContainer instanceof Engine) {
            ((Engine)oldContainer).setService(null);
        }
        this.container = container;
        if (this.container instanceof Engine) {
            ((Engine)this.container).setService(this);
        }
        if (this.started && this.container != null && this.container instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)this.container)).start();
            }
            catch (LifecycleException e) {
                // empty catch block
            }
        }
        Object e = this.connectorsMonitor;
        synchronized (e) {
            for (int i = 0; i < this.connectors.length; ++i) {
                this.connectors[i].setContainer(this.container);
            }
        }
        if (this.started && oldContainer != null && oldContainer instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)oldContainer)).stop();
            }
            catch (LifecycleException lifecycleException) {
                // empty catch block
            }
        }
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public ObjectName getContainerName() {
        if (this.container instanceof ContainerBase) {
            return ((ContainerBase)this.container).getJmxName();
        }
        return null;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        int oldDebug = this.debug;
        this.debug = debug;
        this.support.firePropertyChange("debug", (Object)oldDebug, (Object)this.debug);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public void setServer(Server server) {
        this.server = server;
    }

    @Override
    public NotificationBroadcasterSupport getBroadcaster() {
        return this.broadcaster;
    }

    @Override
    public void setBroadcaster(NotificationBroadcasterSupport broadcaster) {
        this.broadcaster = broadcaster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnector(Connector connector) {
        Object object = this.connectorsMonitor;
        synchronized (object) {
            connector.setContainer(this.container);
            connector.setService(this);
            Connector[] results = new Connector[this.connectors.length + 1];
            System.arraycopy(this.connectors, 0, results, 0, this.connectors.length);
            results[this.connectors.length] = connector;
            this.connectors = results;
            if (this.initialized) {
                try {
                    connector.initialize();
                }
                catch (LifecycleException e) {
                    log.log(Level.SEVERE, "Connector.initialize", e);
                }
            }
            if (this.started && connector instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)connector)).start();
                }
                catch (LifecycleException e) {
                    log.log(Level.SEVERE, "Connector.start", e);
                }
            }
            this.support.firePropertyChange("connector", null, connector);
        }
    }

    public ObjectName[] getConnectorNames() {
        ObjectName[] results = new ObjectName[this.connectors.length];
        for (int i = 0; i < results.length; ++i) {
        }
        return results;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public Connector[] findConnectors() {
        return this.connectors;
    }

    public Connector findConnector(String name) {
        for (Connector connector : this.connectors) {
            if (!connector.getName().equals(name)) continue;
            return connector;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnector(Connector connector) throws LifecycleException {
        Object object = this.connectorsMonitor;
        synchronized (object) {
            int j = -1;
            for (int i = 0; i < this.connectors.length; ++i) {
                if (connector != this.connectors[i]) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            ((Lifecycle)((Object)this.connectors[j])).stop();
            int k = 0;
            Connector[] results = new Connector[this.connectors.length - 1];
            for (int i = 0; i < this.connectors.length; ++i) {
                if (i == j) continue;
                results[k++] = this.connectors[i];
            }
            this.connectors = results;
            this.support.firePropertyChange("connector", connector, null);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StandardService[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public List<LifecycleListener> findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws LifecycleException {
        Object object;
        if (this.started && log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, SERVICE_STARTED);
        }
        if (!this.initialized) {
            this.init();
        }
        this.lifecycle.fireLifecycleEvent("before_start", null);
        if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, STARTING_SERVICE, this.name);
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.container != null) {
            object = this.container;
            synchronized (object) {
                if (this.container instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.container)).start();
                }
            }
        }
        object = this.connectorsMonitor;
        synchronized (object) {
            for (int i = 0; i < this.connectors.length; ++i) {
                if (!(this.connectors[i] instanceof Lifecycle)) continue;
                ((Lifecycle)((Object)this.connectors[i])).start();
            }
        }
        this.lifecycle.fireLifecycleEvent("after_start", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        this.lifecycle.fireLifecycleEvent("stop", null);
        if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, STOPPING_SERVICE, this.name);
        }
        this.started = false;
        Object object = this.connectorsMonitor;
        synchronized (object) {
            for (int i = 0; i < this.connectors.length; ++i) {
                if (!(this.connectors[i] instanceof Lifecycle)) continue;
                ((Lifecycle)((Object)this.connectors[i])).stop();
            }
        }
        if (this.container != null) {
            object = this.container;
            synchronized (object) {
                if (this.container instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.container)).stop();
                }
            }
        }
        this.lifecycle.fireLifecycleEvent("after_stop", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() throws LifecycleException {
        if (this.initialized) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, SERVICE_HAS_BEEN_INIT);
            }
            return;
        }
        this.initialized = true;
        if (this.oname == null) {
            try {
                Container engine = this.getContainer();
                this.domain = engine.getName();
                this.oname = new ObjectName(this.domain + ":type=Service,serviceName=" + this.name);
            }
            catch (Exception e) {
                String msg = MessageFormat.format(rb.getString(ERROR_REGISTER_SERVICE_EXCEPTION), this.domain);
                log.log(Level.SEVERE, msg, e);
            }
        }
        if (this.server == null) {
            ServerFactory.getServer().addService(this);
        }
        Object object = this.connectorsMonitor;
        synchronized (object) {
            for (int i = 0; i < this.connectors.length; ++i) {
                this.connectors[i].initialize();
            }
        }
    }

    public void destroy() throws LifecycleException {
        if (this.started) {
            this.stop();
        }
        if (this.initialized) {
            this.initialized = false;
        }
    }

    public void init() {
        try {
            this.initialize();
        }
        catch (Throwable t) {
            String msg = MessageFormat.format(rb.getString(FAILED_SERVICE_INIT_EXCEPTION), this.domain);
            log.log(Level.SEVERE, msg, t);
        }
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }
}

