/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.ServletRegistration;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.core.StandardWrapper;

public class ServletRegistrationImpl
implements ServletRegistration {
    protected StandardWrapper wrapper;
    protected StandardContext ctx;
    private static final ResourceBundle rb = StandardServer.log.getResourceBundle();
    public static final String SERVLET_REGISTRATION_ALREADY_INIT = "AS-WEB-CORE-00053";
    public static final String SERVLET_REGISTRATION_MAPPING_URL_PATTERNS_EXCEPTION = "AS-WEB-CORE-00054";

    public ServletRegistrationImpl(StandardWrapper wrapper, StandardContext ctx) {
        this.wrapper = wrapper;
        this.ctx = ctx;
    }

    @Override
    public String getName() {
        return this.wrapper.getName();
    }

    public StandardContext getContext() {
        return this.ctx;
    }

    public StandardWrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public String getClassName() {
        return this.wrapper.getServletClassName();
    }

    public String getJspFile() {
        return this.wrapper.getJspFile();
    }

    @Override
    public boolean setInitParameter(String name, String value) {
        if (this.ctx.isContextInitializedCalled()) {
            String msg = MessageFormat.format(rb.getString(SERVLET_REGISTRATION_ALREADY_INIT), "init parameter", this.wrapper.getName(), this.ctx.getName());
            throw new IllegalStateException(msg);
        }
        return this.wrapper.setInitParameter(name, value, false);
    }

    @Override
    public String getInitParameter(String name) {
        return this.wrapper.getInitParameter(name);
    }

    @Override
    public Set<String> setInitParameters(Map<String, String> initParameters) {
        return this.wrapper.setInitParameters(initParameters);
    }

    @Override
    public Map<String, String> getInitParameters() {
        return this.wrapper.getInitParameters();
    }

    @Override
    public Set<String> addMapping(String ... urlPatterns) {
        if (this.ctx.isContextInitializedCalled()) {
            String msg = MessageFormat.format(rb.getString(SERVLET_REGISTRATION_ALREADY_INIT), "mapping", this.wrapper.getName(), this.ctx.getName());
            throw new IllegalStateException(msg);
        }
        if (urlPatterns == null || urlPatterns.length == 0) {
            String msg = MessageFormat.format(rb.getString(SERVLET_REGISTRATION_MAPPING_URL_PATTERNS_EXCEPTION), this.wrapper.getName(), this.ctx.getName());
            throw new IllegalArgumentException(msg);
        }
        return this.ctx.addServletMapping(this.wrapper.getName(), urlPatterns);
    }

    @Override
    public Collection<String> getMappings() {
        return this.wrapper.getMappings();
    }

    @Override
    public String getRunAsRole() {
        return this.wrapper.getRunAs();
    }
}

