/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Globals;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.core.RequestFacadeHelper;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.InstanceSupport;

final class ApplicationFilterChain
implements FilterChain {
    private static final Logger log = StandardServer.log;
    private static final ResourceBundle rb = log.getResourceBundle();
    public static final String FILTER_EXECUTION_EXCEPTION = "AS-WEB-CORE-00023";
    public static final int INCREMENT = 10;
    private ApplicationFilterConfig[] filters = new ApplicationFilterConfig[0];
    private int pos = 0;
    private int n = 0;
    private Servlet servlet = null;
    private StandardWrapper wrapper = null;
    private static Class<?>[] classType = new Class[]{ServletRequest.class, ServletResponse.class, FilterChain.class};

    @Override
    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (Globals.IS_SECURITY_ENABLED) {
            final ServletRequest req = request;
            final ServletResponse res = response;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws ServletException, IOException {
                        ApplicationFilterChain.this.internalDoFilter(req, res);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof ServletException) {
                    throw (ServletException)e;
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new ServletException(e.getMessage(), e);
            }
        } else {
            this.internalDoFilter(request, response);
        }
    }

    private void internalDoFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.wrapper == null) {
            throw new IllegalStateException("Missing wrapper");
        }
        InstanceSupport support = this.wrapper.getInstanceSupport();
        if (this.pos < this.n) {
            RequestFacadeHelper reqFacHelper;
            ApplicationFilterConfig filterConfig;
            if (!(filterConfig = this.filters[this.pos++]).isAsyncSupported() && (reqFacHelper = RequestFacadeHelper.getInstance(request)) != null) {
                reqFacHelper.disableAsyncSupport();
            }
            Filter filter = null;
            try {
                filter = filterConfig.getFilter();
                support.fireInstanceEvent(InstanceEvent.EventType.BEFORE_FILTER_EVENT, filter, request, response);
                if (SecurityUtil.isPackageProtectionEnabled()) {
                    ServletRequest req = request;
                    ServletResponse res = response;
                    Principal principal = ((HttpServletRequest)req).getUserPrincipal();
                    Object[] filterType = new Object[]{req, res, this};
                    SecurityUtil.doAsPrivilege("doFilter", filter, (Class[])classType, filterType, principal);
                } else {
                    filter.doFilter(request, response, this);
                }
                support.fireInstanceEvent(InstanceEvent.EventType.AFTER_FILTER_EVENT, filter, request, response);
            }
            catch (IOException e) {
                if (filter != null) {
                    support.fireInstanceEvent(InstanceEvent.EventType.AFTER_FILTER_EVENT, filter, request, response, (Throwable)e);
                }
                throw e;
            }
            catch (ServletException e) {
                if (filter != null) {
                    support.fireInstanceEvent(InstanceEvent.EventType.AFTER_FILTER_EVENT, filter, request, response, (Throwable)e);
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (filter != null) {
                    support.fireInstanceEvent(InstanceEvent.EventType.AFTER_FILTER_EVENT, filter, request, response, (Throwable)e);
                }
                throw e;
            }
            catch (Throwable e) {
                if (filter != null) {
                    support.fireInstanceEvent(InstanceEvent.EventType.AFTER_FILTER_EVENT, filter, request, response, e);
                }
                throw new ServletException(rb.getString(FILTER_EXECUTION_EXCEPTION), e);
            }
            return;
        }
        this.wrapper.service(request, response, this.servlet);
    }

    void addFilter(ApplicationFilterConfig filterConfig) {
        if (this.n == this.filters.length) {
            ApplicationFilterConfig[] newFilters = new ApplicationFilterConfig[this.n + 10];
            System.arraycopy(this.filters, 0, newFilters, 0, this.n);
            this.filters = newFilters;
        }
        this.filters[this.n++] = filterConfig;
    }

    void release() {
        this.n = 0;
        this.pos = 0;
        this.servlet = null;
        this.wrapper = null;
    }

    void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    void setWrapper(StandardWrapper wrapper) {
        this.wrapper = wrapper;
    }
}

