/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.WebConnection;
import org.apache.catalina.connector.Request;
import org.apache.catalina.core.StandardContext;

public class WebConnectionImpl
implements WebConnection {
    private ServletInputStream inputStream;
    private ServletOutputStream outputStream;
    private Request request;

    public WebConnectionImpl(ServletInputStream inputStream, ServletOutputStream outputStream) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        if (this.request != null && this.request.isUpgrade()) {
            HttpUpgradeHandler httpUpgradeHandler = this.request.getHttpUpgradeHandler();
            try {
                httpUpgradeHandler.destroy();
            }
            finally {
                ((StandardContext)this.request.getContext()).fireContainerEvent("predestroy", httpUpgradeHandler);
            }
            this.request.getCoyoteRequest().getResponse().resume();
        }
        Exception exception = null;
        try {
            this.inputStream.close();
        }
        catch (Exception ex) {
            exception = ex;
        }
        try {
            this.outputStream.close();
        }
        catch (Exception ex) {
            exception = ex;
        }
        try {
            if (this.request != null && this.request.getSocket() != null) {
                this.request.getSocket().close();
            }
        }
        catch (Exception ex) {
            exception = ex;
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void setRequest(Request req) {
        this.request = req;
    }
}

