/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.Reader;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ReadListener;
import javax.servlet.http.HttpUpgradeHandler;
import org.apache.catalina.connector.AsyncContextImpl;
import org.apache.catalina.connector.Request;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardServer;
import org.glassfish.grizzly.ReadHandler;
import org.glassfish.grizzly.http.util.ByteChunk;
import org.glassfish.grizzly.http.util.CharChunk;

public class InputBuffer
extends Reader
implements ByteChunk.ByteInputChannel,
CharChunk.CharInputChannel,
CharChunk.CharOutputChannel {
    private static final Logger log = StandardServer.log;
    private static final ResourceBundle rb = log.getResourceBundle();
    public static final String STREAM_CLOSED = "AS-WEB-CORE-00350";
    public static final String ALREADY_SET_READ_LISTENER = "AS-WEB-CORE-00351";
    public static final String NON_ASYNC_UPGRADE_EXCEPTION = "AS-WEB-CORE-00352";
    public static final String READ_LISTENER_ON_DATA_AVAILABLE_ERROR = "AS-WEB-CORE-00353";
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private org.glassfish.grizzly.http.server.Request grizzlyRequest;
    private org.glassfish.grizzly.http.server.io.InputBuffer grizzlyInputBuffer;
    private Request request;
    private ReadHandler readHandler = null;
    private boolean prevIsReady = true;
    private static final ThreadLocal<Boolean> IS_READY_SCOPE = new ThreadLocal();

    public InputBuffer() {
        this(8192);
    }

    public InputBuffer(int size) {
    }

    public void setRequest(org.glassfish.grizzly.http.server.Request grizzlyRequest) {
        this.grizzlyRequest = grizzlyRequest;
        this.grizzlyInputBuffer = grizzlyRequest.getInputBuffer();
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public org.glassfish.grizzly.http.server.Request getRequest() {
        return this.grizzlyRequest;
    }

    public void recycle() {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "recycle()");
        }
        this.grizzlyInputBuffer = null;
        this.grizzlyRequest = null;
        this.readHandler = null;
        this.prevIsReady = true;
    }

    @Override
    public void close() throws IOException {
        this.grizzlyInputBuffer.close();
    }

    public int available() throws IOException {
        return this.grizzlyInputBuffer.readyData();
    }

    @Override
    public int realReadBytes(byte[] cbuf, int off, int len) throws IOException {
        return this.grizzlyInputBuffer.read(cbuf, off, len);
    }

    public int readByte() throws IOException {
        if (this.grizzlyInputBuffer.isClosed()) {
            throw new IOException(rb.getString(STREAM_CLOSED));
        }
        return this.grizzlyInputBuffer.readByte();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.grizzlyInputBuffer.isClosed()) {
            throw new IOException(rb.getString(STREAM_CLOSED));
        }
        return this.grizzlyInputBuffer.read(b, off, len);
    }

    public boolean isFinished() {
        return this.grizzlyInputBuffer.isFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReady() {
        boolean result;
        if (!this.prevIsReady) {
            return false;
        }
        boolean bl = result = this.grizzlyInputBuffer.available() > 0;
        if (!result) {
            if (this.readHandler != null) {
                this.prevIsReady = false;
                IS_READY_SCOPE.set(Boolean.TRUE);
                try {
                    this.grizzlyInputBuffer.notifyAvailable(this.readHandler);
                }
                finally {
                    IS_READY_SCOPE.remove();
                }
            } else {
                this.prevIsReady = true;
            }
        }
        return result;
    }

    public void setReadListener(ReadListener readListener) {
        if (this.readHandler != null) {
            throw new IllegalStateException(rb.getString(ALREADY_SET_READ_LISTENER));
        }
        if (!this.request.isAsyncStarted() && !this.request.isUpgrade()) {
            throw new IllegalStateException(rb.getString(NON_ASYNC_UPGRADE_EXCEPTION));
        }
        this.readHandler = new ReadHandlerImpl(readListener);
        if (this.isReady()) {
            try {
                this.readHandler.onDataAvailable();
            }
            catch (Throwable t) {
                log.log(Level.WARNING, READ_LISTENER_ON_DATA_AVAILABLE_ERROR, t);
            }
        }
    }

    @Override
    public void realWriteChars(char[] c, int off, int len) throws IOException {
    }

    public void setEncoding(String encoding) {
        this.grizzlyInputBuffer.setDefaultEncoding(encoding);
    }

    @Override
    public int realReadChars(char[] cbuf, int off, int len) throws IOException {
        return this.grizzlyInputBuffer.read(cbuf, off, len);
    }

    @Override
    public int read() throws IOException {
        if (this.grizzlyInputBuffer.isClosed()) {
            throw new IOException(rb.getString(STREAM_CLOSED));
        }
        return this.grizzlyInputBuffer.readChar();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.grizzlyInputBuffer.isClosed()) {
            throw new IOException(rb.getString(STREAM_CLOSED));
        }
        return this.grizzlyInputBuffer.read(cbuf, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.grizzlyInputBuffer.isClosed()) {
            throw new IOException(rb.getString(STREAM_CLOSED));
        }
        if (n < 0L) {
            throw new IllegalArgumentException();
        }
        return this.grizzlyInputBuffer.skip(n, true);
    }

    @Override
    public boolean ready() throws IOException {
        if (this.grizzlyInputBuffer.isClosed()) {
            throw new IOException(rb.getString(STREAM_CLOSED));
        }
        return this.grizzlyInputBuffer.ready();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.grizzlyInputBuffer.mark(readAheadLimit);
    }

    @Override
    public void reset() throws IOException {
        if (this.grizzlyInputBuffer.isClosed()) {
            throw new IOException(rb.getString(STREAM_CLOSED));
        }
        this.grizzlyInputBuffer.reset();
    }

    public void checkConverter() throws IOException {
        this.grizzlyInputBuffer.processingChars();
    }

    class ReadHandlerImpl
    implements ReadHandler {
        private ReadListener readListener = null;
        private Object lk = new Object();

        private ReadHandlerImpl(ReadListener listener) {
            this.readListener = listener;
        }

        @Override
        public void onDataAvailable() {
            if (!Boolean.TRUE.equals(IS_READY_SCOPE.get())) {
                this.processDataAvailable();
            } else {
                AsyncContextImpl.pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        ReadHandlerImpl.this.processDataAvailable();
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processDataAvailable() {
            Object object = this.lk;
            synchronized (object) {
                InputBuffer.this.prevIsReady = true;
                if (InputBuffer.this.request.getContext() != null) {
                    Thread.currentThread().setContextClassLoader(((StandardContext)InputBuffer.this.request.getContext()).getClassLoader());
                }
                this.readListener.onDataAvailable();
            }
        }

        @Override
        public void onAllDataRead() {
            if (!Boolean.TRUE.equals(IS_READY_SCOPE.get())) {
                this.processAllDataRead();
            } else {
                AsyncContextImpl.pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        ReadHandlerImpl.this.processAllDataRead();
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processAllDataRead() {
            Object object = this.lk;
            synchronized (object) {
                InputBuffer.this.prevIsReady = true;
                if (InputBuffer.this.request.getContext() != null) {
                    Thread.currentThread().setContextClassLoader(((StandardContext)InputBuffer.this.request.getContext()).getClassLoader());
                }
                this.readListener.onAllDataRead();
            }
        }

        @Override
        public void onError(final Throwable t) {
            if (!Boolean.TRUE.equals(IS_READY_SCOPE.get())) {
                this.processError(t);
            } else {
                AsyncContextImpl.pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        ReadHandlerImpl.this.processError(t);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processError(Throwable t) {
            Object object = this.lk;
            synchronized (object) {
                if (InputBuffer.this.request.isUpgrade()) {
                    HttpUpgradeHandler httpUpgradeHandler = InputBuffer.this.request.getHttpUpgradeHandler();
                    try {
                        httpUpgradeHandler.destroy();
                    }
                    finally {
                        ((StandardContext)InputBuffer.this.request.getContext()).fireContainerEvent("predestroy", httpUpgradeHandler);
                    }
                    InputBuffer.this.grizzlyRequest.getResponse().resume();
                }
                this.readListener.onError(t);
            }
        }
    }
}

