/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ResourceBundle;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import org.apache.catalina.connector.InputBuffer;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.security.SecurityUtil;

public class CoyoteInputStream
extends ServletInputStream {
    private static final ResourceBundle rb = StandardServer.log.getResourceBundle();
    public static final String OBJECT_INVALID_SCOPE_EXCEPTION = "AS-WEB-CORE-00340";
    public static final String NULL_READ_LISTENER_EXCEPTION = "AS-WEB-CORE-00341";
    protected InputBuffer ib;

    public CoyoteInputStream(InputBuffer ib) {
        this.ib = ib;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    void clear() {
        this.ib = null;
    }

    @Override
    public int read() throws IOException {
        if (this.ib == null) {
            throw new IllegalStateException(rb.getString(OBJECT_INVALID_SCOPE_EXCEPTION));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer result = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws IOException {
                        Integer integer = CoyoteInputStream.this.ib.readByte();
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.ib.readByte();
    }

    @Override
    public int available() throws IOException {
        if (this.ib == null) {
            throw new IllegalStateException(rb.getString(OBJECT_INVALID_SCOPE_EXCEPTION));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer result = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws IOException {
                        Integer integer = CoyoteInputStream.this.ib.available();
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.ib.available();
    }

    @Override
    public int read(final byte[] b) throws IOException {
        if (this.ib == null) {
            throw new IllegalStateException(rb.getString(OBJECT_INVALID_SCOPE_EXCEPTION));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer result = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws IOException {
                        Integer integer = CoyoteInputStream.this.ib.read(b, 0, b.length);
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.ib.read(b, 0, b.length);
    }

    @Override
    public int read(final byte[] b, final int off, final int len) throws IOException {
        if (this.ib == null) {
            throw new IllegalStateException(rb.getString(OBJECT_INVALID_SCOPE_EXCEPTION));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer result = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws IOException {
                        Integer integer = CoyoteInputStream.this.ib.read(b, off, len);
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.ib.read(b, off, len);
    }

    @Override
    public int readLine(byte[] b, int off, int len) throws IOException {
        if (this.ib == null) {
            throw new IllegalStateException(rb.getString(OBJECT_INVALID_SCOPE_EXCEPTION));
        }
        return super.readLine(b, off, len);
    }

    @Override
    public boolean isFinished() {
        if (this.ib == null) {
            throw new IllegalStateException(rb.getString(OBJECT_INVALID_SCOPE_EXCEPTION));
        }
        return this.ib.isFinished();
    }

    @Override
    public boolean isReady() {
        if (this.ib == null) {
            throw new IllegalStateException(rb.getString(OBJECT_INVALID_SCOPE_EXCEPTION));
        }
        return this.ib.isReady();
    }

    @Override
    public void setReadListener(ReadListener readListener) {
        if (this.ib == null) {
            throw new IllegalStateException(rb.getString(OBJECT_INVALID_SCOPE_EXCEPTION));
        }
        if (readListener == null) {
            throw new NullPointerException(rb.getString(NULL_READ_LISTENER_EXCEPTION));
        }
        this.ib.setReadListener(readListener);
    }

    @Override
    public void close() throws IOException {
        if (this.ib == null) {
            throw new IllegalStateException(rb.getString(OBJECT_INVALID_SCOPE_EXCEPTION));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException {
                        CoyoteInputStream.this.ib.close();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
        } else {
            this.ib.close();
        }
    }
}

