/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import com.sun.appserv.ProxyHandler;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.Constants;
import org.apache.catalina.connector.CoyotePrincipal;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.util.ServerInfo;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.Note;
import org.glassfish.grizzly.http.server.AfterServiceListener;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.util.ByteChunk;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.MessageBytes;
import org.glassfish.web.valve.GlassFishValve;

public class CoyoteAdapter
extends HttpHandler {
    private static final Logger log = StandardServer.log;
    private static final ResourceBundle rb = log.getResourceBundle();
    public static final String REQUEST_PROCESSING_EXCEPTION = "AS-WEB-CORE-00410";
    public static final String HTTP_LISTENER_DISABLED = "AS-WEB-CORE-00411";
    public static final String PARSING_CLIENT_CERT_EXCEPTION = "AS-WEB-CORE-00412";
    public static final String NO_HOST_MATCHES_SERVER_NAME_INFO = "AS-WEB-CORE-00413";
    private static final String POWERED_BY = "Servlet/3.0 JSP/2.2 (" + ServerInfo.getServerInfo() + " Java/" + System.getProperty("java.vm.vendor") + "/" + System.getProperty("java.specification.version") + ")";
    static final String JVM_ROUTE = System.getProperty("jvmRoute");
    protected static final boolean ALLOW_BACKSLASH = Boolean.valueOf(System.getProperty("org.glassfish.grizzly.tcp.tomcat5.CoyoteAdapter.ALLOW_BACKSLASH", "false"));
    private static final boolean COLLAPSE_ADJACENT_SLASHES = Boolean.valueOf(System.getProperty("com.sun.enterprise.web.collapseAdjacentSlashes", "true"));
    private boolean compatWithTomcat = false;
    private String serverName = ServerInfo.getPublicServerInfo();
    protected static final Note<MappingData> MAPPING_DATA = org.glassfish.grizzly.http.server.Request.createNote("MappingData");
    static final Note<Request> CATALINA_REQUEST_NOTE = org.glassfish.grizzly.http.server.Request.createNote(Request.class.getName());
    static final Note<Response> CATALINA_RESPONSE_NOTE = org.glassfish.grizzly.http.server.Request.createNote(Response.class.getName());
    static final CatalinaAfterServiceListener catalinaAfterServiceListener = new CatalinaAfterServiceListener();
    private static final Note<DataChunk> DATA_CHUNK = org.glassfish.grizzly.http.server.Request.createNote("DataChunk");
    private Connector connector = null;

    public CoyoteAdapter(Connector connector) {
        this.connector = connector;
    }

    @Override
    public void service(org.glassfish.grizzly.http.server.Request req, org.glassfish.grizzly.http.server.Response res) throws Exception {
        boolean v3Enabled;
        res.getResponse().setAllowCustomReasonPhrase(Constants.USE_CUSTOM_STATUS_MSG_IN_HEADER);
        Request request = req.getNote(CATALINA_REQUEST_NOTE);
        Response response = req.getNote(CATALINA_RESPONSE_NOTE);
        MappingData md = req.getNote(MAPPING_DATA);
        boolean bl = v3Enabled = md != null;
        if (request == null) {
            request = (Request)this.connector.createRequest();
            response = (Response)this.connector.createResponse();
            request.setResponse(response);
            response.setRequest(request);
            req.setNote(CATALINA_REQUEST_NOTE, request);
            req.setNote(CATALINA_RESPONSE_NOTE, response);
            req.getRequest().getRequestURIRef().setDefaultURIEncoding(Charset.forName(this.connector.getURIEncoding()));
        }
        request.setCoyoteRequest(req);
        response.setCoyoteResponse(res);
        if (v3Enabled && !this.compatWithTomcat) {
            request.setMappingData(md);
            request.updatePaths(md);
        }
        req.addAfterServiceListener(catalinaAfterServiceListener);
        try {
            this.doService(req, request, res, response, v3Enabled);
            request.onAfterService();
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, REQUEST_PROCESSING_EXCEPTION, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doService(org.glassfish.grizzly.http.server.Request req, Request request, org.glassfish.grizzly.http.server.Response res, Response response, boolean v3Enabled) throws Exception {
        if (!this.connector.isEnabled()) {
            String msg = MessageFormat.format(rb.getString(HTTP_LISTENER_DISABLED), String.valueOf(this.connector.getPort()));
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, msg);
            }
            response.sendError(404, msg);
            return;
        }
        if (this.connector.isXpoweredBy()) {
            response.addHeader("X-Powered-By", POWERED_BY);
        }
        if (this.postParseRequest(req, request, res, response, v3Enabled)) {
            boolean authPassthroughEnabled = this.connector.getAuthPassthroughEnabled();
            ProxyHandler proxyHandler = this.connector.getProxyHandler();
            if (authPassthroughEnabled && proxyHandler != null) {
                if (proxyHandler.getSSLKeysize(request.getRequest()) > 0) {
                    request.setSecure(true);
                }
                X509Certificate[] certs = null;
                try {
                    certs = proxyHandler.getSSLClientCertificateChain(request.getRequest());
                }
                catch (CertificateException ce) {
                    log.log(Level.SEVERE, PARSING_CLIENT_CERT_EXCEPTION, ce);
                }
                if (certs != null) {
                    request.setAttribute("javax.servlet.request.X509Certificate", certs);
                }
            }
            if (this.serverName != null && !this.serverName.isEmpty()) {
                response.addHeader("Server", this.serverName);
            }
            this.connector.requestStartEvent(request.getRequest(), request.getHost(), request.getContext());
            Container container = this.connector.getContainer();
            try {
                request.lockSession();
                if (container.getPipeline().hasNonBasicValves() || container.hasCustomPipeline()) {
                    container.getPipeline().invoke(request, response);
                } else {
                    Host host = request.getHost();
                    if (host == null) {
                        response.sendError(400);
                        String msg = MessageFormat.format(rb.getString(NO_HOST_MATCHES_SERVER_NAME_INFO), request.getRequest().getServerName());
                        response.setDetailMessage(msg);
                        return;
                    }
                    if (host.getPipeline().hasNonBasicValves() || host.hasCustomPipeline()) {
                        host.getPipeline().invoke(request, response);
                    } else {
                        GlassFishValve hostValve = host.getPipeline().getBasic();
                        hostValve.invoke(request, response);
                        hostValve.postInvoke(request, response);
                    }
                }
            }
            finally {
                try {
                    this.connector.requestEndEvent(request.getRequest(), request.getHost(), request.getContext(), response.getStatus());
                }
                finally {
                    request.unlockSession();
                }
            }
        }
    }

    protected boolean postParseRequest(org.glassfish.grizzly.http.server.Request req, Request request, org.glassfish.grizzly.http.server.Response res, Response response, boolean v3Enabled) throws Exception {
        Context ctx;
        request.setSecure(req.isSecure());
        DataChunk decodedURI = req.getRequest().getRequestURIRef().getDecodedRequestURIBC();
        if (this.compatWithTomcat || !v3Enabled) {
            String authtype;
            String principal = req.getRemoteUser();
            if (principal != null) {
                request.setUserPrincipal(new CoyotePrincipal(principal));
            }
            if ((authtype = req.getAuthType()) != null) {
                request.setAuthType(authtype);
            }
        }
        CharChunk uriParamsCC = request.getURIParams();
        CharChunk uriCC = decodedURI.getCharChunk();
        int semicolon = uriCC.indexOf(';');
        if (semicolon > 0) {
            int absSemicolon = uriCC.getStart() + semicolon;
            uriParamsCC.setChars(uriCC.getBuffer(), absSemicolon, uriCC.getEnd() - absSemicolon);
            decodedURI.setChars(uriCC.getBuffer(), uriCC.getStart(), absSemicolon - uriCC.getStart());
        }
        if (this.compatWithTomcat || !v3Enabled) {
            DataChunk localDecodedURI = decodedURI;
            if (semicolon > 0) {
                localDecodedURI = req.getNote(DATA_CHUNK);
                if (localDecodedURI == null) {
                    localDecodedURI = DataChunk.newInstance();
                    req.setNote(DATA_CHUNK, localDecodedURI);
                }
                localDecodedURI.duplicate(decodedURI);
            }
            this.connector.getMapper().map(req.getRequest().serverName(), localDecodedURI, request.getMappingData());
            MappingData md = request.getMappingData();
            req.setNote(MAPPING_DATA, md);
            request.updatePaths(md);
        }
        String proxyName = this.connector.getProxyName();
        int proxyPort = this.connector.getProxyPort();
        if (proxyPort != 0) {
            req.setServerPort(proxyPort);
        }
        if (proxyName != null) {
            req.setServerName(proxyName);
        }
        if ((ctx = (Context)request.getMappingData().context) != null) {
            if (req.isRequestedSessionIdFromURL() && "jsessionid".equals(ctx.getSessionParameterName())) {
                request.obtainSessionId();
            } else if (!uriParamsCC.isNull()) {
                request.parseSessionId(ctx.getSessionParameterName(), uriParamsCC);
            }
        }
        request.setDefaultContext(request.getMappingData().isDefaultContext);
        request.setContext(ctx);
        if (ctx != null && !uriParamsCC.isNull()) {
            request.parseSessionVersion(uriParamsCC);
        }
        if (!uriParamsCC.isNull()) {
            request.parseJReplica(uriParamsCC);
        }
        request.setWrapper((Wrapper)request.getMappingData().wrapper);
        if (!this.connector.getAllowTrace() && Method.TRACE.equals(req.getMethod())) {
            String[] methods;
            Wrapper wrapper = request.getWrapper();
            String header = null;
            if (wrapper != null && (methods = wrapper.getServletMethods()) != null) {
                for (String method : methods) {
                    if ("TRACE".equals(method)) continue;
                    header = header == null ? method : header + ", " + method;
                }
            }
            res.setStatus(405, "TRACE method is not allowed");
            res.addHeader("Allow", header);
            return false;
        }
        DataChunk redirectPathMB = request.getMappingData().redirectPath;
        if (!(redirectPathMB.isNull() || ctx.hasAdHocPaths() && ctx.getAdHocServletName(request.getRequest().getServletPath()) != null)) {
            String redirectPath = redirectPathMB.toString();
            String query = request.getQueryString();
            if (request.isRequestedSessionIdFromURL()) {
                redirectPath = redirectPath + ";" + ctx.getSessionParameterName() + "=" + request.getRequestedSessionId();
            }
            redirectPath = response.encode(redirectPath);
            if (query != null) {
                redirectPath = redirectPath + "?" + query;
            }
            boolean authPassthroughEnabled = this.connector.getAuthPassthroughEnabled();
            ProxyHandler proxyHandler = this.connector.getProxyHandler();
            if (authPassthroughEnabled && proxyHandler != null && proxyHandler.getSSLKeysize(request.getRequest()) > 0) {
                request.setSecure(true);
            }
            response.sendRedirect(redirectPath, false);
            return false;
        }
        request.parseSessionCookiesId();
        request.parseJrouteCookie();
        return true;
    }

    public static boolean normalize(MessageBytes uriMB) {
        int type2 = uriMB.getType();
        if (type2 == 3) {
            return CoyoteAdapter.normalizeChars(uriMB);
        }
        return CoyoteAdapter.normalizeBytes(uriMB);
    }

    private static boolean normalizeBytes(MessageBytes uriMB) {
        int end;
        ByteChunk uriBC = uriMB.getByteChunk();
        byte[] b = uriBC.getBytes();
        int start = uriBC.getStart();
        if (start == (end = uriBC.getEnd())) {
            return false;
        }
        if (end - start == 1 && b[start] == 42) {
            return true;
        }
        int pos = 0;
        int index = 0;
        for (pos = start; pos < end; ++pos) {
            if (b[pos] == 92) {
                if (ALLOW_BACKSLASH) {
                    b[pos] = 47;
                } else {
                    return false;
                }
            }
            if (b[pos] != 0) continue;
            return false;
        }
        if (b[start] != 47) {
            return false;
        }
        if (COLLAPSE_ADJACENT_SLASHES) {
            for (pos = start; pos < end - 1; ++pos) {
                if (b[pos] != 47) continue;
                while (pos + 1 < end && b[pos + 1] == 47) {
                    CoyoteAdapter.copyBytes(b, pos, pos + 1, end - pos - 1);
                    --end;
                }
            }
        }
        if (end - start > 2 && b[end - 1] == 46 && (b[end - 2] == 47 || b[end - 2] == 46 && b[end - 3] == 47)) {
            b[end] = 47;
            ++end;
        }
        uriBC.setEnd(end);
        index = 0;
        while ((index = uriBC.indexOf("/./", 0, 3, index)) >= 0) {
            CoyoteAdapter.copyBytes(b, start + index, start + index + 2, end - start - index - 2);
            uriBC.setEnd(end -= 2);
        }
        index = 0;
        while ((index = uriBC.indexOf("/../", 0, 4, index)) >= 0) {
            if (index == 0) {
                return false;
            }
            int index2 = -1;
            for (pos = start + index - 1; pos >= 0 && index2 < 0; --pos) {
                if (b[pos] != 47) continue;
                index2 = pos;
            }
            CoyoteAdapter.copyBytes(b, start + index2, start + index + 3, end - start - index - 3);
            end = end + index2 - index - 3;
            uriBC.setEnd(end);
            index = index2;
        }
        uriBC.setBytes(b, start, end);
        return true;
    }

    private static boolean normalizeChars(MessageBytes uriMB) {
        CharChunk uriCC = uriMB.getCharChunk();
        char[] c = uriCC.getChars();
        int start = uriCC.getStart();
        int end = uriCC.getEnd();
        if (end - start == 1 && c[start] == '*') {
            return true;
        }
        int pos = 0;
        int index = 0;
        for (pos = start; pos < end; ++pos) {
            if (c[pos] == '\\') {
                if (ALLOW_BACKSLASH) {
                    c[pos] = 47;
                } else {
                    return false;
                }
            }
            if (c[pos] != '\u0000') continue;
            return false;
        }
        if (c[start] != '/') {
            return false;
        }
        if (COLLAPSE_ADJACENT_SLASHES) {
            for (pos = start; pos < end - 1; ++pos) {
                if (c[pos] != '/') continue;
                while (pos + 1 < end && c[pos + 1] == '/') {
                    CoyoteAdapter.copyChars(c, pos, pos + 1, end - pos - 1);
                    --end;
                }
            }
        }
        if (end - start > 2 && c[end - 1] == '.' && (c[end - 2] == '/' || c[end - 2] == '.' && c[end - 3] == '/')) {
            c[end] = 47;
            ++end;
        }
        uriCC.setEnd(end);
        index = 0;
        while ((index = uriCC.indexOf("/./", 0, 3, index)) >= 0) {
            CoyoteAdapter.copyChars(c, start + index, start + index + 2, end - start - index - 2);
            uriCC.setEnd(end -= 2);
        }
        index = 0;
        while ((index = uriCC.indexOf("/../", 0, 4, index)) >= 0) {
            if (index == 0) {
                return false;
            }
            int index2 = -1;
            for (pos = start + index - 1; pos >= 0 && index2 < 0; --pos) {
                if (c[pos] != '/') continue;
                index2 = pos;
            }
            CoyoteAdapter.copyChars(c, start + index2, start + index + 3, end - start - index - 3);
            end = end + index2 - index - 3;
            uriCC.setEnd(end);
            index = index2;
        }
        uriCC.setChars(c, start, end);
        return true;
    }

    protected static void copyBytes(byte[] b, int dest, int src, int len) {
        for (int pos = 0; pos < len; ++pos) {
            b[pos + dest] = b[pos + src];
        }
    }

    private static void copyChars(char[] c, int dest, int src, int len) {
        for (int pos = 0; pos < len; ++pos) {
            c[pos + dest] = c[pos + src];
        }
    }

    protected void log(String message) {
        log.log(Level.INFO, message);
    }

    protected void log(String message, Throwable throwable) {
        log.log(Level.SEVERE, message, throwable);
    }

    public void fireAdapterEvent(String type2, Object data) {
        if (this.connector != null && this.connector.getContainer() != null) {
            try {
                ((ContainerBase)this.connector.getContainer()).fireContainerEvent(type2, data);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, REQUEST_PROCESSING_EXCEPTION, t);
            }
        }
    }

    public boolean isCompatWithTomcat() {
        return this.compatWithTomcat;
    }

    public void setCompatWithTomcat(boolean compatWithTomcat) {
        this.compatWithTomcat = compatWithTomcat;
        this.serverName = compatWithTomcat ? "Apache/" + this.serverName : ServerInfo.getPublicServerInfo();
    }

    public int getPort() {
        return this.connector.getPort();
    }

    static final class CatalinaAfterServiceListener
    implements AfterServiceListener {
        CatalinaAfterServiceListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAfterService(org.glassfish.grizzly.http.server.Request request) {
            Request servletRequest = request.getNote(CATALINA_REQUEST_NOTE);
            Response servletResponse = request.getNote(CATALINA_RESPONSE_NOTE);
            if (servletRequest != null) {
                try {
                    if (!servletRequest.isUpgrade()) {
                        servletResponse.finishResponse();
                    } else {
                        servletResponse.setUpgrade(servletRequest.isUpgrade());
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, CoyoteAdapter.REQUEST_PROCESSING_EXCEPTION, e);
                }
                finally {
                    servletRequest.recycle();
                    servletResponse.recycle();
                }
            }
        }
    }
}

