/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.util.LinkedList;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.Response;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.catalina.core.ApplicationDispatcher;
import org.apache.catalina.core.ApplicationHttpRequest;
import org.apache.catalina.core.ApplicationHttpResponse;
import org.apache.catalina.core.DispatchTargetsInfo;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.util.StringManager;

class AsyncContextImpl
implements AsyncContext {
    private static final Logger log = StandardServer.log;
    private static final ResourceBundle rb = log.getResourceBundle();
    public static final String UNABLE_DETERMINE_TARGET_OF_DISPATCHER = "AS-WEB-CORE-00320";
    public static final String UNABLE_ACQUIRE_REQUEST_DISPATCHER = "AS-WEB-CORE-00321";
    public static final String UNABLE_ACQUIRE_REQUEST_DISPATCHER_IN_SERVLET_CONTEXT = "AS-WEB-CORE-00322";
    public static final String ERROR_INVOKE_ASYNCLISTENER = "AS-WEB-CORE-00323";
    private static final long DEFAULT_ASYNC_TIMEOUT_MILLIS = 30000L;
    static final ExecutorService pool = Executors.newCachedThreadPool(new AsyncPoolThreadFactory());
    private static final StringManager STRING_MANAGER = StringManager.getManager("org.apache.catalina.connector");
    private Request origRequest;
    private ServletRequest servletRequest;
    private ServletResponse servletResponse;
    private boolean isOriginalRequestAndResponse = false;
    private boolean isStartAsyncWithZeroArg = false;
    private AtomicBoolean isDispatchInProgress = new AtomicBoolean();
    private ThreadLocal<Boolean> isDispatchInScope = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private AtomicBoolean isOkToConfigure = new AtomicBoolean(true);
    private long asyncTimeoutMillis = 30000L;
    private final Queue<AsyncListener> listenerQueue = new ConcurrentLinkedQueue<AsyncListener>();
    private final LinkedList<AsyncListenerContext> asyncListenerContexts = new LinkedList();
    private AtomicInteger startAsyncCounter = new AtomicInteger(0);
    private ThreadLocal<Boolean> isStartAsyncInScope = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    AsyncContextImpl(Request origRequest, ServletRequest servletRequest, Response origResponse, ServletResponse servletResponse, boolean isStartAsyncWithZeroArg) {
        this.origRequest = origRequest;
        this.init(servletRequest, servletResponse, isStartAsyncWithZeroArg);
    }

    @Override
    public ServletRequest getRequest() {
        return this.servletRequest;
    }

    Request getOriginalRequest() {
        return this.origRequest;
    }

    @Override
    public ServletResponse getResponse() {
        return this.servletResponse;
    }

    @Override
    public boolean hasOriginalRequestAndResponse() {
        return this.isOriginalRequestAndResponse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void dispatch() {
        ApplicationDispatcher dispatcher = (ApplicationDispatcher)this.getZeroArgDispatcher(this.origRequest, this.servletRequest, this.isStartAsyncWithZeroArg);
        this.isDispatchInScope.set(true);
        if (dispatcher != null) {
            if (!this.isDispatchInProgress.compareAndSet(false, true)) throw new IllegalStateException(STRING_MANAGER.getString("async.dispatchInProgress"));
            pool.execute(new Handler(this, dispatcher));
            return;
        } else {
            log.log(Level.WARNING, UNABLE_DETERMINE_TARGET_OF_DISPATCHER);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void dispatch(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        ApplicationDispatcher dispatcher = (ApplicationDispatcher)this.servletRequest.getRequestDispatcher(path);
        this.isDispatchInScope.set(true);
        if (dispatcher != null) {
            if (!this.isDispatchInProgress.compareAndSet(false, true)) throw new IllegalStateException(STRING_MANAGER.getString("async.dispatchInProgress"));
            pool.execute(new Handler(this, dispatcher));
            return;
        } else {
            log.log(Level.WARNING, UNABLE_ACQUIRE_REQUEST_DISPATCHER, path);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void dispatch(ServletContext context, String path) {
        if (path == null || context == null) {
            throw new IllegalArgumentException("Null context or path");
        }
        ApplicationDispatcher dispatcher = (ApplicationDispatcher)context.getRequestDispatcher(path);
        this.isDispatchInScope.set(true);
        if (dispatcher != null) {
            if (!this.isDispatchInProgress.compareAndSet(false, true)) throw new IllegalStateException(STRING_MANAGER.getString("async.dispatchInProgress"));
            pool.execute(new Handler(this, dispatcher));
            return;
        } else {
            log.log(Level.WARNING, UNABLE_ACQUIRE_REQUEST_DISPATCHER_IN_SERVLET_CONTEXT, new Object[]{path, context.getContextPath()});
        }
    }

    boolean isDispatchInScope() {
        return this.isDispatchInScope.get();
    }

    boolean getAndResetDispatchInScope() {
        boolean flag = this.isDispatchInScope.get();
        this.isDispatchInScope.set(Boolean.FALSE);
        return flag;
    }

    @Override
    public void complete() {
        this.origRequest.asyncComplete();
    }

    @Override
    public void start(Runnable run2) {
        pool.execute(run2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(AsyncListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        if (!this.isOkToConfigure.get()) {
            throw new IllegalStateException(STRING_MANAGER.getString("async.addListenerIllegalState"));
        }
        LinkedList<AsyncListenerContext> linkedList = this.asyncListenerContexts;
        synchronized (linkedList) {
            this.asyncListenerContexts.add(new AsyncListenerContext(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(AsyncListener listener, ServletRequest servletRequest, ServletResponse servletResponse) {
        if (listener == null || servletRequest == null || servletResponse == null) {
            throw new IllegalArgumentException("Null listener, request, or response");
        }
        if (!this.isOkToConfigure.get()) {
            throw new IllegalStateException(STRING_MANAGER.getString("async.addListenerIllegalState"));
        }
        LinkedList<AsyncListenerContext> linkedList = this.asyncListenerContexts;
        synchronized (linkedList) {
            this.asyncListenerContexts.add(new AsyncListenerContext(listener, servletRequest, servletResponse));
        }
    }

    @Override
    public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
        AsyncListener listener = null;
        StandardContext ctx = (StandardContext)this.origRequest.getContext();
        if (ctx != null) {
            try {
                listener = (AsyncListener)ctx.createListenerInstance(clazz);
                this.listenerQueue.add(listener);
            }
            catch (Throwable t) {
                throw new ServletException(t);
            }
        }
        return (T)listener;
    }

    @Override
    public void setTimeout(long timeout) {
        if (!this.isOkToConfigure.get()) {
            throw new IllegalStateException(STRING_MANAGER.getString("async.setTimeoutIllegalState"));
        }
        this.asyncTimeoutMillis = timeout;
    }

    @Override
    public long getTimeout() {
        return this.asyncTimeoutMillis;
    }

    void reinitialize(ServletRequest servletRequest, ServletResponse servletResponse, boolean isStartAsyncWithZeroArg) {
        this.init(servletRequest, servletResponse, isStartAsyncWithZeroArg);
        this.isDispatchInProgress.set(false);
        this.setOkToConfigure(true);
        this.startAsyncCounter.incrementAndGet();
        this.notifyAsyncListeners(AsyncEventType.START_ASYNC, null);
    }

    boolean isOkToConfigure() {
        return this.isOkToConfigure.get();
    }

    void setOkToConfigure(boolean value) {
        this.isOkToConfigure.set(value);
    }

    private void init(ServletRequest servletRequest, ServletResponse servletResponse, boolean isStartAsyncWithZeroArg) {
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.isOriginalRequestAndResponse = !(!(servletRequest instanceof RequestFacade) && !(servletRequest instanceof ApplicationHttpRequest) || !(servletResponse instanceof ResponseFacade) && !(servletResponse instanceof ApplicationHttpResponse));
        this.isStartAsyncWithZeroArg = isStartAsyncWithZeroArg;
    }

    private RequestDispatcher getZeroArgDispatcher(Request origRequest, ServletRequest servletRequest, boolean isStartAsyncWithZeroArg) {
        String dispatchTarget = null;
        boolean isNamed = false;
        if (!isStartAsyncWithZeroArg && servletRequest instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)servletRequest;
            dispatchTarget = this.getCombinedPath(req);
        } else {
            DispatchTargetsInfo dtInfo = (DispatchTargetsInfo)origRequest.getAttribute("org.apache.catalina.core.ApplicationDispatcher.lastDispatchRequestPathAttr");
            if (dtInfo != null) {
                dispatchTarget = dtInfo.getLastDispatchTarget();
                isNamed = dtInfo.isLastNamedDispatchTarget();
            }
            if (dispatchTarget == null) {
                dispatchTarget = this.getCombinedPath(origRequest);
            }
        }
        RequestDispatcher dispatcher = null;
        if (dispatchTarget != null) {
            dispatcher = isNamed ? servletRequest.getServletContext().getNamedDispatcher(dispatchTarget) : servletRequest.getRequestDispatcher(dispatchTarget);
        }
        return dispatcher;
    }

    private String getCombinedPath(HttpServletRequest req) {
        String servletPath = req.getServletPath();
        if (servletPath == null) {
            return null;
        }
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            return servletPath;
        }
        return servletPath + pathInfo;
    }

    boolean isStartAsyncInScope() {
        return this.isStartAsyncInScope.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAsyncListeners(AsyncEventType asyncEventType, Throwable t) {
        LinkedList<AsyncListenerContext> clone;
        LinkedList<AsyncListenerContext> linkedList = this.asyncListenerContexts;
        synchronized (linkedList) {
            if (this.asyncListenerContexts.isEmpty()) {
                return;
            }
            clone = new LinkedList<AsyncListenerContext>(this.asyncListenerContexts);
            if (asyncEventType.equals((Object)AsyncEventType.START_ASYNC)) {
                this.asyncListenerContexts.clear();
            }
        }
        for (AsyncListenerContext asyncListenerContext : clone) {
            AsyncListener asyncListener = asyncListenerContext.getAsyncListener();
            AsyncEvent asyncEvent = new AsyncEvent(this, asyncListenerContext.getRequest(), asyncListenerContext.getResponse(), t);
            try {
                switch (asyncEventType) {
                    case COMPLETE: {
                        asyncListener.onComplete(asyncEvent);
                        break;
                    }
                    case TIMEOUT: {
                        asyncListener.onTimeout(asyncEvent);
                        break;
                    }
                    case ERROR: {
                        asyncListener.onError(asyncEvent);
                        break;
                    }
                    case START_ASYNC: {
                        asyncListener.onStartAsync(asyncEvent);
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                log.log(Level.WARNING, ERROR_INVOKE_ASYNCLISTENER, throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        LinkedList<AsyncListenerContext> linkedList = this.asyncListenerContexts;
        synchronized (linkedList) {
            this.asyncListenerContexts.clear();
        }
        StandardContext ctx = (StandardContext)this.origRequest.getContext();
        if (ctx != null) {
            for (AsyncListener l : this.listenerQueue) {
                ctx.fireContainerEvent("predestroy", l);
            }
        }
        this.listenerQueue.clear();
        this.servletRequest = null;
        this.servletResponse = null;
        this.origRequest = null;
    }

    static enum AsyncEventType {
        COMPLETE,
        TIMEOUT,
        ERROR,
        START_ASYNC;

    }

    private static class AsyncListenerContext {
        private AsyncListener listener;
        private ServletRequest request;
        private ServletResponse response;

        public AsyncListenerContext(AsyncListener listener) {
            this(listener, null, null);
        }

        public AsyncListenerContext(AsyncListener listener, ServletRequest request, ServletResponse response) {
            this.listener = listener;
            this.request = request;
            this.response = response;
        }

        public AsyncListener getAsyncListener() {
            return this.listener;
        }

        public ServletRequest getRequest() {
            return this.request;
        }

        public ServletResponse getResponse() {
            return this.response;
        }
    }

    private static final class AsyncPoolThreadFactory
    implements ThreadFactory {
        private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();
        private final AtomicInteger counter = new AtomicInteger(0);

        private AsyncPoolThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this.defaultFactory.newThread(r);
            t.setName("glassfish-web-async-thread-" + this.counter.incrementAndGet());
            return t;
        }
    }

    static class Handler
    implements Runnable {
        private final AsyncContextImpl asyncContext;
        private final ApplicationDispatcher dispatcher;

        Handler(AsyncContextImpl asyncContext, ApplicationDispatcher dispatcher) {
            this.asyncContext = asyncContext;
            this.dispatcher = dispatcher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.asyncContext.isStartAsyncInScope.set(Boolean.TRUE);
            Request origRequest = this.asyncContext.getOriginalRequest();
            origRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)DispatcherType.ASYNC);
            origRequest.setAsyncStarted(false);
            int startAsyncCurrent = this.asyncContext.startAsyncCounter.get();
            try {
                this.dispatcher.dispatch(this.asyncContext.getRequest(), this.asyncContext.getResponse(), DispatcherType.ASYNC);
                if (this.asyncContext.startAsyncCounter.compareAndSet(startAsyncCurrent, startAsyncCurrent)) {
                    this.asyncContext.complete();
                } else {
                    origRequest.setAsyncTimeout(this.asyncContext.getTimeout());
                }
            }
            catch (Throwable t) {
                this.asyncContext.notifyAsyncListeners(AsyncEventType.ERROR, t);
                origRequest.errorDispatchAndComplete(t);
            }
            finally {
                this.asyncContext.isStartAsyncInScope.set(Boolean.FALSE);
            }
        }
    }
}

