/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.deploy.LoginConfig;

public class SSLAuthenticator
extends AuthenticatorBase {
    public static final String LOOK_UP_CERTIFICATE_INFO = "AS-WEB-CORE-00310";
    public static final String NO_CERTIFICATE_INCLUDED_INFO = "AS-WEB-CORE-00311";
    public static final String NO_CLIENT_CERTIFICATE_CHAIN = "AS-WEB-CORE-00312";
    public static final String CANNOT_AUTHENTICATE_WITH_CREDENTIALS = "AS-WEB-CORE-00313";
    protected static final String info = "org.apache.catalina.authenticator.SSLAuthenticator/1.0";

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public boolean authenticate(HttpRequest request, HttpResponse response, LoginConfig config) throws IOException {
        X509Certificate[] certs;
        Principal principal = ((HttpServletRequest)request.getRequest()).getUserPrincipal();
        if (principal != null) {
            if (this.debug >= 1) {
                String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00299"), principal.getName());
                this.log(msg);
            }
            return true;
        }
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        if (this.debug >= 1) {
            this.log(rb.getString(LOOK_UP_CERTIFICATE_INFO));
        }
        if ((certs = (X509Certificate[])request.getRequest().getAttribute("javax.servlet.request.X509Certificate")) == null || certs.length < 1) {
            certs = (X509Certificate[])request.getRequest().getAttribute("org.apache.coyote.request.X509Certificate");
        }
        if (certs == null || certs.length < 1) {
            if (this.debug >= 1) {
                this.log(rb.getString(NO_CERTIFICATE_INCLUDED_INFO));
            }
            hres.sendError(400);
            response.setDetailMessage(rb.getString(NO_CLIENT_CERTIFICATE_CHAIN));
            return false;
        }
        principal = this.context.getRealm().authenticate(certs);
        if (principal == null) {
            if (this.debug >= 1) {
                this.log("Realm.authenticate() returned false");
            }
            hres.sendError(401);
            response.setDetailMessage(rb.getString(CANNOT_AUTHENTICATE_WITH_CREDENTIALS));
            return false;
        }
        this.register(request, response, principal, "CLIENT_CERT", null, null);
        String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
        if (ssoId != null) {
            this.getSession(request, true);
        }
        return true;
    }
}

