/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode.stackmap;

import java.util.ArrayList;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ConstPool;
import javassist.bytecode.stackmap.TypeTag;

public abstract class TypeData {
    protected TypeData() {
    }

    public abstract void merge(TypeData var1);

    static void setType(TypeData td, String className, ClassPool cp) throws BadBytecode {
        if (td == TypeTag.TOP) {
            throw new BadBytecode("unset variable");
        }
        td.setType(className, cp);
    }

    public abstract boolean equals(Object var1);

    public abstract int getTypeTag();

    public abstract int getTypeData(ConstPool var1);

    public TypeData getSelf() {
        return this;
    }

    public abstract TypeData copy();

    public abstract boolean isObjectType();

    public boolean is2WordType() {
        return false;
    }

    public boolean isNullType() {
        return false;
    }

    public abstract String getName() throws BadBytecode;

    protected abstract void setType(String var1, ClassPool var2) throws BadBytecode;

    public abstract void evalExpectedType(ClassPool var1) throws BadBytecode;

    public abstract String getExpected() throws BadBytecode;

    public static class ArrayElement
    extends TypeName {
        TypeData array;

        public ArrayElement(TypeData a) {
            this.array = a;
        }

        public TypeData copy() {
            return new ArrayElement(this.array);
        }

        protected void setType(String typeName, ClassPool cp) throws BadBytecode {
            super.setType(typeName, cp);
            this.array.setType(ArrayElement.getArrayType(typeName), cp);
        }

        public String getName() throws BadBytecode {
            String name = this.array.getName();
            if (name.length() > 1 && name.charAt(0) == '[') {
                char c = name.charAt(1);
                if (c == 'L') {
                    return name.substring(2, name.length() - 1).replace('/', '.');
                }
                if (c == '[') {
                    return name.substring(1);
                }
            }
            throw new BadBytecode("bad array type for AALOAD: " + name);
        }

        public static String getArrayType(String elementType) {
            if (elementType.charAt(0) == '[') {
                return "[" + elementType;
            }
            return "[L" + elementType.replace('.', '/') + ";";
        }

        public static String getElementType(String arrayType) {
            char c = arrayType.charAt(1);
            if (c == 'L') {
                return arrayType.substring(2, arrayType.length() - 1).replace('/', '.');
            }
            if (c == '[') {
                return arrayType.substring(1);
            }
            return arrayType;
        }
    }

    protected static class BasicType
    extends TypeData {
        private String name;
        private int typeTag;

        public BasicType(String type2, int tag) {
            this.name = type2;
            this.typeTag = tag;
        }

        public void merge(TypeData neighbor) {
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int getTypeTag() {
            return this.typeTag;
        }

        public int getTypeData(ConstPool cp) {
            return 0;
        }

        public boolean isObjectType() {
            return false;
        }

        public boolean is2WordType() {
            return this.typeTag == 4 || this.typeTag == 3;
        }

        public TypeData copy() {
            return this;
        }

        public void evalExpectedType(ClassPool cp) throws BadBytecode {
        }

        public String getExpected() throws BadBytecode {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        protected void setType(String s, ClassPool cp) throws BadBytecode {
            throw new BadBytecode("conflict: " + this.name + " and " + s);
        }

        public String toString() {
            return this.name;
        }
    }

    public static class ClassName
    extends TypeName {
        private String name;

        public ClassName(String n) {
            this.name = n;
        }

        public TypeData copy() {
            return new ClassName(this.name);
        }

        public String getName() {
            return this.name;
        }
    }

    public static class NullType
    extends ClassName {
        public NullType() {
            super("null");
        }

        public TypeData copy() {
            return new NullType();
        }

        public boolean isNullType() {
            return true;
        }

        public int getTypeTag() {
            try {
                if ("null".equals(this.getExpected())) {
                    return 5;
                }
                return super.getTypeTag();
            }
            catch (BadBytecode e) {
                throw new RuntimeException("fatal error: ", e);
            }
        }

        protected int getTypeData2(ConstPool cp, String type2) {
            if ("null".equals(type2)) {
                return 0;
            }
            return super.getTypeData2(cp, type2);
        }

        public String getExpected() throws BadBytecode {
            String en = this.expectedName;
            if (en == null) {
                return "java.lang.Object";
            }
            return en;
        }
    }

    protected static abstract class TypeName
    extends TypeData {
        protected ArrayList equivalences = new ArrayList();
        protected String expectedName;
        private CtClass cache;
        private boolean evalDone;

        protected TypeName() {
            this.equivalences.add(this);
            this.expectedName = null;
            this.cache = null;
            this.evalDone = false;
        }

        public void merge(TypeData neighbor) {
            if (this == neighbor) {
                return;
            }
            if (!(neighbor instanceof TypeName)) {
                return;
            }
            TypeName neighbor2 = (TypeName)neighbor;
            ArrayList list = this.equivalences;
            ArrayList list2 = neighbor2.equivalences;
            if (list == list2) {
                return;
            }
            int n = list2.size();
            for (int i = 0; i < n; ++i) {
                TypeName tn = (TypeName)list2.get(i);
                TypeName.add(list, tn);
                tn.equivalences = list;
            }
        }

        private static void add(ArrayList list, TypeData td) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (list.get(i) != td) continue;
                return;
            }
            list.add(td);
        }

        public int getTypeTag() {
            return 7;
        }

        public int getTypeData(ConstPool cp) {
            String type2;
            try {
                type2 = this.getExpected();
            }
            catch (BadBytecode e) {
                throw new RuntimeException("fatal error: ", e);
            }
            return this.getTypeData2(cp, type2);
        }

        protected int getTypeData2(ConstPool cp, String type2) {
            return cp.addClassInfo(type2);
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeName) {
                try {
                    TypeName tn = (TypeName)obj;
                    return this.getExpected().equals(tn.getExpected());
                }
                catch (BadBytecode badBytecode) {
                    // empty catch block
                }
            }
            return false;
        }

        public boolean isObjectType() {
            return true;
        }

        protected void setType(String typeName, ClassPool cp) throws BadBytecode {
            if (this.update(cp, this.expectedName, typeName)) {
                this.expectedName = typeName;
            }
        }

        public void evalExpectedType(ClassPool cp) throws BadBytecode {
            TypeName tn;
            TypeData td;
            int i;
            if (this.evalDone) {
                return;
            }
            ArrayList equiv = this.equivalences;
            int n = equiv.size();
            String name = this.evalExpectedType2(equiv, n);
            if (name == null) {
                name = this.expectedName;
                for (i = 0; i < n; ++i) {
                    td = (TypeData)equiv.get(i);
                    if (!(td instanceof TypeName)) continue;
                    tn = (TypeName)td;
                    if (!this.update(cp, name, tn.expectedName)) continue;
                    name = tn.expectedName;
                }
            }
            for (i = 0; i < n; ++i) {
                td = (TypeData)equiv.get(i);
                if (!(td instanceof TypeName)) continue;
                tn = (TypeName)td;
                tn.expectedName = name;
                tn.cache = null;
                tn.evalDone = true;
            }
        }

        private String evalExpectedType2(ArrayList equiv, int n) throws BadBytecode {
            String origName = null;
            for (int i = 0; i < n; ++i) {
                TypeData td = (TypeData)equiv.get(i);
                if (td.isNullType()) continue;
                if (origName == null) {
                    origName = td.getName();
                    continue;
                }
                if (origName.equals(td.getName())) continue;
                return null;
            }
            return origName;
        }

        protected boolean isTypeName() {
            return true;
        }

        private boolean update(ClassPool cp, String oldName, String typeName) throws BadBytecode {
            if (typeName == null) {
                return false;
            }
            if (oldName == null) {
                return true;
            }
            if (oldName.equals(typeName)) {
                return false;
            }
            if (typeName.charAt(0) == '[' && oldName.equals("[Ljava.lang.Object;")) {
                return true;
            }
            try {
                CtClass cache2;
                if (this.cache == null) {
                    this.cache = cp.get(oldName);
                }
                if ((cache2 = cp.get(typeName)).subtypeOf(this.cache)) {
                    this.cache = cache2;
                    return true;
                }
                return false;
            }
            catch (NotFoundException e) {
                throw new BadBytecode("cannot find " + e.getMessage());
            }
        }

        public String getExpected() throws BadBytecode {
            ArrayList equiv = this.equivalences;
            if (equiv.size() == 1) {
                return this.getName();
            }
            String en = this.expectedName;
            if (en == null) {
                return "java.lang.Object";
            }
            return en;
        }

        public String toString() {
            try {
                String en = this.expectedName;
                if (en != null) {
                    return en;
                }
                String name = this.getName();
                if (this.equivalences.size() == 1) {
                    return name;
                }
                return name + "?";
            }
            catch (BadBytecode e) {
                return "<" + e.getMessage() + ">";
            }
        }
    }

    public static class UninitData
    extends TypeData {
        String className;
        int offset;
        boolean initialized;

        UninitData(int offset, String className) {
            this.className = className;
            this.offset = offset;
            this.initialized = false;
        }

        public void merge(TypeData neighbor) {
        }

        public int getTypeTag() {
            return 8;
        }

        public int getTypeData(ConstPool cp) {
            return this.offset;
        }

        public boolean equals(Object obj) {
            if (obj instanceof UninitData) {
                UninitData ud = (UninitData)obj;
                return this.offset == ud.offset && this.className.equals(ud.className);
            }
            return false;
        }

        public TypeData getSelf() {
            if (this.initialized) {
                return this.copy();
            }
            return this;
        }

        public TypeData copy() {
            return new ClassName(this.className);
        }

        public boolean isObjectType() {
            return true;
        }

        protected void setType(String typeName, ClassPool cp) throws BadBytecode {
            this.initialized = true;
        }

        public void evalExpectedType(ClassPool cp) throws BadBytecode {
        }

        public String getName() {
            return this.className;
        }

        public String getExpected() {
            return this.className;
        }

        public String toString() {
            return "uninit:" + this.className + "@" + this.offset;
        }
    }

    public static class UninitThis
    extends UninitData {
        UninitThis(String className) {
            super(-1, className);
        }

        public int getTypeTag() {
            return 6;
        }

        public int getTypeData(ConstPool cp) {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof UninitThis;
        }

        public String toString() {
            return "uninit:this";
        }
    }
}

