/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.client;

import com.sun.pkg.client.Version;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Fmri
implements Comparable<Fmri>,
Cloneable {
    public static final String PREF_AUTH_PFX = "_PRE";
    public static final Fmri nullFmri = new Fmri();
    String name = "";
    Version version = Version.nullVersion;
    String authname = "";

    private Fmri() {
    }

    public Fmri(String p) {
        int nameidx;
        int veridx = p.lastIndexOf(64);
        if (p.startsWith("pkg://")) {
            nameidx = p.indexOf(47, 6) + 1;
            this.authname = p.substring(6, nameidx - 1);
        } else {
            nameidx = p.startsWith("pkg:/") ? 5 : 0;
        }
        if (veridx != -1) {
            this.version = new Version(p.substring(veridx + 1));
            this.name = p.substring(nameidx, veridx);
        } else {
            this.version = Version.nullVersion;
            this.name = p.substring(nameidx);
        }
    }

    public Fmri(String name, String version) {
        this.name = name;
        this.version = new Version(version);
    }

    Fmri(File dir2) {
        try {
            String verStr = URLDecoder.decode(dir2.getName(), "UTF-8");
            this.version = new Version(verStr);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(Fmri.class.getName()).log(Level.SEVERE, null, ex);
            this.version = new Version("");
        }
        this.name = dir2.getParentFile().getName();
    }

    public Fmri clone() {
        try {
            return (Fmri)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public String getAuthority() {
        return this.authname;
    }

    void setAuthority(String name) {
        this.authname = name;
    }

    public String getName() {
        return this.name;
    }

    public Version getVersion() {
        return this.version;
    }

    public File getPkgDir(File pkgdir) throws IOException {
        return new File(pkgdir, URLEncoder.encode(this.name, "UTF-8"));
    }

    public File getPkgVersionDir(File pkgdir) throws IOException {
        return new File(new File(pkgdir, URLEncoder.encode(this.name, "UTF-8")), URLEncoder.encode(this.version.toString(), "UTF-8"));
    }

    public String getURLPath() throws IOException {
        return URLEncoder.encode(this.name, "UTF-8") + "@" + URLEncoder.encode(this.version.toString(), "UTF-8");
    }

    String getLinkFileName() throws IOException {
        return this.getURLPath();
    }

    public String toString() {
        return "pkg:" + (this.authname.length() == 0 ? "" : "//" + this.authname) + "/" + this.name + "@" + this.version;
    }

    String toStringWithoutAuthority() {
        return "pkg:/" + this.name + "@" + this.version;
    }

    public boolean equals(Object o) {
        Fmri fmri = (Fmri)o;
        return this.name.equals(fmri.name) && this.version.equals(fmri.version);
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 19 * hash + (this.version != null ? this.version.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(Fmri fmri) {
        int i = this.name.compareTo(fmri.name);
        if (i != 0) {
            return i;
        }
        return this.version.compareTo(fmri.version);
    }

    public boolean matches(Fmri f) {
        return this.name.equals(f.name) && this.version.matches(f.version);
    }

    public boolean isSamePackage(Fmri f) {
        return this.name.equals(f.name);
    }

    public boolean isSuccessor(Fmri f) {
        if (!this.isSamePackage(f)) {
            return false;
        }
        return this.version.compareTo(f.version) >= 0;
    }
}

