/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.CompletionHandler;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.ControlImpl;
import com.sun.jts.CosTransactions.CoordinatorImpl;
import com.sun.jts.CosTransactions.CoordinatorResourceImpl;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.CosTransactions.LogicErrorException;
import com.sun.jts.CosTransactions.NestingInfo;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.jts.CosTransactions.RegisteredResources;
import com.sun.jts.CosTransactions.SuperiorInfo;
import com.sun.jts.CosTransactions.TerminatorImpl;
import com.sun.jts.CosTransactions.TimeoutManager;
import com.sun.jts.CosTransactions.TransactionState;
import com.sun.jts.codegen.otsidl.CoordinatorResource;
import com.sun.jts.codegen.otsidl.JCoordinator;
import com.sun.jts.codegen.otsidl.JCoordinatorHelper;
import com.sun.jts.utils.LogFormatter;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.CoordinatorHelper;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.SubtransactionAwareResourceHelper;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.SynchronizationUnavailable;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.Unavailable;
import org.omg.CosTransactions.Vote;
import org.omg.CosTransactions.otid_t;

class SubCoordinator
extends CoordinatorImpl {
    String name = null;
    RegisteredResources participants = null;
    SuperiorInfo superInfo = null;
    NestingInfo nestingInfo = null;
    TransactionState tranState = null;
    CompletionHandler terminator = null;
    boolean registered = false;
    boolean root = true;
    boolean rollbackOnly = false;
    boolean dying = false;
    boolean temporary = false;
    int hash = 0;
    static Logger _logger = LogDomains.getLogger(SubCoordinator.class, "javax.enterprise.system.core.transaction");
    static String[] resultName = new String[]{"Commit", "Rollback", "Read-only"};
    private static Any emptyData = null;

    SubCoordinator(GlobalTID parentGlobalTID, Long parentLocalTID, CoordinatorImpl[] ancestors) throws LogicErrorException {
        this.tranState = new TransactionState(parentLocalTID, parentGlobalTID);
        this.superInfo = new SuperiorInfo(this.tranState.localTID, this.tranState.globalTID, null, null);
        this.name = this.superInfo.globalTID.toString();
        this.hash = this.superInfo.globalTID.hashCode();
        this.nestingInfo = new NestingInfo(ancestors);
        this.participants = null;
        this.root = true;
        this.registered = true;
        this.rollbackOnly = false;
        this.dying = false;
        this.temporary = false;
        this.terminator = null;
        if (!this.tranState.setState(1)) {
            LogicErrorException exc = new LogicErrorException(LogFormatter.getLocalizedMessage(_logger, "jts.invalid_state_change"));
            throw exc;
        }
        RecoveryManager.addCoordinator(this.tranState.globalTID, this.tranState.localTID, this, 0);
    }

    SubCoordinator(GlobalTID globalTID, Coordinator superior, boolean temporary, CoordinatorImpl[] ancestors) throws LogicErrorException {
        this.tranState = new TransactionState(globalTID, null);
        this.superInfo = new SuperiorInfo(this.tranState.localTID, globalTID, superior, null);
        this.name = this.superInfo.globalTID.toString();
        this.hash = this.superInfo.globalTID.hashCode();
        this.nestingInfo = new NestingInfo(ancestors);
        this.participants = null;
        this.root = false;
        this.registered = false;
        this.rollbackOnly = false;
        this.dying = false;
        this.temporary = temporary;
        this.terminator = null;
        if (!this.tranState.setState(1)) {
            LogicErrorException exc = new LogicErrorException(LogFormatter.getLocalizedMessage(_logger, "jts.invalid_state_change"));
            throw exc;
        }
        if (!RecoveryManager.addCoordinator(globalTID, this.tranState.localTID, this, 0)) {
            LogicErrorException exc = new LogicErrorException(LogFormatter.getLocalizedMessage(_logger, "jts.transaction_id_already_in_use"));
            throw exc;
        }
    }

    @Override
    public void doFinalize() {
        this.dying = true;
        int state = 9;
        if (this.tranState != null && !this.temporary) {
            state = this.tranState.state;
        }
        switch (state) {
            case 1: {
                this.rollback(true);
                break;
            }
            case 7: 
            case 9: {
                if (this.superInfo != null) {
                    this.superInfo.doFinalize();
                }
                this.tranState = null;
                this.superInfo = null;
                this.nestingInfo = null;
                this.participants = null;
                this.terminator = null;
                this.name = null;
                break;
            }
        }
    }

    @Override
    public synchronized Status get_status() {
        Status result = Status.StatusUnknown;
        if (this.tranState != null) {
            switch (this.tranState.state) {
                case 1: {
                    if (this.rollbackOnly) {
                        result = Status.StatusMarkedRollback;
                        break;
                    }
                    result = Status.StatusActive;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    result = Status.StatusPrepared;
                    break;
                }
                case 0: {
                    result = Status.StatusNoTransaction;
                    break;
                }
                case 2: {
                    result = Status.StatusPreparing;
                    break;
                }
                case 6: {
                    result = Status.StatusCommitting;
                    break;
                }
                case 7: {
                    result = Status.StatusCommitted;
                    break;
                }
                case 8: {
                    result = Status.StatusRollingBack;
                    break;
                }
                case 9: {
                    result = Status.StatusRolledBack;
                    break;
                }
                default: {
                    result = Status.StatusUnknown;
                    break;
                }
            }
        } else {
            INVALID_TRANSACTION exc = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        return result;
    }

    @Override
    public synchronized Status get_parent_status() throws SystemException {
        Status result = Status.StatusNoTransaction;
        if (this.tranState != null) {
            CoordinatorImpl parent = this.nestingInfo.getParent(false);
            if (parent != null) {
                result = parent.get_status();
            }
        } else {
            INVALID_TRANSACTION exc = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        return result;
    }

    @Override
    public synchronized Status get_top_level_status() throws SystemException {
        Status result = Status.StatusNoTransaction;
        if (this.tranState != null) {
            CoordinatorImpl topLevel = this.nestingInfo.getTopLevel();
            if (topLevel != null) {
                result = topLevel.get_status();
            }
        } else {
            INVALID_TRANSACTION exc = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        return result;
    }

    @Override
    public synchronized boolean is_same_transaction(Coordinator other) throws SystemException {
        boolean result = false;
        if (this.name == null) {
            INVALID_TRANSACTION exc = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        result = this.name.equals(other.get_transaction_name());
        return result;
    }

    @Override
    public synchronized boolean is_related_transaction(Coordinator other) throws SystemException {
        boolean result = false;
        if (this.tranState != null) {
            CoordinatorImpl topLevel = this.nestingInfo.getTopLevel();
            if (topLevel != null) {
                result = other.is_descendant_transaction(topLevel.object());
            }
        } else {
            INVALID_TRANSACTION exc = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        return result;
    }

    @Override
    public boolean is_ancestor_transaction(Coordinator other) throws SystemException {
        boolean result = false;
        if (this.tranState == null) {
            INVALID_TRANSACTION exc = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        result = other.is_descendant_transaction(this.object());
        return result;
    }

    @Override
    public synchronized boolean is_descendant_transaction(Coordinator other) throws SystemException {
        boolean result = false;
        if (this.tranState != null) {
            result = this.is_same_transaction(other) ? true : this.nestingInfo.isDescendant(other);
        } else {
            INVALID_TRANSACTION exc = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        return result;
    }

    @Override
    public boolean is_top_level_transaction() {
        boolean result = false;
        if (this.tranState == null) {
            INVALID_TRANSACTION exc = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        return result;
    }

    @Override
    public synchronized int hash_transaction() {
        int result = this.hash;
        if (this.tranState == null) {
            INVALID_TRANSACTION exc = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        return result;
    }

    @Override
    public synchronized int hash_top_level_tran() throws SystemException {
        int result = 0;
        if (this.tranState != null) {
            CoordinatorImpl topLevel = this.nestingInfo.getTopLevel();
            if (topLevel != null) {
                result = topLevel.hash_transaction();
            }
        } else {
            INVALID_TRANSACTION exc = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        return result;
    }

    @Override
    public synchronized RecoveryCoordinator register_resource(Resource res) throws SystemException, Inactive, TRANSACTION_ROLLEDBACK {
        RecoveryCoordinator result = null;
        if (this.tranState == null || this.tranState.state != 1) {
            Inactive exc = new Inactive();
            throw exc;
        }
        if (this.rollbackOnly) {
            TRANSACTION_ROLLEDBACK exc = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        CoordinatorImpl topLevel = this.nestingInfo.getTopLevel();
        try {
            result = topLevel.register_resource(res);
        }
        catch (SystemException exc) {
            throw (SystemException)exc.fillInStackTrace();
        }
        catch (Inactive exc) {
            throw (Inactive)exc.fillInStackTrace();
        }
        boolean subAwareRes = res._is_a(SubtransactionAwareResourceHelper.id());
        if (subAwareRes) {
            if (!this.registered) {
                CoordinatorResourceImpl cImpl = new CoordinatorResourceImpl(this.superInfo.globalTID, this, true);
                try {
                    CoordinatorResource cRes = cImpl.object();
                    this.superInfo.superior.register_subtran_aware(cRes);
                    this.superInfo.setResource(cRes);
                    this.registered = true;
                }
                catch (Throwable exc) {
                    cImpl.destroy();
                    if (exc instanceof OBJECT_NOT_EXIST) {
                        TRANSACTION_ROLLEDBACK ex2 = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
                        throw ex2;
                    }
                    if (exc instanceof Inactive) {
                        throw (Inactive)exc;
                    }
                    if (exc instanceof SystemException) {
                        throw (SystemException)exc;
                    }
                    INTERNAL ex2 = new INTERNAL(263, CompletionStatus.COMPLETED_NO);
                    throw ex2;
                }
            }
            if (this.participants == null) {
                this.participants = new RegisteredResources(null, this);
            }
            this.participants.addRes((Resource)res._duplicate());
            this.temporary = false;
        }
        return result;
    }

    @Override
    public synchronized void register_subtran_aware(SubtransactionAwareResource sares) throws SystemException, Inactive, TRANSACTION_ROLLEDBACK {
        if (this.tranState == null || this.tranState.state != 1) {
            Inactive exc = new Inactive();
            throw exc;
        }
        if (this.rollbackOnly) {
            TRANSACTION_ROLLEDBACK exc = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        if (!this.registered) {
            CoordinatorResourceImpl cImpl = new CoordinatorResourceImpl(this.superInfo.globalTID, this, true);
            try {
                CoordinatorResource cRes = cImpl.object();
                this.superInfo.superior.register_subtran_aware(cRes);
                this.superInfo.setResource(cRes);
                this.registered = true;
            }
            catch (Throwable exc) {
                cImpl.destroy();
                if (exc instanceof OBJECT_NOT_EXIST) {
                    TRANSACTION_ROLLEDBACK ex2 = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
                    throw ex2;
                }
                if (exc instanceof Inactive) {
                    throw (Inactive)exc;
                }
                if (exc instanceof SystemException) {
                    throw (SystemException)exc;
                }
                INTERNAL ex2 = new INTERNAL(263, CompletionStatus.COMPLETED_NO);
                throw ex2;
            }
        }
        if (this.participants == null) {
            this.participants = new RegisteredResources(null, this);
        }
        this.participants.addRes((Resource)sares._duplicate());
        this.temporary = false;
    }

    @Override
    public synchronized void rollback_only() throws Inactive {
        if (this.tranState.state != 1) {
            Inactive exc = new Inactive();
            throw exc;
        }
        this.rollbackOnly = true;
    }

    @Override
    public synchronized String get_transaction_name() {
        String result = null;
        if (this.tranState == null) {
            INVALID_TRANSACTION exc = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        result = this.name;
        return result;
    }

    @Override
    public synchronized Control create_subtransaction() throws Inactive {
        Control result = null;
        if (this.tranState == null || this.tranState.state != 1) {
            Inactive exc = new Inactive();
            throw exc;
        }
        CoordinatorImpl[] thisAncestors = this.nestingInfo.getAncestors();
        CoordinatorImpl[] ancestors = new CoordinatorImpl[thisAncestors.length + 1];
        System.arraycopy(thisAncestors, 0, ancestors, 1, thisAncestors.length);
        ancestors[0] = this;
        SubCoordinator child = null;
        TerminatorImpl terminator = null;
        try {
            child = new SubCoordinator(this.superInfo.globalTID, this.superInfo.localTID, ancestors);
            terminator = new TerminatorImpl(child, true);
            result = new ControlImpl(terminator, child, new GlobalTID(child.getGlobalTID()), child.getLocalTID()).object();
        }
        catch (Throwable exc) {
            Inactive ex2 = new Inactive();
            throw ex2;
        }
        this.nestingInfo.addChild(child);
        return result;
    }

    @Override
    public otid_t getGlobalTID() {
        otid_t result = null;
        result = this.superInfo.globalTID.realTID;
        return result;
    }

    @Override
    public long getLocalTID() {
        long result = this.superInfo.localTID;
        return result;
    }

    @Override
    synchronized CoordinatorImpl replyAction(int[] action) throws SystemException {
        CoordinatorImpl result = null;
        action[0] = 1;
        if (!this.root && this.nestingInfo.replyCheck()) {
            action[0] = 3;
        } else {
            if (!this.registered) {
                if (this.participants != null && this.participants.involved()) {
                    INTERNAL ex2 = new INTERNAL(263, CompletionStatus.COMPLETED_NO);
                    throw ex2;
                }
                action[0] = 2;
            }
            if (action[0] == 1 && !this.registered) {
                action[0] = 2;
            }
        }
        result = null;
        return result;
    }

    @Override
    synchronized Long setPermanent() {
        Long result = this.superInfo.localTID;
        this.temporary = false;
        return result;
    }

    @Override
    public synchronized boolean isRollbackOnly() {
        boolean result = this.rollbackOnly;
        return result;
    }

    @Override
    synchronized boolean isActive() {
        boolean result = this.tranState.state == 1;
        return result;
    }

    @Override
    synchronized boolean hasRegistered() {
        boolean result = this.registered;
        return result;
    }

    @Override
    public synchronized TransIdentity[] getAncestors() {
        CoordinatorImpl[] coords = this.nestingInfo.getAncestors();
        TransIdentity[] result = new TransIdentity[coords.length];
        for (int i = 0; i < coords.length; ++i) {
            try {
                result[i] = new TransIdentity(coords[i].object(), null, coords[i].getGlobalTID());
                continue;
            }
            catch (Throwable exc) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    synchronized boolean addChild(CoordinatorImpl child) {
        boolean result = this.nestingInfo.addChild(child);
        return result;
    }

    @Override
    synchronized boolean removeChild(CoordinatorImpl child) {
        boolean result = false;
        if (this.nestingInfo != null) {
            result = this.nestingInfo.removeChild(child);
        }
        if (!(!this.temporary || this.registered || this.participants != null && this.participants.involved() || this.nestingInfo != null && this.nestingInfo.numChildren() > 0)) {
            CoordinatorImpl parent = this.nestingInfo.getParent(true);
            this.cleanUpEmpty(parent);
        }
        return result;
    }

    @Override
    synchronized Vote prepare() throws INVALID_TRANSACTION {
        Vote result = Vote.VoteRollback;
        int newState = 4;
        if (this.root && this.nestingInfo.numChildren() != 0) {
            INVALID_TRANSACTION exc = new INVALID_TRANSACTION(1, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        if (!this.tranState.setState(2)) {
            return Vote.VoteRollback;
        }
        if (this.rollbackOnly) {
            if (!this.tranState.setState(4)) {
                return Vote.VoteRollback;
            }
        } else {
            newState = 3;
            result = Vote.VoteCommit;
        }
        if (!this.tranState.setState(newState)) {
            result = Vote.VoteRollback;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void commit() {
        Coordinator parent = null;
        SubCoordinator subCoordinator = this;
        synchronized (subCoordinator) {
            if (!this.tranState.setState(6)) {
                _logger.log(Level.SEVERE, "jts.transaction_wrong_state", "commit");
                String msg = LogFormatter.getLocalizedMessage(_logger, "jts.transaction_wrong_state", new java.lang.Object[]{"commit"});
                throw new INTERNAL(msg);
            }
            parent = this.nestingInfo.getParent(false).object();
        }
        if (this.participants != null) {
            try {
                this.participants.distributeSubcommit(parent);
            }
            catch (Throwable exc) {
                _logger.log(Level.SEVERE, "jts.exception_on_resource_operation", new java.lang.Object[]{exc.toString(), "commit"});
                String msg = LogFormatter.getLocalizedMessage(_logger, "jts.exception_on_resource_operation", new java.lang.Object[]{exc.toString(), "commit"});
                throw new INTERNAL(msg);
            }
        }
        subCoordinator = this;
        synchronized (subCoordinator) {
            if (!this.tranState.setState(7)) {
                _logger.log(Level.SEVERE, "jts.transaction_wrong_state", "commit");
                String msg = LogFormatter.getLocalizedMessage(_logger, "jts.transaction_wrong_state", new java.lang.Object[]{"commit"});
                throw new INTERNAL(msg);
            }
            this.nestingInfo.removeFromParent(this);
            if (this.terminator != null) {
                this.terminator.setCompleted(false, false);
            }
            RecoveryManager.removeCoordinator(this.superInfo.globalTID, this.superInfo.localTID, false);
            this.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void rollback(boolean force) {
        SubCoordinator subCoordinator = this;
        synchronized (subCoordinator) {
            if (this.tranState == null) {
                return;
            }
            if (!(force || this.tranState.state != 3 && this.tranState.setState(8))) {
                return;
            }
            if (!this.temporary && !this.tranState.setState(8) && _logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "SubCoordinator - setState(TransactionState.STATE_ROLLED_BACK) returned false");
            }
            if (this.nestingInfo != null) {
                this.nestingInfo.rollbackFamily();
            }
        }
        if (this.participants != null) {
            this.participants.distributeSubrollback();
        }
        subCoordinator = this;
        synchronized (subCoordinator) {
            if (!this.temporary && !this.tranState.setState(9) && _logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "SubCoordinator - setState(TransactionState.STATE_ROLLED_BACK) returned false");
            }
            this.nestingInfo.removeFromParent(this);
            if (this.terminator != null) {
                this.terminator.setCompleted(true, false);
            }
            RecoveryManager.removeCoordinator(this.superInfo.globalTID, this.superInfo.localTID, false);
            if (!this.dying) {
                this.destroy();
            }
        }
    }

    @Override
    public synchronized void register_synchronization(Synchronization sync) throws Inactive, SynchronizationUnavailable {
        if (this.tranState == null || this.tranState.state != 1) {
            Inactive exc = new Inactive();
            throw exc;
        }
        CoordinatorImpl topLevel = this.nestingInfo.getTopLevel();
        topLevel.register_synchronization(sync);
    }

    @Override
    synchronized void setTerminator(CompletionHandler term) {
        this.terminator = term;
    }

    @Override
    Coordinator getParent() {
        Coordinator result = this.nestingInfo.getParent(false).object();
        return result;
    }

    @Override
    Coordinator getSuperior() {
        Coordinator result = this.superInfo.superior;
        return result;
    }

    @Override
    CompletionHandler getTerminator() {
        CompletionHandler result = this.terminator;
        return result;
    }

    @Override
    public synchronized PropagationContext get_txcontext() throws Unavailable {
        if (this.tranState == null || this.tranState.state != 1 || this.rollbackOnly) {
            Unavailable exc = new Unavailable();
            throw exc;
        }
        long timeLeft = TimeoutManager.timeLeft(this.superInfo.localTID);
        int timeout = 0;
        if (timeLeft > 0L) {
            timeout = (int)timeLeft / 1000;
        } else if (timeLeft == 0L) {
            TimeoutManager.timeoutCoordinator(this.superInfo.localTID, 1);
            TRANSACTION_ROLLEDBACK exc = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        TransIdentity current = new TransIdentity(this.object(), null, this.superInfo.globalTID.realTID);
        TransIdentity[] parents = this.getAncestors();
        if (emptyData == null) {
            emptyData = Configuration.getORB().create_any();
            emptyData.insert_boolean(false);
        }
        PropagationContext result = new PropagationContext(timeout, current, parents, emptyData);
        return result;
    }

    @Override
    void cleanUpEmpty(CoordinatorImpl parent) {
        try {
            this.rollback(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (parent != null) {
            parent.removeChild(this);
        }
    }

    @Override
    boolean commitOnePhase() {
        Vote v = this.prepare();
        if (v == Vote.VoteCommit) {
            this.commit();
        } else if (v != Vote.VoteReadOnly) {
            this.rollback(true);
        }
        return true;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(java.lang.Object other) throws INVALID_TRANSACTION {
        if (this == other) {
            return true;
        }
        otid_t otherTID = null;
        if (other instanceof CoordinatorImpl) {
            if (other instanceof SubCoordinator) {
                otherTID = ((SubCoordinator)other).superInfo.globalTID.realTID;
            }
        } else if (other instanceof Object) {
            try {
                JCoordinator jcoord = JCoordinatorHelper.narrow((Object)other);
                otherTID = jcoord.getGlobalTID();
            }
            catch (BAD_PARAM exc) {
                try {
                    Coordinator coord = CoordinatorHelper.narrow((Object)other);
                    PropagationContext pc = coord.get_txcontext();
                    otherTID = pc.current.otid;
                }
                catch (BAD_PARAM ex2) {
                }
                catch (Unavailable ex2) {
                    INVALID_TRANSACTION ex3 = new INVALID_TRANSACTION(7, CompletionStatus.COMPLETED_NO);
                    throw ex3;
                }
            }
        }
        if (otherTID != null) {
            return this.superInfo.globalTID.isSameTID(otherTID);
        }
        return false;
    }
}

