/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.flow;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.flow.FlowCDIContext;
import com.sun.faces.util.Util;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.flow.Flow;
import javax.faces.flow.FlowCallNode;
import javax.faces.flow.FlowHandler;
import javax.faces.flow.Parameter;
import javax.faces.flow.ViewNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowHandlerImpl
extends FlowHandler {
    private boolean flowFeatureIsEnabled;
    private Map<String, Flow> flows;

    public FlowHandlerImpl() {
        WebConfiguration config = WebConfiguration.getInstance();
        this.flowFeatureIsEnabled = config.isHasFlows();
        this.flows = new ConcurrentHashMap<String, Flow>();
    }

    @Override
    public Map<Object, Object> getCurrentFlowScope() {
        return FlowCDIContext.getCurrentFlowScope();
    }

    @Override
    public Flow getFlow(FacesContext context, Object definingDocument, String id) {
        Flow result = this.flows.get(id);
        return result;
    }

    private Flow getFlowByNodeId(String id) {
        if (null == id || 0 == id.length()) {
            throw new IllegalStateException();
        }
        Flow result = null;
        for (Flow cur : this.flows.values()) {
            for (ViewNode curView : cur.getViews()) {
                if (!id.equals(curView.getId())) continue;
                result = cur;
                break;
            }
            if (null == result) continue;
            break;
        }
        return result;
    }

    @Override
    public void addFlow(FacesContext context, Object definingDocument, Flow toAdd) {
        if (null == toAdd || null == toAdd.getId() || 0 == toAdd.getId().length()) {
            throw new IllegalArgumentException();
        }
        this.flows.put(toAdd.getId(), toAdd);
        NavigationHandler navigationHandler = context.getApplication().getNavigationHandler();
        if (navigationHandler instanceof ConfigurableNavigationHandler) {
            ((ConfigurableNavigationHandler)navigationHandler).inspectFlow(context, toAdd);
        }
    }

    @Override
    public boolean isActive(FacesContext context, Object definingDocument, String id) {
        boolean result = false;
        Deque<Flow> flowStack = this.getFlowStack(context);
        for (Flow cur : flowStack) {
            if (!id.equals(cur.getId())) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public Flow getCurrentFlow(FacesContext context) {
        if (!this.flowFeatureIsEnabled) {
            return null;
        }
        return this.getFlowStack(context).peek();
    }

    @Override
    public Flow transition(FacesContext context, UIComponent src, UIComponent target, FlowCallNode outboundCallNode) {
        Flow targetFlow;
        Flow newFlow = null;
        if (!this.flowFeatureIsEnabled) {
            return newFlow;
        }
        String sourceFlowId = Util.getFlowIdFromComponent(context, src);
        String targetFlowId = Util.getFlowIdFromComponent(context, target);
        Flow sourceFlow = this.getFlowByNodeId(sourceFlowId);
        if (!this.flowsEqual(sourceFlow, targetFlow = this.getFlowByNodeId(targetFlowId))) {
            HashMap<String, Object> evaluatedParams = null;
            if (null != outboundCallNode) {
                Map<String, Parameter> outboundParameters = outboundCallNode.getOutboundParameters();
                Map<String, Parameter> inboundParameters = targetFlow.getInboundParameters();
                if (null != outboundParameters && !outboundParameters.isEmpty() && null != inboundParameters && !inboundParameters.isEmpty()) {
                    ELContext elContext = context.getELContext();
                    for (Map.Entry<Object, Object> entry : outboundParameters.entrySet()) {
                        String curName = (String)entry.getKey();
                        if (!inboundParameters.containsKey(curName)) continue;
                        if (null == evaluatedParams) {
                            evaluatedParams = new HashMap<String, Object>();
                        }
                        evaluatedParams.put(curName, ((Parameter)entry.getValue()).getValue().getValue(elContext));
                    }
                }
            }
            this.performPops(context, sourceFlow, targetFlow);
            if (null != targetFlow) {
                this.pushFlow(context, targetFlow);
                newFlow = targetFlow;
            }
            if (null != evaluatedParams) {
                Map<String, Parameter> inboundParameters = targetFlow.getInboundParameters();
                ELContext elContext = context.getELContext();
                for (Map.Entry<Object, Object> entry : evaluatedParams.entrySet()) {
                    String curName = (String)entry.getKey();
                    assert (inboundParameters.containsKey(curName));
                    ValueExpression toSet = inboundParameters.get(curName).getValue();
                    toSet.setValue(elContext, entry.getValue());
                }
            }
        }
        return newFlow;
    }

    private void performPops(FacesContext context, Flow sourceFlow, Flow targetFlow) {
        if (null == sourceFlow) {
            assert (null == this.peekFlow(context));
            return;
        }
        if (null == targetFlow) {
            this.popAll(context);
            return;
        }
        if (null == sourceFlow.getFlowCall(targetFlow)) {
            this.popFlow(context);
        }
    }

    private boolean flowsEqual(Flow flow1, Flow flow2) {
        boolean result = false;
        result = flow1 == flow2 ? true : (null == flow1 || null == flow2 ? false : flow1.equals(flow2));
        return result;
    }

    private void pushFlow(FacesContext context, Flow toPush) {
        Deque<Flow> flowStack = this.getFlowStack(context);
        flowStack.push(toPush);
        FlowCDIContext.flowEntered();
        MethodExpression me = toPush.getInitializer();
        if (null != me) {
            me.invoke(context.getELContext(), null);
        }
    }

    private Flow peekFlow(FacesContext context) {
        Deque<Flow> flowStack = this.getFlowStack(context);
        return flowStack.peek();
    }

    private Flow popFlow(FacesContext context) {
        Deque<Flow> flowStack = this.getFlowStack(context);
        Flow currentFlow = this.peekFlow(context);
        if (null != currentFlow) {
            this.callFinalizer(context, currentFlow);
        }
        return flowStack.pollFirst();
    }

    private void callFinalizer(FacesContext context, Flow currentFlow) {
        MethodExpression me = currentFlow.getFinalizer();
        if (null != me) {
            me.invoke(context.getELContext(), null);
        }
        FlowCDIContext.flowExited();
    }

    private void popAll(FacesContext context) {
        Deque<Flow> flowStack = this.getFlowStack(context);
        Flow currentFlow = this.peekFlow(context);
        while (!flowStack.isEmpty()) {
            this.callFinalizer(context, currentFlow);
            currentFlow = flowStack.pollFirst();
        }
    }

    private Deque<Flow> getFlowStack(FacesContext context) {
        ArrayDeque result = null;
        ExternalContext extContext = context.getExternalContext();
        String sessionKey = extContext.getClientWindow().getId() + "_flowStack";
        Map<String, Object> sessionMap = extContext.getSessionMap();
        result = (ArrayDeque)sessionMap.get(sessionKey);
        if (null == result) {
            result = new ArrayDeque();
            sessionMap.put(sessionKey, result);
        }
        return result;
    }
}

