/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.flow;

import com.sun.faces.flow.FlowDiscoveryCDIContext;
import com.sun.faces.flow.FlowDiscoveryInfo;
import com.sun.faces.flow.builder.FlowBuilderImpl;
import com.sun.faces.util.FacesLogger;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.flow.Flow;
import javax.faces.flow.FlowDefinition;
import javax.faces.flow.FlowHandler;
import javax.faces.flow.builder.FlowBuilder;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="csfFLOWDISCOVERYCDIHELPER")
@ApplicationScoped
public class FlowDiscoveryCDIHelper
implements Serializable {
    private static final long serialVersionUID = 2010898398003809226L;
    private static final Logger LOGGER = FacesLogger.FLOW.getLogger();
    @Inject
    transient BeanManager beanManager;

    public void discoverFlows(FacesContext context, FlowHandler flowHandler) {
        FlowDiscoveryCDIContext flowDiscoveryContext = (FlowDiscoveryCDIContext)this.beanManager.getContext(FlowDefinition.class);
        List<FlowDiscoveryInfo> flowDefinincClasses = flowDiscoveryContext.getFlowDefiningClasses();
        for (FlowDiscoveryInfo cur : flowDefinincClasses) {
            Class beanClass = cur.getDefiningClass();
            Method[] methods = beanClass.getDeclaredMethods();
            Class<Flow> returnType = null;
            Class<?>[] params = null;
            for (Method curMethod : methods) {
                returnType = curMethod.getReturnType();
                if (!returnType.isAssignableFrom(Flow.class) || 2 != (params = curMethod.getParameterTypes()).length || !params[0].isAssignableFrom(FacesContext.class) || !params[1].isAssignableFrom(FlowBuilder.class)) continue;
                FlowBuilderImpl builder = new FlowBuilderImpl(context);
                try {
                    Object instance = beanClass.newInstance();
                    Object[] builderParam = new Object[]{context, builder};
                    LOGGER.log(Level.FINE, "About to discover flow on {0}", beanClass);
                    Flow toAdd = (Flow)curMethod.invoke(instance, builderParam);
                    if (null == toAdd) {
                        LOGGER.log(Level.SEVERE, "Flow builder method {0}() on class {1} returned null.  Ignoring.", new String[]{curMethod.getName(), beanClass.getName()});
                        continue;
                    }
                    flowHandler.addFlow(context, cur.getDefiningDocument(), toAdd);
                }
                catch (InstantiationException ex) {
                    LOGGER.log(Level.SEVERE, "Cannot instantiate " + beanClass.getName(), ex);
                    throw new FacesException(ex);
                }
                catch (IllegalAccessException ex) {
                    LOGGER.log(Level.SEVERE, "Cannot instantiate " + beanClass.getName(), ex);
                    throw new FacesException(ex);
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.log(Level.SEVERE, "Cannot invoke " + curMethod.getName(), ex);
                    throw new FacesException(ex);
                }
                catch (InvocationTargetException ex) {
                    LOGGER.log(Level.SEVERE, "Cannot invoke " + curMethod.getName(), ex);
                    throw new FacesException(ex);
                }
            }
        }
    }
}

